/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.base.event.EventManager;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.adempiere.process.UUIDGenerator;
import org.compiere.Adempiere;
import org.compiere.acct.Doc;
import org.compiere.model.DocWorkflowMgr;
import org.compiere.model.I_C_ElementValue;
import org.compiere.model.Lookup;
import org.compiere.model.MAttachment;
import org.compiere.model.MChangeLog;
import org.compiere.model.MClient;
import org.compiere.model.MClientShare;
import org.compiere.model.MColumn;
import org.compiere.model.MMessage;
import org.compiere.model.MRecentItem;
import org.compiere.model.MRefList;
import org.compiere.model.MSession;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MTableIndex;
import org.compiere.model.MTree_Base;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Null;
import org.compiere.model.POInfo;
import org.compiere.model.PO_LOB;
import org.compiere.model.Query;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CCache;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.SecureEngine;
import org.compiere.util.Trace;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.osgi.service.event.Event;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class PO
implements Serializable,
Comparator<Object>,
Evaluatee,
Cloneable {
    private static final long serialVersionUID = -1743619574547406959L;
    public static final String LOCAL_TRX_PREFIX = "POSave";
    private static final String USE_TIMEOUT_FOR_UPDATE = "org.adempiere.po.useTimeoutForUpdate";
    private static final int QUERY_TIME_OUT = 300;
    private static DocWorkflowMgr s_docWFMgr = null;
    public static final String ENTITYTYPE_UserMaintained = "U";
    public static final String ENTITYTYPE_Dictionary = "D";
    protected transient CLogger log = CLogger.getCLogger(this.getClass());
    private static CLogger s_log = CLogger.getCLogger(PO.class);
    protected Properties p_ctx;
    protected volatile POInfo p_info = null;
    private Object[] m_oldValues = null;
    private Object[] m_newValues = null;
    private ValueNamePair[] m_setErrors = null;
    private Object[] m_IDs = new Object[]{I_ZERO};
    private String[] m_KeyColumns = null;
    private boolean m_createNew = false;
    private MAttachment m_attachment = null;
    private int m_idOld = 0;
    private HashMap<String, String> m_custom = null;
    private HashMap<String, Object> m_attributes = null;
    protected static final Integer I_ZERO = 0;
    private ArrayList<String> s_acctColumns = null;
    private boolean m_isReplication = false;
    public static final int ACCESSLEVEL_SYSTEM = 4;
    public static final int ACCESSLEVEL_CLIENT = 2;
    public static final int ACCESSLEVEL_ORG = 1;
    public static final int ACCESSLEVEL_ALL = 7;
    public static final int ACCESSLEVEL_SYSTEMCLIENT = 6;
    public static final int ACCESSLEVEL_CLIENTORG = 3;
    private static CCache<String, String> trl_cache = new CCache("po_trl", 5);
    private String m_trxName = null;
    private ArrayList<PO_LOB> m_lobInfo = null;
    protected static final String XML_ATTRIBUTE_AD_Table_ID = "AD_Table_ID";
    protected static final String XML_ATTRIBUTE_Record_ID = "Record_ID";
    private Doc m_doc;

    public static void setDocWorkflowMgr(DocWorkflowMgr docWFMgr) {
        s_docWFMgr = docWFMgr;
        s_log.config(s_docWFMgr.toString());
    }

    public PO(Properties ctx) {
        this(ctx, 0, null, null);
    }

    public PO(Properties ctx, int ID, String trxName) {
        this(ctx, ID, trxName, null);
    }

    public PO(Properties ctx, ResultSet rs, String trxName) {
        this(ctx, 0, trxName, rs);
    }

    public PO(Properties ctx, int ID, String trxName, ResultSet rs) {
        this.p_ctx = ctx != null ? ctx : Env.getCtx();
        this.m_trxName = trxName;
        this.p_info = this.initPO(ctx);
        if (this.p_info == null || this.p_info.getTableName() == null) {
            throw new IllegalArgumentException("Invalid PO Info - " + this.p_info);
        }
        int size = this.p_info.getColumnCount();
        this.m_oldValues = new Object[size];
        this.m_newValues = new Object[size];
        this.m_setErrors = new ValueNamePair[size];
        if (rs != null) {
            this.load(rs);
        } else {
            this.load(ID, trxName);
        }
    }

    public PO(Properties ctx, PO source, int AD_Client_ID, int AD_Org_ID) {
        this(ctx, 0, null, null);
        if (source != null) {
            PO.copyValues(source, this);
        }
        this.setAD_Client_ID(AD_Client_ID);
        this.setAD_Org_ID(AD_Org_ID);
    }

    protected abstract POInfo initPO(Properties var1);

    protected abstract int get_AccessLevel();

    public String toString() {
        StringBuilder sb = new StringBuilder("PO[").append(this.get_WhereClause(true)).append("]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object cmp) {
        if (cmp == null) {
            return false;
        }
        if (!(cmp instanceof PO)) {
            return false;
        }
        if (cmp.getClass().equals(this.getClass())) {
            if (((PO)cmp).get_ID() == 0 && this.get_ID() == 0) {
                return super.equals(cmp);
            }
            return ((PO)cmp).get_ID() == this.get_ID();
        }
        return super.equals(cmp);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (!(o1 instanceof PO)) {
            throw new ClassCastException("Not PO -1- " + o1);
        }
        if (!(o2 instanceof PO)) {
            throw new ClassCastException("Not PO -2- " + o2);
        }
        Collator collator = Collator.getInstance();
        if (o1.getClass().equals(o2.getClass())) {
            int index = this.get_ColumnIndex("DocumentNo");
            if (index == -1) {
                index = this.get_ColumnIndex("Value");
            }
            if (index == -1) {
                index = this.get_ColumnIndex("Name");
            }
            if (index == -1) {
                index = this.get_ColumnIndex("Description");
            }
            if (index != -1) {
                PO po1 = (PO)o1;
                Object comp1 = po1.get_Value(index);
                PO po2 = (PO)o2;
                Object comp2 = po2.get_Value(index);
                if (comp1 == null) {
                    return -1;
                }
                if (comp2 == null) {
                    return 1;
                }
                return collator.compare(comp1.toString(), comp2.toString());
            }
        }
        return collator.compare(o1.toString(), o2.toString());
    }

    public String get_TableName() {
        return this.p_info.getTableName();
    }

    public String[] get_KeyColumns() {
        return this.m_KeyColumns;
    }

    public int get_Table_ID() {
        return this.p_info.getAD_Table_ID();
    }

    public int get_ID() {
        Object oo = this.m_IDs[0];
        if (oo != null && oo instanceof Integer) {
            return (Integer)oo;
        }
        return 0;
    }

    public int get_IDOld() {
        return this.m_idOld;
    }

    public Properties getCtx() {
        return this.p_ctx;
    }

    public CLogger get_Logger() {
        return this.log;
    }

    public final Object get_Value(int index) {
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.log(Level.WARNING, "Index invalid - " + index);
            return null;
        }
        if (this.m_newValues[index] != null) {
            if (this.m_newValues[index].equals(Null.NULL)) {
                return null;
            }
            return this.m_newValues[index];
        }
        return this.m_oldValues[index];
    }

    public int get_ValueAsInt(int index) {
        Object value = this.get_Value(index);
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException ex) {
            this.log.warning(String.valueOf(this.p_info.getColumnName(index)) + " - " + ex.getMessage());
            return 0;
        }
    }

    public final Object get_Value(String columnName) {
        int index = this.get_ColumnIndex(columnName);
        if (index < 0) {
            this.log.log(Level.WARNING, "Column not found - " + columnName);
            Trace.printStack();
            return null;
        }
        return this.get_Value(index);
    }

    protected final Object get_ValueE(String columnName) {
        return this.get_Value(columnName);
    }

    @Override
    public String get_ValueAsString(String variableName) {
        Object value = this.get_Value(variableName);
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public final Object get_ValueOfColumn(int AD_Column_ID) {
        int index = this.p_info.getColumnIndex(AD_Column_ID);
        if (index < 0) {
            this.log.log(Level.WARNING, "Not found - AD_Column_ID=" + AD_Column_ID);
            return null;
        }
        return this.get_Value(index);
    }

    public final Object get_ValueOld(int index) {
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.log(Level.WARNING, "Index invalid - " + index);
            return null;
        }
        return this.m_oldValues[index];
    }

    public final Object get_ValueOld(String columnName) {
        int index = this.get_ColumnIndex(columnName);
        if (index < 0) {
            this.log.log(Level.WARNING, "Column not found - " + columnName);
            return null;
        }
        return this.get_ValueOld(index);
    }

    public int get_ValueOldAsInt(String columnName) {
        Object value = this.get_ValueOld(columnName);
        if (value == null) {
            return 0;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException ex) {
            this.log.warning(String.valueOf(columnName) + " - " + ex.getMessage());
            return 0;
        }
    }

    public final boolean is_ValueChanged(int index) {
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.log(Level.WARNING, "Index invalid - " + index);
            return false;
        }
        if (this.m_newValues[index] == null) {
            return false;
        }
        if (this.m_newValues[index] == Null.NULL && this.m_oldValues[index] == null) {
            return false;
        }
        return !this.m_newValues[index].equals(this.m_oldValues[index]);
    }

    public final boolean is_ValueChanged(String columnName) {
        int index = this.get_ColumnIndex(columnName);
        if (index < 0) {
            this.log.log(Level.WARNING, "Column not found - " + columnName);
            return false;
        }
        return this.is_ValueChanged(index);
    }

    public final Object get_ValueDifference(int index) {
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.log(Level.WARNING, "Index invalid - " + index);
            return null;
        }
        Object nValue = this.m_newValues[index];
        if (nValue == null || nValue == Null.NULL) {
            return null;
        }
        Object oValue = this.m_oldValues[index];
        if (oValue == null || oValue == Null.NULL) {
            return nValue;
        }
        if (nValue instanceof BigDecimal) {
            BigDecimal obd = (BigDecimal)oValue;
            return ((BigDecimal)nValue).subtract(obd);
        }
        if (nValue instanceof Integer) {
            int result = (Integer)nValue;
            return result -= ((Integer)oValue).intValue();
        }
        this.log.warning("Invalid type - New=" + nValue);
        return null;
    }

    public final Object get_ValueDifference(String columnName) {
        int index = this.get_ColumnIndex(columnName);
        if (index < 0) {
            this.log.log(Level.WARNING, "Column not found - " + columnName);
            return null;
        }
        return this.get_ValueDifference(index);
    }

    protected final boolean set_Value(String ColumnName, Object value) {
        return this.set_Value(ColumnName, value, true);
    }

    protected final boolean set_Value(String ColumnName, Object value, boolean checkWritable) {
        Class<?> clazz;
        int index;
        if (value instanceof String && ColumnName.equals("WhereClause") && value.toString().toUpperCase().indexOf("=NULL") != -1) {
            this.log.warning("Invalid Null Value - " + ColumnName + "=" + value);
        }
        if ((index = this.get_ColumnIndex(ColumnName)) < 0) {
            this.log.log(Level.SEVERE, "Column not found - " + ColumnName);
            this.log.saveError("ColumnNotFound", "Column not found - " + ColumnName);
            return false;
        }
        if (ColumnName.endsWith("_ID") && value instanceof String && Integer.class == (clazz = this.p_info.getColumnClass(this.p_info.getColumnIndex(ColumnName)))) {
            this.log.severe("Invalid Data Type for " + ColumnName + "=" + value);
            value = Integer.parseInt((String)value);
        }
        return this.set_Value(index, value, checkWritable);
    }

    protected final boolean set_ValueE(String ColumnName, Object value) {
        return this.set_Value(ColumnName, value);
    }

    protected final boolean set_Value(int index, Object value) {
        return this.set_Value(index, value, true);
    }

    protected final boolean set_Value(int index, Object value, boolean checkWritable) {
        if (index < 0 || index >= this.get_ColumnCount()) {
            this.log.log(Level.WARNING, "Index invalid - " + index);
            return false;
        }
        String ColumnName = this.p_info.getColumnName(index);
        String colInfo = " - " + ColumnName;
        this.m_setErrors[index] = null;
        if (checkWritable) {
            if (this.p_info.isVirtualColumn(index)) {
                this.log.log(Level.WARNING, "Virtual Column" + colInfo);
                this.log.saveError("VirtualColumn", "Virtual Column" + colInfo);
                this.m_setErrors[index] = new ValueNamePair("VirtualColumn", "Virtual Column" + colInfo);
                return false;
            }
            if (!this.p_info.isColumnUpdateable(index) && !this.is_new()) {
                colInfo = String.valueOf(colInfo) + " - NewValue=" + value + " - OldValue=" + this.get_Value(index);
                this.log.log(Level.WARNING, "Column not updateable" + colInfo);
                this.log.saveError("ColumnReadonly", "Column not updateable" + colInfo);
                this.m_setErrors[index] = new ValueNamePair("ColumnReadonly", "Column not updateable" + colInfo);
                return false;
            }
        }
        if (value == null) {
            if (checkWritable && this.p_info.isColumnMandatory(index)) {
                this.log.saveError("FillMandatory", String.valueOf(ColumnName) + " is mandatory.");
                this.m_setErrors[index] = new ValueNamePair("FillMandatory", String.valueOf(ColumnName) + " is mandatory.");
                return false;
            }
            this.m_newValues[index] = Null.NULL;
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(ColumnName) + " = null");
            }
        } else {
            if (value.getClass().equals(this.p_info.getColumnClass(index)) || this.p_info.getColumnClass(index) == Object.class) {
                this.m_newValues[index] = value;
            } else if (value.getClass() == BigDecimal.class && this.p_info.getColumnClass(index) == Integer.class) {
                this.m_newValues[index] = ((BigDecimal)value).intValue();
            } else if (this.p_info.getColumnClass(index) == Boolean.class && ("Y".equals(value) || "N".equals(value))) {
                this.m_newValues[index] = "Y".equals(value);
            } else if (value.getClass() == Integer.class && this.p_info.getColumnClass(index) == String.class) {
                this.m_newValues[index] = value;
            } else if (value.getClass() == String.class && this.p_info.getColumnClass(index) == Integer.class) {
                try {
                    this.m_newValues[index] = Integer.valueOf((String)value);
                }
                catch (NumberFormatException e) {
                    String errmsg = String.valueOf(ColumnName) + " - Class invalid: " + value.getClass().toString() + ", Should be " + this.p_info.getColumnClass(index).toString() + ": " + value;
                    this.log.log(Level.SEVERE, errmsg);
                    this.log.saveError("WrongDataType", errmsg);
                    this.m_setErrors[index] = new ValueNamePair("WrongDataType", errmsg);
                    return false;
                }
            } else {
                String errmsg = String.valueOf(ColumnName) + " - Class invalid: " + value.getClass().toString() + ", Should be " + this.p_info.getColumnClass(index).toString() + ": " + value;
                this.log.log(Level.SEVERE, errmsg);
                this.log.saveError("WrongDataType", errmsg);
                this.m_setErrors[index] = new ValueNamePair("WrongDataType", errmsg);
                return false;
            }
            String error = this.p_info.validate(index, value);
            if (error != null) {
                this.log.log(Level.WARNING, String.valueOf(ColumnName) + "=" + value + " - " + error);
                int separatorIndex = error.indexOf(";");
                if (separatorIndex > 0) {
                    this.log.saveError(error.substring(0, separatorIndex), error.substring(separatorIndex + 1));
                    this.m_setErrors[index] = new ValueNamePair(error.substring(0, separatorIndex), error.substring(separatorIndex + 1));
                } else {
                    this.log.saveError(error, ColumnName);
                    this.m_setErrors[index] = new ValueNamePair(error, ColumnName);
                }
                return false;
            }
            if (this.p_info.getColumnClass(index) == String.class) {
                String stringValue = value.toString();
                int length = this.p_info.getFieldLength(index);
                if (stringValue.length() > length && length > 0) {
                    this.log.warning(String.valueOf(ColumnName) + " - Value too long - truncated to length=" + length);
                    this.m_newValues[index] = stringValue.substring(0, length);
                }
            }
            if (this.p_info.getColumn((int)index).DisplayType == 17 && this.p_info.getColumn((int)index).AD_Reference_Value_ID > 0 && value instanceof String && MRefList.get(this.getCtx(), this.p_info.getColumn((int)index).AD_Reference_Value_ID, (String)value, this.get_TrxName()) == null) {
                StringBuilder validValues = new StringBuilder();
                ValueNamePair[] valueNamePairArray = MRefList.getList(this.getCtx(), this.p_info.getColumn((int)index).AD_Reference_Value_ID, false);
                int n = valueNamePairArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ValueNamePair vp = valueNamePairArray[n2];
                    validValues.append(" - ").append(vp.getValue());
                    ++n2;
                }
                String errmsg = String.valueOf(ColumnName) + " Invalid value - " + value + " - Reference_ID=" + this.p_info.getColumn((int)index).AD_Reference_Value_ID + validValues.toString();
                this.log.saveError("Validate", errmsg);
                this.m_setErrors[index] = new ValueNamePair("Validate", errmsg);
                return false;
            }
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest(String.valueOf(ColumnName) + " = " + this.m_newValues[index] + " (OldValue=" + this.m_oldValues[index] + ")");
            }
        }
        this.set_Keys(ColumnName, this.m_newValues[index]);
        this.setProcessedOn(ColumnName, value, this.m_oldValues[index]);
        return true;
    }

    public void setProcessedOn(String ColumnName, Object value, Object oldValue) {
        if ("Processed".equals(ColumnName) && value instanceof Boolean && ((Boolean)value).booleanValue() && (oldValue == null || oldValue instanceof Boolean && !((Boolean)oldValue).booleanValue()) && this.get_ColumnIndex("ProcessedOn") > 0) {
            Timestamp ts = DB.getSQLValueTS(null, "SELECT CURRENT_TIMESTAMP FROM DUAL", new Object[0]);
            long mili = ts.getTime();
            int nano = ts.getNanos();
            double doublets = Double.parseDouble(String.valueOf(Long.toString(mili)) + "." + Integer.toString(nano));
            BigDecimal bdtimestamp = BigDecimal.valueOf(doublets);
            this.set_Value("ProcessedOn", (Object)bdtimestamp);
        }
    }

    public final boolean set_ValueNoCheck(String ColumnName, Object value) {
        return this.set_Value(ColumnName, value, false);
    }

    protected final boolean set_ValueNoCheckE(String ColumnName, Object value) {
        return this.set_ValueNoCheck(ColumnName, value);
    }

    public final void set_ValueOfColumn(String columnName, Object value) {
        this.set_ValueOfColumnReturningBoolean(columnName, value);
    }

    public final boolean set_ValueOfColumnReturningBoolean(String columnName, Object value) {
        int AD_Column_ID = this.p_info.getAD_Column_ID(columnName);
        if (AD_Column_ID > 0) {
            return this.set_ValueOfColumnReturningBoolean(AD_Column_ID, value);
        }
        return false;
    }

    public final void set_ValueOfColumn(int AD_Column_ID, Object value) {
        this.set_ValueOfColumnReturningBoolean(AD_Column_ID, value);
    }

    public final boolean set_ValueOfColumnReturningBoolean(int AD_Column_ID, Object value) {
        int index = this.p_info.getColumnIndex(AD_Column_ID);
        if (index < 0) {
            throw new AdempiereUserError("Not found - AD_Column_ID=" + AD_Column_ID);
        }
        String ColumnName = this.p_info.getColumnName(index);
        if (ColumnName.equals("IsApproved")) {
            return this.set_ValueNoCheck(ColumnName, value);
        }
        return this.set_Value(index, value);
    }

    public final void set_CustomColumn(String columnName, Object value) {
        this.set_CustomColumnReturningBoolean(columnName, value);
    }

    public final boolean set_CustomColumnReturningBoolean(String columnName, Object value) {
        int poIndex = this.get_ColumnIndex(columnName);
        if (poIndex > 0) {
            return this.set_Value(columnName, value);
        }
        if (this.m_custom == null) {
            this.m_custom = new HashMap();
        }
        String valueString = "NULL";
        if (value != null) {
            valueString = value instanceof Number ? value.toString() : (value instanceof Boolean ? ((Boolean)value != false ? "'Y'" : "'N'") : (value instanceof Timestamp ? DB.TO_DATE((Timestamp)value, false) : DB.TO_STRING(value.toString())));
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.log(Level.INFO, String.valueOf(columnName) + "=" + valueString);
        }
        this.m_custom.put(columnName, valueString);
        return true;
    }

    private void set_Keys(String ColumnName, Object value) {
        int i2 = 0;
        while (i2 < this.m_IDs.length) {
            if (ColumnName.equals(this.m_KeyColumns[i2])) {
                this.m_IDs[i2] = value;
            }
            ++i2;
        }
    }

    public int get_ColumnCount() {
        return this.p_info.getColumnCount();
    }

    public String get_ColumnName(int index) {
        return this.p_info.getColumnName(index);
    }

    protected String get_ColumnLabel(int index) {
        return this.p_info.getColumnLabel(index);
    }

    protected String get_ColumnDescription(int index) {
        return this.p_info.getColumnDescription(index);
    }

    protected boolean isColumnMandatory(int index) {
        return this.p_info.isColumnMandatory(index);
    }

    protected boolean isColumnUpdateable(int index) {
        return this.p_info.isColumnUpdateable(index);
    }

    protected void set_ColumnUpdateable(int index, boolean updateable) {
        this.p_info.setColumnUpdateable(index, updateable);
    }

    protected void setUpdateable(boolean updateable) {
        this.p_info.setUpdateable(updateable);
    }

    protected int get_ColumnDisplayType(int index) {
        return this.p_info.getColumnDisplayType(index);
    }

    protected Lookup get_ColumnLookup(int index) {
        return this.p_info.getColumnLookup(index);
    }

    public final int get_ColumnIndex(String columnName) {
        return this.p_info.getColumnIndex(columnName);
    }

    public String get_DisplayValue(String columnName, boolean currentValue) {
        Object value;
        Object object = value = currentValue ? this.get_Value(columnName) : this.get_ValueOld(columnName);
        if (value == null) {
            return "./.";
        }
        String retValue = value.toString();
        int index = this.get_ColumnIndex(columnName);
        if (index < 0) {
            return retValue;
        }
        int dt = this.get_ColumnDisplayType(index);
        if (DisplayType.isText(dt) || 20 == dt) {
            return retValue;
        }
        Lookup lookup = this.get_ColumnLookup(index);
        if (lookup != null) {
            return lookup.getDisplay(value);
        }
        return retValue;
    }

    protected static void copyValues(PO from, PO to, int AD_Client_ID, int AD_Org_ID) {
        PO.copyValues(from, to);
        to.setAD_Client_ID(AD_Client_ID);
        to.setAD_Org_ID(AD_Org_ID);
    }

    public static void copyValues(PO from, PO to) {
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("From ID=" + from.get_ID() + " - To ID=" + to.get_ID());
        }
        if (from.getClass() != to.getClass()) {
            int i1 = 0;
            while (i1 < from.m_oldValues.length) {
                String colName = from.p_info.getColumnName(i1);
                MColumn column = MColumn.get(from.getCtx(), from.p_info.getAD_Column_ID(colName));
                if (!(column.isVirtualColumn() || column.isKey() || column.isUUIDColumn() || column.isStandardColumn() || !column.isAllowCopy())) {
                    int i2 = 0;
                    while (i2 < to.m_oldValues.length) {
                        if (to.p_info.getColumnName(i2).equals(colName)) {
                            to.m_newValues[i2] = from.m_oldValues[i1];
                            break;
                        }
                        ++i2;
                    }
                }
                ++i1;
            }
        } else {
            int i2 = 0;
            while (i2 < from.m_oldValues.length) {
                String colName = from.p_info.getColumnName(i2);
                MColumn column = MColumn.get(from.getCtx(), from.p_info.getAD_Column_ID(colName));
                if (!(column.isVirtualColumn() || column.isKey() || column.isUUIDColumn() || column.isStandardColumn() || !column.isAllowCopy())) {
                    to.m_newValues[i2] = from.m_oldValues[i2];
                }
                ++i2;
            }
        }
    }

    protected void load(int ID, String trxName) {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("ID=" + ID);
        }
        if (ID > 0) {
            this.setKeyInfo();
            this.m_IDs = new Object[]{ID};
            this.load(trxName);
        } else {
            this.loadDefaults();
            this.m_createNew = true;
            this.setKeyInfo();
            this.loadComplete(true);
        }
    }

    public boolean load(String trxName) {
        boolean success;
        block18: {
            this.m_trxName = trxName;
            success = true;
            StringBuilder sql = new StringBuilder("SELECT ");
            int size = this.get_ColumnCount();
            int i2 = 0;
            while (i2 < size) {
                if (i2 != 0) {
                    sql.append(",");
                }
                sql.append(this.p_info.getColumnSQL(i2));
                ++i2;
            }
            sql.append(" FROM ").append(this.p_info.getTableName()).append(" WHERE ").append(this.get_WhereClause(false));
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest(this.get_WhereClause(true));
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), this.m_trxName);
                    int i3 = 0;
                    while (i3 < this.m_IDs.length) {
                        Object oo = this.m_IDs[i3];
                        if (oo instanceof Integer) {
                            pstmt.setInt(i3 + 1, (Integer)this.m_IDs[i3]);
                        } else if (oo instanceof Boolean) {
                            pstmt.setString(i3 + 1, (Boolean)this.m_IDs[i3] != false ? "Y" : "N");
                        } else if (oo instanceof Timestamp) {
                            pstmt.setTimestamp(i3 + 1, (Timestamp)this.m_IDs[i3]);
                        } else {
                            pstmt.setString(i3 + 1, this.m_IDs[i3].toString());
                        }
                        ++i3;
                    }
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        success = this.load(rs);
                    } else {
                        this.log.log(Level.SEVERE, "NO Data found for " + this.get_WhereClause(true), new Exception());
                        this.m_IDs = new Object[]{I_ZERO};
                        success = false;
                    }
                    this.m_createNew = false;
                    this.m_newValues = new Object[size];
                }
                catch (Exception e) {
                    String msg = "";
                    if (this.m_trxName != null) {
                        msg = "[" + this.m_trxName + "] - ";
                    }
                    msg = String.valueOf(msg) + this.get_WhereClause(true) + ", SQL=" + sql.toString();
                    success = false;
                    this.m_IDs = new Object[]{I_ZERO};
                    this.log.log(Level.SEVERE, msg, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block18;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.loadComplete(success);
        return success;
    }

    protected boolean load(ResultSet rs) {
        int size = this.get_ColumnCount();
        boolean success = true;
        int index = 0;
        this.log.finest("(rs)");
        index = 0;
        while (index < size) {
            String columnName = this.p_info.getColumnName(index);
            Class<?> clazz = this.p_info.getColumnClass(index);
            int dt = this.p_info.getColumnDisplayType(index);
            try {
                if (clazz == Integer.class) {
                    this.m_oldValues[index] = this.decrypt(index, rs.getInt(columnName));
                } else if (clazz == BigDecimal.class) {
                    this.m_oldValues[index] = this.decrypt(index, rs.getBigDecimal(columnName));
                } else if (clazz == Boolean.class) {
                    this.m_oldValues[index] = "Y".equals(this.decrypt(index, rs.getString(columnName)));
                } else if (clazz == Timestamp.class) {
                    this.m_oldValues[index] = this.decrypt(index, rs.getTimestamp(columnName));
                } else if (DisplayType.isLOB(dt)) {
                    this.m_oldValues[index] = this.get_LOB(rs.getObject(columnName));
                } else if (clazz == String.class) {
                    String value = (String)this.decrypt(index, rs.getString(columnName));
                    if (value != null && (this.get_Table_ID() == 101 || this.get_Table_ID() == 276 || this.get_Table_ID() == 107) && ("Description".equals(columnName) || "Help".equals(columnName))) {
                        value = value.intern();
                    }
                    this.m_oldValues[index] = value;
                } else {
                    this.m_oldValues[index] = this.loadSpecial(rs, index);
                }
                if (rs.wasNull() && this.m_oldValues[index] != null) {
                    this.m_oldValues[index] = null;
                }
                if (CLogMgt.isLevelAll()) {
                    this.log.finest(String.valueOf(String.valueOf(index)) + ": " + this.p_info.getColumnName(index) + "(" + this.p_info.getColumnClass(index) + ") = " + this.m_oldValues[index]);
                }
            }
            catch (SQLException e) {
                if (this.p_info.isVirtualColumn(index)) {
                    if (this.log.isLoggable(Level.FINER)) {
                        this.log.log(Level.FINER, "Virtual Column not loaded: " + columnName);
                    }
                }
                this.log.log(Level.SEVERE, "(rs) - " + String.valueOf(index) + ": " + this.p_info.getTableName() + "." + this.p_info.getColumnName(index) + " (" + this.p_info.getColumnClass(index) + ") - " + e);
                success = false;
            }
            ++index;
        }
        this.m_createNew = false;
        this.setKeyInfo();
        this.loadComplete(success);
        return success;
    }

    protected boolean load(HashMap<String, String> hmIn) {
        int size = this.get_ColumnCount();
        boolean success = true;
        int index = 0;
        this.log.finest("(hm)");
        index = 0;
        while (index < size) {
            String columnName = this.p_info.getColumnName(index);
            String value = hmIn.get(columnName);
            if (value != null) {
                Class<?> clazz = this.p_info.getColumnClass(index);
                int dt = this.p_info.getColumnDisplayType(index);
                try {
                    this.m_oldValues[index] = clazz == Integer.class ? Integer.valueOf(value) : (clazz == BigDecimal.class ? new BigDecimal(value) : (clazz == Boolean.class ? Boolean.valueOf("Y".equals(value)) : (clazz == Timestamp.class ? Timestamp.valueOf(value) : (DisplayType.isLOB(dt) ? null : (clazz == String.class ? value : null)))));
                    if (CLogMgt.isLevelAll()) {
                        this.log.finest(String.valueOf(String.valueOf(index)) + ": " + this.p_info.getColumnName(index) + "(" + this.p_info.getColumnClass(index) + ") = " + this.m_oldValues[index]);
                    }
                }
                catch (Exception e) {
                    if (this.p_info.isVirtualColumn(index)) {
                        if (this.log.isLoggable(Level.FINER)) {
                            this.log.log(Level.FINER, "Virtual Column not loaded: " + columnName);
                        }
                    }
                    this.log.log(Level.SEVERE, "(ht) - " + String.valueOf(index) + ": " + this.p_info.getTableName() + "." + this.p_info.getColumnName(index) + " (" + this.p_info.getColumnClass(index) + ") - " + e);
                    success = false;
                }
            }
            ++index;
        }
        this.m_createNew = false;
        this.setStandardDefaults();
        this.setKeyInfo();
        this.loadComplete(success);
        return success;
    }

    protected HashMap<String, String> get_HashMap() {
        HashMap<String, String> hmOut = new HashMap<String, String>();
        int size = this.get_ColumnCount();
        int i2 = 0;
        while (i2 < size) {
            Object value = this.get_Value(i2);
            if (value != null && !this.p_info.isVirtualColumn(i2)) {
                int dt = this.p_info.getColumnDisplayType(i2);
                Class<?> c = this.p_info.getColumnClass(i2);
                String stringValue = null;
                if (c != Object.class && value != null && !value.equals(Null.NULL)) {
                    if (value instanceof Integer || value instanceof BigDecimal) {
                        stringValue = value.toString();
                    } else if (c == Boolean.class) {
                        boolean bValue = false;
                        bValue = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
                        stringValue = bValue ? "Y" : "N";
                    } else if (value instanceof Timestamp) {
                        stringValue = value.toString();
                    } else if (c == String.class) {
                        stringValue = (String)value;
                    } else if (DisplayType.isLOB(dt)) {
                        // empty if block
                    }
                }
                if (stringValue != null) {
                    hmOut.put(this.p_info.getColumnName(i2), stringValue);
                }
            }
            ++i2;
        }
        if (this.m_custom != null) {
            for (String column : this.m_custom.keySet()) {
                String value = this.m_custom.get(column);
                if (value == null) continue;
                hmOut.put(column, value);
            }
            this.m_custom = null;
        }
        return hmOut;
    }

    protected Object loadSpecial(ResultSet rs, int index) throws SQLException {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("(NOP) - " + this.p_info.getColumnName(index));
        }
        return null;
    }

    protected void loadComplete(boolean success) {
    }

    protected void loadDefaults() {
        this.setStandardDefaults();
    }

    protected void setStandardDefaults() {
        int size = this.get_ColumnCount();
        int i2 = 0;
        while (i2 < size) {
            if (!this.p_info.isVirtualColumn(i2)) {
                String colName = this.p_info.getColumnName(i2);
                if (colName.endsWith("tedBy")) {
                    this.m_newValues[i2] = Env.getContextAsInt(this.p_ctx, "#AD_User_ID");
                } else if (colName.equals("Created") || colName.equals("Updated")) {
                    this.m_newValues[i2] = new Timestamp(System.currentTimeMillis());
                } else if (colName.equals(String.valueOf(this.p_info.getTableName()) + "_ID")) {
                    this.m_newValues[i2] = I_ZERO;
                } else if (colName.equals("IsActive")) {
                    this.m_newValues[i2] = Boolean.TRUE;
                } else if (colName.equals("AD_Client_ID")) {
                    this.m_newValues[i2] = Env.getAD_Client_ID(this.p_ctx);
                } else if (colName.equals("AD_Org_ID")) {
                    this.m_newValues[i2] = Env.getAD_Org_ID(this.p_ctx);
                } else if (colName.equals("Processed")) {
                    this.m_newValues[i2] = Boolean.FALSE;
                } else if (colName.equals("Processing")) {
                    this.m_newValues[i2] = Boolean.FALSE;
                } else if (colName.equals("Posted")) {
                    this.m_newValues[i2] = Boolean.FALSE;
                }
            }
            ++i2;
        }
    }

    private void setKeyInfo() {
        int i2 = 0;
        while (i2 < this.p_info.getColumnCount()) {
            if (this.p_info.isKey(i2)) {
                String ColumnName = this.p_info.getColumnName(i2);
                this.m_KeyColumns = new String[]{ColumnName};
                if (this.p_info.getColumnName(i2).endsWith("_ID")) {
                    Integer ii = (Integer)this.get_Value(i2);
                    this.m_IDs = ii == null ? new Object[]{I_ZERO} : new Object[]{ii};
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("(PK) " + ColumnName + "=" + ii);
                    }
                } else {
                    Object oo = this.get_Value(i2);
                    this.m_IDs = oo == null ? new Object[1] : new Object[]{oo};
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("(PK) " + ColumnName + "=" + oo);
                    }
                }
                return;
            }
            ++i2;
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        int i3 = 0;
        while (i3 < this.p_info.getColumnCount()) {
            if (this.p_info.isColumnParent(i3)) {
                columnNames.add(this.p_info.getColumnName(i3));
            }
            ++i3;
        }
        int size = columnNames.size();
        if (size == 0) {
            throw new IllegalStateException("No PK nor FK - " + this.p_info.getTableName());
        }
        this.m_IDs = new Object[size];
        this.m_KeyColumns = new String[size];
        int i4 = 0;
        while (i4 < size) {
            this.m_KeyColumns[i4] = (String)columnNames.get(i4);
            if (this.m_KeyColumns[i4].endsWith("_ID")) {
                Integer ii = null;
                try {
                    ii = (Integer)this.get_Value(this.m_KeyColumns[i4]);
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "", e);
                }
                if (ii != null) {
                    this.m_IDs[i4] = ii;
                }
            } else {
                this.m_IDs[i4] = this.get_Value(this.m_KeyColumns[i4]);
            }
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("(FK) " + this.m_KeyColumns[i4] + "=" + this.m_IDs[i4]);
            }
            ++i4;
        }
    }

    protected boolean isMandatoryOK() {
        int size = this.get_ColumnCount();
        int i2 = 0;
        while (i2 < size) {
            if (this.p_info.isColumnMandatory(i2) && !this.p_info.isVirtualColumn(i2) && (this.get_Value(i2) == null || this.get_Value(i2).equals(Null.NULL))) {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info(this.p_info.getColumnName(i2));
                }
                return false;
            }
            ++i2;
        }
        return true;
    }

    protected final void setAD_Client_ID(int AD_Client_ID) {
        this.set_ValueNoCheck("AD_Client_ID", AD_Client_ID);
    }

    public final int getAD_Client_ID() {
        Integer ii = (Integer)this.get_Value("AD_Client_ID");
        if (ii == null) {
            return 0;
        }
        return ii;
    }

    public final void setAD_Org_ID(int AD_Org_ID) {
        this.set_ValueNoCheck("AD_Org_ID", AD_Org_ID);
    }

    public int getAD_Org_ID() {
        Integer ii = (Integer)this.get_Value("AD_Org_ID");
        if (ii == null) {
            return 0;
        }
        return ii;
    }

    protected void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        if (AD_Client_ID != this.getAD_Client_ID()) {
            this.setAD_Client_ID(AD_Client_ID);
        }
        if (AD_Org_ID != this.getAD_Org_ID()) {
            this.setAD_Org_ID(AD_Org_ID);
        }
    }

    protected void setClientOrg(PO po) {
        this.setClientOrg(po.getAD_Client_ID(), po.getAD_Org_ID());
    }

    public final void setIsActive(boolean active) {
        this.set_Value("IsActive", (Object)active);
    }

    public final boolean isActive() {
        Boolean bb = (Boolean)this.get_Value("IsActive");
        if (bb != null) {
            return bb;
        }
        return false;
    }

    public final Timestamp getCreated() {
        return (Timestamp)this.get_Value("Created");
    }

    public final Timestamp getUpdated() {
        return (Timestamp)this.get_Value("Updated");
    }

    public final int getCreatedBy() {
        Integer ii = (Integer)this.get_Value("CreatedBy");
        if (ii == null) {
            return 0;
        }
        return ii;
    }

    public final int getUpdatedBy() {
        Integer ii = (Integer)this.get_Value("UpdatedBy");
        if (ii == null) {
            return 0;
        }
        return ii;
    }

    protected final void setUpdatedBy(int AD_User_ID) {
        this.set_ValueNoCheck("UpdatedBy", AD_User_ID);
    }

    public String get_Translation(String columnName, String AD_Language) {
        return this.get_Translation(columnName, AD_Language, false, true);
    }

    public String get_Translation(String columnName, String AD_Language, boolean reload, boolean fallback) {
        if (columnName == null || AD_Language == null || this.m_IDs.length > 1 || this.m_IDs[0].equals(I_ZERO) || !(this.m_IDs[0] instanceof Integer)) {
            throw new IllegalArgumentException("ColumnName=" + columnName + ", AD_Language=" + AD_Language + ", ID.length=" + this.m_IDs.length + ", ID=" + this.m_IDs[0]);
        }
        String key = this.getTrlCacheKey(columnName, AD_Language);
        String retValue = null;
        if (!reload && trl_cache.containsKey(key)) {
            retValue = trl_cache.get(key);
            return retValue;
        }
        if (!Env.isBaseLanguage(AD_Language, this.get_TableName()) && this.p_info.isColumnTranslated(this.p_info.getColumnIndex(columnName))) {
            int ID = (Integer)this.m_IDs[0];
            StringBuilder sql = new StringBuilder("SELECT ").append(columnName).append(" FROM ").append(this.p_info.getTableName()).append("_Trl WHERE ").append(this.m_KeyColumns[0]).append("=?").append(" AND AD_Language=?");
            retValue = DB.getSQLValueString(this.get_TrxName(), sql.toString(), ID, AD_Language);
        }
        if (retValue == null && fallback) {
            Object val = this.get_Value(columnName);
            retValue = val != null ? val.toString() : null;
        }
        trl_cache.put(key, retValue);
        return retValue;
    }

    private String getTrlCacheKey(String columnName, String AD_Language) {
        return String.valueOf(this.get_TableName()) + "." + columnName + "|" + this.get_ID() + "|" + AD_Language;
    }

    public String get_Translation(String columnName) {
        return this.get_Translation(columnName, true);
    }

    public String get_Translation(String columnName, String AD_Language, boolean reload) {
        return this.get_Translation(columnName, AD_Language, reload, true);
    }

    public String get_Translation(String columnName, boolean fallback) {
        return this.get_Translation(columnName, Env.getAD_Language(this.getCtx()), false, fallback);
    }

    public boolean is_new() {
        if (this.m_createNew) {
            return true;
        }
        int i2 = 0;
        while (i2 < this.m_IDs.length) {
            if (!this.m_IDs[i2].equals(I_ZERO) && this.m_IDs[i2] != Null.NULL) {
                return false;
            }
            ++i2;
        }
        return !MTable.isZeroIDTable(this.get_TableName());
    }

    public boolean save() {
        this.checkValidContext();
        CLogger.resetLast();
        boolean newRecord = this.is_new();
        if (!newRecord && !this.is_Changed()) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Nothing changed - " + this.p_info.getTableName());
            }
            return true;
        }
        int i2 = 0;
        while (i2 < this.m_setErrors.length) {
            ValueNamePair setError = this.m_setErrors[i2];
            if (setError != null) {
                this.log.saveError(setError.getValue(), String.valueOf(Msg.getElement(this.getCtx(), this.p_info.getColumnName(i2))) + " - " + setError.getName());
                return false;
            }
            ++i2;
        }
        if (this.getAD_Org_ID() == 0 && (this.get_AccessLevel() == 1 || this.get_AccessLevel() == 3 && MClientShare.isOrgLevelOnly(this.getAD_Client_ID(), this.get_Table_ID()))) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "AD_Org_ID"));
            return false;
        }
        if (this.getAD_Org_ID() != 0) {
            boolean reset;
            boolean bl = reset = this.get_AccessLevel() == 4;
            if (!reset && MClientShare.isClientLevelOnly(this.getAD_Client_ID(), this.get_Table_ID())) {
                boolean bl2 = reset = this.get_AccessLevel() == 2 || this.get_AccessLevel() == 6 || this.get_AccessLevel() == 7 || this.get_AccessLevel() == 3;
            }
            if (reset) {
                this.log.warning("Set Org to 0");
                this.setAD_Org_ID(0);
            }
        }
        Trx localTrx = null;
        Trx trx = null;
        Savepoint savepoint = null;
        if (this.m_trxName == null) {
            StringBuilder l_trxname = new StringBuilder(LOCAL_TRX_PREFIX).append(this.get_TableName());
            if (l_trxname.length() > 23) {
                l_trxname.setLength(23);
            }
            this.m_trxName = Trx.createTrxName(l_trxname.toString());
            localTrx = Trx.get(this.m_trxName, true);
            if (newRecord) {
                localTrx.setDisplayName(String.valueOf(this.getClass().getName()) + "_insert");
            } else {
                localTrx.setDisplayName(String.valueOf(this.getClass().getName()) + "_update_ID" + this.get_ID());
            }
            localTrx.getConnection();
        } else {
            trx = Trx.get(this.m_trxName, false);
            if (trx == null) {
                trx = Trx.get(this.m_trxName, true);
                this.log.severe("Transaction closed or never opened (" + this.m_trxName + ") => starting now --> " + this.toString());
            }
        }
        try {
            if (localTrx == null) {
                savepoint = trx.setSavepoint(null);
            }
            if (!this.beforeSave(newRecord)) {
                this.log.warning("beforeSave failed - " + this.toString());
                if (localTrx != null) {
                    localTrx.rollback();
                    localTrx.close();
                    this.m_trxName = null;
                } else {
                    trx.rollback(savepoint);
                    savepoint = null;
                }
                return false;
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "beforeSave - " + this.toString(), e);
            String msg = DBException.getDefaultDBExceptionMessage(e);
            this.log.saveError(msg != null ? msg : "Error", e, false);
            if (localTrx != null) {
                localTrx.rollback();
                localTrx.close();
                this.m_trxName = null;
            } else if (savepoint != null) {
                try {
                    trx.rollback(savepoint);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                savepoint = null;
            }
            return false;
        }
        try {
            boolean b2;
            String errorMsg = ModelValidationEngine.get().fireModelChange(this, newRecord ? 1 : 2);
            if (errorMsg != null) {
                this.log.warning("Validation failed - " + errorMsg);
                this.log.saveError("Error", errorMsg);
                if (localTrx != null) {
                    localTrx.rollback();
                    this.m_trxName = null;
                } else {
                    trx.rollback(savepoint);
                }
                return false;
            }
            if (newRecord) {
                b2 = this.saveNew();
                if (b2) {
                    if (localTrx != null) {
                        boolean bl = localTrx.commit();
                        return bl;
                    }
                    boolean bl = b2;
                    return bl;
                }
                this.validateUniqueIndex();
                if (localTrx != null) {
                    localTrx.rollback();
                } else {
                    trx.rollback(savepoint);
                }
                boolean bl = b2;
                return bl;
            }
            b2 = this.saveUpdate();
            if (b2) {
                if (localTrx != null) {
                    boolean bl = localTrx.commit();
                    return bl;
                }
                boolean bl = b2;
                return bl;
            }
            this.validateUniqueIndex();
            if (localTrx != null) {
                localTrx.rollback();
            } else {
                trx.rollback(savepoint);
            }
            boolean bl = b2;
            return bl;
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "afterSave - " + this.toString(), e);
            String msg = DBException.getDefaultDBExceptionMessage(e);
            this.log.saveError(msg != null ? msg : "Error", e);
            if (localTrx != null) {
                localTrx.rollback();
            } else if (savepoint != null) {
                try {
                    trx.rollback(savepoint);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                savepoint = null;
            }
            return false;
        }
        finally {
            if (localTrx != null) {
                localTrx.close();
                this.m_trxName = null;
            } else {
                if (savepoint != null) {
                    try {
                        trx.releaseSavepoint(savepoint);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                savepoint = null;
                trx = null;
            }
        }
    }

    public void saveEx() throws AdempiereException {
        if (!this.save()) {
            String val;
            String msg = null;
            ValueNamePair err = CLogger.retrieveError();
            String string = val = err != null ? Msg.translate(this.getCtx(), err.getValue()) : "";
            if (err != null) {
                msg = String.valueOf(val != null ? String.valueOf(val) + ": " : "") + err.getName();
            }
            if (msg == null || msg.length() == 0) {
                msg = "SaveError";
            }
            throw new AdempiereException(msg);
        }
    }

    private boolean saveFinish(boolean newRecord, boolean success) {
        if (success) {
            if (newRecord) {
                this.insertTranslations();
            } else {
                this.updateTranslations();
            }
            if (this.get_ColumnIndex("IsSummary") >= 0) {
                if (newRecord) {
                    this.insert_Tree("TL");
                }
                int idxValue = this.get_ColumnIndex("Value");
                if (newRecord || idxValue >= 0 && this.is_ValueChanged(idxValue)) {
                    this.update_Tree("TL");
                }
            }
        }
        try {
            success = this.afterSave(newRecord, success);
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "afterSave", e);
            this.log.saveError("Error", e, false);
            success = false;
        }
        if (success) {
            String errorMsg = ModelValidationEngine.get().fireModelChange(this, newRecord ? (this.isReplication() ? 7 : 4) : (this.isReplication() ? 8 : 5));
            this.setReplication(false);
            if (errorMsg != null) {
                this.log.saveError("Error", errorMsg);
                success = false;
            }
        }
        if (success) {
            String topic = newRecord ? "adempiere/po/postCreate" : "adempiere/po/postUpdate";
            Event event = EventManager.newEvent(topic, this);
            EventManager.getInstance().postEvent(event);
            if (s_docWFMgr == null) {
                try {
                    Class.forName("org.compiere.wf.DocWorkflowManager");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (s_docWFMgr != null) {
                s_docWFMgr.process(this, this.p_info.getAD_Table_ID());
            }
            int size = this.p_info.getColumnCount();
            int i2 = 0;
            while (i2 < size) {
                if (this.m_newValues[i2] != null) {
                    this.m_oldValues[i2] = this.m_newValues[i2] == Null.NULL ? null : this.m_newValues[i2];
                }
                ++i2;
            }
            this.m_newValues = new Object[size];
            this.m_createNew = false;
        }
        if (!newRecord) {
            CacheMgt.get().reset(this.p_info.getTableName());
            MRecentItem.clearLabel(this.p_info.getAD_Table_ID(), this.get_ID());
        } else if (this.get_ID() > 0 && success) {
            CacheMgt.get().newRecord(this.p_info.getTableName(), this.get_ID());
        }
        return success;
    }

    public boolean save(String trxName) {
        this.set_TrxName(trxName);
        return this.save();
    }

    public void saveReplica(boolean isFromReplication) throws AdempiereException {
        this.setReplication(isFromReplication);
        this.saveEx();
    }

    public void saveEx(String trxName) throws AdempiereException {
        this.set_TrxName(trxName);
        this.saveEx();
    }

    public boolean is_Changed() {
        int size = this.get_ColumnCount();
        int i2 = 0;
        while (i2 < size) {
            if (this.is_ValueChanged(i2)) {
                return true;
            }
            ++i2;
        }
        return this.m_custom != null && this.m_custom.size() > 0;
    }

    protected boolean beforeSave(boolean newRecord) {
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        return success;
    }

    protected boolean saveUpdate() {
        boolean ok = this.doUpdate(this.isLogSQLScript());
        return this.saveFinish(false, ok);
    }

    private boolean isLogSQLScript() {
        String sysProperty;
        boolean logMigrationScript = false;
        logMigrationScript = Ini.isClient() ? Ini.isPropertyBool("LogMigrationScript") : "y".equalsIgnoreCase(sysProperty = Env.getCtx().getProperty("LogMigrationScript", "N")) || "true".equalsIgnoreCase(sysProperty);
        return logMigrationScript;
    }

    private boolean doUpdate(boolean withValues) {
        ArrayList<Object> params = new ArrayList<Object>();
        String where = this.get_WhereClause(true);
        boolean changes = false;
        StringBuilder sql = new StringBuilder("UPDATE ");
        sql.append(this.p_info.getTableName()).append(" SET ");
        boolean updated = false;
        boolean updatedBy = false;
        this.lobReset();
        MSession session = MSession.get(this.p_ctx, false);
        if (session == null) {
            this.log.fine("No Session found");
        }
        int AD_ChangeLog_ID = 0;
        int size = this.get_ColumnCount();
        int i2 = 0;
        while (i2 < size) {
            block63: {
                String columnName;
                int dt;
                Class<?> c;
                Object value;
                block65: {
                    block64: {
                        value = this.m_newValues[i2];
                        if (value == null || this.p_info.isVirtualColumn(i2)) break block63;
                        c = this.p_info.getColumnClass(i2);
                        dt = this.p_info.getColumnDisplayType(i2);
                        columnName = this.p_info.getColumnName(i2);
                        if (!columnName.equals("UpdatedBy")) break block64;
                        if (updatedBy) break block63;
                        updatedBy = true;
                        break block65;
                    }
                    if (!columnName.equals("Updated")) break block65;
                    if (updated) break block63;
                    updated = true;
                }
                if (DisplayType.isLOB(dt)) {
                    this.lobAdd(value, i2, dt);
                    if (!changes && !updatedBy) {
                        int AD_User_ID = Env.getContextAsInt(this.p_ctx, "#AD_User_ID");
                        this.set_ValueNoCheck("UpdatedBy", AD_User_ID);
                        sql.append("UpdatedBy=").append(AD_User_ID);
                        changes = true;
                        updatedBy = true;
                    }
                } else {
                    if (columnName.equals("DocumentNo")) {
                        String strValue = (String)value;
                        if (strValue.startsWith("<") && strValue.endsWith(">")) {
                            value = null;
                            int AD_Client_ID = this.getAD_Client_ID();
                            int index = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
                            if (index == -1) {
                                index = this.p_info.getColumnIndex("C_DocType_ID");
                            }
                            if (index != -1) {
                                value = DB.getDocumentNo(this.get_ValueAsInt(index), this.m_trxName, false, this);
                            }
                            if (value == null) {
                                value = DB.getDocumentNo(AD_Client_ID, this.p_info.getTableName(), this.m_trxName, this);
                            }
                        } else if (this.log.isLoggable(Level.INFO)) {
                            this.log.info("DocumentNo updated: " + this.m_oldValues[i2] + " -> " + value);
                        }
                    }
                    if (changes) {
                        sql.append(", ");
                    }
                    changes = true;
                    sql.append(columnName).append("=");
                    if (withValues) {
                        if (value == Null.NULL) {
                            sql.append("NULL");
                        } else if (value instanceof Integer || value instanceof BigDecimal) {
                            sql.append(value);
                        } else if (c == Boolean.class) {
                            boolean bValue = false;
                            bValue = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
                            sql.append(this.encrypt(i2, bValue ? "'Y'" : "'N'"));
                        } else if (value instanceof Timestamp) {
                            sql.append(DB.TO_DATE((Timestamp)this.encrypt(i2, value), this.p_info.getColumnDisplayType(i2) == 15));
                        } else if (value.toString().length() == 0) {
                            sql.append(DB.TO_STRING(value.toString()));
                        } else {
                            sql.append(this.encrypt(i2, DB.TO_STRING(value.toString())));
                        }
                    } else {
                        if (value instanceof Timestamp && dt == 15) {
                            sql.append("trunc(cast(? as date))");
                        } else {
                            sql.append("?");
                        }
                        if (value == Null.NULL) {
                            params.add(null);
                        } else if (c == Boolean.class) {
                            boolean bValue = false;
                            bValue = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
                            params.add(this.encrypt(i2, bValue ? "Y" : "N"));
                        } else if (c == String.class) {
                            if (value.toString().length() == 0) {
                                params.add(null);
                            } else {
                                params.add(this.encrypt(i2, value));
                            }
                        } else {
                            params.add(value);
                        }
                    }
                    if (session != null && this.m_IDs.length == 1 && this.p_info.isAllowLogging(i2) && !this.p_info.isEncrypted(i2) && !this.p_info.isVirtualColumn(i2) && !"Password".equals(columnName)) {
                        MChangeLog cLog;
                        Object oldV = this.m_oldValues[i2];
                        Object newV = value;
                        if (oldV != null && oldV == Null.NULL) {
                            oldV = null;
                        }
                        if (newV != null && newV == Null.NULL) {
                            newV = null;
                        }
                        if ((cLog = session.changeLog(this.m_trxName, AD_ChangeLog_ID, this.p_info.getAD_Table_ID(), this.p_info.getColumn((int)i2).AD_Column_ID, this.get_ID(), this.getAD_Client_ID(), this.getAD_Org_ID(), oldV, newV, ENTITYTYPE_UserMaintained)) != null) {
                            AD_ChangeLog_ID = cLog.getAD_ChangeLog_ID();
                        }
                    }
                }
            }
            ++i2;
        }
        if (this.m_custom != null) {
            Iterator<String> it = this.m_custom.keySet().iterator();
            while (it.hasNext()) {
                if (changes) {
                    sql.append(", ");
                }
                changes = true;
                String column = it.next();
                String value = this.m_custom.get(column);
                int index = this.p_info.getColumnIndex(column);
                if (withValues) {
                    sql.append(column).append("=").append(this.encrypt(index, value));
                    continue;
                }
                sql.append(column).append("=?");
                if (value == null || value.toString().length() == 0) {
                    params.add(null);
                    continue;
                }
                params.add(this.encrypt(index, value));
            }
            this.m_custom = null;
        }
        if (changes) {
            boolean ok;
            if (this.m_trxName == null) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(String.valueOf(this.p_info.getTableName()) + "." + where);
                }
            } else if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("[" + this.m_trxName + "] - " + this.p_info.getTableName() + "." + where);
            }
            if (!updated) {
                Timestamp now = new Timestamp(System.currentTimeMillis());
                this.set_ValueNoCheck("Updated", now);
                if (withValues) {
                    sql.append(",Updated=").append(DB.TO_DATE(now, false));
                } else {
                    sql.append(",Updated=?");
                    params.add(now);
                }
            }
            if (!updatedBy) {
                int AD_User_ID = Env.getContextAsInt(this.p_ctx, "#AD_User_ID");
                this.set_ValueNoCheck("UpdatedBy", AD_User_ID);
                if (withValues) {
                    sql.append(",UpdatedBy=").append(AD_User_ID);
                } else {
                    sql.append(",UpdatedBy=?");
                    params.add(AD_User_ID);
                }
            }
            sql.append(" WHERE ").append(where);
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest(sql.toString());
            }
            int no = 0;
            no = this.isUseTimeoutForUpdate() ? (withValues ? DB.executeUpdateEx(sql.toString(), this.m_trxName, 300) : DB.executeUpdateEx(sql.toString(), params.toArray(), this.m_trxName, 300)) : (withValues ? DB.executeUpdate(sql.toString(), this.m_trxName) : DB.executeUpdate(sql.toString(), params.toArray(), false, this.m_trxName));
            boolean bl = ok = no == 1;
            if (ok) {
                ok = this.lobSave();
            } else if (this.m_trxName == null) {
                this.log.saveError("SaveError", "Update return " + no + " instead of 1" + " - " + this.p_info.getTableName() + "." + where);
            } else {
                this.log.saveError("SaveError", "Update return " + no + " instead of 1" + " - [" + this.m_trxName + "] - " + this.p_info.getTableName() + "." + where);
            }
            return ok;
        }
        return true;
    }

    private boolean isUseTimeoutForUpdate() {
        return "true".equalsIgnoreCase(System.getProperty(USE_TIMEOUT_FOR_UPDATE, "false")) && DB.getDatabase().isQueryTimeoutSupported();
    }

    private boolean saveNew() {
        String value;
        String columnName;
        int index;
        int uuidIndex;
        if (this.m_IDs.length == 1 && this.p_info.hasKeyColumn() && this.m_KeyColumns[0].endsWith("_ID")) {
            int no = this.saveNew_getID();
            if (no <= 0) {
                no = DB.getNextID(this.getAD_Client_ID(), this.p_info.getTableName(), this.m_trxName);
            }
            if (this.isReplication() && this.get_ID() > 0) {
                no = this.get_ID();
            }
            if (no <= 0) {
                this.log.severe("No NextID (" + no + ")");
                return this.saveFinish(true, false);
            }
            this.m_IDs[0] = no;
            this.set_ValueNoCheck(this.m_KeyColumns[0], this.m_IDs[0]);
        }
        if ((uuidIndex = this.p_info.getColumnIndex(this.getUUIDColumnName())) >= 0) {
            String value2 = (String)this.get_Value(uuidIndex);
            if (this.p_info.getColumn((int)uuidIndex).FieldLength == 36 && (value2 == null || value2.length() == 0)) {
                UUID uuid = UUID.randomUUID();
                this.set_ValueNoCheck(this.p_info.getColumnName(uuidIndex), uuid.toString());
            }
        }
        if (this.m_trxName == null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(this.p_info.getTableName()) + " - " + this.get_WhereClause(true));
            }
        } else if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("[" + this.m_trxName + "] - " + this.p_info.getTableName() + " - " + this.get_WhereClause(true));
        }
        if ((index = this.p_info.getColumnIndex(columnName = "DocumentNo")) != -1) {
            value = (String)this.get_Value(index);
            if (value != null && value.startsWith("<") && value.endsWith(">")) {
                value = null;
            }
            if (value == null || value.length() == 0) {
                int dt = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
                if (dt == -1) {
                    dt = this.p_info.getColumnIndex("C_DocType_ID");
                }
                if (dt != -1) {
                    value = DB.getDocumentNo(this.get_ValueAsInt(dt), this.m_trxName, false, this);
                }
                if (value == null) {
                    value = DB.getDocumentNo(this.getAD_Client_ID(), this.p_info.getTableName(), this.m_trxName, this);
                }
                this.set_ValueNoCheck(columnName, value);
            }
        }
        if (!("M_AttributeInstance".equals(this.get_TableName()) || (index = this.p_info.getColumnIndex(columnName = "Value")) == -1 || this.p_info.isVirtualColumn(index) || (value = (String)this.get_Value(index)) != null && value.length() != 0)) {
            value = DB.getDocumentNo(this.getAD_Client_ID(), this.p_info.getTableName(), this.m_trxName, this);
            this.set_ValueNoCheck(columnName, value);
        }
        boolean ok = this.doInsert(this.isLogSQLScript());
        return this.saveFinish(true, ok);
    }

    private boolean doInsert(boolean withValues) {
        boolean ok;
        this.lobReset();
        MSession session = MSession.get(this.p_ctx, false);
        if (session == null) {
            this.log.fine("No Session found");
        }
        int AD_ChangeLog_ID = 0;
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder sqlInsert = new StringBuilder("INSERT INTO ");
        sqlInsert.append(this.p_info.getTableName()).append(" (");
        StringBuilder sqlValues = new StringBuilder(") VALUES (");
        int size = this.get_ColumnCount();
        boolean doComma = false;
        int i2 = 0;
        while (i2 < size) {
            block51: {
                MChangeLog cLog;
                int dt;
                Object value;
                block52: {
                    value = this.get_Value(i2);
                    if (value == null || this.p_info.isVirtualColumn(i2)) break block51;
                    dt = this.p_info.getColumnDisplayType(i2);
                    if (!DisplayType.isLOB(dt)) break block52;
                    this.lobAdd(value, i2, dt);
                    if (!this.p_info.isColumnMandatory(i2)) break block51;
                }
                if (doComma) {
                    sqlInsert.append(",");
                    sqlValues.append(",");
                } else {
                    doComma = true;
                }
                sqlInsert.append(this.p_info.getColumnName(i2));
                Class<?> c = this.p_info.getColumnClass(i2);
                if (withValues) {
                    try {
                        if (c == Object.class) {
                            sqlValues.append(this.saveNewSpecial(value, i2));
                        }
                        if (value == null || value.equals(Null.NULL)) {
                            sqlValues.append("NULL");
                        }
                        if (value instanceof Integer || value instanceof BigDecimal) {
                            sqlValues.append(value);
                        }
                        if (c == Boolean.class) {
                            boolean bValue = false;
                            bValue = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
                            sqlValues.append(this.encrypt(i2, bValue ? "'Y'" : "'N'"));
                        }
                        if (value instanceof Timestamp) {
                            sqlValues.append(DB.TO_DATE((Timestamp)this.encrypt(i2, value), this.p_info.getColumnDisplayType(i2) == 15));
                        }
                        if (c == String.class) {
                            sqlValues.append(this.encrypt(i2, DB.TO_STRING((String)value)));
                        }
                        if (DisplayType.isLOB(dt)) {
                            if (this.p_info.isColumnMandatory(i2)) {
                                sqlValues.append("''");
                            }
                            sqlValues.append("null");
                        }
                        sqlValues.append(this.saveNewSpecial(value, i2));
                    }
                    catch (Exception e) {
                        String msg = "";
                        if (this.m_trxName != null) {
                            msg = "[" + this.m_trxName + "] - ";
                        }
                        msg = String.valueOf(msg) + this.p_info.toString(i2) + " - Value=" + value + "(" + (value == null ? "null" : value.getClass().getName()) + ")";
                        this.log.log(Level.SEVERE, msg, e);
                        throw new DBException(e);
                    }
                } else {
                    if (value instanceof Timestamp && dt == 15) {
                        sqlValues.append("trunc(cast(? as date))");
                    } else {
                        sqlValues.append("?");
                    }
                    if (DisplayType.isLOB(dt)) {
                        if (this.p_info.isColumnMandatory(i2)) {
                            if (dt == 23) {
                                params.add(new byte[1]);
                            } else {
                                params.add("");
                            }
                        } else {
                            params.add(null);
                        }
                    } else if (value == null || value.equals(Null.NULL)) {
                        params.add(null);
                    } else if (c == Boolean.class) {
                        boolean bValue = false;
                        bValue = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
                        params.add(this.encrypt(i2, bValue ? "Y" : "N"));
                    } else if (c == String.class) {
                        if (value.toString().length() == 0) {
                            params.add(null);
                        } else {
                            params.add(this.encrypt(i2, value));
                        }
                    } else {
                        params.add(value);
                    }
                }
                String insertLog = MSysConfig.getValue("SYSTEM_INSERT_CHANGELOG", "Y", this.getAD_Client_ID());
                if (session != null && this.m_IDs.length == 1 && this.p_info.isAllowLogging(i2) && !this.p_info.isEncrypted(i2) && !this.p_info.isVirtualColumn(i2) && !"Password".equals(this.p_info.getColumnName(i2)) && (insertLog.equalsIgnoreCase("Y") || insertLog.equalsIgnoreCase("K") && this.p_info.getColumn((int)i2).IsKey) && (cLog = session.changeLog(this.m_trxName, AD_ChangeLog_ID, this.p_info.getAD_Table_ID(), this.p_info.getColumn((int)i2).AD_Column_ID, this.get_ID(), this.getAD_Client_ID(), this.getAD_Org_ID(), null, value, "I")) != null) {
                    AD_ChangeLog_ID = cLog.getAD_ChangeLog_ID();
                }
            }
            ++i2;
        }
        if (this.m_custom != null) {
            for (String column : this.m_custom.keySet()) {
                int index = this.p_info.getColumnIndex(column);
                String value = this.m_custom.get(column);
                if (value == null) continue;
                if (doComma) {
                    sqlInsert.append(",");
                    sqlValues.append(",");
                } else {
                    doComma = true;
                }
                sqlInsert.append(column);
                if (withValues) {
                    sqlValues.append(this.encrypt(index, value));
                    continue;
                }
                sqlValues.append("?");
                if (value == null || value.toString().length() == 0) {
                    params.add(null);
                    continue;
                }
                params.add(this.encrypt(index, value));
            }
            this.m_custom = null;
        }
        sqlInsert.append((CharSequence)sqlValues).append(")");
        int no = withValues ? DB.executeUpdate(sqlInsert.toString(), this.m_trxName) : DB.executeUpdate(sqlInsert.toString(), params.toArray(), false, this.m_trxName);
        boolean bl = ok = no == 1;
        if (ok) {
            ok = this.lobSave();
            if (!this.load(this.m_trxName)) {
                if (this.m_trxName == null) {
                    this.log.log(Level.SEVERE, "reloading");
                } else {
                    this.log.log(Level.SEVERE, "[" + this.m_trxName + "] - reloading");
                }
                ok = false;
            }
        } else {
            String msg = "Not inserted - ";
            msg = CLogMgt.isLevelFiner() ? String.valueOf(msg) + sqlInsert.toString() : String.valueOf(msg) + this.get_TableName();
            if (this.m_trxName == null) {
                this.log.log(Level.WARNING, msg);
            } else {
                this.log.log(Level.WARNING, "[" + this.m_trxName + "]" + msg);
            }
        }
        return ok;
    }

    protected int saveNew_getID() {
        if (this.get_ID() > 0 && this.get_ID() < 999999) {
            return this.get_ID();
        }
        return 0;
    }

    public String get_WhereClause(boolean withValues) {
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (i2 < this.m_IDs.length) {
            if (i2 != 0) {
                sb.append(" AND ");
            }
            sb.append(this.m_KeyColumns[i2]).append("=");
            if (withValues) {
                if (this.m_KeyColumns[i2].endsWith("_ID")) {
                    sb.append(this.m_IDs[i2]);
                } else if (this.m_IDs[i2] instanceof Timestamp) {
                    sb.append(DB.TO_DATE((Timestamp)this.m_IDs[i2], false));
                } else {
                    sb.append("'");
                    if (this.m_IDs[i2] instanceof Boolean) {
                        if (((Boolean)this.m_IDs[i2]).booleanValue()) {
                            sb.append("Y");
                        } else {
                            sb.append("N");
                        }
                    } else {
                        sb.append(this.m_IDs[i2]);
                    }
                    sb.append("'");
                }
            } else {
                sb.append("?");
            }
            ++i2;
        }
        return sb.toString();
    }

    protected String saveNewSpecial(Object value, int index) {
        String colName = this.p_info.getColumnName(index);
        String colClass = this.p_info.getColumnClass(index).toString();
        String colValue = value == null ? "null" : value.getClass().toString();
        this.log.log(Level.SEVERE, "Unknown class for column " + colName + " (" + colClass + ") - Value=" + colValue);
        if (value == null) {
            return "NULL";
        }
        return value.toString();
    }

    private Object encrypt(int index, Object xx) {
        if (xx == null) {
            return null;
        }
        if (index != -1 && this.p_info.isEncrypted(index)) {
            return SecureEngine.encrypt(xx, this.getAD_Client_ID());
        }
        return xx;
    }

    private Object decrypt(int index, Object yy) {
        if (yy == null) {
            return null;
        }
        if (index != -1 && this.p_info.isEncrypted(index)) {
            return SecureEngine.decrypt(yy, this.getAD_Client_ID());
        }
        return yy;
    }

    /*
     * Exception decompiling
     */
    public boolean delete(boolean force) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void deleteEx(boolean force) throws AdempiereException {
        if (!this.delete(force)) {
            String msg = null;
            ValueNamePair err = CLogger.retrieveError();
            if (err != null) {
                msg = err.getName();
            }
            if (msg == null || msg.length() == 0) {
                msg = "DeleteError";
            }
            throw new AdempiereException(msg);
        }
    }

    public boolean delete(boolean force, String trxName) {
        this.set_TrxName(trxName);
        return this.delete(force);
    }

    public void deleteEx(boolean force, String trxName) throws AdempiereException {
        this.set_TrxName(trxName);
        this.deleteEx(force);
    }

    protected boolean beforeDelete() {
        return true;
    }

    protected boolean afterDelete(boolean success) {
        return success;
    }

    private boolean insertTranslations() {
        if (this.m_IDs.length > 1 || this.m_IDs[0].equals(I_ZERO) || !(this.m_IDs[0] instanceof Integer) || !this.p_info.isTranslated()) {
            return true;
        }
        StringBuilder iColumns = new StringBuilder();
        StringBuilder sColumns = new StringBuilder();
        int i2 = 0;
        while (i2 < this.p_info.getColumnCount()) {
            if (this.p_info.isColumnTranslated(i2)) {
                iColumns.append(this.p_info.getColumnName(i2)).append(",");
                sColumns.append("t.").append(this.p_info.getColumnName(i2)).append(",");
            }
            ++i2;
        }
        if (iColumns.length() == 0) {
            return true;
        }
        String tableName = this.p_info.getTableName();
        String keyColumn = this.m_KeyColumns[0];
        boolean uuidFunction = DB.isGenerateUUIDSupported();
        int uuidColumnId = DB.getSQLValue(this.get_TrxName(), "SELECT col.AD_Column_ID FROM AD_Column col INNER JOIN AD_Table tbl ON col.AD_Table_ID = tbl.AD_Table_ID WHERE tbl.TableName=? AND col.ColumnName=?", String.valueOf(tableName) + "_Trl", PO.getUUIDColumnName(String.valueOf(tableName) + "_Trl"));
        StringBuilder sql = new StringBuilder("INSERT INTO ").append(tableName).append("_Trl (AD_Language,").append(keyColumn).append(", ").append((CharSequence)iColumns).append(" IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy");
        if (uuidColumnId > 0 && uuidFunction) {
            sql.append(",").append(PO.getUUIDColumnName(String.valueOf(tableName) + "_Trl")).append(" ) ");
        } else {
            sql.append(" ) ");
        }
        sql.append("SELECT l.AD_Language,t.").append(keyColumn).append(", ").append((CharSequence)sColumns).append(" 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy");
        if (uuidColumnId > 0 && uuidFunction) {
            sql.append(",Generate_UUID() ");
        } else {
            sql.append(" ");
        }
        sql.append("FROM AD_Language l, ").append(tableName).append(" t ").append("WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.").append(keyColumn).append("=").append(this.get_ID()).append(" AND NOT EXISTS (SELECT * FROM ").append(tableName).append("_Trl tt WHERE tt.AD_Language=l.AD_Language AND tt.").append(keyColumn).append("=t.").append(keyColumn).append(")");
        int no = DB.executeUpdate(sql.toString(), this.m_trxName);
        if (uuidColumnId > 0 && !uuidFunction) {
            MColumn column = new MColumn(this.getCtx(), uuidColumnId, this.get_TrxName());
            UUIDGenerator.updateUUID(column, this.get_TrxName());
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + no);
        }
        return no > 0;
    }

    private boolean updateTranslations() {
        if (this.m_IDs.length > 1 || this.m_IDs[0].equals(I_ZERO) || !(this.m_IDs[0] instanceof Integer) || !this.p_info.isTranslated()) {
            return true;
        }
        String tableName = this.p_info.getTableName();
        if (tableName.startsWith("AD") && this.getAD_Client_ID() == 0) {
            return true;
        }
        boolean trlColumnChanged = false;
        int i2 = 0;
        while (i2 < this.p_info.getColumnCount()) {
            if (this.p_info.isColumnTranslated(i2) && this.is_ValueChanged(this.p_info.getColumnName(i2))) {
                trlColumnChanged = true;
                break;
            }
            ++i2;
        }
        if (!trlColumnChanged) {
            return true;
        }
        MClient client = MClient.get(this.getCtx());
        String keyColumn = this.m_KeyColumns[0];
        StringBuilder sqlupdate = new StringBuilder("UPDATE ").append(tableName).append("_Trl SET ");
        StringBuilder sqlcols = new StringBuilder();
        int i3 = 0;
        while (i3 < this.p_info.getColumnCount()) {
            String columnName = this.p_info.getColumnName(i3);
            if (this.p_info.isColumnTranslated(i3) && this.is_ValueChanged(columnName)) {
                String[] availableLanguages;
                sqlcols.append(columnName).append("=");
                Object value = this.get_Value(columnName);
                if (value == null) {
                    sqlcols.append("NULL");
                } else if (value instanceof String) {
                    sqlcols.append(DB.TO_STRING((String)value));
                } else if (value instanceof Boolean) {
                    sqlcols.append((Boolean)value != false ? "'Y'" : "'N'");
                } else if (value instanceof Timestamp) {
                    sqlcols.append(DB.TO_DATE((Timestamp)value));
                } else {
                    sqlcols.append(value.toString());
                }
                sqlcols.append(",");
                String[] stringArray = availableLanguages = Language.getNames();
                int n = availableLanguages.length;
                int n2 = 0;
                while (n2 < n) {
                    String langName = stringArray[n2];
                    Language language = Language.getLanguage(langName);
                    String key = this.getTrlCacheKey(columnName, language.getAD_Language());
                    trl_cache.remove(key);
                    ++n2;
                }
            }
            ++i3;
        }
        StringBuilder whereid = new StringBuilder(" WHERE ").append(keyColumn).append("=").append(this.get_ID());
        StringBuilder andlang = new StringBuilder(" AND AD_Language=").append(DB.TO_STRING(client.getAD_Language()));
        StringBuilder andnotlang = new StringBuilder(" AND AD_Language!=").append(DB.TO_STRING(client.getAD_Language()));
        int no = -1;
        if (client.isMultiLingualDocument()) {
            String baselang = Language.getBaseAD_Language();
            if (client.getAD_Language().equals(baselang)) {
                StringBuilder sqlexec = new StringBuilder().append((CharSequence)sqlupdate).append("IsTranslated='N'").append((CharSequence)whereid);
                no = DB.executeUpdate(sqlexec.toString(), this.m_trxName);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("#" + no);
                }
            } else {
                StringBuilder sqlexec = new StringBuilder().append((CharSequence)sqlupdate).append((CharSequence)sqlcols).append("IsTranslated='Y'").append((CharSequence)whereid).append((CharSequence)andlang);
                no = DB.executeUpdate(sqlexec.toString(), this.m_trxName);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("#" + no);
                }
                if (no >= 0) {
                    sqlexec = new StringBuilder().append((CharSequence)sqlupdate).append("IsTranslated='N'").append((CharSequence)whereid).append((CharSequence)andnotlang);
                    no = DB.executeUpdate(sqlexec.toString(), this.m_trxName);
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("#" + no);
                    }
                }
            }
        } else {
            StringBuilder sqlexec = new StringBuilder().append((CharSequence)sqlupdate).append((CharSequence)sqlcols).append("IsTranslated='Y'").append((CharSequence)whereid);
            no = DB.executeUpdate(sqlexec.toString(), this.m_trxName);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("#" + no);
            }
        }
        return no >= 0;
    }

    private boolean deleteTranslations(String trxName) {
        if (this.m_IDs.length > 1 || this.m_IDs[0].equals(I_ZERO) || !(this.m_IDs[0] instanceof Integer) || !this.p_info.isTranslated()) {
            return true;
        }
        String tableName = this.p_info.getTableName();
        String keyColumn = this.m_KeyColumns[0];
        StringBuilder sql = new StringBuilder("DELETE  FROM  ").append(tableName).append("_Trl WHERE ").append(keyColumn).append("=").append(this.get_ID());
        int no = DB.executeUpdate(sql.toString(), trxName);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + no);
        }
        return no >= 0;
    }

    protected boolean insert_Accounting(String acctTable, String acctBaseTable, String whereClause) {
        if (this.s_acctColumns == null || acctTable.startsWith("C_BP_")) {
            block17: {
                this.s_acctColumns = new ArrayList();
                String sql = "SELECT c.ColumnName FROM AD_Column c INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID) WHERE t.TableName=? AND c.IsActive='Y' AND c.AD_Reference_ID=25 ORDER BY c.ColumnName";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, null);
                        pstmt.setString(1, acctTable);
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            this.s_acctColumns.add(rs.getString(1));
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, acctTable, e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            if (this.s_acctColumns.size() == 0) {
                this.log.severe("No Columns for " + acctTable);
                return false;
            }
        }
        StringBuilder sb = new StringBuilder("INSERT INTO ").append(acctTable).append(" (").append(this.get_TableName()).append("_ID, C_AcctSchema_ID, AD_Client_ID,AD_Org_ID,IsActive, Created,CreatedBy,Updated,UpdatedBy ");
        int i2 = 0;
        while (i2 < this.s_acctColumns.size()) {
            sb.append(",").append(this.s_acctColumns.get(i2));
            ++i2;
        }
        boolean uuidFunction = DB.isGenerateUUIDSupported();
        int uuidColumnId = DB.getSQLValue(this.get_TrxName(), "SELECT col.AD_Column_ID FROM AD_Column col INNER JOIN AD_Table tbl ON col.AD_Table_ID = tbl.AD_Table_ID WHERE tbl.TableName=? AND col.ColumnName=?", acctTable, PO.getUUIDColumnName(acctTable));
        if (uuidColumnId > 0 && uuidFunction) {
            sb.append(",").append(PO.getUUIDColumnName(acctTable));
        }
        sb.append(") SELECT ").append(this.get_ID()).append(", p.C_AcctSchema_ID, p.AD_Client_ID,0,'Y', SysDate,").append(this.getUpdatedBy()).append(",SysDate,").append(this.getUpdatedBy());
        int i3 = 0;
        while (i3 < this.s_acctColumns.size()) {
            sb.append(",p.").append(this.s_acctColumns.get(i3));
            ++i3;
        }
        if (uuidColumnId > 0 && uuidFunction) {
            sb.append(",generate_uuid()");
        }
        sb.append(" FROM ").append(acctBaseTable).append(" p WHERE p.AD_Client_ID=").append(this.getAD_Client_ID());
        if (whereClause != null && whereClause.length() > 0) {
            sb.append(" AND ").append(whereClause);
        }
        sb.append(" AND NOT EXISTS (SELECT * FROM ").append(acctTable).append(" e WHERE e.C_AcctSchema_ID=p.C_AcctSchema_ID AND e.").append(this.get_TableName()).append("_ID=").append(this.get_ID()).append(")");
        int no = DB.executeUpdate(sb.toString(), this.get_TrxName());
        if (no > 0) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("#" + no);
            }
        } else {
            this.log.warning("#" + no + " - Table=" + acctTable + " from " + acctBaseTable);
        }
        if (uuidColumnId > 0 && !uuidFunction) {
            MColumn column = new MColumn(this.getCtx(), uuidColumnId, this.get_TrxName());
            UUIDGenerator.updateUUID(column, this.get_TrxName());
        }
        return no > 0;
    }

    @Deprecated
    protected boolean delete_Accounting(String acctTable) {
        return true;
    }

    protected boolean insert_Tree(String treeType) {
        return this.insert_Tree(treeType, 0);
    }

    protected boolean insert_Tree(String treeType, int C_Element_ID) {
        String tableName = MTree_Base.getNodeTableName(treeType);
        boolean uuidFunction = DB.isGenerateUUIDSupported();
        int uuidColumnId = DB.getSQLValue(this.get_TrxName(), "SELECT col.AD_Column_ID FROM AD_Column col INNER JOIN AD_Table tbl ON col.AD_Table_ID = tbl.AD_Table_ID WHERE tbl.TableName=? AND col.ColumnName=?", tableName, PO.getUUIDColumnName(tableName));
        StringBuilder sb = new StringBuilder("INSERT INTO ").append(tableName).append(" (AD_Client_ID,AD_Org_ID, IsActive,Created,CreatedBy,Updated,UpdatedBy, AD_Tree_ID, Node_ID, Parent_ID, SeqNo");
        if (uuidColumnId > 0 && uuidFunction) {
            sb.append(", ").append(PO.getUUIDColumnName(tableName)).append(") ");
        } else {
            sb.append(") ");
        }
        sb.append("SELECT t.AD_Client_ID, 0, 'Y', SysDate, " + this.getUpdatedBy() + ", SysDate, " + this.getUpdatedBy() + "," + "t.AD_Tree_ID, ").append(this.get_ID()).append(", 0, 999");
        if (uuidColumnId > 0 && uuidFunction) {
            sb.append(", Generate_UUID() ");
        } else {
            sb.append(" ");
        }
        sb.append("FROM AD_Tree t WHERE t.AD_Client_ID=").append(this.getAD_Client_ID()).append(" AND t.IsActive='Y'");
        if (C_Element_ID != 0) {
            sb.append(" AND EXISTS (SELECT * FROM C_Element ae WHERE ae.C_Element_ID=").append(C_Element_ID).append(" AND t.AD_Tree_ID=ae.AD_Tree_ID)");
        } else {
            sb.append(" AND t.IsAllNodes='Y' AND t.TreeType='").append(treeType).append("'");
        }
        if ("TL".equals(treeType)) {
            sb.append(" AND t.AD_Table_ID=").append(this.get_Table_ID());
        }
        sb.append(" AND NOT EXISTS (SELECT * FROM " + MTree_Base.getNodeTableName(treeType) + " e " + "WHERE e.AD_Tree_ID=t.AD_Tree_ID AND Node_ID=").append(this.get_ID()).append(")");
        int no = DB.executeUpdate(sb.toString(), this.get_TrxName());
        if (no > 0) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("#" + no + " - TreeType=" + treeType);
            }
        } else if (!"TL".equals(treeType)) {
            this.log.warning("#" + no + " - TreeType=" + treeType);
        }
        if (uuidColumnId > 0 && !uuidFunction) {
            MColumn column = new MColumn(this.getCtx(), uuidColumnId, this.get_TrxName());
            UUIDGenerator.updateUUID(column, this.get_TrxName());
        }
        return no > 0;
    }

    public void update_Tree(String treeType) {
        Object[] parameters;
        String whereTree;
        String sourceTableName;
        int idxValueCol = this.get_ColumnIndex("Value");
        if (idxValueCol < 0) {
            return;
        }
        int idxValueIsSummary = this.get_ColumnIndex("IsSummary");
        if (idxValueIsSummary < 0) {
            return;
        }
        String value = this.get_Value(idxValueCol).toString();
        if (value == null) {
            return;
        }
        String tableName = MTree_Base.getNodeTableName(treeType);
        if ("TL".equals(treeType)) {
            sourceTableName = this.get_TableName();
            whereTree = "TreeType=? AND AD_Table_ID=?";
            parameters = new Object[]{treeType, this.get_Table_ID()};
        } else {
            sourceTableName = MTree_Base.getSourceTableName(treeType);
            if ("EV".equals(treeType) && this instanceof I_C_ElementValue) {
                whereTree = "TreeType=? AND AD_Tree_ID=?";
                parameters = new Object[]{treeType, ((I_C_ElementValue)((Object)this)).getC_Element().getAD_Tree_ID()};
            } else {
                whereTree = "TreeType=?";
                parameters = new Object[]{treeType};
            }
        }
        String updateSeqNo = "UPDATE " + tableName + " SET SeqNo=SeqNo+1 WHERE Parent_ID=? AND SeqNo>=? AND AD_Tree_ID=?";
        String update = "UPDATE " + tableName + " SET SeqNo=?, Parent_ID=? WHERE Node_ID=? AND AD_Tree_ID=?";
        String selMinSeqNo = "SELECT COALESCE(MIN(tn.SeqNo),-1) FROM AD_TreeNode tn JOIN " + sourceTableName + " n ON (tn.Node_ID=n." + sourceTableName + "_ID) WHERE tn.Parent_ID=? AND tn.AD_Tree_ID=? AND n.Value>?";
        String selMaxSeqNo = "SELECT COALESCE(MAX(tn.SeqNo)+1,999) FROM AD_TreeNode tn JOIN " + sourceTableName + " n ON (tn.Node_ID=n." + sourceTableName + "_ID) WHERE tn.Parent_ID=? AND tn.AD_Tree_ID=? AND n.Value<?";
        List trees = new Query(this.getCtx(), "AD_Tree", whereTree, this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).setParameters(parameters).list();
        for (MTree_Base tree : trees) {
            if (!tree.isTreeDrivenByValue()) continue;
            int newParentID = -1;
            if ("C_ElementValue".equals(sourceTableName)) {
                newParentID = this.retrieveIdOfElementValue(value, this.getAD_Client_ID(), ((I_C_ElementValue)((Object)this)).getC_Element().getC_Element_ID(), this.get_TrxName());
            } else {
                int linkColId = tree.getParent_Column_ID();
                String linkColName = null;
                int linkID = 0;
                if (linkColId > 0) {
                    linkColName = MColumn.getColumnName(Env.getCtx(), linkColId);
                    linkID = (Integer)this.get_Value(linkColName);
                }
                newParentID = PO.retrieveIdOfParentValue(value, sourceTableName, linkColName, linkID, this.getAD_Client_ID(), this.get_TrxName());
            }
            int seqNo = DB.getSQLValueEx(this.get_TrxName(), selMinSeqNo, newParentID, tree.getAD_Tree_ID(), value);
            if (seqNo == -1) {
                seqNo = DB.getSQLValueEx(this.get_TrxName(), selMaxSeqNo, newParentID, tree.getAD_Tree_ID(), value);
            }
            DB.executeUpdateEx(updateSeqNo, new Object[]{newParentID, seqNo, tree.getAD_Tree_ID()}, this.get_TrxName());
            DB.executeUpdateEx(update, new Object[]{seqNo, newParentID, this.get_ID(), tree.getAD_Tree_ID()}, this.get_TrxName());
        }
    }

    private int retrieveIdOfElementValue(String value, int clientID, int elementID, String trxName) {
        String sql = "SELECT C_ElementValue_ID FROM C_ElementValue WHERE IsSummary='Y' AND AD_Client_ID=? AND C_Element_ID=? AND Value=?";
        int pos = value.length() - 1;
        while (pos > 0) {
            String testParentValue = value.substring(0, pos);
            int parentID = DB.getSQLValueEx(trxName, sql, clientID, elementID, testParentValue);
            if (parentID > 0) {
                return parentID;
            }
            --pos;
        }
        return 0;
    }

    public static int retrieveIdOfParentValue(String value, String tableName, int clientID, String trxName) {
        return PO.retrieveIdOfParentValue(value, tableName, null, 0, clientID, trxName);
    }

    public static int retrieveIdOfParentValue(String value, String tableName, String linkCol, int linkID, int clientID, String trxName) {
        String sql = "SELECT " + tableName + "_ID FROM " + tableName + " WHERE IsSummary='Y'";
        if (!Util.isEmpty(linkCol)) {
            sql = String.valueOf(sql) + " AND " + linkCol + "=" + linkID;
        }
        sql = String.valueOf(sql) + " AND AD_Client_ID=? AND Value=?";
        int pos = value.length() - 1;
        while (pos > 0) {
            String testParentValue = value.substring(0, pos);
            int parentID = DB.getSQLValueEx(trxName, sql, clientID, testParentValue);
            if (parentID > 0) {
                return parentID;
            }
            --pos;
        }
        return 0;
    }

    protected boolean delete_Tree(String treeType) {
        int cnt;
        int id = this.get_ID();
        if (id == 0) {
            id = this.get_IDOld();
        }
        StringBuilder countSql = new StringBuilder("SELECT COUNT(*) FROM ").append(MTree_Base.getNodeTableName(treeType)).append(" n JOIN AD_Tree t ON n.AD_Tree_ID=t.AD_Tree_ID").append(" WHERE Parent_ID=? AND t.TreeType=?");
        if ("TL".equals(treeType)) {
            countSql.append(" AND t.AD_Table_ID=").append(this.get_Table_ID());
        }
        if ((cnt = DB.getSQLValueEx(this.get_TrxName(), countSql.toString(), id, treeType)) > 0) {
            throw new AdempiereException(Msg.getMsg(Env.getCtx(), "NoParentDelete", new Object[]{cnt}));
        }
        StringBuilder sb = new StringBuilder("DELETE FROM ").append(MTree_Base.getNodeTableName(treeType)).append(" n WHERE Node_ID=").append(id).append(" AND EXISTS (SELECT * FROM AD_Tree t WHERE t.AD_Tree_ID=n.AD_Tree_ID AND t.TreeType='").append(treeType).append("'");
        if ("TL".equals(treeType)) {
            sb.append(" AND t.AD_Table_ID=").append(this.get_Table_ID());
        }
        sb.append(")");
        int no = DB.executeUpdate(sb.toString(), this.get_TrxName());
        if (no > 0) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("#" + no + " - TreeType=" + treeType);
            }
        } else if (!"TL".equals(treeType)) {
            this.log.warning("#" + no + " - TreeType=" + treeType);
        }
        return no > 0;
    }

    public boolean lock() {
        int index = this.get_ProcessingIndex();
        if (index != -1) {
            this.m_newValues[index] = Boolean.TRUE;
            String sql = "UPDATE " + this.p_info.getTableName() + " SET Processing='Y' WHERE (Processing='N' OR Processing IS NULL) AND " + this.get_WhereClause(true);
            boolean success = false;
            if (this.isUseTimeoutForUpdate()) {
                success = DB.executeUpdateEx(sql, null, 300) == 1;
            } else {
                boolean bl = success = DB.executeUpdate(sql, null) == 1;
            }
            if (success) {
                this.log.fine("success");
            } else {
                this.log.log(Level.WARNING, "failed");
            }
            return success;
        }
        return false;
    }

    private int get_ProcessingIndex() {
        return this.p_info.getColumnIndex("Processing");
    }

    public boolean unlock(String trxName) {
        int index = this.get_ProcessingIndex();
        if (index != -1) {
            this.m_newValues[index] = Boolean.FALSE;
            String sql = "UPDATE " + this.p_info.getTableName() + " SET Processing='N' WHERE " + this.get_WhereClause(true);
            boolean success = false;
            if (this.isUseTimeoutForUpdate()) {
                success = DB.executeUpdateEx(sql, trxName, 300) == 1;
            } else {
                boolean bl = success = DB.executeUpdate(sql, trxName) == 1;
            }
            if (success) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("success" + (trxName == null ? "" : "[" + trxName + "]"));
                }
            } else {
                this.log.log(Level.WARNING, "failed" + (trxName == null ? "" : " [" + trxName + "]"));
            }
            return success;
        }
        return true;
    }

    public void set_TrxName(String trxName) {
        this.m_trxName = trxName;
    }

    public String get_TrxName() {
        return this.m_trxName;
    }

    public MAttachment getAttachment() {
        return this.getAttachment(false);
    }

    public MAttachment getAttachment(boolean requery) {
        if (this.m_attachment == null || requery) {
            this.m_attachment = MAttachment.get(this.getCtx(), this.p_info.getAD_Table_ID(), this.get_ID());
        }
        return this.m_attachment;
    }

    public MAttachment createAttachment() {
        this.getAttachment(false);
        if (this.m_attachment == null) {
            this.m_attachment = new MAttachment(this.getCtx(), this.p_info.getAD_Table_ID(), this.get_ID(), null);
        }
        return this.m_attachment;
    }

    public boolean isAttachment(String extension) {
        this.getAttachment(false);
        if (this.m_attachment == null) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.m_attachment.getEntryCount()) {
            if (this.m_attachment.getEntryName(i2).endsWith(extension)) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("#" + i2 + ": " + this.m_attachment.getEntryName(i2));
                }
                return true;
            }
            ++i2;
        }
        return false;
    }

    public byte[] getAttachmentData(String extension) {
        this.getAttachment(false);
        if (this.m_attachment == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < this.m_attachment.getEntryCount()) {
            if (this.m_attachment.getEntryName(i2).endsWith(extension)) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("#" + i2 + ": " + this.m_attachment.getEntryName(i2));
                }
                return this.m_attachment.getEntryData(i2);
            }
            ++i2;
        }
        return null;
    }

    public boolean isPdfAttachment() {
        return this.isAttachment(".pdf");
    }

    public byte[] getPdfAttachment() {
        return this.getAttachmentData(".pdf");
    }

    public void dump() {
        if (CLogMgt.isLevelFinest()) {
            this.log.finer(this.get_WhereClause(true));
            int i2 = 0;
            while (i2 < this.get_ColumnCount()) {
                this.dump(i2);
                ++i2;
            }
        }
    }

    public void dump(int index) {
        StringBuilder sb = new StringBuilder(" ").append(index);
        if (index < 0 || index >= this.get_ColumnCount()) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest(sb.append(": invalid").toString());
            }
            return;
        }
        sb.append(": ").append(this.get_ColumnName(index)).append(" = ").append(this.m_oldValues[index]).append(" (").append(this.m_newValues[index]).append(")");
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(sb.toString());
        }
    }

    public static int[] getAllIDs(String TableName, String WhereClause, String trxName) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(TableName).append("_ID FROM ").append(TableName);
        if (WhereClause != null && WhereClause.length() > 0) {
            sql.append(" WHERE ").append(WhereClause);
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql.toString(), trxName);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.add(rs.getInt(1));
                }
            }
            catch (SQLException e) {
                s_log.log(Level.SEVERE, sql.toString(), e);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        int[] retValue = new int[list.size()];
        int i2 = 0;
        while (i2 < retValue.length) {
            retValue[i2] = (Integer)list.get(i2);
            ++i2;
        }
        return retValue;
    }

    protected static String getFindParameter(String query) {
        if (query == null) {
            return null;
        }
        if (query.length() == 0 || query.equals("%")) {
            return null;
        }
        if (!query.endsWith("%")) {
            query = String.valueOf(query) + "%";
        }
        return query.toUpperCase();
    }

    private Object get_LOB(Object value) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Value=" + value);
        }
        if (value == null) {
            return null;
        }
        Object retValue = null;
        long length = -99L;
        try {
            if (value instanceof String || value instanceof byte[]) {
                retValue = value;
            } else if (value instanceof Clob) {
                Clob clob = (Clob)value;
                length = clob.length();
                retValue = clob.getSubString(1L, (int)length);
            } else if (value instanceof Blob) {
                Blob blob = (Blob)value;
                length = blob.length();
                int index = 1;
                if (blob.getClass().getName().equals("oracle.jdbc.rowset.OracleSerialBlob")) {
                    index = 0;
                }
                retValue = blob.getBytes(index, (int)length);
            } else {
                this.log.log(Level.SEVERE, "Unknown: " + value);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Length=" + length, e);
        }
        return retValue;
    }

    private void lobReset() {
        this.m_lobInfo = null;
    }

    private void lobAdd(Object value, int index, int displayType) {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Value=" + value);
        }
        PO_LOB lob = new PO_LOB(this.p_info.getTableName(), this.get_ColumnName(index), this.get_WhereClause(true), displayType, value);
        if (this.m_lobInfo == null) {
            this.m_lobInfo = new ArrayList();
        }
        this.m_lobInfo.add(lob);
    }

    private boolean lobSave() {
        if (this.m_lobInfo == null) {
            return true;
        }
        boolean retValue = true;
        int i2 = 0;
        while (i2 < this.m_lobInfo.size()) {
            PO_LOB lob = this.m_lobInfo.get(i2);
            if (!lob.save(this.get_TrxName())) {
                retValue = false;
                break;
            }
            ++i2;
        }
        this.lobReset();
        return retValue;
    }

    public StringBuffer get_xmlString(StringBuffer xml) {
        if (xml == null) {
            xml = new StringBuffer();
        } else {
            xml.append(Env.NL);
        }
        try {
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            DOMSource source = new DOMSource(this.get_xmlDocument(xml.length() != 0));
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
            StringBuffer newXML = writer.getBuffer();
            if (xml.length() != 0) {
                int tagIndex = newXML.indexOf("?>");
                if (tagIndex != -1) {
                    xml.append(newXML.substring(tagIndex + 2));
                } else {
                    xml.append(newXML);
                }
            } else {
                xml.append(newXML);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
        }
        return xml;
    }

    public Document get_xmlDocument(boolean noComment) {
        Object value;
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            if (!noComment) {
                document.appendChild(document.createComment(Adempiere.getSummaryAscii()));
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
        }
        Element root = document.createElement(this.get_TableName());
        root.setAttribute(XML_ATTRIBUTE_AD_Table_ID, String.valueOf(this.get_Table_ID()));
        root.setAttribute(XML_ATTRIBUTE_Record_ID, String.valueOf(this.get_ID()));
        document.appendChild(root);
        int size = this.get_ColumnCount();
        int i2 = 0;
        while (i2 < size) {
            if (!this.p_info.isVirtualColumn(i2)) {
                Element col = document.createElement(this.p_info.getColumnName(i2));
                value = this.get_Value(i2);
                int dt = this.p_info.getColumnDisplayType(i2);
                Class<?> c = this.p_info.getColumnClass(i2);
                if (value != null && !value.equals(Null.NULL)) {
                    if (c == Object.class) {
                        col.appendChild(document.createCDATASection(value.toString()));
                    } else if (value instanceof Integer || value instanceof BigDecimal) {
                        col.appendChild(document.createTextNode(value.toString()));
                    } else if (c == Boolean.class) {
                        boolean bValue = false;
                        bValue = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
                        col.appendChild(document.createTextNode(bValue ? "Y" : "N"));
                    } else if (value instanceof Timestamp) {
                        col.appendChild(document.createTextNode(value.toString()));
                    } else if (c == String.class) {
                        col.appendChild(document.createCDATASection((String)value));
                    } else if (DisplayType.isLOB(dt)) {
                        col.appendChild(document.createCDATASection(value.toString()));
                    } else {
                        col.appendChild(document.createCDATASection(value.toString()));
                    }
                }
                root.appendChild(col);
            }
            ++i2;
        }
        if (this.m_custom != null) {
            for (String columnName : this.m_custom.keySet()) {
                value = this.m_custom.get(columnName);
                Element col = document.createElement(columnName);
                if (value != null) {
                    col.appendChild(document.createTextNode((String)value));
                }
                root.appendChild(col);
            }
            this.m_custom = null;
        }
        return document;
    }

    public void setDoc(Doc doc) {
        this.m_doc = doc;
    }

    public void setReplication(boolean isFromReplication) {
        this.m_isReplication = isFromReplication;
    }

    public boolean isReplication() {
        return this.m_isReplication;
    }

    public Doc getDoc() {
        return this.m_doc;
    }

    public static void set_TrxName(PO[] lines, String trxName) {
        PO[] pOArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            PO line = pOArray[n2];
            line.set_TrxName(trxName);
            ++n2;
        }
    }

    public int get_ValueAsInt(String columnName) {
        int idx = this.get_ColumnIndex(columnName);
        if (idx < 0) {
            return 0;
        }
        return this.get_ValueAsInt(idx);
    }

    public boolean get_ValueAsBoolean(String columnName) {
        Object oo = this.get_Value(columnName);
        if (oo != null) {
            if (oo instanceof Boolean) {
                return (Boolean)oo;
            }
            return "Y".equals(oo);
        }
        return false;
    }

    public String getUUIDColumnName() {
        return PO.getUUIDColumnName(this.get_TableName());
    }

    public static String getUUIDColumnName(String tableName) {
        String columnName = String.valueOf(tableName) + "_UU";
        if (columnName.length() > 30) {
            int i2 = columnName.length() - 30;
            columnName = String.valueOf(tableName.substring(0, tableName.length() - i2)) + "_UU";
        }
        return columnName;
    }

    protected Object clone() throws CloneNotSupportedException {
        int i2;
        PO clone = (PO)super.clone();
        clone.m_trxName = null;
        if (this.m_custom != null) {
            clone.m_custom = new HashMap();
            clone.m_custom.putAll(this.m_custom);
        }
        if (this.m_newValues != null) {
            clone.m_newValues = new Object[this.m_newValues.length];
            i2 = 0;
            while (i2 < this.m_newValues.length) {
                clone.m_newValues[i2] = this.m_newValues[i2];
                ++i2;
            }
        }
        if (this.m_oldValues != null) {
            clone.m_oldValues = new Object[this.m_oldValues.length];
            i2 = 0;
            while (i2 < this.m_oldValues.length) {
                clone.m_oldValues[i2] = this.m_oldValues[i2];
                ++i2;
            }
        }
        if (this.m_IDs != null) {
            clone.m_IDs = new Object[this.m_IDs.length];
            i2 = 0;
            while (i2 < this.m_IDs.length) {
                clone.m_IDs[i2] = this.m_IDs[i2];
                ++i2;
            }
        }
        clone.p_ctx = Env.getCtx();
        clone.m_doc = null;
        clone.m_lobInfo = null;
        clone.m_attachment = null;
        clone.m_isReplication = false;
        return clone;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.log = CLogger.getCLogger(this.getClass());
    }

    public void set_Attribute(String columnName, Object value) {
        if (this.m_attributes == null) {
            this.m_attributes = new HashMap();
        }
        this.m_attributes.put(columnName, value);
    }

    public Object get_Attribute(String columnName) {
        if (this.m_attributes != null) {
            return this.m_attributes.get(columnName);
        }
        return null;
    }

    public HashMap<String, Object> get_Attributes() {
        return this.m_attributes;
    }

    private void validateUniqueIndex() {
        ValueNamePair ppE = CLogger.retrieveError();
        if (ppE != null) {
            Exception e;
            String msg = ppE.getValue();
            String info = ppE.getName();
            if ("DBExecuteError".equals(msg)) {
                info = "DBExecuteError:" + info;
            }
            if (DBException.isUniqueContraintError(e = CLogger.retrieveException())) {
                MTableIndex[] indexes;
                boolean found = false;
                String dbIndexName = DB.getDatabase().getNameOfUniqueConstraintError(e);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("dbIndexName=" + dbIndexName);
                }
                MTableIndex[] mTableIndexArray = indexes = MTableIndex.get(MTable.get(this.getCtx(), this.get_Table_ID()));
                int n = indexes.length;
                int n2 = 0;
                while (n2 < n) {
                    MTableIndex index = mTableIndexArray[n2];
                    if (dbIndexName.equalsIgnoreCase(index.getName())) {
                        if (index.getAD_Message_ID() <= 0) break;
                        MMessage message = MMessage.get(this.getCtx(), index.getAD_Message_ID());
                        this.log.saveError("SaveError", Msg.getMsg(this.getCtx(), message.getValue()));
                        found = true;
                        break;
                    }
                    ++n2;
                }
                if (!found) {
                    this.log.saveError(msg, info);
                }
            } else {
                this.log.saveError(msg, info);
            }
        }
    }

    private void checkValidContext() {
        if (this.getCtx().isEmpty() && this.getCtx().getProperty("#AD_Client_ID") == null) {
            throw new AdempiereException("Context lost");
        }
    }
}

