/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Element;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class M_Element
extends X_AD_Element {
    private static final long serialVersionUID = -6644398794862560030L;

    public static String getColumnName(String columnName) {
        return M_Element.getColumnName(columnName, null);
    }

    public static String getColumnName(String columnName, String trxName) {
        if (columnName == null || columnName.length() == 0) {
            return columnName;
        }
        M_Element element = M_Element.get(Env.getCtx(), columnName, trxName);
        if (element == null) {
            return columnName;
        }
        return element.getColumnName();
    }

    public static M_Element get(Properties ctx, String columnName) {
        return M_Element.get(ctx, columnName, null);
    }

    public static M_Element get(Properties ctx, String columnName, String trxName) {
        if (columnName == null || columnName.length() == 0) {
            return null;
        }
        String whereClause = "UPPER(ColumnName)=?";
        M_Element retValue = (M_Element)new Query(ctx, "AD_Element", "UPPER(ColumnName)=?", trxName).setParameters(columnName.toUpperCase()).firstOnly();
        return retValue;
    }

    public static M_Element getOfColumn(Properties ctx, int AD_Column_ID, String trxName) {
        if (AD_Column_ID == 0) {
            return null;
        }
        String whereClause = "EXISTS (SELECT 1 FROM AD_Column c WHERE c.AD_Element_ID=AD_Element.AD_Element_ID AND c.AD_Column_ID=?)";
        M_Element retValue = (M_Element)new Query(ctx, "AD_Element", "EXISTS (SELECT 1 FROM AD_Column c WHERE c.AD_Element_ID=AD_Element.AD_Element_ID AND c.AD_Column_ID=?)", trxName).setParameters(AD_Column_ID).firstOnly();
        return retValue;
    }

    public static M_Element getOfColumn(Properties ctx, int AD_Column_ID) {
        return M_Element.getOfColumn(ctx, AD_Column_ID, null);
    }

    public M_Element(Properties ctx, int AD_Element_ID, String trxName) {
        super(ctx, AD_Element_ID, trxName);
    }

    public M_Element(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public M_Element(Properties ctx, String columnName, String EntityType, String trxName) {
        super(ctx, 0, trxName);
        this.setColumnName(columnName);
        this.setName(columnName);
        this.setPrintName(columnName);
        this.setEntityType(EntityType);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord || this.is_ValueChanged("ColumnName")) {
            int no;
            String columnName = this.getColumnName().trim();
            if (this.getColumnName().length() != columnName.length()) {
                this.setColumnName(columnName);
            }
            StringBuilder sql = new StringBuilder("select count(*) from AD_Element where UPPER(ColumnName)=?");
            if (!newRecord) {
                sql.append(" AND AD_Element_ID<>").append(this.get_ID());
            }
            if ((no = DB.getSQLValue(null, sql.toString(), columnName.toUpperCase())) > 0) {
                this.log.saveError("SaveErrorNotUnique", Msg.getElement(this.getCtx(), "ColumnName"));
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (!newRecord) {
            StringBuilder sql = new StringBuilder();
            int no = 0;
            if (this.is_ValueChanged("Name") || this.is_ValueChanged("Description") || this.is_ValueChanged("Help") || this.is_ValueChanged("Placeholder") || this.is_ValueChanged("ColumnName")) {
                sql = new StringBuilder("UPDATE AD_Column SET ColumnName=").append(DB.TO_STRING(this.getColumnName())).append(", Name=").append(DB.TO_STRING(this.getName())).append(", Description=").append(DB.TO_STRING(this.getDescription())).append(", Help=").append(DB.TO_STRING(this.getHelp())).append(", Placeholder=").append(DB.TO_STRING(this.getPlaceholder())).append(" WHERE AD_Element_ID=").append(this.get_ID());
                no = DB.executeUpdate(sql.toString(), this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("afterSave - Columns updated #" + no);
                }
                sql = new StringBuilder("UPDATE AD_Process_Para SET ColumnName=").append(DB.TO_STRING(this.getColumnName())).append(", Name=").append(DB.TO_STRING(this.getName())).append(", Description=").append(DB.TO_STRING(this.getDescription())).append(", Help=").append(DB.TO_STRING(this.getHelp())).append(", AD_Element_ID=").append(this.get_ID()).append(" WHERE UPPER(ColumnName)=").append(DB.TO_STRING(this.getColumnName().toUpperCase())).append(" AND IsCentrallyMaintained='Y' AND AD_Element_ID IS NULL");
                no = DB.executeUpdate(sql.toString(), this.get_TrxName());
                sql = new StringBuilder("UPDATE AD_Process_Para SET ColumnName=").append(DB.TO_STRING(this.getColumnName())).append(", Name=").append(DB.TO_STRING(this.getName())).append(", Description=").append(DB.TO_STRING(this.getDescription())).append(", Help=").append(DB.TO_STRING(this.getHelp())).append(", Placeholder=").append(DB.TO_STRING(this.getPlaceholder())).append(" WHERE AD_Element_ID=").append(this.get_ID()).append(" AND IsCentrallyMaintained='Y'");
                no += DB.executeUpdate(sql.toString(), this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Parameters updated #" + no);
                }
                sql = new StringBuilder("UPDATE AD_InfoColumn SET ColumnName=").append(DB.TO_STRING(this.getColumnName())).append(", Name=").append(DB.TO_STRING(this.getName())).append(", Description=").append(DB.TO_STRING(this.getDescription())).append(", Help=").append(DB.TO_STRING(this.getHelp())).append(", Placeholder=").append(DB.TO_STRING(this.getPlaceholder())).append(" WHERE AD_Element_ID=").append(this.get_ID()).append(" AND IsCentrallyMaintained='Y'");
                no += DB.executeUpdate(sql.toString(), this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Info Column updated #" + no);
                }
            }
            if (this.is_ValueChanged("Name") || this.is_ValueChanged("Description") || this.is_ValueChanged("Help") || this.is_ValueChanged("Placeholder")) {
                sql = new StringBuilder("UPDATE AD_Field SET Name=").append(DB.TO_STRING(this.getName())).append(", Description=").append(DB.TO_STRING(this.getDescription())).append(", Help=").append(DB.TO_STRING(this.getHelp())).append(", Placeholder=").append(DB.TO_STRING(this.getPlaceholder())).append(" WHERE AD_Column_ID IN (SELECT AD_Column_ID FROM AD_Column WHERE AD_Element_ID=").append(this.get_ID()).append(") AND IsCentrallyMaintained='Y'");
                no = DB.executeUpdate(sql.toString(), this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Fields updated #" + no);
                }
            }
            if (this.is_ValueChanged("PrintName") || this.is_ValueChanged("Name")) {
                sql = new StringBuilder("UPDATE AD_PrintFormatItem SET PrintName=").append(DB.TO_STRING(this.getPrintName())).append(", Name=").append(DB.TO_STRING(this.getName())).append(" WHERE IsCentrallyMaintained='Y'").append(" AND EXISTS (SELECT * FROM AD_Column c ").append("WHERE c.AD_Column_ID=AD_PrintFormatItem.AD_Column_ID AND c.AD_Element_ID=").append(this.get_ID()).append(")");
                no = DB.executeUpdate(sql.toString(), this.get_TrxName());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("PrintFormatItem updated #" + no);
                }
            }
        }
        return success;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("M_Element[");
        sb.append(this.get_ID()).append("-").append(this.getColumnName()).append("]");
        return sb.toString();
    }
}

