/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.compiere.model.GridWindow;
import org.compiere.model.MQuery;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_AD_ZoomCondition;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Evaluator;
import org.compiere.util.Util;

public class MZoomCondition
extends X_AD_ZoomCondition {
    private static final long serialVersionUID = 3077830061348224074L;
    private static CCache<Integer, MZoomCondition[]> s_conditions = new CCache("AD_ZoomCondition", 0);

    public MZoomCondition(Properties ctx, int AD_ZoomCondition_ID, String trxName) {
        super(ctx, AD_ZoomCondition_ID, trxName);
    }

    public MZoomCondition(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MZoomCondition[] getConditions(int AD_Table_ID) {
        MZoomCondition[] conditions = s_conditions.get(AD_Table_ID);
        if (conditions == null) {
            String whereClauseFinal = "AD_Table_ID=?";
            List<MZoomCondition> list = new Query(Env.getCtx(), "AD_ZoomCondition", "AD_Table_ID=?", null).setParameters(AD_Table_ID).setOnlyActiveRecords(true).setOrderBy("SeqNo").list();
            conditions = list.toArray(new MZoomCondition[list.size()]);
            s_conditions.put(AD_Table_ID, conditions);
        }
        return conditions;
    }

    private static int findZoomWindowByTableId(int AD_Table_ID, MQuery query) {
        return MZoomCondition.findZoomWindowByTableId(AD_Table_ID, query, 0);
    }

    private static int findZoomWindowByTableId(int AD_Table_ID, MQuery query, int windowNo) {
        final int winNo = windowNo;
        if (query == null) {
            return 0;
        }
        MZoomCondition[] conditions = MZoomCondition.getConditions(AD_Table_ID);
        if (conditions.length > 0) {
            Evaluatee evaluatee = new Evaluatee(){

                @Override
                public String get_ValueAsString(String variableName) {
                    return Env.getContext(Env.getCtx(), winNo, variableName);
                }
            };
            MZoomCondition[] mZoomConditionArray = conditions;
            int n = conditions.length;
            int n2 = 0;
            while (n2 < n) {
                boolean evaluation;
                MZoomCondition condition = mZoomConditionArray[n2];
                if ((Util.isEmpty(condition.getZoomLogic()) || Evaluator.evaluateLogic(evaluatee, condition.getZoomLogic())) && (evaluation = condition.evaluate(query.getWhereClause(true)))) {
                    return condition.getAD_Window_ID();
                }
                ++n2;
            }
        }
        return 0;
    }

    public static int findZoomWindow(MQuery query) {
        String tableName = query.getTableName();
        if (Util.isEmpty(tableName)) {
            return 0;
        }
        MTable table2 = MTable.get(Env.getCtx(), tableName);
        if (table2 == null) {
            return 0;
        }
        return MZoomCondition.findZoomWindowByTableId(table2.getAD_Table_ID(), query);
    }

    public static int findZoomWindowByWindowId(int AD_Window_ID, MQuery query) {
        return MZoomCondition.findZoomWindowByWindowId(AD_Window_ID, query, 0);
    }

    /*
     * Unable to fully structure code
     */
    public static int findZoomWindowByWindowId(int AD_Window_ID, MQuery query, int windowNo) {
        block19: {
            if (query == null) {
                return 0;
            }
            tableID = DB.getSQLValueEx(null, "SELECT t.AD_Table_ID FROM AD_Tab tab JOIN AD_Table t ON t.AD_Table_ID=tab.AD_Table_ID WHERE t.IsActive='Y' AND tab.IsActive='Y' AND tab.AD_Window_ID=? ORDER BY tab.SeqNo", new Object[]{AD_Window_ID});
            tableName = null;
            if (tableID > 0) {
                tableName = MTable.get(Env.getCtx(), tableID).getTableName();
            }
            if (tableName != null && tableName.equals(query.getZoomTableName())) {
                return MZoomCondition.findZoomWindowByTableId(tableID, query, windowNo);
            }
            try {
                window = GridWindow.get(Env.getCtx(), -1, AD_Window_ID);
                if (window == null || window.getTabCount() == 0) {
                    return 0;
                }
                size = window.getTabCount();
                gTab = null;
                i = 0;
                while (i < size) {
                    if (window.getTab(i).getTableName().equals(query.getZoomTableName())) {
                        gTab = window.getTab(i);
                        break;
                    }
                    ++i;
                }
                if (gTab == null) break block19;
                window.initTab(gTab.getTabNo());
                parentTab = gTab.getParentTab();
                parentId = -1;
                if (!Util.isEmpty(gTab.getLinkColumnName())) {
                    parentId = DB.getSQLValue(null, "SELECT " + gTab.getLinkColumnName() + " FROM " + gTab.getTableName() + " WHERE " + query.getWhereClause());
                }
                if (parentId > 0) ** GOTO lbl46
                if (Util.isEmpty(parentTab.getKeyColumnName())) {
                    parentTab.initTab(false);
                }
                if (!Util.isEmpty(parentctxid = Env.getContext(Env.getCtx(), windowNo, parentTab.getKeyColumnName()))) {
                    parentId = DB.getSQLValue(null, "SELECT " + parentTab.getKeyColumnName() + " FROM " + parentTab.getTableName() + " WHERE " + parentTab.getKeyColumnName() + "=" + parentctxid);
                }
                if (parentId > 0) ** GOTO lbl46
                return 0;
lbl-1000:
                // 1 sources

                {
                    window.initTab(parentTab.getTabNo());
                    if (parentTab.getParentTab() != null) {
                        parentId = DB.getSQLValue(null, "SELECT " + parentTab.getLinkColumnName() + " FROM " + parentTab.getTableName() + " WHERE " + parentTab.getTableName() + "_ID=" + parentId);
                        if (parentId <= 0) {
                            return 0;
                        }
                        parentTab = parentTab.getParentTab();
                        continue;
                    }
                    if (parentTab != window.getTab(0)) continue;
                    var12_12 = MZoomCondition.findZoomWindowByTableId(parentTab.getAD_Table_ID(), parentId, windowNo);
                    return var12_12;
lbl46:
                    // 4 sources

                    ** while (parentTab != null)
                }
lbl47:
                // 1 sources

            }
            finally {
                Env.clearWinContext(-1);
            }
        }
        return 0;
    }

    public static int findZoomWindowByTableId(int AD_Table_ID, int recordID) {
        return MZoomCondition.findZoomWindowByTableId(AD_Table_ID, recordID, 0);
    }

    public static int findZoomWindowByTableId(int AD_Table_ID, int recordID, int windowNo) {
        final int winNo = windowNo;
        MTable table2 = MTable.get(Env.getCtx(), AD_Table_ID);
        MZoomCondition[] conditions = MZoomCondition.getConditions(AD_Table_ID);
        if (conditions.length > 0) {
            Evaluatee evaluatee = new Evaluatee(){

                @Override
                public String get_ValueAsString(String variableName) {
                    return Env.getContext(Env.getCtx(), winNo, variableName);
                }
            };
            String whereClause = String.valueOf(table2.getTableName()) + "_ID=" + recordID;
            MZoomCondition[] mZoomConditionArray = conditions;
            int n = conditions.length;
            int n2 = 0;
            while (n2 < n) {
                boolean evaluation;
                MZoomCondition condition = mZoomConditionArray[n2];
                if ((Util.isEmpty(condition.getZoomLogic()) || Evaluator.evaluateLogic(evaluatee, condition.getZoomLogic())) && (evaluation = condition.evaluate(whereClause))) {
                    return condition.getAD_Window_ID();
                }
                ++n2;
            }
        }
        return 0;
    }

    public boolean evaluate(String whereClause) {
        if (Util.isEmpty(this.getWhereClause())) {
            return true;
        }
        MTable table2 = MTable.get(Env.getCtx(), this.getAD_Table_ID());
        String tableName = table2.getTableName();
        StringBuilder builder = new StringBuilder("SELECT Count(*) FROM ");
        builder.append(tableName).append(" WHERE ").append(whereClause).append(" AND ").append(Env.parseContext(Env.getCtx(), 0, this.getWhereClause(), false, true));
        int no = DB.getSQLValue(null, builder.toString());
        return no == 1;
    }
}

