/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.awt.Dimension;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MMenu;
import org.compiere.model.MRole;
import org.compiere.model.MTab;
import org.compiere.model.MWindowAccess;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Window;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.wf.MWFNode;

public class MWindow
extends X_AD_Window {
    private static final long serialVersionUID = 8966733945232755787L;
    private static CLogger s_log = CLogger.getCLogger(MWindow.class);
    private static CCache<Integer, MWindow> s_cache = new CCache("AD_Window", 20);
    private MTab[] m_tabs = null;

    public static MWindow get(Properties ctx, int AD_Window_ID) {
        Integer key = AD_Window_ID;
        MWindow retValue = s_cache.get(key);
        if (retValue != null && retValue.getCtx() == ctx) {
            return retValue;
        }
        retValue = new MWindow(ctx, AD_Window_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MWindow(Properties ctx, int AD_Window_ID, String trxName) {
        super(ctx, AD_Window_ID, trxName);
        if (AD_Window_ID == 0) {
            this.setWindowType("M");
            this.setEntityType("U");
            this.setIsBetaFunctionality(false);
            this.setIsDefault(false);
            this.setIsSOTrx(true);
        }
    }

    public MWindow(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setWindowSize(Dimension size) {
        if (size != null) {
            this.setWinWidth(size.width);
            this.setWinHeight(size.height);
        }
    }

    public MTab[] getTabs(boolean reload, String trxName) {
        if (this.m_tabs != null && !reload) {
            return this.m_tabs;
        }
        String whereClause = "AD_Window_ID=?";
        List<MTab> list = new Query(this.getCtx(), "AD_Tab", "AD_Window_ID=?", trxName).setParameters(this.getAD_Window_ID()).setOrderBy("SeqNo").list();
        this.m_tabs = new MTab[list.size()];
        list.toArray(this.m_tabs);
        return this.m_tabs;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        block8: {
            block7: {
                if (!success) {
                    return success;
                }
                if (!newRecord) break block7;
                MRole[] roles = MRole.getOf(this.getCtx(), "IsManual='N'");
                int i2 = 0;
                while (i2 < roles.length) {
                    MWindowAccess wa = new MWindowAccess(this, roles[i2].getAD_Role_ID());
                    wa.saveEx();
                    ++i2;
                }
                break block8;
            }
            if (!this.is_ValueChanged("IsActive") && !this.is_ValueChanged("Name") && !this.is_ValueChanged("Description") && !this.is_ValueChanged("Help")) break block8;
            MMenu[] menues = MMenu.get(this.getCtx(), "AD_Window_ID=" + this.getAD_Window_ID(), this.get_TrxName());
            int i3 = 0;
            while (i3 < menues.length) {
                menues[i3].setName(this.getName());
                menues[i3].setDescription(this.getDescription());
                menues[i3].setIsActive(this.isActive());
                menues[i3].saveEx();
                ++i3;
            }
            MWFNode[] nodes = MWindow.getWFNodes(this.getCtx(), "AD_Window_ID=" + this.getAD_Window_ID(), this.get_TrxName());
            int i4 = 0;
            while (i4 < nodes.length) {
                boolean changed = false;
                if (nodes[i4].isActive() != this.isActive()) {
                    nodes[i4].setIsActive(this.isActive());
                    changed = true;
                }
                if (nodes[i4].isCentrallyMaintained()) {
                    nodes[i4].setName(this.getName());
                    nodes[i4].setDescription(this.getDescription());
                    nodes[i4].setHelp(this.getHelp());
                    changed = true;
                }
                if (changed) {
                    nodes[i4].saveEx();
                }
                ++i4;
            }
        }
        return success;
    }

    public static MWFNode[] getWFNodes(Properties ctx, String whereClause, String trxName) {
        List<MWFNode> list = new Query(ctx, "AD_WF_Node", whereClause, trxName).list();
        MWFNode[] retValue = new MWFNode[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static int getWindow_ID(String windowName) {
        int retValue;
        block6: {
            retValue = 0;
            String SQL = "SELECT AD_Window_ID FROM AD_Window WHERE Name = ?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(SQL, null);
                    pstmt.setString(1, windowName);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, SQL, e);
                    retValue = -1;
                    DB.close(rs, pstmt);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
        return retValue;
    }
}

