/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MLocator;
import org.compiere.model.MOrg;
import org.compiere.model.Query;
import org.compiere.model.X_M_Warehouse;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MWarehouse
extends X_M_Warehouse {
    private static final long serialVersionUID = -3065089372599460372L;
    protected static CCache<Integer, MWarehouse> s_cache = new CCache("M_Warehouse", 50);
    protected MLocator[] m_locators = null;

    public static MWarehouse get(Properties ctx, int M_Warehouse_ID) {
        return MWarehouse.get(ctx, M_Warehouse_ID, null);
    }

    public static MWarehouse get(Properties ctx, int M_Warehouse_ID, String trxName) {
        Integer key = M_Warehouse_ID;
        MWarehouse retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MWarehouse(ctx, M_Warehouse_ID, trxName);
        s_cache.put(key, retValue);
        return retValue;
    }

    public static MWarehouse[] getForOrg(Properties ctx, int AD_Org_ID) {
        String whereClause = "AD_Org_ID=?";
        List<MWarehouse> list = new Query(ctx, "M_Warehouse", "AD_Org_ID=?", null).setParameters(AD_Org_ID).setOnlyActiveRecords(true).setOrderBy("M_Warehouse_ID").list();
        return list.toArray(new MWarehouse[list.size()]);
    }

    public static MWarehouse[] getInTransitForOrg(Properties ctx, int AD_Org_ID) {
        String whereClause = "IsInTransit=? AND AD_Org_ID=?";
        List<MWarehouse> list = new Query(ctx, "M_Warehouse", "IsInTransit=? AND AD_Org_ID=?", null).setParameters("Y", AD_Org_ID).setOnlyActiveRecords(true).setOrderBy("M_Warehouse_ID").list();
        return list.toArray(new MWarehouse[list.size()]);
    }

    public MWarehouse(Properties ctx, int M_Warehouse_ID, String trxName) {
        super(ctx, M_Warehouse_ID, trxName);
        if (M_Warehouse_ID == 0) {
            this.setSeparator("*");
        }
    }

    public MWarehouse(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MWarehouse(MOrg org) {
        this(org.getCtx(), 0, org.get_TrxName());
        this.setClientOrg(org);
        this.setValue(org.getValue());
        this.setName(org.getName());
        if (org.getInfo() != null) {
            this.setC_Location_ID(org.getInfo().getC_Location_ID());
        }
    }

    public MLocator[] getLocators(boolean reload) {
        if (!reload && this.m_locators != null) {
            return this.m_locators;
        }
        String whereClause = "M_Warehouse_ID=?";
        List<MLocator> list = new Query(this.getCtx(), "M_Locator", "M_Warehouse_ID=?", null).setParameters(this.getM_Warehouse_ID()).setOnlyActiveRecords(true).setOrderBy("X,Y,Z").list();
        this.m_locators = list.toArray(new MLocator[list.size()]);
        return this.m_locators;
    }

    public MLocator getDefaultLocator() {
        MLocator[] locators = this.getLocators(false);
        int i2 = 0;
        while (i2 < locators.length) {
            if (locators[i2].isDefault() && locators[i2].isActive()) {
                return locators[i2];
            }
            ++i2;
        }
        if (locators.length > 0) {
            this.log.warning("No default locator for " + this.getName());
            return locators[0];
        }
        String whereClause = "M_Warehouse_ID=?";
        List list = new Query(this.getCtx(), "M_Locator", whereClause, null).setParameters(this.getM_Warehouse_ID()).setOnlyActiveRecords(false).list();
        if (!list.isEmpty()) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("All locator is inactive for " + this.getName());
            }
            return null;
        }
        MLocator loc = new MLocator(this, "Standard");
        loc.setIsDefault(true);
        loc.saveEx();
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Created default locator for " + this.getName());
        }
        return loc;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.is_ValueChanged("IsDisallowNegativeInv") && this.isDisallowNegativeInv()) {
            String sql = "SELECT M_Product_ID FROM M_StorageOnHand s WHERE s.M_Locator_ID IN (SELECT M_Locator_ID FROM M_Locator l WHERE M_Warehouse_ID=? ) GROUP BY M_Product_ID, M_Locator_ID, M_AttributeSetInstance_ID  HAVING SUM(s.QtyOnHand) < 0 ";
            int prdid = DB.getSQLValueEx(this.get_TrxName(), sql, this.getM_Warehouse_ID());
            if (prdid > 0) {
                this.log.saveError("Error", Msg.translate(this.getCtx(), "NegativeOnhandExists"));
                return false;
            }
        }
        if (this.getAD_Org_ID() == 0) {
            int context_AD_Org_ID = Env.getAD_Org_ID(this.getCtx());
            if (context_AD_Org_ID != 0) {
                this.setAD_Org_ID(context_AD_Org_ID);
                this.log.warning("Changed Org to Context=" + context_AD_Org_ID);
            } else {
                this.log.saveError("Error", Msg.translate(this.getCtx(), "Org0NotAllowed"));
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord && success) {
            this.insert_Accounting("M_Warehouse_Acct", "C_AcctSchema_Default", null);
        }
        return success;
    }
}

