/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MTable;
import org.compiere.model.MViewColumn;
import org.compiere.model.Query;
import org.compiere.model.X_AD_ViewColumn;
import org.compiere.model.X_AD_ViewComponent;

public class MViewComponent
extends X_AD_ViewComponent {
    private static final long serialVersionUID = -8915166706061086737L;
    private MViewColumn[] m_columns = null;

    public MViewComponent(Properties ctx, int AD_ViewComponent_ID, String trxName) {
        super(ctx, AD_ViewComponent_ID, trxName);
    }

    public MViewComponent(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MViewComponent(MTable parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setAD_Table_ID(parent.getAD_Table_ID());
    }

    public MViewColumn[] getColumns(boolean reload) {
        if (this.m_columns != null && !reload) {
            return this.m_columns;
        }
        Query query = new Query(this.getCtx(), "AD_ViewColumn", "AD_ViewComponent_ID=?", this.get_TrxName());
        query.setParameters(this.getAD_ViewComponent_ID());
        query.setOnlyActiveRecords(true);
        query.setOrderBy("SeqNo, AD_ViewColumn_ID");
        List<MViewColumn> list = query.list();
        this.m_columns = new MViewColumn[list.size()];
        list.toArray(this.m_columns);
        return this.m_columns;
    }

    public String getSelect(boolean requery, MViewColumn[] vCols) {
        this.getColumns(requery);
        if (this.m_columns == null || this.m_columns.length == 0) {
            return null;
        }
        if (vCols == null) {
            vCols = this.m_columns;
        }
        StringBuilder sb = new StringBuilder("SELECT ");
        int i2 = 0;
        while (i2 < vCols.length) {
            String colSQL;
            String colName = vCols[i2].getColumnName();
            X_AD_ViewColumn vc = null;
            MViewColumn[] mViewColumnArray = this.m_columns;
            int n = this.m_columns.length;
            int n2 = 0;
            while (n2 < n) {
                MViewColumn element = mViewColumnArray[n2];
                if (element.getColumnName().equals(colName)) {
                    vc = element;
                    break;
                }
                ++n2;
            }
            if (i2 > 0) {
                sb.append(", ");
            }
            if ((colSQL = vc.getColumnSQL()) == null || colSQL.toUpperCase().equals("NULL")) {
                String dt = vc.getDBDataType();
                if (dt != null) {
                    if (dt.equals("C") || dt.equals("V")) {
                        colSQL = "NULLIF('a','a')";
                    } else if (dt.equals("D") || dt.equals("I") || dt.equals("N")) {
                        colSQL = "NULLIF(1,1)";
                    } else if (dt.equals("T")) {
                        colSQL = "NULL";
                    }
                } else {
                    colSQL = "NULL";
                }
            }
            sb.append(colSQL);
            if (!colName.equals("*")) {
                sb.append(" AS ").append(colName);
            }
            ++i2;
        }
        sb.append(" ").append(this.getFromClause());
        String t = this.getWhereClause();
        if (t != null && t.length() > 0) {
            sb.append(" ").append(t);
        }
        if ((t = this.getOtherClause()) != null && t.length() > 0) {
            sb.append(" ").append(t);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MViewComponent[").append(this.get_ID()).append("-").append(this.getName());
        sb.append("]");
        return sb.toString();
    }
}

