/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.compiere.model.MClient;
import org.compiere.model.MPasswordHistory;
import org.compiere.model.MPasswordRule;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.Query;
import org.compiere.model.X_AD_User;
import org.compiere.model.X_AD_UserBPAccess;
import org.compiere.model.X_C_BPartner;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Secure;
import org.compiere.util.SecureEngine;
import org.compiere.util.Util;

public class MUser
extends X_AD_User {
    private static final long serialVersionUID = 9027688865361175114L;
    private static CCache<Integer, MUser> s_cache = new CCache("AD_User", 30, 60);
    private static CLogger s_log = CLogger.getCLogger(MUser.class);
    private MRole[] m_roles = null;
    private int m_rolesAD_Org_ID = -1;
    private Boolean m_isAdministrator = null;
    private X_AD_UserBPAccess[] m_bpAccess = null;
    private boolean being_hashed = false;

    public static MUser[] getOfBPartner(Properties ctx, int C_BPartner_ID) {
        return MUser.getOfBPartner(ctx, C_BPartner_ID, null);
    }

    public static MUser[] getOfBPartner(Properties ctx, int C_BPartner_ID, String trxName) {
        List<MUser> list = new Query(ctx, "AD_User", "C_BPartner_ID=?", trxName).setParameters(C_BPartner_ID).setOnlyActiveRecords(true).list();
        MUser[] retValue = new MUser[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MUser[] getWithRole(MRole role) {
        ArrayList<MUser> list;
        block6: {
            list = new ArrayList<MUser>();
            String sql = "SELECT * FROM AD_User u WHERE u.IsActive='Y' AND EXISTS (SELECT * FROM AD_User_Roles ur WHERE ur.AD_User_ID=u.AD_User_ID AND ur.AD_Role_ID=? AND ur.IsActive='Y')";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, role.getAD_Role_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MUser(role.getCtx(), rs, null));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
        MUser[] retValue = new MUser[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MUser get(Properties ctx, int AD_User_ID) {
        Integer key = AD_User_ID;
        MUser retValue = s_cache.get(key);
        if (retValue == null) {
            retValue = new MUser(ctx, AD_User_ID, null);
            if (AD_User_ID == 0) {
                String trxName = null;
                retValue.load(trxName);
            }
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static MUser get(Properties ctx) {
        return MUser.get(ctx, Env.getAD_User_ID(ctx));
    }

    public static MUser get(Properties ctx, String name, String password) {
        if (name == null || name.length() == 0 || password == null || password.length() == 0) {
            s_log.warning("Invalid Name/Password = " + name);
            return null;
        }
        boolean hash_password = MSysConfig.getBooleanValue("USER_PASSWORD_HASH", false);
        boolean email_login = MSysConfig.getBooleanValue("USE_EMAIL_FOR_LOGIN", false);
        ArrayList<Integer> clientsValidated = new ArrayList<Integer>();
        MUser retValue = null;
        StringBuilder where = new StringBuilder("Password IS NOT NULL AND ");
        if (email_login) {
            where.append("EMail=?");
        } else {
            where.append("COALESCE(LDAPUser,Name)=?");
        }
        where.append(" AND").append(" EXISTS (SELECT * FROM AD_User_Roles ur").append("         INNER JOIN AD_Role r ON (ur.AD_Role_ID=r.AD_Role_ID)").append("         WHERE ur.AD_User_ID=AD_User.AD_User_ID AND ur.IsActive='Y' AND r.IsActive='Y') AND ").append(" EXISTS (SELECT * FROM AD_Client c").append("         WHERE c.AD_Client_ID=AD_User.AD_Client_ID").append("         AND c.IsActive='Y') AND ").append(" AD_User.IsActive='Y'");
        List users = new Query(ctx, "AD_User", where.toString(), null).setParameters(name).setOrderBy("AD_Client_ID, AD_User_ID").list();
        if (users.size() == 0) {
            s_log.saveError("UserPwdError", name, false);
            return null;
        }
        for (MUser user : users) {
            if (clientsValidated.contains(user.getAD_Client_ID())) {
                s_log.severe("Two users with password with the same name/email combination on same tenant: " + name);
                return null;
            }
            clientsValidated.add(user.getAD_Client_ID());
            boolean valid = false;
            valid = hash_password ? user.authenticateHash(password) : user.getPassword().equals(password);
            if (!valid) continue;
            retValue = user;
            break;
        }
        return retValue;
    }

    public static String getNameOfUser(int AD_User_ID) {
        MUser user = MUser.get(Env.getCtx(), AD_User_ID);
        if (user.getAD_User_ID() != AD_User_ID) {
            return "?";
        }
        return user.getName();
    }

    public static boolean isSalesRep(int AD_User_ID) {
        if (AD_User_ID == 0) {
            return false;
        }
        String sql = "SELECT MAX(AD_User_ID) FROM AD_User u INNER JOIN C_BPartner bp ON (u.C_BPartner_ID=bp.C_BPartner_ID) WHERE bp.IsSalesRep='Y' AND AD_User_ID=?";
        int no = DB.getSQLValue(null, sql, AD_User_ID);
        return no == AD_User_ID;
    }

    public MUser(Properties ctx, int AD_User_ID, String trxName) {
        super(ctx, AD_User_ID, trxName);
        if (AD_User_ID == 0) {
            this.setIsFullBPAccess(true);
            this.setNotificationType("E");
        }
    }

    public MUser(X_C_BPartner partner) {
        this(partner.getCtx(), 0, partner.get_TrxName());
        this.setClientOrg(partner);
        this.setC_BPartner_ID(partner.getC_BPartner_ID());
        this.setName(partner.getName());
    }

    public MUser(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String getValue() {
        String s = super.getValue();
        if (s != null) {
            return s;
        }
        this.setValue(null);
        return super.getValue();
    }

    @Override
    public void setValue(String Value) {
        String result;
        if (Value == null || Value.trim().length() == 0) {
            Value = this.getLDAPUser();
        }
        if (Value == null || Value.length() == 0) {
            Value = this.getName();
        }
        if (Value == null || Value.length() == 0) {
            Value = "noname";
        }
        if ((result = this.cleanValue(Value)).length() > 8) {
            String first = this.getName(Value, true);
            String last = this.getName(Value, false);
            if (last.length() > 0) {
                String temp = last;
                if (first.length() > 0) {
                    temp = String.valueOf(first.substring(0, 1)) + last;
                }
                result = this.cleanValue(temp);
            } else {
                result = this.cleanValue(first);
            }
        }
        if (result.length() > 8) {
            result = result.substring(0, 8);
        }
        super.setValue(result);
    }

    private String cleanValue(String value) {
        char[] chars = value.toCharArray();
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (i2 < chars.length) {
            char ch = chars[i2];
            if ((ch = Character.toLowerCase(ch)) >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z') {
                sb.append(ch);
            }
            ++i2;
        }
        return sb.toString();
    }

    @Override
    public void setPassword(String password) {
        if (password == null) {
            super.setPassword(password);
            return;
        }
        boolean hash_password = MSysConfig.getBooleanValue("USER_PASSWORD_HASH", false);
        if (!hash_password) {
            super.setPassword(password);
            return;
        }
        if (this.being_hashed) {
            return;
        }
        this.being_hashed = true;
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            byte[] bSalt = new byte[8];
            random.nextBytes(bSalt);
            String hash = SecureEngine.getSHA512Hash(1000, password, bSalt);
            String sSalt = Secure.convertToHexString(bSalt);
            super.setPassword(hash);
            this.setSalt(sSalt);
        }
        catch (NoSuchAlgorithmException e) {
            super.setPassword(password);
        }
        catch (UnsupportedEncodingException e) {
            super.setPassword(password);
        }
    }

    public boolean authenticateHash(String password) {
        return SecureEngine.isMatchHash(this.getPassword(), this.getSalt(), password);
    }

    public String getFirstName() {
        return this.getName(this.getName(), true);
    }

    public String getLastName() {
        return this.getName(this.getName(), false);
    }

    private String getName(String name, boolean getFirst) {
        if (name == null || name.length() == 0) {
            return "";
        }
        String first = null;
        String last = null;
        boolean lastFirst = name.indexOf(44) != -1;
        StringTokenizer st = null;
        st = lastFirst ? new StringTokenizer(name, ",") : new StringTokenizer(name, " ");
        while (st.hasMoreTokens()) {
            String s = st.nextToken().trim();
            if (lastFirst) {
                if (last == null) {
                    last = s;
                    continue;
                }
                if (first != null) continue;
                first = s;
                continue;
            }
            if (first == null) {
                first = s;
                continue;
            }
            last = s;
        }
        if (getFirst) {
            if (first == null) {
                return "";
            }
            return first.trim();
        }
        if (last == null) {
            return "";
        }
        return last.trim();
    }

    public void addDescription(String description) {
        if (description == null || description.length() == 0) {
            return;
        }
        String descr = this.getDescription();
        if (descr == null || descr.length() == 0) {
            this.setDescription(description);
        } else {
            this.setDescription(String.valueOf(descr) + " - " + description);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MUser[").append(this.get_ID()).append(",Name=").append(this.getName()).append(",EMailUserID=").append(this.getEMailUser()).append("]");
        return sb.toString();
    }

    public boolean isOnline() {
        return this.getEMail() != null && this.getPassword() != null;
    }

    @Override
    public void setEMail(String EMail2) {
        super.setEMail(EMail2);
        this.setEMailVerifyDate(null);
    }

    public InternetAddress getInternetAddress() {
        String email = this.getEMail();
        if (email == null || email.length() == 0) {
            return null;
        }
        try {
            InternetAddress ia = new InternetAddress(email, true);
            if (ia != null) {
                ia.validate();
            }
            return ia;
        }
        catch (AddressException ex) {
            this.log.warning(String.valueOf(email) + " - " + ex.getLocalizedMessage());
            return null;
        }
    }

    private String validateEmail(InternetAddress ia) {
        if (ia == null) {
            return "NoEmail";
        }
        return ia.getAddress();
    }

    public boolean isEMailValid() {
        return this.validateEmail(this.getInternetAddress()) != null;
    }

    public boolean isCanSendEMail() {
        String s = this.getEMailUser();
        if (s == null || s.length() == 0) {
            return false;
        }
        if (!MClient.get(this.getCtx()).isSmtpAuthorization()) {
            return true;
        }
        s = this.getEMailUserPW();
        return s != null && s.length() > 0;
    }

    public String getEMailVerifyCode() {
        long code = this.getAD_User_ID() + this.getName().hashCode();
        return "C" + String.valueOf(Math.abs(code)) + "C";
    }

    public boolean setEMailVerifyCode(String code, String info) {
        boolean ok;
        boolean bl = ok = code != null && code.equals(this.getEMailVerifyCode());
        if (ok) {
            this.setEMailVerifyDate(new Timestamp(System.currentTimeMillis()));
        } else {
            this.setEMailVerifyDate(null);
        }
        this.setEMailVerify(info);
        return ok;
    }

    public boolean isEMailVerified() {
        return this.getEMailVerifyDate() != null && this.getEMailVerify() != null && this.getEMailVerify().length() > 0;
    }

    public boolean isNotificationEMail() {
        String s = this.getNotificationType();
        return s == null || "E".equals(s) || "B".equals(s);
    }

    public boolean isNotificationNote() {
        String s = this.getNotificationType();
        return s != null && ("N".equals(s) || "B".equals(s));
    }

    public MRole[] getRoles(int AD_Org_ID) {
        ArrayList<MRole> list;
        block7: {
            if (this.m_roles != null && this.m_rolesAD_Org_ID == AD_Org_ID) {
                return this.m_roles;
            }
            list = new ArrayList<MRole>();
            String sql = "SELECT * FROM AD_Role r WHERE r.IsActive='Y' AND EXISTS (SELECT * FROM AD_User_Roles ur WHERE r.AD_Role_ID=ur.AD_Role_ID AND ur.IsActive='Y' AND ur.AD_User_ID=?)  AND ( ( r.isaccessallorgs = 'Y' ) OR  ( r.IsUseUserOrgAccess <> 'Y' AND EXISTS (SELECT * FROM AD_Role_OrgAccess ro WHERE r.AD_Role_ID=ro.AD_Role_ID AND ro.IsActive='Y' AND ro.AD_Org_ID=?) ) OR  ( r.IsUseUserOrgAccess = 'Y' AND EXISTS (SELECT * FROM AD_User_OrgAccess uo WHERE uo.AD_User_ID=? AND uo.IsActive='Y' AND uo.AD_Org_ID=?) ) ) ORDER BY AD_Role_ID";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getAD_User_ID());
                    pstmt.setInt(2, AD_Org_ID);
                    pstmt.setInt(3, this.getAD_User_ID());
                    pstmt.setInt(4, AD_Org_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MRole(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_rolesAD_Org_ID = AD_Org_ID;
        this.m_roles = new MRole[list.size()];
        list.toArray(this.m_roles);
        return this.m_roles;
    }

    public boolean isAdministrator() {
        if (this.m_isAdministrator == null) {
            this.m_isAdministrator = Boolean.FALSE;
            MRole[] roles = this.getRoles(0);
            int i2 = 0;
            while (i2 < roles.length) {
                if (roles[i2].getAD_Role_ID() == 0) {
                    this.m_isAdministrator = Boolean.TRUE;
                    break;
                }
                ++i2;
            }
        }
        return this.m_isAdministrator;
    }

    public boolean hasBPAccess(String BPAccessType, Object[] params) {
        if (this.isFullBPAccess()) {
            return true;
        }
        this.getBPAccess(false);
        int i2 = 0;
        while (i2 < this.m_bpAccess.length) {
            if (this.m_bpAccess[i2].getBPAccessType().equals(BPAccessType)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public X_AD_UserBPAccess[] getBPAccess(boolean requery) {
        ArrayList<X_AD_UserBPAccess> list;
        block7: {
            if (this.m_bpAccess != null && !requery) {
                return this.m_bpAccess;
            }
            String sql = "SELECT * FROM AD_UserBPAccess WHERE AD_User_ID=? AND IsActive='Y'";
            list = new ArrayList<X_AD_UserBPAccess>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, this.getAD_User_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new X_AD_UserBPAccess(this.getCtx(), rs, null));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
        this.m_bpAccess = new X_AD_UserBPAccess[list.size()];
        list.toArray(this.m_bpAccess);
        return this.m_bpAccess;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (!newRecord && this.is_ValueChanged("EMail")) {
            this.setEMailVerifyDate(null);
        }
        if (!Util.isEmpty(this.getEMail()) && (newRecord || this.is_ValueChanged("EMail")) && !EMail.validate(this.getEMail())) {
            this.log.saveError("SaveError", String.valueOf(Msg.getMsg(this.getCtx(), "InvalidEMailFormat")) + Msg.getElement(this.getCtx(), "EMail") + " - [" + this.getEMail() + "]");
            return false;
        }
        if (newRecord || super.getValue() == null || this.is_ValueChanged("Value")) {
            this.setValue(super.getValue());
        }
        if (this.getPassword() != null && this.getPassword().length() > 0) {
            boolean email_login = MSysConfig.getBooleanValue("USE_EMAIL_FOR_LOGIN", false);
            if (email_login) {
                if (this.getEMail() == null || this.getEMail().length() == 0) {
                    this.log.saveError("SaveError", String.valueOf(Msg.getMsg(this.getCtx(), "FillMandatory")) + Msg.getElement(this.getCtx(), "EMail") + " - " + this.toString());
                    return false;
                }
                int cnt = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(*) FROM AD_User WHERE Password IS NOT NULL AND EMail=? AND AD_Client_ID=? AND AD_User_ID!=?", this.getEMail(), this.getAD_Client_ID(), this.getAD_User_ID());
                if (cnt > 0) {
                    this.log.saveError("SaveError", String.valueOf(Msg.getMsg(this.getCtx(), "SaveErrorNotUnique", true)) + Msg.getElement(this.getCtx(), "EMail"));
                    return false;
                }
            } else {
                int cnt;
                String nameToValidate = this.getLDAPUser();
                if (Util.isEmpty(nameToValidate)) {
                    nameToValidate = this.getName();
                }
                if ((cnt = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(*) FROM AD_User WHERE Password IS NOT NULL AND COALESCE(LDAPUser,Name)=? AND AD_Client_ID=? AND AD_User_ID!=?", nameToValidate, this.getAD_Client_ID(), this.getAD_User_ID())) > 0) {
                    this.log.saveError("SaveError", String.valueOf(Msg.getMsg(this.getCtx(), "SaveErrorNotUnique", true)) + Msg.getElement(this.getCtx(), "Name") + " / " + Msg.getElement(this.getCtx(), "LDAPUser"));
                    return false;
                }
            }
        }
        if (this.getPassword() != null && this.getPassword().length() > 0 && (newRecord || this.is_ValueChanged("Password"))) {
            boolean hash_password;
            if (this.get_ValueOld("Salt") != null || this.get_Value("Salt") == null) {
                MPasswordRule pwdrule = MPasswordRule.getRules(this.getCtx(), this.get_TrxName());
                if (pwdrule != null) {
                    List<MPasswordHistory> passwordHistorys = MPasswordHistory.getPasswordHistoryForCheck(pwdrule.getDays_Reuse_Password(), this.getAD_User_ID());
                    pwdrule.validate(this.getLDAPUser() != null ? this.getLDAPUser() : this.getName(), this.getPassword(), passwordHistorys);
                }
                this.setDatePasswordChanged(new Timestamp(new Date().getTime()));
            }
            if (hash_password = MSysConfig.getBooleanValue("USER_PASSWORD_HASH", false)) {
                this.setPassword(this.getPassword());
            }
        }
        return true;
    }

    public boolean isMenuAutoExpand() {
        boolean isMenuAutoExpand = false;
        isMenuAutoExpand = this.getIsMenuAutoExpand() != null ? "Y".equals(this.getIsMenuAutoExpand()) : MRole.getDefault().isMenuAutoExpand();
        return isMenuAutoExpand;
    }

    public static MUser get(Properties ctx, String name) {
        MUser retValue;
        block11: {
            if (name == null || name.length() == 0) {
                s_log.warning("Invalid Name = " + name);
                return null;
            }
            retValue = null;
            int AD_Client_ID = Env.getAD_Client_ID(ctx);
            StringBuffer sql = new StringBuffer("SELECT DISTINCT u.AD_User_ID ").append("FROM AD_User u").append(" INNER JOIN AD_User_Roles ur ON (u.AD_User_ID=ur.AD_User_ID AND ur.IsActive='Y')").append(" INNER JOIN AD_Role r ON (ur.AD_Role_ID=r.AD_Role_ID AND r.IsActive='Y') ");
            sql.append("WHERE u.Password IS NOT NULL AND ur.AD_Client_ID=? AND ");
            boolean email_login = MSysConfig.getBooleanValue("USE_EMAIL_FOR_LOGIN", false);
            if (email_login) {
                sql.append("u.EMail=?");
            } else {
                sql.append("COALESCE(u.LDAPUser,u.Name)=?");
            }
            sql.append(" AND u.IsActive='Y'").append(" AND EXISTS (SELECT * FROM AD_Client c WHERE u.AD_Client_ID=c.AD_Client_ID AND c.IsActive='Y')");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    pstmt.setInt(1, AD_Client_ID);
                    pstmt.setString(2, name);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = MUser.get(ctx, rs.getInt(1));
                        if (rs.next()) {
                            s_log.warning("More then one user with Name/Password = " + name);
                        }
                    } else {
                        s_log.fine("No record");
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    @Override
    public String getEMailUser() {
        if (MClient.isSendCredentialsSystem()) {
            MClient sysclient = MClient.get(this.getCtx(), 0);
            return sysclient.getRequestUser();
        }
        if (MClient.isSendCredentialsClient()) {
            MClient client = MClient.get(this.getCtx());
            return client.getRequestUser();
        }
        return super.getEMailUser();
    }

    @Override
    public String getEMailUserPW() {
        if (MClient.isSendCredentialsSystem()) {
            MClient sysclient = MClient.get(this.getCtx(), 0);
            return sysclient.getRequestUserPW();
        }
        if (MClient.isSendCredentialsClient()) {
            MClient client = MClient.get(this.getCtx());
            return client.getRequestUserPW();
        }
        return super.getEMailUserPW();
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        MPasswordRule pwdrule;
        if (this.getPassword() != null && this.getPassword().length() > 0 && (newRecord || this.is_ValueChanged("Password")) && (pwdrule = MPasswordRule.getRules(this.getCtx(), this.get_TrxName())) != null && pwdrule.getDays_Reuse_Password() > 0) {
            boolean hash_password = MSysConfig.getBooleanValue("USER_PASSWORD_HASH", false);
            if (!hash_password) {
                this.log.severe("Saving password history: it is strongly encouraged to save password history just when using hashed passwords - WARNING! table AD_Password_History is possibly keeping plain passwords");
            }
            MPasswordHistory passwordHistory = new MPasswordHistory(this.getCtx(), 0, this.get_TrxName());
            passwordHistory.setSalt(this.getSalt());
            passwordHistory.setPassword(this.getPassword());
            if (!this.is_new() && this.getAD_User_ID() == 0) {
                passwordHistory.set_Value("AD_User_ID", (Object)0);
            } else {
                passwordHistory.setAD_User_ID(this.getAD_User_ID());
            }
            passwordHistory.setDatePasswordChanged(this.getUpdated());
            passwordHistory.saveEx();
        }
        return super.afterSave(newRecord, success);
    }
}

