/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MTaxPostal;
import org.compiere.model.Query;
import org.compiere.model.X_C_Tax;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class MTax
extends X_C_Tax {
    private static final long serialVersionUID = 5871827364071851846L;
    private static CCache<Integer, MTax> s_cache = new CCache("C_Tax", 5);
    private static CCache<Integer, MTax[]> s_cacheAll = new CCache("C_Tax", "C_Tax_Of_Client", 5);
    private MTax[] m_childTaxes = null;
    private MTaxPostal[] m_postals = null;

    public static MTax[] getAll(Properties ctx) {
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        MTax[] retValue = s_cacheAll.get(AD_Client_ID);
        if (retValue != null) {
            return retValue;
        }
        List<MTax> list = new Query(ctx, "C_Tax", null, null).setClient_ID().setOrderBy("C_CountryGroupFrom_ID, C_Country_ID, C_Region_ID, C_CountryGroupTo_ID, To_Country_ID, To_Region_ID, ValidFrom DESC").setOnlyActiveRecords(true).list();
        for (MTax tax : list) {
            s_cache.put(tax.get_ID(), tax);
        }
        retValue = list.toArray(new MTax[list.size()]);
        s_cacheAll.put(AD_Client_ID, retValue);
        return retValue;
    }

    public static MTax get(Properties ctx, int C_Tax_ID) {
        Integer key = C_Tax_ID;
        MTax retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MTax(ctx, C_Tax_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MTax(Properties ctx, int C_Tax_ID, String trxName) {
        super(ctx, C_Tax_ID, trxName);
        if (C_Tax_ID == 0) {
            this.setIsDefault(false);
            this.setIsDocumentLevel(true);
            this.setIsSummary(false);
            this.setIsTaxExempt(false);
            this.setRate(Env.ZERO);
            this.setRequiresTaxCertificate(false);
            this.setSOPOType("B");
            this.setValidFrom(TimeUtil.getDay(1990, 1, 1));
            this.setIsSalesTax(false);
        }
    }

    public MTax(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MTax(Properties ctx, String Name2, BigDecimal Rate, int C_TaxCategory_ID, String trxName) {
        this(ctx, 0, trxName);
        this.setName(Name2);
        this.setRate(Rate == null ? Env.ZERO : Rate);
        this.setC_TaxCategory_ID(C_TaxCategory_ID);
    }

    public MTax[] getChildTaxes(boolean requery) {
        if (!this.isSummary()) {
            return null;
        }
        if (this.m_childTaxes != null && !requery) {
            return this.m_childTaxes;
        }
        String whereClause = "Parent_Tax_ID=?";
        List<MTax> list = new Query(this.getCtx(), "C_Tax", "Parent_Tax_ID=?", this.get_TrxName()).setParameters(this.getC_Tax_ID()).setOnlyActiveRecords(true).list();
        this.m_childTaxes = new MTax[list.size()];
        list.toArray(this.m_childTaxes);
        return this.m_childTaxes;
    }

    public MTaxPostal[] getPostals(boolean requery) {
        if (this.m_postals != null && !requery) {
            return this.m_postals;
        }
        String whereClause = "C_Tax_ID=?";
        List<MTaxPostal> list = new Query(this.getCtx(), "C_TaxPostal", "C_Tax_ID=?", this.get_TrxName()).setParameters(this.getC_Tax_ID()).setOnlyActiveRecords(true).setOrderBy("Postal, Postal_To").list();
        if (list.size() > 0) {
            this.m_postals = new MTaxPostal[list.size()];
            list.toArray(this.m_postals);
        }
        return this.m_postals;
    }

    public boolean isPostal() {
        if (this.getPostals(false) == null) {
            return false;
        }
        return this.getPostals(false).length > 0;
    }

    public boolean isZeroTax() {
        return this.getRate().signum() == 0;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MTax[").append(this.get_ID()).append(", Name = ").append(this.getName()).append(", SO/PO=").append(this.getSOPOType()).append(", Rate=").append(this.getRate()).append(", C_TaxCategory_ID=").append(this.getC_TaxCategory_ID()).append(", Summary=").append(this.isSummary()).append(", Parent=").append(this.getParent_Tax_ID()).append(", Country=").append(this.getC_Country_ID()).append("|").append(this.getTo_Country_ID()).append(", Region=").append(this.getC_Region_ID()).append("|").append(this.getTo_Region_ID()).append("]");
        return sb.toString();
    }

    public BigDecimal calculateTax(BigDecimal amount, boolean taxIncluded, int scale) {
        if (this.isZeroTax()) {
            return Env.ZERO;
        }
        MTax[] taxarray = this.isSummary() ? this.getChildTaxes(false) : new MTax[]{this};
        BigDecimal tax = Env.ZERO;
        MTax[] mTaxArray = taxarray;
        int n = taxarray.length;
        int n2 = 0;
        while (n2 < n) {
            MTax taxc = mTaxArray[n2];
            BigDecimal multiplier = taxc.getRate().divide(Env.ONEHUNDRED, 12, RoundingMode.HALF_UP);
            if (!taxIncluded) {
                BigDecimal itax = amount.multiply(multiplier).setScale(scale, RoundingMode.HALF_UP);
                tax = tax.add(itax);
            } else {
                multiplier = multiplier.add(Env.ONE);
                BigDecimal base = amount.divide(multiplier, 12, RoundingMode.HALF_UP);
                BigDecimal itax = amount.subtract(base).setScale(scale, RoundingMode.HALF_UP);
                tax = tax.add(itax);
            }
            ++n2;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("calculateTax " + amount + " (incl=" + taxIncluded + ",scale=" + scale + ") = " + tax + " [" + tax + "]");
        }
        return tax;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.isDefault()) {
            String whereClause = "C_TaxCategory_ID=? AND C_Tax_ID<>? AND IsDefault='Y'";
            List list = new Query(this.getCtx(), "C_Tax", whereClause, this.get_TrxName()).setParameters(this.getC_TaxCategory_ID(), this.getC_Tax_ID()).setOnlyActiveRecords(true).list();
            if (list.size() >= 1) {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), Msg.getMsg(Env.getCtx(), "OnlyOneTaxPerCategoryMarkedDefault")));
                return false;
            }
        }
        if (this.getC_Country_ID() > 0 && this.getC_CountryGroupFrom_ID() > 0) {
            this.setC_Country_ID(0);
        }
        if (this.getTo_Country_ID() > 0 && this.getC_CountryGroupTo_ID() > 0) {
            this.setTo_Country_ID(0);
        }
        return super.beforeSave(newRecord);
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord && success) {
            this.insert_Accounting("C_Tax_Acct", "C_AcctSchema_Default", null);
        }
        return success;
    }
}

