/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Table_ScriptValidator;
import org.compiere.util.CCache;
import org.compiere.util.DB;

public class MTableScriptValidator
extends X_AD_Table_ScriptValidator {
    private static final long serialVersionUID = 6272423660330749776L;
    private static CCache<Integer, MTableScriptValidator> s_cache = new CCache("AD_Table_ScriptValidator", 20);
    private static CCache<MultiKey, List<MTableScriptValidator>> s_cacheTableEvent = new CCache(null, "AD_Table_ScriptValidator_TableEvent", 20, false);

    public static MTableScriptValidator get(Properties ctx, int AD_Table_ScriptValidator_ID) {
        Integer key = AD_Table_ScriptValidator_ID;
        MTableScriptValidator retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MTableScriptValidator(ctx, AD_Table_ScriptValidator_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static List<MTableScriptValidator> getModelValidatorRules(Properties ctx, int ad_table_id, String event) {
        MultiKey key = new MultiKey((Object)ad_table_id, (Object)event);
        List<MTableScriptValidator> mvrs = s_cacheTableEvent.get(key);
        if (mvrs != null) {
            if (mvrs.size() > 0) {
                return mvrs;
            }
            return null;
        }
        String whereClause = "AD_Table_ID=? AND EventModelValidator=?";
        mvrs = new Query(ctx, "AD_Table_ScriptValidator", "AD_Table_ID=? AND EventModelValidator=?", null).setParameters(ad_table_id, event).setOnlyActiveRecords(true).setOrderBy("SeqNo").list();
        for (MTableScriptValidator rule : mvrs) {
            s_cache.put(rule.get_ID(), rule);
        }
        if (mvrs != null) {
            s_cacheTableEvent.put(key, mvrs);
        }
        if (mvrs != null && mvrs.size() > 0) {
            return mvrs;
        }
        return null;
    }

    public MTableScriptValidator(Properties ctx, int AD_Table_ScriptValidator_ID, String trxName) {
        super(ctx, AD_Table_ScriptValidator_ID, trxName);
    }

    public MTableScriptValidator(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getSeqNo() == 0) {
            String sql = "SELECT COALESCE(MAX(SeqNo),0) + 10 FROM AD_Table_ScriptValidator WHERE AD_Table_ID=? AND EventModelValidator=?";
            int seqNo = DB.getSQLValueEx(this.get_TrxName(), "SELECT COALESCE(MAX(SeqNo),0) + 10 FROM AD_Table_ScriptValidator WHERE AD_Table_ID=? AND EventModelValidator=?", this.getAD_Table_ID(), this.getEventModelValidator());
            this.setSeqNo(seqNo);
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MTableScriptValidator[");
        sb.append(this.get_ID()).append("-").append(this.getAD_Table_ID()).append("-").append(this.getEventModelValidator()).append("]");
        return sb.toString();
    }
}

