/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.X_AD_Table_Access;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MTableAccess
extends X_AD_Table_Access {
    private static final long serialVersionUID = -3747261579266442904L;
    private String m_tableName;

    public MTableAccess(Properties ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
    }

    public MTableAccess(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MTableAccess[");
        sb.append("AD_Role_ID=").append(this.getAD_Role_ID()).append(",AD_Table_ID=").append(this.getAD_Table_ID()).append(",Exclude=").append(this.isExclude()).append(",Type=").append(this.getAccessTypeRule());
        if ("A".equals(this.getAccessTypeRule())) {
            sb.append("-ReadOnly=").append(this.isReadOnly());
        } else if ("E".equals(this.getAccessTypeRule())) {
            sb.append("-CanExport=").append(!this.isExclude());
        } else if ("R".equals(this.getAccessTypeRule())) {
            sb.append("-CanReport=").append(!this.isExclude());
        }
        sb.append("]");
        return sb.toString();
    }

    public String toStringX(Properties ctx) {
        String in = Msg.getMsg(ctx, "Include");
        String ex = Msg.getMsg(ctx, "Exclude");
        StringBuilder sb = new StringBuilder();
        sb.append(Msg.translate(ctx, "AD_Table_ID")).append("=").append(this.getTableName(ctx));
        if ("A".equals(this.getAccessTypeRule())) {
            sb.append(" - ").append(Msg.translate(ctx, "IsReadOnly")).append("=").append(this.isReadOnly());
        } else if ("E".equals(this.getAccessTypeRule())) {
            sb.append(" - ").append(Msg.translate(ctx, "CanExport")).append("=").append(!this.isExclude());
        } else if ("R".equals(this.getAccessTypeRule())) {
            sb.append(" - ").append(Msg.translate(ctx, "CanReport")).append("=").append(!this.isExclude());
        }
        sb.append(" - ").append(this.isExclude() ? ex : in);
        return sb.toString();
    }

    public String getTableName(Properties ctx) {
        if (this.m_tableName == null) {
            block8: {
                String sql = "SELECT TableName FROM AD_Table WHERE AD_Table_ID=?";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, this.get_TrxName());
                        pstmt.setInt(1, this.getAD_Table_ID());
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            this.m_tableName = rs.getString(1);
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "getTableName", e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            String realName = Msg.translate(ctx, String.valueOf(this.m_tableName) + "_ID");
            if (!realName.equals(String.valueOf(this.m_tableName) + "_ID")) {
                this.m_tableName = realName;
            }
        }
        return this.m_tableName;
    }
}

