/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.IModelFactory;
import org.adempiere.base.Service;
import org.adempiere.model.GenericPO;
import org.compiere.model.MColumn;
import org.compiere.model.MSequence;
import org.compiere.model.MViewComponent;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Table;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;

public class MTable
extends X_AD_Table {
    private static final long serialVersionUID = 7527235342324308477L;
    public static final int MAX_OFFICIAL_ID = 999999;
    private static CCache<Integer, MTable> s_cache = new CCache("AD_Table", 20);
    private static CLogger s_log = CLogger.getCLogger(MTable.class);
    private MColumn[] m_columns = null;
    private Map<String, Integer> m_columnNameMap;
    private Map<Integer, Integer> m_columnIdMap;
    private MViewComponent[] m_viewComponents = null;

    public static MTable get(Properties ctx, int AD_Table_ID) {
        return MTable.get(ctx, AD_Table_ID, null);
    }

    public static MTable get(Properties ctx, int AD_Table_ID, String trxName) {
        Integer key = AD_Table_ID;
        MTable retValue = s_cache.get(key);
        if (retValue != null && retValue.getCtx() == ctx) {
            if (trxName != null) {
                retValue.set_TrxName(trxName);
            }
            return retValue;
        }
        retValue = new MTable(ctx, AD_Table_ID, trxName);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static synchronized MTable get(Properties ctx, String tableName) {
        MTable retValue2;
        block9: {
            if (tableName == null) {
                return null;
            }
            for (MTable retValue2 : s_cache.values()) {
                if (!tableName.equalsIgnoreCase(retValue2.getTableName()) || retValue2.getCtx() != ctx) continue;
                return retValue2;
            }
            retValue2 = null;
            String sql = "SELECT * FROM AD_Table WHERE UPPER(TableName)=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setString(1, tableName.toUpperCase());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue2 = new MTable(ctx, rs, null);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue2 != null) {
            Integer key = retValue2.getAD_Table_ID();
            s_cache.put(key, retValue2);
        }
        return retValue2;
    }

    public static String getTableName(Properties ctx, int AD_Table_ID) {
        return MTable.get(ctx, AD_Table_ID).getTableName();
    }

    public static Class<?> getClass(String tableName) {
        List<IModelFactory> factoryList = Service.locator().list(IModelFactory.class).getServices();
        if (factoryList == null) {
            return null;
        }
        for (IModelFactory factory : factoryList) {
            Class<?> clazz = factory.getClass(tableName);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    public MTable(Properties ctx, int AD_Table_ID, String trxName) {
        super(ctx, AD_Table_ID, trxName);
        if (AD_Table_ID == 0) {
            this.setAccessLevel("4");
            this.setEntityType("U");
            this.setIsChangeLog(false);
            this.setIsDeleteable(false);
            this.setIsHighVolume(false);
            this.setIsSecurityEnabled(false);
            this.setIsView(false);
            this.setReplicationType("L");
        }
    }

    public MTable(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public synchronized MColumn[] getColumns(boolean requery) {
        ArrayList<MColumn> list;
        block7: {
            if (this.m_columns != null && !requery) {
                return this.m_columns;
            }
            this.m_columnNameMap = new HashMap<String, Integer>();
            this.m_columnIdMap = new HashMap<Integer, Integer>();
            String sql = "SELECT * FROM AD_Column WHERE AD_Table_ID=? AND IsActive='Y' ORDER BY ColumnName";
            list = new ArrayList<MColumn>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getAD_Table_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MColumn column = new MColumn(this.getCtx(), rs, this.get_TrxName());
                        list.add(column);
                        this.m_columnNameMap.put(column.getColumnName().toUpperCase(), list.size() - 1);
                        this.m_columnIdMap.put(column.getAD_Column_ID(), list.size() - 1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_columns = new MColumn[list.size()];
        list.toArray(this.m_columns);
        return this.m_columns;
    }

    public MColumn getColumn(String columnName) {
        if (columnName == null || columnName.length() == 0) {
            return null;
        }
        this.getColumns(false);
        int i2 = 0;
        while (i2 < this.m_columns.length) {
            if (columnName.equalsIgnoreCase(this.m_columns[i2].getColumnName())) {
                return this.m_columns[i2];
            }
            ++i2;
        }
        return null;
    }

    public synchronized int getColumnIndex(String ColumnName) {
        Integer i2;
        if (this.m_columns == null) {
            this.getColumns(false);
        }
        if ((i2 = this.m_columnNameMap.get(ColumnName.toUpperCase())) != null) {
            return i2;
        }
        return -1;
    }

    public synchronized int getColumnIndex(int AD_Column_ID) {
        Integer i2;
        if (this.m_columns == null) {
            this.getColumns(false);
        }
        if ((i2 = this.m_columnIdMap.get(AD_Column_ID)) != null) {
            return i2;
        }
        return -1;
    }

    public boolean isSingleKey() {
        String[] keys = this.getKeyColumns();
        return keys.length == 1;
    }

    public String[] getKeyColumns() {
        this.getColumns(false);
        ArrayList<String> list = new ArrayList<String>();
        int i2 = 0;
        while (i2 < this.m_columns.length) {
            MColumn column = this.m_columns[i2];
            if (column.isKey()) {
                return new String[]{column.getColumnName()};
            }
            if (column.isParent()) {
                list.add(column.getColumnName());
            }
            ++i2;
        }
        String[] retValue = new String[list.size()];
        retValue = list.toArray(retValue);
        return retValue;
    }

    public String[] getIdentifierColumns() {
        ArrayList<KeyNamePair> listkn = new ArrayList<KeyNamePair>();
        MColumn[] mColumnArray = this.getColumns(false);
        int n = mColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            MColumn column = mColumnArray[n2];
            if (column.isIdentifier()) {
                listkn.add(new KeyNamePair(column.getSeqNo(), column.getColumnName()));
            }
            ++n2;
        }
        Collections.sort(listkn, new Comparator<KeyNamePair>(){

            @Override
            public int compare(KeyNamePair s1, KeyNamePair s2) {
                if (s1.getKey() < s2.getKey()) {
                    return -1;
                }
                if (s1.getKey() > s2.getKey()) {
                    return 1;
                }
                return 0;
            }
        });
        String[] retValue = new String[listkn.size()];
        int i2 = 0;
        while (i2 < listkn.size()) {
            retValue[i2] = ((KeyNamePair)listkn.get(i2)).getName();
            ++i2;
        }
        return retValue;
    }

    public PO getPO(int Record_ID, String trxName) {
        String tableName = this.getTableName();
        if (Record_ID != 0 && !this.isSingleKey()) {
            this.log.log(Level.WARNING, "(id) - Multi-Key " + tableName);
            return null;
        }
        PO po = null;
        List<IModelFactory> factoryList = Service.locator().list(IModelFactory.class).getServices();
        if (factoryList != null) {
            for (IModelFactory factory : factoryList) {
                po = factory.getPO(tableName, Record_ID, trxName);
                if (po == null) continue;
                if (po.get_ID() == Record_ID || Record_ID <= 0) break;
                po = null;
            }
        }
        if (po == null && (po = new GenericPO(tableName, this.getCtx(), Record_ID, trxName)).get_ID() != Record_ID && Record_ID > 0) {
            po = null;
        }
        return po;
    }

    public PO getPO(ResultSet rs, String trxName) {
        String tableName = this.getTableName();
        PO po = null;
        List<IModelFactory> factoryList = Service.locator().list(IModelFactory.class).getServices();
        if (factoryList != null) {
            for (IModelFactory factory : factoryList) {
                po = factory.getPO(tableName, rs, trxName);
                if (po != null) break;
            }
        }
        if (po == null) {
            po = new GenericPO(tableName, this.getCtx(), rs, trxName);
        }
        return po;
    }

    public PO getPO(String whereClause, String trxName) {
        return this.getPO(whereClause, null, trxName);
    }

    public PO getPO(String whereClause, Object[] params, String trxName) {
        PO po;
        block10: {
            if (whereClause == null || whereClause.length() == 0) {
                return null;
            }
            po = null;
            POInfo info = POInfo.getPOInfo(this.getCtx(), this.getAD_Table_ID(), trxName);
            if (info == null) {
                return null;
            }
            StringBuilder sqlBuffer = info.buildSelect();
            sqlBuffer.append(" WHERE ").append(whereClause);
            String sql = sqlBuffer.toString();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    if (params != null && params.length > 0) {
                        int i2 = 0;
                        while (i2 < params.length) {
                            pstmt.setObject(i2 + 1, params[i2]);
                            ++i2;
                        }
                    }
                    if ((rs = pstmt.executeQuery()).next()) {
                        po = this.getPO(rs, trxName);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    this.log.saveError("Error", e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return po;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.isView() && this.isDeleteable()) {
            this.setIsDeleteable(false);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        MSequence seq = MSequence.get(this.getCtx(), this.getTableName(), this.get_TrxName());
        if (seq == null || seq.get_ID() == 0) {
            MSequence.createTableSequence(this.getCtx(), this.getTableName(), this.get_TrxName());
        } else if (!seq.getName().equals(this.getTableName())) {
            seq.setName(this.getTableName());
            seq.saveEx();
        }
        return success;
    }

    public String getSQLCreate() {
        StringBuffer sb = new StringBuffer("CREATE TABLE ").append(this.getTableName()).append(" (");
        StringBuffer constraints = new StringBuffer();
        this.getColumns(true);
        boolean columnAdded = false;
        int i2 = 0;
        while (i2 < this.m_columns.length) {
            MColumn column = this.m_columns[i2];
            String colSQL = column.getSQLDDL();
            if (colSQL != null) {
                if (columnAdded) {
                    sb.append(", ");
                } else {
                    columnAdded = true;
                }
                sb.append(column.getSQLDDL());
                String constraint = column.getConstraint(this.getTableName());
                if (constraint != null && constraint.length() > 0) {
                    constraints.append(", ").append(constraint);
                }
            }
            ++i2;
        }
        sb.append(constraints).append(")");
        return sb.toString();
    }

    public static int getTable_ID(String tableName) {
        int retValue;
        block6: {
            retValue = 0;
            String SQL = "SELECT AD_Table_ID FROM AD_Table WHERE tablename = ?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(SQL, null);
                    pstmt.setString(1, tableName);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = rs.getInt(1);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, SQL, e);
                    retValue = -1;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    public Query createQuery(String whereClause, String trxName) {
        return new Query(this.getCtx(), this, whereClause, trxName);
    }

    public MViewComponent[] getViewComponent(boolean reload) {
        if (!this.isView() || !this.isActive()) {
            return null;
        }
        if (this.m_viewComponents != null && !reload) {
            return this.m_viewComponents;
        }
        Query query = new Query(this.getCtx(), "AD_ViewComponent", "AD_Table_ID=?", this.get_TrxName());
        query.setParameters(this.getAD_Table_ID());
        query.setOrderBy("SeqNo");
        query.setOnlyActiveRecords(true);
        List<MViewComponent> list = query.list();
        this.m_viewComponents = new MViewComponent[list.size()];
        list.toArray(this.m_viewComponents);
        return this.m_viewComponents;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MTable[");
        sb.append(this.get_ID()).append("-").append(this.getTableName()).append("]");
        return sb.toString();
    }

    public static boolean isZeroIDTable(String tablename) {
        return tablename.equals("AD_Org") || tablename.equals("AD_OrgInfo") || tablename.equals("AD_Client") || tablename.equals("AD_AllClients_V") || tablename.equals("AD_ReportView") || tablename.equals("AD_Role") || tablename.equals("AD_System") || tablename.equals("AD_User") || tablename.equals("AD_AllUsers_V") || tablename.equals("C_DocType") || tablename.equals("GL_Category") || tablename.equals("M_AttributeSet") || tablename.equals("M_AttributeSetInstance");
    }
}

