/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ChoiceFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.X_AD_StatusLine;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MStatusLine
extends X_AD_StatusLine {
    private static final long serialVersionUID = 2473407023692665378L;
    private static CLogger s_log = CLogger.getCLogger(MStatusLine.class);
    private static CCache<String, MStatusLine> s_cache = new CCache("AD_StatusLine", 10);
    private static CCache<String, MStatusLine[]> s_cachew = new CCache("AD_StatusLine", 10);

    public MStatusLine(Properties ctx, int AD_StatusLine_ID, String trxName) {
        super(ctx, AD_StatusLine_ID, trxName);
    }

    public MStatusLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MStatusLine getSL(int window_ID, int tab_ID, int table_ID) {
        StringBuilder key = new StringBuilder().append(window_ID).append("|").append(tab_ID).append("|").append(table_ID);
        MStatusLine retValue = null;
        if (s_cache.containsKey(key.toString())) {
            retValue = s_cache.get(key.toString());
            if (s_log.isLoggable(Level.FINEST)) {
                s_log.finest("Cache: " + retValue);
            }
            return retValue;
        }
        String sql = "SELECT slu.AD_StatusLine_ID FROM   AD_StatusLineUsedIn slu JOIN AD_StatusLine sl ON (sl.AD_StatusLine_ID = slu.AD_StatusLine_ID) WHERE  slu.IsActive = 'Y'        AND sl.IsActive = 'Y'        AND slu.IsStatusLine = 'Y'        AND slu.AD_Window_ID = ?        AND slu.AD_Tab_ID = ?";
        int slid = DB.getSQLValueEx(null, sql, window_ID, tab_ID);
        if (slid <= 0) {
            sql = "SELECT slu.AD_StatusLine_ID FROM   AD_StatusLineUsedIn slu JOIN AD_StatusLine sl ON (sl.AD_StatusLine_ID = slu.AD_StatusLine_ID) WHERE  slu.IsActive = 'Y'        AND sl.IsActive = 'Y'        AND slu.IsStatusLine = 'Y'        AND slu.AD_Window_ID = ?        AND slu.AD_Tab_ID IS NULL";
            slid = DB.getSQLValueEx(null, sql, window_ID);
        }
        if (slid <= 0) {
            sql = "SELECT slu.AD_StatusLine_ID FROM   AD_StatusLineUsedIn slu JOIN AD_StatusLine sl ON (sl.AD_StatusLine_ID = slu.AD_StatusLine_ID) WHERE  slu.IsActive = 'Y'        AND sl.IsActive = 'Y'        AND slu.IsStatusLine = 'Y'        AND slu.AD_Table_ID = ?";
            slid = DB.getSQLValueEx(null, sql, table_ID);
        }
        if (slid > 0) {
            retValue = new MStatusLine(Env.getCtx(), slid, null);
        }
        s_cache.put(key.toString(), retValue);
        return retValue;
    }

    public static MStatusLine[] getStatusLinesWidget(int window_ID, int tab_ID, int table_ID) {
        StringBuilder key = new StringBuilder().append(window_ID).append("|").append(tab_ID).append("|").append(table_ID);
        MStatusLine[] retValue = null;
        if (s_cachew.containsKey(key.toString())) {
            retValue = s_cachew.get(key.toString());
            if (s_log.isLoggable(Level.FINEST)) {
                s_log.finest("Cache: " + retValue);
            }
            return retValue;
        }
        String sql = "SELECT DISTINCT slu.AD_StatusLine_ID, slu.SeqNo FROM   AD_StatusLineUsedIn slu JOIN AD_StatusLine sl ON (sl.AD_StatusLine_ID = slu.AD_StatusLine_ID) WHERE  slu.IsActive = 'Y'        AND sl.IsActive = 'Y'        AND slu.IsStatusLine = 'N'        AND (slu.AD_Table_ID = ? OR (slu.AD_Window_ID=? AND slu.AD_Tab_ID=?) OR (slu.AD_Window_ID=? AND slu.AD_Tab_ID IS NULL)) ORDER BY slu.SeqNo";
        int[] wlids = DB.getIDsEx(null, "SELECT DISTINCT slu.AD_StatusLine_ID, slu.SeqNo FROM   AD_StatusLineUsedIn slu JOIN AD_StatusLine sl ON (sl.AD_StatusLine_ID = slu.AD_StatusLine_ID) WHERE  slu.IsActive = 'Y'        AND sl.IsActive = 'Y'        AND slu.IsStatusLine = 'N'        AND (slu.AD_Table_ID = ? OR (slu.AD_Window_ID=? AND slu.AD_Tab_ID=?) OR (slu.AD_Window_ID=? AND slu.AD_Tab_ID IS NULL)) ORDER BY slu.SeqNo", table_ID, window_ID, tab_ID, window_ID);
        if (wlids.length > 0) {
            ArrayList<MStatusLine> list = new ArrayList<MStatusLine>();
            int[] nArray = wlids;
            int n = wlids.length;
            int n2 = 0;
            while (n2 < n) {
                int wlid = nArray[n2];
                MStatusLine wl = new MStatusLine(Env.getCtx(), wlid, null);
                list.add(wl);
                ++n2;
            }
            retValue = new MStatusLine[list.size()];
            int i2 = 0;
            while (i2 < retValue.length) {
                retValue[i2] = (MStatusLine)list.get(i2);
                ++i2;
            }
        }
        s_cachew.put(key.toString(), retValue);
        return retValue;
    }

    public String parseLine(int windowNo) {
        boolean filled;
        Object[] arguments;
        MessageFormat mf;
        block12: {
            String sql = this.getSQLStatement();
            if (sql.indexOf("@") >= 0 && (sql = Env.parseContext(Env.getCtx(), windowNo, sql, false, false)).length() == 0) {
                return null;
            }
            mf = null;
            String msgValue = this.getAD_Message().getValue();
            try {
                mf = new MessageFormat(Msg.getMsg(Env.getAD_Language(this.getCtx()), msgValue), Env.getLanguage(this.getCtx()).getLocale());
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, String.valueOf(msgValue) + "=" + Msg.getMsg(Env.getAD_Language(this.getCtx()), msgValue), e);
            }
            if (mf == null) {
                return null;
            }
            Format[] fmts = mf.getFormatsByArgumentIndex();
            arguments = new Object[fmts.length];
            filled = false;
            CPreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    stmt = DB.prepareStatement(sql, null);
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        int idx = 0;
                        while (idx < fmts.length) {
                            Format fmt = fmts[idx];
                            Object obj = fmt instanceof DecimalFormat || fmt instanceof ChoiceFormat ? Double.valueOf(rs.getDouble(idx + 1)) : (fmt instanceof SimpleDateFormat ? rs.getTimestamp(idx + 1) : rs.getString(idx + 1));
                            arguments[idx] = obj;
                            ++idx;
                        }
                        filled = true;
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.WARNING, sql, e);
                    DB.close(rs, stmt);
                    rs = null;
                    stmt = null;
                    break block12;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, stmt);
                rs = null;
                stmt = null;
                throw throwable;
            }
            DB.close(rs, stmt);
            rs = null;
            stmt = null;
        }
        if (filled) {
            return mf.format(arguments);
        }
        return null;
    }
}

