/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.X_R_Status;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MStatus
extends X_R_Status {
    private static final long serialVersionUID = -4549127671165860354L;
    private static CLogger s_log = CLogger.getCLogger(MStatus.class);
    private static CCache<Integer, MStatus> s_cache = new CCache("R_Status", 10);
    private static CCache<Integer, MStatus> s_cacheDefault = new CCache("R_Status", "R_Status_Default", 10);

    public static MStatus get(Properties ctx, int R_Status_ID) {
        if (R_Status_ID == 0) {
            return null;
        }
        Integer key = R_Status_ID;
        MStatus retValue = s_cache.get(key);
        if (retValue == null) {
            retValue = new MStatus(ctx, R_Status_ID, null);
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static MStatus getDefault(Properties ctx, int R_RequestType_ID) {
        MStatus retValue;
        Integer key;
        block8: {
            key = R_RequestType_ID;
            retValue = s_cacheDefault.get(key);
            if (retValue != null) {
                return retValue;
            }
            String sql = "SELECT * FROM R_Status s WHERE EXISTS (SELECT * FROM R_RequestType rt WHERE rt.R_StatusCategory_ID=s.R_StatusCategory_ID AND rt.R_RequestType_ID=?) AND IsDefault='Y' ORDER BY SeqNo";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, R_RequestType_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = new MStatus(ctx, rs, null);
                    }
                }
                catch (SQLException ex) {
                    s_log.log(Level.SEVERE, sql, ex);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue != null) {
            s_cacheDefault.put(key, retValue);
        }
        return retValue;
    }

    public static MStatus[] getClosed(Properties ctx) {
        ArrayList<MStatus> list;
        block6: {
            int AD_Client_ID = Env.getAD_Client_ID(ctx);
            String sql = "SELECT * FROM R_Status WHERE AD_Client_ID=? AND IsActive='Y' AND IsClosed='Y' ORDER BY Value";
            list = new ArrayList<MStatus>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, AD_Client_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MStatus(ctx, rs, null));
                    }
                }
                catch (SQLException ex) {
                    s_log.log(Level.SEVERE, sql, ex);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MStatus[] retValue = new MStatus[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MStatus(Properties ctx, int R_Status_ID, String trxName) {
        super(ctx, R_Status_ID, trxName);
        if (R_Status_ID == 0) {
            this.setIsClosed(false);
            this.setIsDefault(false);
            this.setIsFinalClose(false);
            this.setIsOpen(false);
            this.setIsWebCanUpdate(true);
        }
    }

    public MStatus(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.isOpen() && this.isClosed()) {
            this.setIsClosed(false);
        }
        if (this.isFinalClose() && !this.isClosed()) {
            this.setIsFinalClose(false);
        }
        if (!this.isWebCanUpdate() && this.getUpdate_Status_ID() != 0) {
            this.setUpdate_Status_ID(0);
        }
        if (this.getTimeoutDays() == 0 && this.getNext_Status_ID() != 0) {
            this.setNext_Status_ID(0);
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MStatus[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }
}

