/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.IShipmentProcessor;
import org.adempiere.model.MShipperFacade;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCurrency;
import org.compiere.model.MLocation;
import org.compiere.model.MOnlineTrxHistory;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MShipper;
import org.compiere.model.MShipperLabels;
import org.compiere.model.MShippingTransactionLine;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.model.X_C_Country;
import org.compiere.model.X_M_CommodityShipment;
import org.compiere.model.X_M_ShippingTransaction;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MShippingTransaction
extends X_M_ShippingTransaction {
    private static final long serialVersionUID = -2444841696998774096L;
    private String m_errorMessage = null;
    private PartyInfo senderInfo;
    private PartyInfo recipientInfo;

    public MShippingTransaction(Properties ctx, int M_ShippingTransaction_ID, String trxName) {
        super(ctx, M_ShippingTransaction_ID, trxName);
    }

    public MShippingTransaction(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MShippingTransactionLine[] getLines(String whereClause) {
        StringBuilder whereClauseFinal = new StringBuilder("M_ShippingTransaction_ID=? ");
        if (!Util.isEmpty(whereClause, true)) {
            whereClauseFinal.append(whereClause);
        }
        List<MShippingTransactionLine> list = new Query(this.getCtx(), "M_ShippingTransactionLine", whereClauseFinal.toString(), this.get_TrxName()).setParameters(this.get_ID()).setOrderBy("SeqNo").list();
        return list.toArray(new MShippingTransactionLine[list.size()]);
    }

    public void setErrorMessage(String errorMessage) {
        this.m_errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    public boolean processOnline() {
        this.setErrorMessage(null);
        boolean processed = false;
        try {
            MShipperFacade sf = new MShipperFacade(this.getMShipper());
            IShipmentProcessor processor = Core.getShipmentProcessor(sf);
            if (processor == null) {
                this.setErrorMessage(Msg.getMsg(Env.getCtx(), "ShippingNoProcessor"));
            } else {
                if (this.getAction().equals("PS")) {
                    processed = processor.processShipment(this.getCtx(), this, this.get_TrxName());
                } else if (this.getAction().equals("RI")) {
                    processed = processor.rateInquiry(this.getCtx(), this, this.isPriviledgedRate(), this.get_TrxName());
                } else if (this.getAction().equals("VS")) {
                    processed = processor.voidShipment(this.getCtx(), this, this.get_TrxName());
                } else {
                    throw new AdempiereException(Msg.getMsg(Env.getCtx(), "ActionNotSupported"));
                }
                if (!processed) {
                    this.setErrorMessage("From " + this.getMShipper().getName() + ": " + this.getShippingRespMessage());
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "processOnline", e);
            this.setErrorMessage(String.valueOf(Msg.getMsg(Env.getCtx(), "ShippingNotProcessed")) + ":\n" + e.getMessage());
        }
        MOnlineTrxHistory history = new MOnlineTrxHistory(this.getCtx(), 0, this.get_TrxName());
        history.setAD_Table_ID(200051);
        history.setRecord_ID(this.getM_ShippingTransaction_ID());
        history.setIsError(!processed);
        history.setProcessed(processed);
        StringBuilder msg = new StringBuilder();
        if (processed) {
            msg.append(this.getShippingRespMessage());
        } else {
            msg.append("ERROR: " + this.getErrorMessage());
        }
        msg.append("\nAction: " + this.getAction());
        history.setTextMsg(msg.toString());
        history.saveEx();
        this.setProcessed(processed);
        return processed;
    }

    public MShipper getMShipper() {
        return new MShipper(this.getCtx(), this.getM_Shipper_ID(), this.get_TrxName());
    }

    public boolean isInternational() {
        MShipperFacade facade = new MShipperFacade(this.getMShipper());
        return facade.isInternational();
    }

    public String getCurrencyCode() {
        MCurrency currency = MCurrency.get(this.getCtx(), this.getC_Currency_ID());
        return currency.getISO_Code();
    }

    public boolean isPayBySender() {
        if ("D_PP".equals(this.getFreightCharges()) || "E_PPB".equals(this.getFreightCharges())) {
            return true;
        }
        return !"B_3P".equals(this.getFreightCharges()) && this.isCashOnDelivery();
    }

    public int getProductFreightID() {
        return DB.getSQLValue(null, "SELECT M_ProductFreight_ID FROM AD_Clientinfo WHERE AD_Client_ID = ?", this.getAD_Client_ID());
    }

    public boolean isPrintLabelAsImage() {
        MShipperLabels label2 = new MShipperLabels(this.getCtx(), this.getM_ShipperLabels_ID(), this.get_TrxName());
        return "I".equals(label2.getLabelPrintMethod());
    }

    public boolean isPrintZebraLabel() {
        MShipperLabels label2 = new MShipperLabels(this.getCtx(), this.getM_ShipperLabels_ID(), this.get_TrxName());
        return "Z".equals(label2.getLabelPrintMethod());
    }

    public boolean isPrintEltronLabel() {
        MShipperLabels label2 = new MShipperLabels(this.getCtx(), this.getM_ShipperLabels_ID(), this.get_TrxName());
        return "E".equals(label2.getLabelPrintMethod());
    }

    public String getPayorAccount() {
        if (this.isPayBySender()) {
            MShipperFacade sf = new MShipperFacade(this.getMShipper());
            return sf.getShipperAccount(this.getAD_Org_ID());
        }
        String ac = this.getShipperAccount();
        if (ac != null) {
            ac = ac.replaceAll("[-]", "");
            ac = ac.replaceAll(" ", "");
        }
        return ac;
    }

    public String getDutiesPayorAccount() {
        if (this.isPayBySender()) {
            MShipperFacade sf = new MShipperFacade(this.getMShipper());
            String dutiesShipperAccount = sf.getDutiesShipperAccount(this.getAD_Org_ID());
            if (dutiesShipperAccount == null) {
                dutiesShipperAccount = sf.getShipperAccount(this.getAD_Org_ID());
            }
            return dutiesShipperAccount;
        }
        String ac = this.getDutiesShipperAccount();
        if (ac == null) {
            ac = this.getShipperAccount();
        }
        if (ac != null) {
            ac = ac.replaceAll("[-]", "");
            ac = ac.replaceAll(" ", "");
        }
        return ac;
    }

    public String getPayorCountryCode() {
        if (!this.isPayBySender()) {
            MBPartnerLocation partnerLocation = new MBPartnerLocation(this.getCtx(), this.getC_BPartner_Location_ID(), this.get_TrxName());
            MLocation location = new MLocation(this.getCtx(), partnerLocation.getC_Location_ID(), this.get_TrxName());
            X_C_Country country = new X_C_Country(this.getCtx(), location.getC_Country_ID(), this.get_TrxName());
            return country.getCountryCode();
        }
        MOrg org = new MOrg(this.getCtx(), this.getAD_Org_ID(), this.get_TrxName());
        MOrgInfo info = new MOrgInfo(org);
        MLocation location = new MLocation(this.getCtx(), info.getC_Location_ID(), this.get_TrxName());
        X_C_Country country = new X_C_Country(this.getCtx(), location.getC_Country_ID(), this.get_TrxName());
        return country.getCountryCode();
    }

    public boolean isCollect() {
        return "A_Col".equals(this.getFreightCharges());
    }

    public boolean is3rdParty() {
        return "B_3P".equals(this.getFreightCharges());
    }

    public X_M_CommodityShipment getCommodityShipment(int M_Product_ID) {
        X_M_CommodityShipment commodityShipment;
        block7: {
            commodityShipment = null;
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT * FROM M_CommodityShipment ");
            sql.append("WHERE M_Product_ID IN (0, ?) OR M_Product_ID IS NULL ");
            sql.append("AND AD_Client_ID IN (0, ?) ");
            sql.append("AND AD_Org_ID IN (0, ?) ");
            sql.append("ORDER BY M_Product_ID, AD_Org_ID, AD_Client_ID");
            CPreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    stmt = DB.prepareStatement(sql.toString(), null);
                    stmt.setInt(1, M_Product_ID);
                    stmt.setInt(2, this.getAD_Client_ID());
                    stmt.setInt(3, this.getAD_Org_ID());
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        commodityShipment = new X_M_CommodityShipment(this.getCtx(), rs, null);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    DB.close(rs, stmt);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, stmt);
                throw throwable;
            }
            DB.close(rs, stmt);
        }
        if (commodityShipment == null) {
            commodityShipment = new X_M_CommodityShipment(this.getCtx(), 0, null);
        }
        return commodityShipment;
    }

    public int getCommodityShipmentID(int M_Product_ID) {
        X_M_CommodityShipment commodityShipment = this.getCommodityShipment(M_Product_ID);
        return commodityShipment.getM_CommodityShipment_ID();
    }

    public String getCommodityDescription(int M_Product_ID) {
        X_M_CommodityShipment commodityShipment = this.getCommodityShipment(M_Product_ID);
        return commodityShipment.getDescription();
    }

    public String getHarmonizedCode(int M_Product_ID) {
        X_M_CommodityShipment commodityShipment = this.getCommodityShipment(M_Product_ID);
        return commodityShipment.getHarmonizedCode();
    }

    public String getExportLicenseNum(int M_Product_ID) {
        X_M_CommodityShipment commodityShipment = this.getCommodityShipment(M_Product_ID);
        return commodityShipment.getExportLicenseNum();
    }

    public String getCountryOfManufacture(int M_Product_ID) {
        X_M_CommodityShipment commodityShipment = this.getCommodityShipment(M_Product_ID);
        int countryId = commodityShipment.getCountryOfManufacture_ID();
        X_C_Country c = new X_C_Country(this.getCtx(), countryId, null);
        return c.getCountryCode();
    }

    public PartyInfo getSenderInfo() {
        if (this.senderInfo != null) {
            return this.senderInfo;
        }
        PartyInfo partyInfo = null;
        if (partyInfo == null) {
            MOrg sender = new MOrg(this.getCtx(), this.getAD_Org_ID(), this.get_TrxName());
            MUser senderContact = new MUser(this.getCtx(), this.getSalesRep_ID(), this.get_TrxName());
            MWarehouse warehouse = new MWarehouse(this.getCtx(), this.getM_Warehouse_ID(), this.get_TrxName());
            partyInfo = new PartyInfo();
            partyInfo.setCompanyName(sender.getName());
            partyInfo.setContactName(senderContact.getName());
            partyInfo.setPhoneNumber(sender.getInfo().getPhone());
            partyInfo.setEmail(senderContact.getEMail());
            partyInfo.setLocationId(warehouse.getC_Location_ID());
        }
        this.senderInfo = partyInfo;
        return partyInfo;
    }

    public PartyInfo getRecipientInfo() {
        if (this.recipientInfo != null) {
            return this.recipientInfo;
        }
        PartyInfo partyInfo = null;
        if (partyInfo == null) {
            MBPartner recipient = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
            MBPartnerLocation ra = new MBPartnerLocation(this.getCtx(), this.getC_BPartner_Location_ID(), this.get_TrxName());
            MUser contact = new MUser(this.getCtx(), this.getAD_User_ID(), this.get_TrxName());
            partyInfo = new PartyInfo();
            partyInfo.setCompanyName(recipient.getName());
            partyInfo.setContactName(contact.getName());
            partyInfo.setPhoneNumber(contact.getPhone());
            partyInfo.setEmail(contact.getEMail());
            partyInfo.setLocationId(ra.getC_Location_ID());
        }
        this.recipientInfo = partyInfo;
        return partyInfo;
    }

    public class PartyInfo {
        private String companyName;
        private String contactName;
        private String phoneNumber;
        private String email;
        private int locationId;

        public String getCompanyName() {
            return this.companyName;
        }

        public void setCompanyName(String companyName) {
            this.companyName = companyName;
        }

        public String getContactName() {
            return this.contactName;
        }

        public void setContactName(String contactName) {
            this.contactName = contactName;
        }

        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public int getLocationId() {
            return this.locationId;
        }

        public void setLocationId(int locationId) {
            this.locationId = locationId;
        }
    }
}

