/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.util.ProcessUtil;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctProcessor;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBPGroup;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCalendar;
import org.compiere.model.MCashBook;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MDiscountSchema;
import org.compiere.model.MDocType;
import org.compiere.model.MElement;
import org.compiere.model.MElementValue;
import org.compiere.model.MGLCategory;
import org.compiere.model.MLocation;
import org.compiere.model.MLocator;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProductPrice;
import org.compiere.model.MRequestProcessor;
import org.compiere.model.MRole;
import org.compiere.model.MRoleOrgAccess;
import org.compiere.model.MSequence;
import org.compiere.model.MTable;
import org.compiere.model.MTax;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.NaturalAccountMap;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public final class MSetup {
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private Trx m_trx = Trx.get(Trx.createTrxName("Setup"), true);
    private Properties m_ctx;
    private String m_lang;
    private int m_WindowNo;
    private StringBuffer m_info;
    private String m_clientName;
    private String m_stdColumns = "AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy";
    private String m_stdValues;
    private String m_stdValuesOrg;
    private NaturalAccountMap<String, MElementValue> m_nap = null;
    private MClient m_client;
    private MOrg m_org;
    private MAcctSchema m_as;
    private int AD_User_ID;
    private String AD_User_Name;
    private int AD_User_U_ID;
    private String AD_User_U_Name;
    private MCalendar m_calendar;
    private int m_AD_Tree_Account_ID;
    private int C_Cycle_ID;
    private boolean m_hasProject = false;
    private boolean m_hasMCampaign = false;
    private boolean m_hasSRegion = false;
    private boolean m_hasActivity = false;

    public MSetup(Properties ctx, int WindowNo) {
        this.m_ctx = new Properties(ctx);
        this.m_lang = Env.getAD_Language(this.m_ctx);
        this.m_WindowNo = WindowNo;
    }

    public boolean createClient(String clientName, String orgValue, String orgName, String userClient, String userOrg, String phone, String phone2, String fax, String eMail, String taxID, String adminEmail, String userEmail, boolean isSetInitialPassword) {
        MRoleOrgAccess adminOrgAccess;
        this.log.info(clientName);
        this.m_trx.setDisplayName(String.valueOf(this.getClass().getName()) + "_createClient");
        this.m_trx.start();
        this.m_info = new StringBuffer();
        String name = null;
        String sql = null;
        int no = 0;
        name = clientName;
        if (name == null || name.length() == 0) {
            name = "newClient";
        }
        this.m_clientName = name;
        this.m_client = new MClient(this.m_ctx, 0, true, this.m_trx.getTrxName());
        this.m_client.setValue(this.m_clientName);
        this.m_client.setName(this.m_clientName);
        if (!this.m_client.save()) {
            String err = "Client NOT created";
            this.log.log(Level.SEVERE, err);
            this.m_info.append(err);
            this.m_trx.rollback();
            this.m_trx.close();
            return false;
        }
        int AD_Client_ID = this.m_client.getAD_Client_ID();
        Env.setContext(this.m_ctx, this.m_WindowNo, "AD_Client_ID", AD_Client_ID);
        Env.setContext(this.m_ctx, "#AD_Client_ID", AD_Client_ID);
        this.m_stdValues = String.valueOf(String.valueOf(AD_Client_ID)) + ",0,'Y',SysDate,0,SysDate,0";
        this.m_info.append(Msg.translate(this.m_lang, "AD_Client_ID")).append("=").append(name).append("\n");
        if (!MSequence.checkClientSequences(this.m_ctx, AD_Client_ID, this.m_trx.getTrxName())) {
            String err = "Sequences NOT created";
            this.log.log(Level.SEVERE, err);
            this.m_info.append(err);
            this.m_trx.rollback();
            this.m_trx.close();
            return false;
        }
        if (!this.m_client.setupClientInfo(this.m_lang)) {
            String err = "Client Info NOT created";
            this.log.log(Level.SEVERE, err);
            this.m_info.append(err);
            this.m_trx.rollback();
            this.m_trx.close();
            return false;
        }
        this.m_AD_Tree_Account_ID = this.m_client.getSetup_AD_Tree_Account_ID();
        name = orgName;
        if (name == null || name.length() == 0) {
            name = "newOrg";
        }
        if (orgValue == null || orgValue.length() == 0) {
            orgValue = name;
        }
        this.m_org = new MOrg(this.m_client, orgValue, name);
        if (!this.m_org.save()) {
            String err = "Organization NOT created";
            this.log.log(Level.SEVERE, err);
            this.m_info.append(err);
            this.m_trx.rollback();
            this.m_trx.close();
            return false;
        }
        Env.setContext(this.m_ctx, this.m_WindowNo, "AD_Org_ID", this.getAD_Org_ID());
        Env.setContext(this.m_ctx, "#AD_Org_ID", this.getAD_Org_ID());
        this.m_stdValuesOrg = String.valueOf(AD_Client_ID) + "," + this.getAD_Org_ID() + ",'Y',SysDate,0,SysDate,0";
        this.m_info.append(Msg.translate(this.m_lang, "AD_Org_ID")).append("=").append(name).append("\n");
        MOrgInfo orgInfo = MOrgInfo.get(this.m_ctx, this.getAD_Org_ID(), this.m_trx.getTrxName());
        orgInfo.setPhone(phone);
        orgInfo.setPhone2(phone2);
        orgInfo.setFax(fax);
        orgInfo.setEMail(eMail);
        if (taxID != null && taxID.length() > 0) {
            orgInfo.setTaxID(taxID);
        }
        if (!orgInfo.save()) {
            String err = "Organization Info NOT Updated";
            this.log.log(Level.SEVERE, err);
            this.m_info.append(err);
            this.m_trx.rollback();
            this.m_trx.close();
            return false;
        }
        name = String.valueOf(this.m_clientName) + " Admin";
        MRole admin = new MRole(this.m_ctx, 0, this.m_trx.getTrxName());
        admin.setClientOrg(this.m_client);
        admin.setName(name);
        admin.setUserLevel(" CO");
        admin.setPreferenceType("C");
        admin.setIsShowAcct(true);
        admin.setIsAccessAdvanced(true);
        if (!admin.save()) {
            String err = "Admin Role A NOT inserted";
            this.log.log(Level.SEVERE, err);
            this.m_info.append(err);
            this.m_trx.rollback();
            this.m_trx.close();
            return false;
        }
        MRoleOrgAccess adminClientAccess = new MRoleOrgAccess(admin, 0);
        if (!adminClientAccess.save()) {
            this.log.log(Level.SEVERE, "Admin Role_OrgAccess 0 NOT created");
        }
        if (!(adminOrgAccess = new MRoleOrgAccess(admin, this.m_org.getAD_Org_ID())).save()) {
            this.log.log(Level.SEVERE, "Admin Role_OrgAccess NOT created");
        }
        this.m_info.append(Msg.translate(this.m_lang, "AD_Role_ID")).append("=").append(name).append("\n");
        name = String.valueOf(this.m_clientName) + " User";
        MRole user = new MRole(this.m_ctx, 0, this.m_trx.getTrxName());
        user.setClientOrg(this.m_client);
        user.setName(name);
        user.setIsAccessAdvanced(false);
        if (!user.save()) {
            String err = "User Role A NOT inserted";
            this.log.log(Level.SEVERE, err);
            this.m_info.append(err);
            this.m_trx.rollback();
            this.m_trx.close();
            return false;
        }
        MRoleOrgAccess userOrgAccess = new MRoleOrgAccess(user, this.m_org.getAD_Org_ID());
        if (!userOrgAccess.save()) {
            this.log.log(Level.SEVERE, "User Role_OrgAccess NOT created");
        }
        this.m_info.append(Msg.translate(this.m_lang, "AD_Role_ID")).append("=").append(name).append("\n");
        MUser clientAdminUser = new MUser(this.m_ctx, 0, this.m_trx.getTrxName());
        name = userClient;
        if (name == null || name.length() == 0) {
            name = String.valueOf(this.m_clientName) + "Client";
        }
        if (isSetInitialPassword) {
            clientAdminUser.setPassword(name);
        }
        clientAdminUser.setDescription(name);
        clientAdminUser.setName(name);
        clientAdminUser.setAD_Client_ID(AD_Client_ID);
        clientAdminUser.setAD_Org_ID(0);
        clientAdminUser.setEMail(adminEmail);
        try {
            clientAdminUser.saveEx();
        }
        catch (AdempiereException ex) {
            String err = "Admin User NOT inserted - " + this.AD_User_Name;
            this.log.log(Level.SEVERE, err);
            this.m_info.append(err);
            this.m_trx.rollback();
            this.m_trx.close();
            return false;
        }
        this.AD_User_ID = clientAdminUser.getAD_User_ID();
        this.AD_User_Name = name;
        this.m_info.append(Msg.translate(this.m_lang, "AD_User_ID")).append("=").append(this.AD_User_Name).append("/").append(this.AD_User_Name).append("\n");
        MUser clientUser = new MUser(this.m_ctx, 0, this.m_trx.getTrxName());
        name = userClient;
        if (name == null || name.length() == 0) {
            name = String.valueOf(this.m_clientName) + "Client";
        }
        if ((name = userOrg) == null || name.length() == 0) {
            name = String.valueOf(this.m_clientName) + "Org";
        }
        if (isSetInitialPassword) {
            clientUser.setPassword(name);
        }
        clientUser.setDescription(name);
        clientUser.setName(name);
        clientUser.setAD_Client_ID(AD_Client_ID);
        clientUser.setAD_Org_ID(0);
        clientUser.setEMail(userEmail);
        try {
            clientUser.saveEx();
        }
        catch (AdempiereException ex) {
            String err = "Org User NOT inserted - " + this.AD_User_U_Name;
            this.log.log(Level.SEVERE, err);
            this.m_info.append(err);
            this.m_trx.rollback();
            this.m_trx.close();
            return false;
        }
        this.AD_User_U_ID = clientUser.getAD_User_ID();
        this.AD_User_U_Name = name;
        this.m_info.append(Msg.translate(this.m_lang, "AD_User_ID")).append("=").append(this.AD_User_U_Name).append("/").append(this.AD_User_U_Name).append("\n");
        sql = "INSERT INTO AD_User_Roles(" + this.m_stdColumns + ",AD_User_ID,AD_Role_ID,AD_User_Roles_UU)" + " VALUES (" + this.m_stdValues + "," + this.AD_User_ID + "," + admin.getAD_Role_ID() + "," + DB.TO_STRING(UUID.randomUUID().toString()) + ")";
        no = DB.executeUpdateEx(sql, this.m_trx.getTrxName());
        if (no != 1) {
            this.log.log(Level.SEVERE, "UserRole ClientUser+Admin NOT inserted");
        }
        if ((no = DB.executeUpdateEx(sql = "INSERT INTO AD_User_Roles(" + this.m_stdColumns + ",AD_User_ID,AD_Role_ID,AD_User_Roles_UU)" + " VALUES (" + this.m_stdValues + "," + this.AD_User_ID + "," + user.getAD_Role_ID() + "," + DB.TO_STRING(UUID.randomUUID().toString()) + ")", this.m_trx.getTrxName())) != 1) {
            this.log.log(Level.SEVERE, "UserRole ClientUser+User NOT inserted");
        }
        if ((no = DB.executeUpdateEx(sql = "INSERT INTO AD_User_Roles(" + this.m_stdColumns + ",AD_User_ID,AD_Role_ID,AD_User_Roles_UU)" + " VALUES (" + this.m_stdValues + "," + this.AD_User_U_ID + "," + user.getAD_Role_ID() + "," + DB.TO_STRING(UUID.randomUUID().toString()) + ")", this.m_trx.getTrxName())) != 1) {
            this.log.log(Level.SEVERE, "UserRole OrgUser+Org NOT inserted");
        }
        MAcctProcessor ap = new MAcctProcessor(this.m_client, this.AD_User_ID);
        ap.setAD_Schedule_ID(200002);
        ap.saveEx();
        MRequestProcessor rp = new MRequestProcessor(this.m_client, this.AD_User_ID);
        rp.setAD_Schedule_ID(200003);
        rp.saveEx();
        this.log.info("fini");
        return true;
    }

    public boolean createAccounting(KeyNamePair currency, boolean hasProduct, boolean hasBPartner, boolean hasProject, boolean hasMCampaign, boolean hasSRegion, File AccountingFile) {
        return this.createAccounting(currency, hasProduct, hasBPartner, hasProject, hasMCampaign, hasSRegion, false, AccountingFile, false, false);
    }

    public boolean createAccounting(KeyNamePair currency, boolean hasProduct, boolean hasBPartner, boolean hasProject, boolean hasMCampaign, boolean hasSRegion, boolean hasActivity, File AccountingFile, boolean useDefaultCoA, boolean inactivateDefaults) {
        MElement element;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.m_client.toString());
        }
        this.m_hasProject = hasProject;
        this.m_hasMCampaign = hasMCampaign;
        this.m_hasSRegion = hasSRegion;
        this.m_hasActivity = hasActivity;
        this.m_info = new StringBuffer();
        String name = null;
        StringBuffer sqlCmd = null;
        int no = 0;
        this.m_calendar = new MCalendar(this.m_client);
        if (!this.m_calendar.save()) {
            String err = "Calendar NOT inserted";
            this.log.log(Level.SEVERE, err);
            this.m_info.append(err);
            this.m_trx.rollback();
            this.m_trx.close();
            return false;
        }
        this.m_info.append(Msg.translate(this.m_lang, "C_Calendar_ID")).append("=").append(this.m_calendar.getName()).append("\n");
        if (this.m_calendar.createYear(this.m_client.getLocale()) == null) {
            this.log.log(Level.SEVERE, "Year NOT inserted");
        }
        if (!(element = new MElement(this.m_client, name = String.valueOf(this.m_clientName) + " " + Msg.translate(this.m_lang, "Account_ID"), "A", this.m_AD_Tree_Account_ID)).save()) {
            String err = "Acct Element NOT inserted";
            this.log.log(Level.SEVERE, err);
            this.m_info.append(err);
            this.m_trx.rollback();
            this.m_trx.close();
            return false;
        }
        int C_Element_ID = element.getC_Element_ID();
        this.m_info.append(Msg.translate(this.m_lang, "C_Element_ID")).append("=").append(name).append("\n");
        this.m_nap = new NaturalAccountMap(this.m_ctx, this.m_trx.getTrxName());
        String errMsg = this.m_nap.parseFile(AccountingFile);
        if (errMsg.length() != 0) {
            this.log.log(Level.SEVERE, errMsg);
            this.m_info.append(errMsg);
            this.m_trx.rollback();
            this.m_trx.close();
            return false;
        }
        if (!this.m_nap.saveAccounts(this.getAD_Client_ID(), this.getAD_Org_ID(), C_Element_ID, !inactivateDefaults)) {
            String err = "Acct Element Values NOT inserted";
            this.log.log(Level.SEVERE, err);
            this.m_info.append(err);
            this.m_trx.rollback();
            this.m_trx.close();
            return false;
        }
        this.m_info.append(Msg.translate(this.m_lang, "C_ElementValue_ID")).append(" # ").append(this.m_nap.size()).append("\n");
        int summary_ID = this.m_nap.getC_ElementValue_ID("SUMMARY");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("summary_ID=" + summary_ID);
        }
        if (summary_ID > 0) {
            DB.executeUpdateEx("UPDATE AD_TreeNode SET Parent_ID=? WHERE AD_Tree_ID=? AND Node_ID!=?", new Object[]{summary_ID, this.m_AD_Tree_Account_ID, summary_ID}, this.m_trx.getTrxName());
        }
        int C_ElementValue_ID = this.m_nap.getC_ElementValue_ID("DEFAULT_ACCT");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("C_ElementValue_ID=" + C_ElementValue_ID);
        }
        this.m_as = new MAcctSchema(this.m_client, currency);
        if (!this.m_as.save()) {
            String err = "AcctSchema NOT inserted";
            this.log.log(Level.SEVERE, err);
            this.m_info.append(err);
            this.m_trx.rollback();
            this.m_trx.close();
            return false;
        }
        this.m_info.append(Msg.translate(this.m_lang, "C_AcctSchema_ID")).append("=").append(this.m_as.getName()).append("\n");
        String sql2 = null;
        sql2 = Env.isBaseLanguage(this.m_lang, "AD_Reference") ? "SELECT Value, Name FROM AD_Ref_List WHERE AD_Reference_ID=181" : "SELECT l.Value, t.Name FROM AD_Ref_List l, AD_Ref_List_Trl t WHERE l.AD_Reference_ID=181 AND l.AD_Ref_List_ID=t.AD_Ref_List_ID AND t.AD_Language=" + DB.TO_STRING(this.m_lang);
        CPreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            try {
                int AD_Client_ID = this.m_client.getAD_Client_ID();
                stmt = DB.prepareStatement(sql2, this.m_trx.getTrxName());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String ElementType = rs.getString(1);
                    name = rs.getString(2);
                    String IsMandatory = null;
                    String IsBalanced = "N";
                    int SeqNo = 0;
                    int C_AcctSchema_Element_ID = 0;
                    if (ElementType.equals("OO")) {
                        C_AcctSchema_Element_ID = this.getNextID(AD_Client_ID, "C_AcctSchema_Element");
                        IsMandatory = "Y";
                        IsBalanced = "Y";
                        SeqNo = 10;
                    } else if (ElementType.equals("AC")) {
                        C_AcctSchema_Element_ID = this.getNextID(AD_Client_ID, "C_AcctSchema_Element");
                        IsMandatory = "Y";
                        SeqNo = 20;
                    } else if (ElementType.equals("PR") && hasProduct) {
                        C_AcctSchema_Element_ID = this.getNextID(AD_Client_ID, "C_AcctSchema_Element");
                        IsMandatory = "N";
                        SeqNo = 30;
                    } else if (ElementType.equals("BP") && hasBPartner) {
                        C_AcctSchema_Element_ID = this.getNextID(AD_Client_ID, "C_AcctSchema_Element");
                        IsMandatory = "N";
                        SeqNo = 40;
                    } else if (ElementType.equals("PJ") && hasProject) {
                        C_AcctSchema_Element_ID = this.getNextID(AD_Client_ID, "C_AcctSchema_Element");
                        IsMandatory = "N";
                        SeqNo = 50;
                    } else if (ElementType.equals("MC") && hasMCampaign) {
                        C_AcctSchema_Element_ID = this.getNextID(AD_Client_ID, "C_AcctSchema_Element");
                        IsMandatory = "N";
                        SeqNo = 60;
                    } else if (ElementType.equals("SR") && hasSRegion) {
                        C_AcctSchema_Element_ID = this.getNextID(AD_Client_ID, "C_AcctSchema_Element");
                        IsMandatory = "N";
                        SeqNo = 70;
                    } else if (ElementType.equals("AY") && hasActivity) {
                        C_AcctSchema_Element_ID = this.getNextID(AD_Client_ID, "C_AcctSchema_Element");
                        IsMandatory = "N";
                        SeqNo = 80;
                    }
                    if (IsMandatory == null) continue;
                    sqlCmd = new StringBuffer("INSERT INTO C_AcctSchema_Element(");
                    sqlCmd.append(this.m_stdColumns).append(",C_AcctSchema_Element_ID,C_AcctSchema_ID,").append("ElementType,Name,SeqNo,IsMandatory,IsBalanced,C_AcctSchema_Element_UU) VALUES (");
                    sqlCmd.append(this.m_stdValues).append(",").append(C_AcctSchema_Element_ID).append(",").append(this.m_as.getC_AcctSchema_ID()).append(",").append("'").append(ElementType).append("','").append(name).append("',").append(SeqNo).append(",'").append(IsMandatory).append("','").append(IsBalanced).append("',").append(DB.TO_STRING(UUID.randomUUID().toString())).append(")");
                    no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
                    if (no == 1) {
                        this.m_info.append(Msg.translate(this.m_lang, "C_AcctSchema_Element_ID")).append("=").append(name).append("\n");
                    }
                    if (ElementType.equals("OO")) {
                        sqlCmd = new StringBuffer("UPDATE C_AcctSchema_Element SET Org_ID=");
                        sqlCmd.append(this.getAD_Org_ID()).append(" WHERE C_AcctSchema_Element_ID=").append(C_AcctSchema_Element_ID);
                        no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
                        if (no != 1) {
                            this.log.log(Level.SEVERE, "Default Org in AcctSchemaElement NOT updated");
                        }
                    }
                    if (!ElementType.equals("AC")) continue;
                    sqlCmd = new StringBuffer("UPDATE C_AcctSchema_Element SET C_ElementValue_ID=");
                    sqlCmd.append(C_ElementValue_ID).append(", C_Element_ID=").append(C_Element_ID);
                    sqlCmd.append(" WHERE C_AcctSchema_Element_ID=").append(C_AcctSchema_Element_ID);
                    no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
                    if (no == 1) continue;
                    this.log.log(Level.SEVERE, "Default Account in AcctSchemaElement NOT updated");
                }
            }
            catch (SQLException e1) {
                this.log.log(Level.SEVERE, "Elements", e1);
                this.m_info.append(e1.getMessage());
                this.m_trx.rollback();
                this.m_trx.close();
                DB.close(rs, stmt);
                rs = null;
                stmt = null;
                return false;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, stmt);
            rs = null;
            stmt = null;
            throw throwable;
        }
        DB.close(rs, stmt);
        rs = null;
        stmt = null;
        try {
            this.createAccountingRecord("C_AcctSchema_GL");
            this.createAccountingRecord("C_AcctSchema_Default");
        }
        catch (Exception e) {
            String err = e.getLocalizedMessage();
            this.log.log(Level.SEVERE, err);
            this.m_info.append(err);
            this.m_trx.rollback();
            this.m_trx.close();
            return false;
        }
        this.createGLCategory("Standard", "M", true);
        int GL_None = this.createGLCategory("None", "D", false);
        int GL_GL = this.createGLCategory("Manual", "M", false);
        int GL_ARI = this.createGLCategory("AR Invoice", "D", false);
        int GL_ARR = this.createGLCategory("AR Receipt", "D", false);
        int GL_MM = this.createGLCategory("Material Management", "D", false);
        int GL_API = this.createGLCategory("AP Invoice", "D", false);
        int GL_APP = this.createGLCategory("AP Payment", "D", false);
        int GL_CASH = this.createGLCategory("Cash/Payments", "D", false);
        int GL_Manufacturing = this.createGLCategory("Manufacturing", "D", false);
        int GL_Distribution = this.createGLCategory("Distribution", "D", false);
        int GL_Payroll = this.createGLCategory("Payroll", "D", false);
        int ii = this.createDocType("GL Journal", Msg.getElement(this.m_ctx, "GL_Journal_ID"), "GLJ", null, 0, 0, 1000, GL_GL, false);
        if (ii == 0) {
            String err = "Document Type not created";
            this.m_info.append(err);
            this.m_trx.rollback();
            this.m_trx.close();
            return false;
        }
        this.createDocType("GL Journal Batch", Msg.getElement(this.m_ctx, "GL_JournalBatch_ID"), "GLJ", null, 0, 0, 100, GL_GL, false);
        int DT_I = this.createDocType("AR Invoice", Msg.getElement(this.m_ctx, "C_Invoice_ID", true), "ARI", null, 0, 0, 100000, GL_ARI, false);
        int DT_II = this.createDocType("AR Invoice Indirect", Msg.getElement(this.m_ctx, "C_Invoice_ID", true), "ARI", null, 0, 0, 150000, GL_ARI, false);
        int DT_IC = this.createDocType("AR Credit Memo", Msg.getMsg(this.m_ctx, "CreditMemo"), "ARC", null, 0, 0, 170000, GL_ARI, false);
        this.createDocType("AP Invoice", Msg.getElement(this.m_ctx, "C_Invoice_ID", false), "API", null, 0, 0, 0, GL_API, false);
        int DT_IPC = this.createDocType("AP CreditMemo", Msg.getMsg(this.m_ctx, "CreditMemo"), "APC", null, 0, 0, 0, GL_API, false);
        this.createDocType("Match Invoice", Msg.getElement(this.m_ctx, "M_MatchInv_ID", false), "MXI", null, 0, 0, 390000, GL_API, false);
        this.createDocType("AR Receipt", Msg.getElement(this.m_ctx, "C_Payment_ID", true), "ARR", null, 0, 0, 0, GL_ARR, false);
        this.createDocType("AP Payment", Msg.getElement(this.m_ctx, "C_Payment_ID", false), "APP", null, 0, 0, 0, GL_APP, false);
        this.createDocType("Allocation", "Allocation", "CMA", null, 0, 0, 490000, GL_CASH, false);
        int DT_S = this.createDocType("MM Shipment", "Delivery Note", "MMS", null, 0, 0, 500000, GL_MM, false);
        int DT_SI = this.createDocType("MM Shipment Indirect", "Delivery Note", "MMS", null, 0, 0, 550000, GL_MM, false);
        int DT_VRM = this.createDocType("MM Vendor Return", "Vendor Return", "MMS", null, 0, 0, 590000, GL_MM, true);
        this.createDocType("MM Receipt", "Vendor Delivery", "MMR", null, 0, 0, 0, GL_MM, false);
        int DT_RM = this.createDocType("MM Customer Return", "Customer Return", "MMR", null, 0, 0, 570000, GL_MM, true);
        this.createDocType("Purchase Order", Msg.getElement(this.m_ctx, "C_Order_ID", false), "POO", null, 0, 0, 800000, GL_None, false);
        this.createDocType("Match PO", Msg.getElement(this.m_ctx, "M_MatchPO_ID", false), "MXP", null, 0, 0, 890000, GL_None, false);
        this.createDocType("Purchase Requisition", Msg.getElement(this.m_ctx, "M_Requisition_ID", false), "POR", null, 0, 0, 900000, GL_None, false);
        this.createDocType("Vendor Return Material", "Vendor Return Material Authorization", "POO", "RM", DT_VRM, DT_IPC, 990000, GL_MM, false);
        this.createDocType("Bank Statement", Msg.getElement(this.m_ctx, "C_BankStatemet_ID", true), "CMB", null, 0, 0, 700000, GL_CASH, false);
        this.createDocType("Cash Journal", Msg.getElement(this.m_ctx, "C_Cash_ID", true), "CMC", null, 0, 0, 750000, GL_CASH, false);
        this.createDocType("Material Movement", Msg.getElement(this.m_ctx, "M_Movement_ID", false), "MMM", null, 0, 0, 610000, GL_MM, false);
        this.createDocType("Physical Inventory", Msg.getElement(this.m_ctx, "M_Inventory_ID", false), "MMI", "PI", 0, 0, 620000, GL_MM, false);
        this.createDocType("Material Production", Msg.getElement(this.m_ctx, "M_Production_ID", false), "MMP", null, 0, 0, 630000, GL_MM, false);
        this.createDocType("Project Issue", Msg.getElement(this.m_ctx, "C_ProjectIssue_ID", false), "PJI", null, 0, 0, 640000, GL_MM, false);
        this.createDocType("Internal Use Inventory", "Internal Use Inventory", "MMI", "IU", 0, 0, 650000, GL_MM, false);
        this.createDocType("Cost Adjustment", "Cost Adjustment", "MMI", "CA", 0, 0, 660000, GL_MM, false);
        this.createDocType("Binding offer", "Quotation", "SOO", "OB", 0, 0, 10000, GL_None, false);
        this.createDocType("Non binding offer", "Proposal", "SOO", "ON", 0, 0, 20000, GL_None, false);
        this.createDocType("Prepay Order", "Prepay Order", "SOO", "PR", DT_S, DT_I, 30000, GL_None, false);
        this.createDocType("Customer Return Material", "Customer Return Material Authorization", "SOO", "RM", DT_RM, DT_IC, 30000, GL_None, false);
        this.createDocType("Standard Order", "Order Confirmation", "SOO", "SO", DT_S, DT_I, 50000, GL_None, false);
        this.createDocType("Credit Order", "Order Confirmation", "SOO", "WI", DT_SI, DT_I, 60000, GL_None, false);
        this.createDocType("Warehouse Order", "Order Confirmation", "SOO", "WP", DT_S, DT_I, 70000, GL_None, false);
        this.createDocType("Manufacturing Order", "Manufacturing Order", "MOP", null, 0, 0, 80000, GL_Manufacturing, false);
        this.createDocType("Manufacturing Cost Collector", "Cost Collector", "MCC", null, 0, 0, 81000, GL_Manufacturing, false);
        this.createDocType("Maintenance Order", "Maintenance Order", "MOF", null, 0, 0, 86000, GL_Manufacturing, false);
        this.createDocType("Quality Order", "Quality Order", "MQO", null, 0, 0, 87000, GL_Manufacturing, false);
        this.createDocType("Distribution Order", "Distribution Order", "DOO", null, 0, 0, 88000, GL_Distribution, false);
        this.createDocType("Payroll", "Payroll", "HRP", null, 0, 0, 90000, GL_Payroll, false);
        int DT = this.createDocType("POS Order", "Order Confirmation", "SOO", "WR", DT_SI, DT_II, 80000, GL_None, false);
        this.createPreference("C_DocTypeTarget_ID", String.valueOf(DT), 143);
        sqlCmd = new StringBuffer("UPDATE AD_ClientInfo SET ");
        sqlCmd.append("C_AcctSchema1_ID=").append(this.m_as.getC_AcctSchema_ID()).append(", C_Calendar_ID=").append(this.m_calendar.getC_Calendar_ID()).append(" WHERE AD_Client_ID=").append(this.m_client.getAD_Client_ID());
        no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
        if (no != 1) {
            String err = "ClientInfo not updated";
            this.log.log(Level.SEVERE, err);
            this.m_info.append(err);
            this.m_trx.rollback();
            this.m_trx.close();
            return false;
        }
        ProcessInfo processInfo = new ProcessInfo("Document Type Verify", 0);
        processInfo.setAD_Client_ID(this.getAD_Client_ID());
        processInfo.setAD_User_ID(this.getAD_User_ID());
        processInfo.setParameter(new ProcessInfoParameter[0]);
        processInfo.setClassName("org.compiere.process.DocumentTypeVerify");
        if (!ProcessUtil.startJavaProcess(this.m_ctx, processInfo, this.m_trx, false)) {
            String err = "Document type verification failed. Message=" + processInfo.getSummary();
            this.log.log(Level.SEVERE, err);
            this.m_info.append(err);
            this.m_trx.rollback();
            this.m_trx.close();
            return false;
        }
        this.log.info("fini");
        return true;
    }

    private void createAccountingRecord(String tableName) throws Exception {
        MColumn[] cols;
        MTable table2 = MTable.get(this.m_ctx, tableName);
        PO acct = table2.getPO(0, this.m_trx.getTrxName());
        MColumn[] mColumnArray = cols = table2.getColumns(false);
        int n = cols.length;
        int n2 = 0;
        while (n2 < n) {
            MColumn c = mColumnArray[n2];
            if (c.isActive()) {
                String columnName = c.getColumnName();
                if (!c.isStandardColumn()) {
                    if (25 == c.getAD_Reference_ID()) {
                        acct.set_Value(columnName, (Object)this.getAcct(columnName));
                        if (this.log.isLoggable(Level.INFO)) {
                            this.log.info("Account: " + columnName);
                        }
                    } else if (20 == c.getAD_Reference_ID()) {
                        acct.set_Value(columnName, (Object)Boolean.TRUE);
                        if (this.log.isLoggable(Level.INFO)) {
                            this.log.info("YesNo: " + c.getColumnName());
                        }
                    }
                }
            }
            ++n2;
        }
        acct.setAD_Client_ID(this.m_client.getAD_Client_ID());
        acct.set_Value("C_AcctSchema_ID", (Object)this.m_as.getC_AcctSchema_ID());
        if (!acct.save()) {
            throw new AdempiereUserError(CLogger.retrieveErrorString(String.valueOf(table2.getName()) + " not created"));
        }
    }

    private Integer getAcct(String key) throws AdempiereUserError {
        this.log.fine(key);
        int C_ElementValue_ID = this.m_nap.getC_ElementValue_ID(key.toUpperCase());
        if (C_ElementValue_ID == 0) {
            throw new AdempiereUserError("Account not defined: " + key);
        }
        MAccount vc = MAccount.getDefault(this.m_as, true);
        vc.setAD_Org_ID(0);
        vc.setAccount_ID(C_ElementValue_ID);
        if (!vc.save()) {
            throw new AdempiereUserError("Not Saved - Key=" + key + ", C_ElementValue_ID=" + C_ElementValue_ID);
        }
        int C_ValidCombination_ID = vc.getC_ValidCombination_ID();
        if (C_ValidCombination_ID == 0) {
            throw new AdempiereUserError("No account - Key=" + key + ", C_ElementValue_ID=" + C_ElementValue_ID);
        }
        return C_ValidCombination_ID;
    }

    private int createGLCategory(String Name, String CategoryType, boolean isDefault) {
        MGLCategory cat = new MGLCategory(this.m_ctx, 0, this.m_trx.getTrxName());
        cat.setName(Name);
        cat.setCategoryType(CategoryType);
        cat.setIsDefault(isDefault);
        if (!cat.save()) {
            this.log.log(Level.SEVERE, "GL Category NOT created - " + Name);
            return 0;
        }
        return cat.getGL_Category_ID();
    }

    private int createDocType(String Name, String PrintName, String DocBaseType, String DocSubTypeSO, int C_DocTypeShipment_ID, int C_DocTypeInvoice_ID, int StartNo, int GL_Category_ID, boolean isReturnTrx) {
        MSequence sequence = null;
        if (StartNo != 0 && !(sequence = new MSequence(this.m_ctx, this.getAD_Client_ID(), Name, StartNo, this.m_trx.getTrxName())).save()) {
            this.log.log(Level.SEVERE, "Sequence NOT created - " + Name);
            return 0;
        }
        MDocType dt = new MDocType(this.m_ctx, DocBaseType, Name, this.m_trx.getTrxName());
        if (PrintName != null && PrintName.length() > 0) {
            dt.setPrintName(PrintName);
        }
        if (DocSubTypeSO != null) {
            if ("MMI".equals(DocBaseType)) {
                dt.setDocSubTypeInv(DocSubTypeSO);
            } else {
                dt.setDocSubTypeSO(DocSubTypeSO);
            }
        }
        if (C_DocTypeShipment_ID != 0) {
            dt.setC_DocTypeShipment_ID(C_DocTypeShipment_ID);
        }
        if (C_DocTypeInvoice_ID != 0) {
            dt.setC_DocTypeInvoice_ID(C_DocTypeInvoice_ID);
        }
        if (GL_Category_ID != 0) {
            dt.setGL_Category_ID(GL_Category_ID);
        }
        if (sequence == null) {
            dt.setIsDocNoControlled(false);
        } else {
            dt.setIsDocNoControlled(true);
            dt.setDocNoSequence_ID(sequence.getAD_Sequence_ID());
        }
        dt.setIsSOTrx();
        if (isReturnTrx) {
            dt.setIsSOTrx(!dt.isSOTrx());
        }
        if (!dt.save()) {
            this.log.log(Level.SEVERE, "DocType NOT created - " + Name);
            return 0;
        }
        return dt.getC_DocType_ID();
    }

    public boolean createEntities(int C_Country_ID, String City, int C_Region_ID, int C_Currency_ID, String postal, String address1) {
        MProductPrice pp;
        if (this.m_as == null) {
            this.log.severe("No AcctountingSChema");
            this.m_trx.rollback();
            this.m_trx.close();
            return false;
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_Country_ID=" + C_Country_ID + ", City=" + City + ", C_Region_ID=" + C_Region_ID);
        }
        this.m_info.append("\n----\n");
        String defaultName = Msg.translate(this.m_lang, "Standard");
        String defaultEntry = "'" + defaultName + "',";
        StringBuffer sqlCmd = null;
        int no = 0;
        int C_Channel_ID = this.getNextID(this.getAD_Client_ID(), "C_Channel");
        sqlCmd = new StringBuffer("INSERT INTO C_Channel ");
        sqlCmd.append("(C_Channel_ID,Name,");
        sqlCmd.append(this.m_stdColumns).append(",C_Channel_UU) VALUES (");
        sqlCmd.append(C_Channel_ID).append(",").append(defaultEntry);
        sqlCmd.append(this.m_stdValues).append(",").append(DB.TO_STRING(UUID.randomUUID().toString())).append(")");
        no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
        if (no != 1) {
            this.log.log(Level.SEVERE, "Channel NOT inserted");
        }
        int C_Campaign_ID = this.getNextID(this.getAD_Client_ID(), "C_Campaign");
        sqlCmd = new StringBuffer("INSERT INTO C_Campaign ");
        sqlCmd.append("(C_Campaign_ID,C_Channel_ID,").append(this.m_stdColumns).append(",");
        sqlCmd.append(" Value,Name,Costs,C_Campaign_UU) VALUES (");
        sqlCmd.append(C_Campaign_ID).append(",").append(C_Channel_ID).append(",").append(this.m_stdValues).append(",");
        sqlCmd.append(defaultEntry).append(defaultEntry).append("0").append(",").append(DB.TO_STRING(UUID.randomUUID().toString())).append(")");
        no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
        if (no == 1) {
            this.m_info.append(Msg.translate(this.m_lang, "C_Campaign_ID")).append("=").append(defaultName).append("\n");
        } else {
            this.log.log(Level.SEVERE, "Campaign NOT inserted");
        }
        if (this.m_hasMCampaign) {
            sqlCmd = new StringBuffer("UPDATE C_AcctSchema_Element SET ");
            sqlCmd.append("C_Campaign_ID=").append(C_Campaign_ID);
            sqlCmd.append(" WHERE C_AcctSchema_ID=").append(this.m_as.getC_AcctSchema_ID());
            sqlCmd.append(" AND ElementType='MC'");
            no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
            if (no != 1) {
                this.log.log(Level.SEVERE, "AcctSchema Element Campaign NOT updated");
            }
        }
        sqlCmd = new StringBuffer("INSERT INTO C_Campaign_Trl (AD_Language,C_Campaign_ID, Description,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy,C_Campaign_Trl_UU)");
        sqlCmd.append(" SELECT l.AD_Language,t.C_Campaign_ID, t.Description,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy, generate_uuid() FROM AD_Language l, C_Campaign t");
        sqlCmd.append(" WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.C_Campaign_ID=").append(C_Campaign_ID);
        sqlCmd.append(" AND NOT EXISTS (SELECT * FROM C_Campaign_Trl tt WHERE tt.AD_Language=l.AD_Language AND tt.C_Campaign_ID=t.C_Campaign_ID)");
        no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
        if (no < 0) {
            this.log.log(Level.SEVERE, "Campaign Translation NOT inserted");
        }
        int C_SalesRegion_ID = this.getNextID(this.getAD_Client_ID(), "C_SalesRegion");
        sqlCmd = new StringBuffer("INSERT INTO C_SalesRegion ");
        sqlCmd.append("(C_SalesRegion_ID,").append(this.m_stdColumns).append(",");
        sqlCmd.append(" Value,Name,IsSummary,C_SalesRegion_UU) VALUES (");
        sqlCmd.append(C_SalesRegion_ID).append(",").append(this.m_stdValues).append(", ");
        sqlCmd.append(defaultEntry).append(defaultEntry).append("'N'").append(",").append(DB.TO_STRING(UUID.randomUUID().toString())).append(")");
        no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
        if (no == 1) {
            this.m_info.append(Msg.translate(this.m_lang, "C_SalesRegion_ID")).append("=").append(defaultName).append("\n");
        } else {
            this.log.log(Level.SEVERE, "SalesRegion NOT inserted");
        }
        if (this.m_hasSRegion) {
            sqlCmd = new StringBuffer("UPDATE C_AcctSchema_Element SET ");
            sqlCmd.append("C_SalesRegion_ID=").append(C_SalesRegion_ID);
            sqlCmd.append(" WHERE C_AcctSchema_ID=").append(this.m_as.getC_AcctSchema_ID());
            sqlCmd.append(" AND ElementType='SR'");
            no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
            if (no != 1) {
                this.log.log(Level.SEVERE, "AcctSchema Element SalesRegion NOT updated");
            }
        }
        sqlCmd = new StringBuffer("INSERT INTO C_SalesRegion_Trl (AD_Language,C_SalesRegion_ID, Description,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy,C_SalesRegion_Trl_UU)");
        sqlCmd.append(" SELECT l.AD_Language,t.C_SalesRegion_ID, t.Description,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy, generate_uuid() FROM AD_Language l, C_SalesRegion t");
        sqlCmd.append(" WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.C_SalesRegion_ID=").append(C_SalesRegion_ID);
        sqlCmd.append(" AND NOT EXISTS (SELECT * FROM C_SalesRegion_Trl tt WHERE tt.AD_Language=l.AD_Language AND tt.C_SalesRegion_ID=t.C_SalesRegion_ID)");
        no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
        if (no < 0) {
            this.log.log(Level.SEVERE, "Sales Region Translation NOT inserted");
        }
        int C_Activity_ID = this.getNextID(this.getAD_Client_ID(), "C_Activity");
        sqlCmd = new StringBuffer("INSERT INTO C_Activity ");
        sqlCmd.append("(C_Activity_ID,").append(this.m_stdColumns).append(",");
        sqlCmd.append(" Value,Name,IsSummary,C_Activity_UU) VALUES (");
        sqlCmd.append(C_Activity_ID).append(",").append(this.m_stdValues).append(", ");
        sqlCmd.append(defaultEntry).append(defaultEntry).append("'N'").append(",").append(DB.TO_STRING(UUID.randomUUID().toString())).append(")");
        no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
        if (no == 1) {
            this.m_info.append(Msg.translate(this.m_lang, "C_Activity_ID")).append("=").append(defaultName).append("\n");
        } else {
            this.log.log(Level.SEVERE, "Activity NOT inserted");
        }
        if (this.m_hasActivity) {
            sqlCmd = new StringBuffer("UPDATE C_AcctSchema_Element SET ");
            sqlCmd.append("C_Activity_ID=").append(C_Activity_ID);
            sqlCmd.append(" WHERE C_AcctSchema_ID=").append(this.m_as.getC_AcctSchema_ID());
            sqlCmd.append(" AND ElementType='AY'");
            no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
            if (no != 1) {
                this.log.log(Level.SEVERE, "AcctSchema Element Activity NOT updated");
            }
        }
        sqlCmd = new StringBuffer("INSERT INTO C_Activity_Trl (AD_Language,C_Activity_ID, Description,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy,C_Activity_Trl_UU)");
        sqlCmd.append(" SELECT l.AD_Language,t.C_Activity_ID, t.Description,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy, generate_uuid() FROM AD_Language l, C_Activity t");
        sqlCmd.append(" WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.C_Activity_ID=").append(C_Activity_ID);
        sqlCmd.append(" AND NOT EXISTS (SELECT * FROM C_Activity_Trl tt WHERE tt.AD_Language=l.AD_Language AND tt.C_Activity_ID=t.C_Activity_ID)");
        no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
        if (no < 0) {
            this.log.log(Level.SEVERE, "Activity Translation NOT inserted");
        }
        MBPGroup bpg = new MBPGroup(this.m_ctx, 0, this.m_trx.getTrxName());
        bpg.setValue(defaultName);
        bpg.setName(defaultName);
        bpg.setIsDefault(true);
        if (bpg.save()) {
            this.m_info.append(Msg.translate(this.m_lang, "C_BP_Group_ID")).append("=").append(defaultName).append("\n");
        } else {
            this.log.log(Level.SEVERE, "BP Group NOT inserted");
        }
        MBPartner bp = new MBPartner(this.m_ctx, 0, this.m_trx.getTrxName());
        bp.setValue(defaultName);
        bp.setName(defaultName);
        bp.setBPGroup(bpg);
        if (bp.save()) {
            this.m_info.append(Msg.translate(this.m_lang, "C_BPartner_ID")).append("=").append(defaultName).append("\n");
        } else {
            this.log.log(Level.SEVERE, "BPartner NOT inserted");
        }
        MLocation bpLoc = new MLocation(this.m_ctx, C_Country_ID, C_Region_ID, City, this.m_trx.getTrxName());
        bpLoc.saveEx();
        MBPartnerLocation bpl = new MBPartnerLocation(bp);
        bpl.setC_Location_ID(bpLoc.getC_Location_ID());
        if (!bpl.save()) {
            this.log.log(Level.SEVERE, "BP_Location (Standard) NOT inserted");
        }
        sqlCmd = new StringBuffer("UPDATE C_AcctSchema_Element SET ");
        sqlCmd.append("C_BPartner_ID=").append(bp.getC_BPartner_ID());
        sqlCmd.append(" WHERE C_AcctSchema_ID=").append(this.m_as.getC_AcctSchema_ID());
        sqlCmd.append(" AND ElementType='BP'");
        no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
        if (no != 1) {
            this.log.log(Level.SEVERE, "AcctSchema Element BPartner NOT updated");
        }
        this.createPreference("C_BPartner_ID", String.valueOf(bp.getC_BPartner_ID()), 143);
        MProductCategory pc = new MProductCategory(this.m_ctx, 0, this.m_trx.getTrxName());
        pc.setValue(defaultName);
        pc.setName(defaultName);
        pc.setIsDefault(true);
        if (pc.save()) {
            this.m_info.append(Msg.translate(this.m_lang, "M_Product_Category_ID")).append("=").append(defaultName).append("\n");
        } else {
            this.log.log(Level.SEVERE, "Product Category NOT inserted");
        }
        int C_UOM_ID = 100;
        int C_TaxCategory_ID = this.getNextID(this.getAD_Client_ID(), "C_TaxCategory");
        sqlCmd = new StringBuffer("INSERT INTO C_TaxCategory ");
        sqlCmd.append("(C_TaxCategory_ID,").append(this.m_stdColumns).append(",");
        sqlCmd.append(" Name,IsDefault,C_TaxCategory_UU) VALUES (");
        sqlCmd.append(C_TaxCategory_ID).append(",").append(this.m_stdValues).append(", ");
        if (C_Country_ID == 100) {
            sqlCmd.append("'Sales Tax','Y',");
        } else {
            sqlCmd.append(defaultEntry).append("'Y',");
        }
        sqlCmd.append(DB.TO_STRING(UUID.randomUUID().toString())).append(")");
        no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
        if (no != 1) {
            this.log.log(Level.SEVERE, "TaxCategory NOT inserted");
        }
        sqlCmd = new StringBuffer("INSERT INTO C_TaxCategory_Trl (AD_Language,C_TaxCategory_ID, Description,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy,C_TaxCategory_Trl_UU)");
        sqlCmd.append(" SELECT l.AD_Language,t.C_TaxCategory_ID, t.Description,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy, generate_uuid() FROM AD_Language l, C_TaxCategory t");
        sqlCmd.append(" WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.C_TaxCategory_ID=").append(C_TaxCategory_ID);
        sqlCmd.append(" AND NOT EXISTS (SELECT * FROM C_TaxCategory_Trl tt WHERE tt.AD_Language=l.AD_Language AND tt.C_TaxCategory_ID=t.C_TaxCategory_ID)");
        no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
        if (no < 0) {
            this.log.log(Level.SEVERE, "TaxCategory Translation NOT inserted");
        }
        MTax tax = new MTax(this.m_ctx, "Standard", Env.ZERO, C_TaxCategory_ID, this.m_trx.getTrxName());
        tax.setIsDefault(true);
        if (tax.save()) {
            this.m_info.append(Msg.translate(this.m_lang, "C_Tax_ID")).append("=").append(tax.getName()).append("\n");
        } else {
            this.log.log(Level.SEVERE, "Tax NOT inserted");
        }
        MProduct product = new MProduct(this.m_ctx, 0, this.m_trx.getTrxName());
        product.setValue(defaultName);
        product.setName(defaultName);
        product.setC_UOM_ID(C_UOM_ID);
        product.setM_Product_Category_ID(pc.getM_Product_Category_ID());
        product.setC_TaxCategory_ID(C_TaxCategory_ID);
        if (product.save()) {
            this.m_info.append(Msg.translate(this.m_lang, "M_Product_ID")).append("=").append(defaultName).append("\n");
        } else {
            this.log.log(Level.SEVERE, "Product NOT inserted");
        }
        sqlCmd = new StringBuffer("UPDATE C_AcctSchema_Element SET ");
        sqlCmd.append("M_Product_ID=").append(product.getM_Product_ID());
        sqlCmd.append(" WHERE C_AcctSchema_ID=").append(this.m_as.getC_AcctSchema_ID());
        sqlCmd.append(" AND ElementType='PR'");
        no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
        if (no != 1) {
            this.log.log(Level.SEVERE, "AcctSchema Element Product NOT updated");
        }
        MLocation loc = new MLocation(this.m_ctx, C_Country_ID, C_Region_ID, City, this.m_trx.getTrxName());
        loc.setAddress1(address1);
        loc.setPostal(postal);
        loc.saveEx();
        sqlCmd = new StringBuffer("UPDATE AD_OrgInfo SET C_Location_ID=");
        sqlCmd.append(loc.getC_Location_ID()).append(" WHERE AD_Org_ID=").append(this.getAD_Org_ID());
        no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
        if (no != 1) {
            this.log.log(Level.SEVERE, "Location NOT inserted");
        }
        this.createPreference("C_Country_ID", String.valueOf(C_Country_ID), 0);
        MLocation locwh = new MLocation(this.m_ctx, C_Country_ID, C_Region_ID, City, this.m_trx.getTrxName());
        locwh.setAddress1(address1);
        locwh.setPostal(postal);
        locwh.saveEx();
        MWarehouse wh = new MWarehouse(this.m_ctx, 0, this.m_trx.getTrxName());
        wh.setValue(defaultName);
        wh.setName(defaultName);
        wh.setC_Location_ID(locwh.getC_Location_ID());
        if (!wh.save()) {
            this.log.log(Level.SEVERE, "Warehouse NOT inserted");
        }
        MLocator locator = new MLocator(wh, defaultName);
        locator.setIsDefault(true);
        if (!locator.save()) {
            this.log.log(Level.SEVERE, "Locator NOT inserted");
        }
        sqlCmd = new StringBuffer("UPDATE AD_ClientInfo SET ");
        sqlCmd.append("C_BPartnerCashTrx_ID=").append(bp.getC_BPartner_ID());
        sqlCmd.append(",M_ProductFreight_ID=").append(product.getM_Product_ID());
        sqlCmd.append(" WHERE AD_Client_ID=").append(this.getAD_Client_ID());
        no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
        if (no != 1) {
            String err = "ClientInfo not updated";
            this.log.log(Level.SEVERE, err);
            this.m_info.append(err);
            return false;
        }
        MPriceList pl = new MPriceList(this.m_ctx, 0, this.m_trx.getTrxName());
        pl.setName(defaultName);
        pl.setC_Currency_ID(C_Currency_ID);
        pl.setIsDefault(true);
        if (!pl.save()) {
            this.log.log(Level.SEVERE, "PriceList NOT inserted");
        }
        MDiscountSchema ds = new MDiscountSchema(this.m_ctx, 0, this.m_trx.getTrxName());
        ds.setName(defaultName);
        ds.setDiscountType("P");
        if (!ds.save()) {
            this.log.log(Level.SEVERE, "DiscountSchema NOT inserted");
        }
        MPriceListVersion plv = new MPriceListVersion(pl);
        plv.setName();
        plv.setM_DiscountSchema_ID(ds.getM_DiscountSchema_ID());
        if (!plv.save()) {
            this.log.log(Level.SEVERE, "PriceList_Version NOT inserted");
        }
        if (!(pp = new MProductPrice(plv, product.getM_Product_ID(), Env.ONE, Env.ONE, Env.ONE)).save()) {
            this.log.log(Level.SEVERE, "ProductPrice NOT inserted");
        }
        MBPartner bpCU = new MBPartner(this.m_ctx, 0, this.m_trx.getTrxName());
        bpCU.setValue(this.AD_User_U_Name);
        bpCU.setName(this.AD_User_U_Name);
        bpCU.setBPGroup(bpg);
        bpCU.setIsEmployee(true);
        bpCU.setIsSalesRep(true);
        if (bpCU.save()) {
            this.m_info.append(Msg.translate(this.m_lang, "SalesRep_ID")).append("=").append(this.AD_User_U_Name).append("\n");
        } else {
            this.log.log(Level.SEVERE, "SalesRep (User) NOT inserted");
        }
        MLocation bpLocCU = new MLocation(this.m_ctx, C_Country_ID, C_Region_ID, City, this.m_trx.getTrxName());
        bpLocCU.saveEx();
        MBPartnerLocation bplCU = new MBPartnerLocation(bpCU);
        bplCU.setC_Location_ID(bpLocCU.getC_Location_ID());
        if (!bplCU.save()) {
            this.log.log(Level.SEVERE, "BP_Location (User) NOT inserted");
        }
        sqlCmd = new StringBuffer("UPDATE AD_User SET C_BPartner_ID=");
        sqlCmd.append(bpCU.getC_BPartner_ID()).append(" WHERE AD_User_ID=").append(this.AD_User_U_ID);
        no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
        if (no != 1) {
            this.log.log(Level.SEVERE, "User of SalesRep (User) NOT updated");
        }
        MBPartner bpCA = new MBPartner(this.m_ctx, 0, this.m_trx.getTrxName());
        bpCA.setValue(this.AD_User_Name);
        bpCA.setName(this.AD_User_Name);
        bpCA.setBPGroup(bpg);
        bpCA.setIsEmployee(true);
        bpCA.setIsSalesRep(true);
        if (bpCA.save()) {
            this.m_info.append(Msg.translate(this.m_lang, "SalesRep_ID")).append("=").append(this.AD_User_Name).append("\n");
        } else {
            this.log.log(Level.SEVERE, "SalesRep (Admin) NOT inserted");
        }
        MLocation bpLocCA = new MLocation(this.m_ctx, C_Country_ID, C_Region_ID, City, this.m_trx.getTrxName());
        bpLocCA.saveEx();
        MBPartnerLocation bplCA = new MBPartnerLocation(bpCA);
        bplCA.setC_Location_ID(bpLocCA.getC_Location_ID());
        if (!bplCA.save()) {
            this.log.log(Level.SEVERE, "BP_Location (Admin) NOT inserted");
        }
        sqlCmd = new StringBuffer("UPDATE AD_User SET C_BPartner_ID=");
        sqlCmd.append(bpCA.getC_BPartner_ID()).append(" WHERE AD_User_ID=").append(this.AD_User_ID);
        no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
        if (no != 1) {
            this.log.log(Level.SEVERE, "User of SalesRep (Admin) NOT updated");
        }
        int C_PaymentTerm_ID = this.getNextID(this.getAD_Client_ID(), "C_PaymentTerm");
        sqlCmd = new StringBuffer("INSERT INTO C_PaymentTerm ");
        sqlCmd.append("(C_PaymentTerm_ID,").append(this.m_stdColumns).append(",");
        sqlCmd.append("Value,Name,NetDays,GraceDays,DiscountDays,Discount,DiscountDays2,Discount2,IsDefault,C_PaymentTerm_UU) VALUES (");
        sqlCmd.append(C_PaymentTerm_ID).append(",").append(this.m_stdValues).append(",");
        sqlCmd.append("'Immediate','Immediate',0,0,0,0,0,0,'Y'").append(",").append(DB.TO_STRING(UUID.randomUUID().toString())).append(")");
        no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
        if (no != 1) {
            this.log.log(Level.SEVERE, "PaymentTerm NOT inserted");
        }
        sqlCmd = new StringBuffer("INSERT INTO C_PaymentTerm_Trl (AD_Language,C_PaymentTerm_ID, Description,Name, IsTranslated,AD_Client_ID,AD_Org_ID,Created,Createdby,Updated,UpdatedBy,C_PaymentTerm_Trl_UU)");
        sqlCmd.append(" SELECT l.AD_Language,t.C_PaymentTerm_ID, t.Description,t.Name, 'N',t.AD_Client_ID,t.AD_Org_ID,t.Created,t.Createdby,t.Updated,t.UpdatedBy, generate_uuid() FROM AD_Language l, C_PaymentTerm t");
        sqlCmd.append(" WHERE l.IsActive='Y' AND l.IsSystemLanguage='Y' AND l.IsBaseLanguage='N' AND t.C_PaymentTerm_ID=").append(C_PaymentTerm_ID);
        sqlCmd.append(" AND NOT EXISTS (SELECT * FROM C_PaymentTerm_Trl tt WHERE tt.AD_Language=l.AD_Language AND tt.C_PaymentTerm_ID=t.C_PaymentTerm_ID)");
        no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
        if (no < 0) {
            this.log.log(Level.SEVERE, "Payment Term Translation NOT inserted");
        }
        this.C_Cycle_ID = this.getNextID(this.getAD_Client_ID(), "C_Cycle");
        sqlCmd = new StringBuffer("INSERT INTO C_Cycle ");
        sqlCmd.append("(C_Cycle_ID,").append(this.m_stdColumns).append(",");
        sqlCmd.append(" Name,C_Currency_ID,C_Cycle_UU) VALUES (");
        sqlCmd.append(this.C_Cycle_ID).append(",").append(this.m_stdValues).append(", ");
        sqlCmd.append(defaultEntry).append(C_Currency_ID).append(",").append(DB.TO_STRING(UUID.randomUUID().toString())).append(")");
        no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
        if (no != 1) {
            this.log.log(Level.SEVERE, "Cycle NOT inserted");
        }
        int C_Project_ID = this.getNextID(this.getAD_Client_ID(), "C_Project");
        sqlCmd = new StringBuffer("INSERT INTO C_Project ");
        sqlCmd.append("(C_Project_ID,").append(this.m_stdColumns).append(",");
        sqlCmd.append(" Value,Name,C_Currency_ID,IsSummary,C_Project_UU) VALUES (");
        sqlCmd.append(C_Project_ID).append(",").append(this.m_stdValuesOrg).append(", ");
        sqlCmd.append(defaultEntry).append(defaultEntry).append(C_Currency_ID).append(",'N'").append(",").append(DB.TO_STRING(UUID.randomUUID().toString())).append(")");
        no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
        if (no == 1) {
            this.m_info.append(Msg.translate(this.m_lang, "C_Project_ID")).append("=").append(defaultName).append("\n");
        } else {
            this.log.log(Level.SEVERE, "Project NOT inserted");
        }
        if (this.m_hasProject) {
            sqlCmd = new StringBuffer("UPDATE C_AcctSchema_Element SET ");
            sqlCmd.append("C_Project_ID=").append(C_Project_ID);
            sqlCmd.append(" WHERE C_AcctSchema_ID=").append(this.m_as.getC_AcctSchema_ID());
            sqlCmd.append(" AND ElementType='PJ'");
            no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
            if (no != 1) {
                this.log.log(Level.SEVERE, "AcctSchema Element Project NOT updated");
            }
        }
        MCashBook cb = new MCashBook(this.m_ctx, 0, this.m_trx.getTrxName());
        cb.setName(defaultName);
        cb.setC_Currency_ID(C_Currency_ID);
        if (cb.save()) {
            this.m_info.append(Msg.translate(this.m_lang, "C_CashBook_ID")).append("=").append(defaultName).append("\n");
        } else {
            this.log.log(Level.SEVERE, "CashBook NOT inserted");
        }
        boolean success = this.m_trx.commit();
        this.m_trx.close();
        this.log.info("finish");
        return success;
    }

    private void createPreference(String Attribute2, String Value, int AD_Window_ID) {
        int AD_Preference_ID = this.getNextID(this.getAD_Client_ID(), "AD_Preference");
        StringBuilder sqlCmd = new StringBuilder("INSERT INTO AD_Preference ");
        sqlCmd.append("(AD_Preference_ID,").append("AD_Preference_UU,").append(this.m_stdColumns).append(",");
        sqlCmd.append("Attribute,Value,AD_Window_ID) VALUES (");
        sqlCmd.append(AD_Preference_ID).append(",").append(DB.TO_STRING(UUID.randomUUID().toString())).append(",").append(this.m_stdValues).append(",");
        sqlCmd.append("'").append(Attribute2).append("','").append(Value).append("',");
        if (AD_Window_ID == 0) {
            sqlCmd.append("NULL)");
        } else {
            sqlCmd.append(AD_Window_ID).append(")");
        }
        int no = DB.executeUpdateEx(sqlCmd.toString(), this.m_trx.getTrxName());
        if (no != 1) {
            this.log.log(Level.SEVERE, "Preference NOT inserted - " + Attribute2);
        }
    }

    private int getNextID(int AD_Client_ID, String TableName) {
        return DB.getNextID(AD_Client_ID, TableName, this.m_trx.getTrxName());
    }

    public int getAD_Client_ID() {
        return this.m_client.getAD_Client_ID();
    }

    public int getAD_Org_ID() {
        return this.m_org.getAD_Org_ID();
    }

    public int getAD_User_ID() {
        return this.AD_User_ID;
    }

    public String getInfo() {
        return this.m_info.toString();
    }

    public void rollback() {
        try {
            this.m_trx.rollback();
            this.m_trx.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

