/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.AdempiereProcessor2;
import org.compiere.model.AdempiereProcessorLog;
import org.compiere.model.MProcess;
import org.compiere.model.MSchedule;
import org.compiere.model.MSchedulerLog;
import org.compiere.model.MSchedulerPara;
import org.compiere.model.MSchedulerRecipient;
import org.compiere.model.MTable;
import org.compiere.model.MUserRoles;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Scheduler;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MScheduler
extends X_AD_Scheduler
implements AdempiereProcessor,
AdempiereProcessor2 {
    private static final long serialVersionUID = 5106574386025319255L;
    private MSchedulerPara[] m_parameter = null;
    private MSchedulerRecipient[] m_recipients = null;

    public static MScheduler[] getActive(Properties ctx) {
        List<MScheduler> list = new Query(ctx, "AD_Scheduler", null, null).setOnlyActiveRecords(true).list();
        MScheduler[] retValue = new MScheduler[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MScheduler(Properties ctx, int AD_Scheduler_ID, String trxName) {
        super(ctx, AD_Scheduler_ID, trxName);
        if (AD_Scheduler_ID == 0) {
            this.setKeepLogDays(7);
        }
    }

    public MScheduler(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String getServerID() {
        return "Scheduler" + this.get_ID();
    }

    @Override
    public Timestamp getDateNextRun(boolean requery) {
        if (requery) {
            this.load(this.get_TrxName());
        }
        return this.getDateNextRun();
    }

    @Override
    public AdempiereProcessorLog[] getLogs() {
        String whereClause = "AD_Scheduler_ID=?";
        List<AdempiereProcessorLog> list = new Query(this.getCtx(), "AD_SchedulerLog", "AD_Scheduler_ID=?", this.get_TrxName()).setParameters(this.getAD_Scheduler_ID()).setOrderBy("Created DESC").list();
        AdempiereProcessorLog[] retValue = new MSchedulerLog[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int deleteLog() {
        if (this.getKeepLogDays() < 1) {
            return 0;
        }
        String sql = "DELETE AD_SchedulerLog WHERE AD_Scheduler_ID=" + this.getAD_Scheduler_ID() + " AND (Created+" + this.getKeepLogDays() + ") < SysDate";
        int no = DB.executeUpdateEx(sql, this.get_TrxName());
        return no;
    }

    public MProcess getProcess() {
        return MProcess.get(this.getCtx(), this.getAD_Process_ID());
    }

    public MSchedulerPara[] getParameters(boolean reload) {
        if (!reload && this.m_parameter != null) {
            return this.m_parameter;
        }
        String whereClause = "AD_Scheduler_ID=?";
        List<MSchedulerPara> list = new Query(this.getCtx(), "AD_Scheduler_Para", "AD_Scheduler_ID=?", this.get_TrxName()).setParameters(this.getAD_Scheduler_ID()).setOnlyActiveRecords(true).list();
        this.m_parameter = new MSchedulerPara[list.size()];
        list.toArray(this.m_parameter);
        return this.m_parameter;
    }

    public MSchedulerRecipient[] getRecipients(boolean reload) {
        if (!reload && this.m_recipients != null) {
            return this.m_recipients;
        }
        String whereClause = "AD_Scheduler_ID=?";
        List<MSchedulerRecipient> list = new Query(this.getCtx(), "AD_SchedulerRecipient", "AD_Scheduler_ID=?", this.get_TrxName()).setParameters(this.getAD_Scheduler_ID()).setOnlyActiveRecords(true).list();
        this.m_recipients = new MSchedulerRecipient[list.size()];
        list.toArray(this.m_recipients);
        return this.m_recipients;
    }

    public Integer[] getRecipientAD_User_IDs() {
        TreeSet<Integer> list = new TreeSet<Integer>();
        MSchedulerRecipient[] recipients = this.getRecipients(false);
        int i2 = 0;
        while (i2 < recipients.length) {
            MSchedulerRecipient recipient = recipients[i2];
            if (recipient.isActive()) {
                if (recipient.getAD_User_ID() != 0) {
                    list.add(recipient.getAD_User_ID());
                }
                if (recipient.getAD_Role_ID() != 0) {
                    MUserRoles[] urs = MUserRoles.getOfRole(this.getCtx(), recipient.getAD_Role_ID());
                    int j = 0;
                    while (j < urs.length) {
                        MUserRoles ur = urs[j];
                        if (ur.isActive() && !list.contains(ur.getAD_User_ID())) {
                            list.add(ur.getAD_User_ID());
                        }
                        ++j;
                    }
                }
            }
            ++i2;
        }
        return list.toArray(new Integer[list.size()]);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        long nextWork;
        if (this.getAD_Table_ID() > 0) {
            int colid = new Query(this.getCtx(), "AD_Column", "AD_Table_ID=? AND AD_Reference_ID=? AND AD_Process_ID=?", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.getAD_Table_ID(), 28, this.getAD_Process_ID()).firstId();
            if (colid <= 0) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), "TableMustHaveProcessButton"));
                return false;
            }
        } else {
            this.setRecord_ID(-1);
        }
        if (this.getRecord_ID() != 0) {
            if (this.getAD_Table_ID() <= 0) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), "MustFillTable"));
                return false;
            }
            MTable table2 = MTable.get(this.getCtx(), this.getAD_Table_ID());
            PO po = table2.getPO(this.getRecord_ID(), this.get_TrxName());
            if (po == null || po.get_ID() <= 0 || po.getAD_Client_ID() != this.getAD_Client_ID()) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), "NoRecordID"));
                return false;
            }
        }
        if ((newRecord || this.is_ValueChanged("AD_Schedule_ID")) && (nextWork = MSchedule.getNextRunMS(System.currentTimeMillis(), this.getScheduleType(), this.getFrequencyType(), this.getFrequency(), this.getCronPattern())) > 0L) {
            this.setDateNextRun(new Timestamp(nextWork));
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MScheduler[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    @Override
    public String getFrequencyType() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).getFrequencyType();
    }

    @Override
    public int getFrequency() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).getFrequency();
    }

    @Override
    public boolean isIgnoreProcessingTime() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).isIgnoreProcessingTime();
    }

    @Override
    public String getScheduleType() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).getScheduleType();
    }

    @Override
    public String getCronPattern() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).getCronPattern();
    }
}

