/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MRevenueRecogService;
import org.compiere.model.MRevenueRecognition;
import org.compiere.model.MRevenueRecognitionRun;
import org.compiere.model.X_C_RevenueRecognition_Plan;
import org.compiere.model.X_C_RevenueRecognition_Run;
import org.compiere.util.Env;

public class MRevenueRecognitionPlan
extends X_C_RevenueRecognition_Plan {
    private static final long serialVersionUID = -8437258098744762898L;

    public MRevenueRecognitionPlan(Properties ctx, int C_RevenueRecognition_Plan_ID, String trxName) {
        super(ctx, C_RevenueRecognition_Plan_ID, trxName);
        if (C_RevenueRecognition_Plan_ID == 0) {
            this.setTotalAmt(Env.ZERO);
            this.setRecognizedAmt(Env.ZERO);
        }
    }

    public MRevenueRecognitionPlan(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord) {
            MRevenueRecognition rr = new MRevenueRecognition(this.getCtx(), this.getC_RevenueRecognition_ID(), this.get_TrxName());
            if (rr.isTimeBased()) {
                MInvoiceLine il = (MInvoiceLine)this.getC_InvoiceLine();
                Calendar cal = Calendar.getInstance();
                Timestamp startDate = new Timestamp(cal.getTimeInMillis());
                if (il.getRRStartDate() != null) {
                    startDate = il.getRRStartDate();
                } else if (il.getParent().getDateInvoiced() != null) {
                    startDate = il.getParent().getDateInvoiced();
                }
                cal.setTimeInMillis(startDate.getTime());
                int interval = 1;
                if ("Q".equals(rr.getRecognitionFrequency())) {
                    interval = 3;
                } else if ("Y".equals(rr.getRecognitionFrequency())) {
                    interval = 12;
                }
                int periods = rr.getNoMonths();
                BigDecimal amt = this.getTotalAmt().divide(new BigDecimal(String.valueOf(periods)), RoundingMode.HALF_UP);
                BigDecimal total = Env.ZERO;
                BigDecimal startAmt = amt;
                int monthOffset = cal.get(2);
                double startDay = cal.get(5);
                if ("M".equals(rr.getRecognitionFrequency()) && rr.getFixedRecogDay() != 0) {
                    double daysInMonth = cal.getActualMaximum(5);
                    ++periods;
                    double totalDays = (double)rr.getFixedRecogDay() > daysInMonth ? daysInMonth : (double)rr.getFixedRecogDay();
                    double noDays = totalDays - (startDay - 1.0);
                    if (noDays <= 0.0) {
                        ++monthOffset;
                        noDays += daysInMonth;
                    }
                    BigDecimal proportion = new BigDecimal(noDays / daysInMonth);
                    startAmt = amt.multiply(proportion);
                    startAmt = startAmt.setScale(2, RoundingMode.HALF_UP);
                    cal.set(5, rr.getFixedRecogDay());
                }
                cal.set(2, 0);
                int i2 = 0;
                while (i2 <= periods - 1) {
                    Calendar cal2 = Calendar.getInstance();
                    cal2.setTimeInMillis(cal.getTimeInMillis());
                    cal2.add(2, interval * i2 + monthOffset);
                    MRevenueRecognitionRun run = new MRevenueRecognitionRun(this.getCtx(), 0, this.get_TrxName());
                    run.setClientOrg(this);
                    run.setC_RevenueRecognition_Plan_ID(this.getC_RevenueRecognition_Plan_ID());
                    run.setDateRecognized(new Timestamp(cal2.getTimeInMillis()));
                    BigDecimal recogAmt = amt;
                    if (i2 == 0) {
                        recogAmt = startAmt;
                    }
                    if (i2 == periods - 1) {
                        recogAmt = this.getTotalAmt().subtract(total);
                    }
                    run.setRecognizedAmt(recogAmt);
                    if (recogAmt.signum() != 0) {
                        run.saveEx();
                    }
                    total = total.add(recogAmt);
                    ++i2;
                }
            } else {
                List<MRevenueRecogService> services = rr.getServicesList();
                BigDecimal totalAmt = Env.ZERO;
                X_C_RevenueRecognition_Run last = null;
                for (MRevenueRecogService service : services) {
                    BigDecimal recogAmt = this.getTotalAmt().multiply(service.getPercent()).divide(Env.ONEHUNDRED, 4, RoundingMode.HALF_UP);
                    MRevenueRecognitionRun run = new MRevenueRecognitionRun(this.getCtx(), 0, this.get_TrxName());
                    run.setClientOrg(this);
                    run.setC_RevenueRecognition_Plan_ID(this.getC_RevenueRecognition_Plan_ID());
                    run.setRecognizedAmt(recogAmt);
                    run.setC_RevenueRecog_Service_ID(service.getC_RevenueRecog_Service_ID());
                    run.saveEx();
                    last = run;
                    totalAmt = totalAmt.add(recogAmt);
                }
                if (this.getTotalAmt().subtract(totalAmt).compareTo(Env.ZERO) != 0) {
                    last.setRecognizedAmt(last.getRecognizedAmt().add(this.getTotalAmt().subtract(totalAmt)));
                    last.saveEx();
                }
            }
        }
        return success;
    }
}

