/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Service;
import org.adempiere.base.event.EventManager;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MUserDefWin;
import org.compiere.model.MWindow;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_AD_RecentItem;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.idempiere.distributed.IMessageService;
import org.idempiere.distributed.ITopic;
import org.osgi.service.event.Event;

public class MRecentItem
extends X_AD_RecentItem {
    private static final long serialVersionUID = -311416268128338337L;
    public static final String ON_RECENT_ITEM_CHANGED_TOPIC = "onRecentItemChanged";
    private static CCache<String, MRecentItem> s_cache = new CCache("AD_RecentItem", 10);
    private static CLogger s_log = CLogger.getCLogger(MRecentItem.class);
    private String m_label;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MRecentItem(Properties ctx, int AD_RecentItem_ID, String trxName) {
        super(ctx, AD_RecentItem_ID, trxName);
        if (AD_RecentItem_ID <= 0) return;
        Class<MRecentItem> clazz = MRecentItem.class;
        synchronized (MRecentItem.class) {
            String key = MRecentItem.getCacheKey(AD_RecentItem_ID, ctx);
            if (s_cache.containsKey(key)) return;
            s_cache.put(key, this);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private static String getCacheKey(int AD_RecentItem_ID, Properties ctx) {
        return String.valueOf(AD_RecentItem_ID) + "|" + Env.getAD_Language(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MRecentItem(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        String key = null;
        try {
            key = MRecentItem.getCacheKey(rs.getInt("AD_RecentItem_ID"), ctx);
        }
        catch (SQLException e) {
            throw new AdempiereException(e);
        }
        Class<MRecentItem> clazz = MRecentItem.class;
        synchronized (MRecentItem.class) {
            if (key != null && !s_cache.containsKey(key)) {
                s_cache.put(key, this);
            }
            // ** MonitorExit[var5_6] (shouldn't be in output)
            return;
        }
    }

    public static synchronized MRecentItem get(Properties ctx, int AD_RecentItem_ID) {
        String ii = MRecentItem.getCacheKey(AD_RecentItem_ID, ctx);
        MRecentItem ri = s_cache.get(ii);
        if (ri == null) {
            ri = new MRecentItem(ctx, AD_RecentItem_ID, null);
        }
        return ri;
    }

    public static synchronized MRecentItem get(Properties ctx, int AD_Table_ID, int Record_ID, int AD_User_ID) {
        MRecentItem retValue2;
        for (MRecentItem retValue2 : s_cache.values()) {
            if (retValue2.getAD_Table_ID() != AD_Table_ID || retValue2.getRecord_ID() != Record_ID || retValue2.getAD_User_ID() != AD_User_ID || !Env.getAD_Language(ctx).equals(Env.getAD_Language(retValue2.getCtx()))) continue;
            return retValue2;
        }
        retValue2 = null;
        String sql = "SELECT * FROM AD_RecentItem WHERE AD_Table_ID=? AND Record_ID=? AND NVL(AD_User_ID,0)=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, AD_Table_ID);
                pstmt.setInt(2, Record_ID);
                pstmt.setInt(3, AD_User_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    retValue2 = new MRecentItem(ctx, rs, null);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new AdempiereException(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (retValue2 != null) {
            String key = MRecentItem.getCacheKey(retValue2.getAD_RecentItem_ID(), ctx);
            s_cache.put(key, retValue2);
        }
        return retValue2;
    }

    public static void addModifiedField(Properties ctx, int AD_Table_ID, int Record_ID, int AD_User_ID, int AD_Role_ID, int AD_Window_ID, int AD_Tab_ID) {
        int maxri = MSysConfig.getIntValue("RecentItems_MaxSaved", 50, Env.getAD_Client_ID(ctx));
        if (maxri <= 0) {
            return;
        }
        MRecentItem ri = MRecentItem.get(ctx, AD_Table_ID, Record_ID, AD_User_ID);
        if (ri == null) {
            ri = new MRecentItem(ctx, 0, null);
            ri.setAD_Table_ID(AD_Table_ID);
            ri.setRecord_ID(Record_ID);
            ri.setAD_User_ID(AD_User_ID);
            ri.setAD_Role_ID(AD_Role_ID);
            ri.setAD_Window_ID(AD_Window_ID);
            ri.setAD_Tab_ID(AD_Tab_ID);
            ri.saveEx();
        } else if (ri.getAD_Role_ID() != AD_Role_ID || ri.getAD_Window_ID() != AD_Window_ID || ri.getAD_Tab_ID() != AD_Tab_ID) {
            ri.setAD_Role_ID(AD_Role_ID);
            ri.setAD_Window_ID(AD_Window_ID);
            ri.setAD_Tab_ID(AD_Tab_ID);
            ri.saveEx();
        } else {
            DB.executeUpdateEx("UPDATE AD_RecentItem SET Updated=SYSDATE WHERE AD_RecentItem_ID=?", new Object[]{ri.getAD_RecentItem_ID()}, null);
        }
        MRecentItem.publishChangedEvent(AD_User_ID);
    }

    public static void publishChangedEvent(int AD_User_ID) {
        IMessageService service = Service.locator().locate(IMessageService.class).getService();
        if (service != null) {
            ITopic<Integer> topic = service.getTopic(ON_RECENT_ITEM_CHANGED_TOPIC);
            topic.publish(AD_User_ID);
        } else {
            MRecentItem.postOnChangedEvent(AD_User_ID);
        }
    }

    public static void postOnChangedEvent(int AD_User_ID) {
        HashMap<String, Integer> properties = new HashMap<String, Integer>();
        properties.put("AD_User_ID", AD_User_ID);
        Event event = new Event(ON_RECENT_ITEM_CHANGED_TOPIC, properties);
        EventManager.getInstance().postEvent(event);
    }

    public static void touchUpdatedRecord(Properties ctx, int AD_Table_ID, int Record_ID, int AD_User_ID) {
        MRecentItem ri = MRecentItem.get(ctx, AD_Table_ID, Record_ID, AD_User_ID);
        if (ri != null) {
            DB.executeUpdateEx("UPDATE AD_RecentItem SET Updated=SYSDATE WHERE AD_RecentItem_ID=?", new Object[]{ri.getAD_RecentItem_ID()}, null);
            MRecentItem.deleteExtraRecentItems(ctx, AD_User_ID);
            MRecentItem.publishChangedEvent(AD_User_ID);
        }
    }

    private static void deleteExtraRecentItems(Properties ctx, int AD_User_ID) {
        int cntri;
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        int maxri = MSysConfig.getIntValue("RecentItems_MaxSaved", 50, AD_Client_ID);
        if (maxri < 0) {
            maxri = 0;
        }
        if ((cntri = DB.getSQLValue(null, "SELECT COUNT(*) FROM AD_RecentItem WHERE NVL(AD_User_ID,0)=? AND AD_Client_ID=?", AD_User_ID, AD_Client_ID)) > maxri) {
            int cntdel = cntri - maxri;
            String sql = "SELECT AD_Table_ID, Record_ID FROM AD_RecentItem WHERE NVL(AD_User_ID,0)=? AND AD_Client_ID=? ORDER BY Updated";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, AD_User_ID);
                    pstmt.setInt(2, AD_Client_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int AD_Table_ID = rs.getInt(1);
                        int Record_ID = rs.getInt(2);
                        MRecentItem ri = MRecentItem.get(ctx, AD_Table_ID, Record_ID, AD_User_ID);
                        ri.deleteEx(true);
                        if (--cntdel != 0) {
                            continue;
                        }
                        break;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new AdempiereException(e);
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(boolean force) {
        String ii = MRecentItem.getCacheKey(this.getAD_RecentItem_ID(), this.getCtx());
        Class<MRecentItem> clazz = MRecentItem.class;
        synchronized (MRecentItem.class) {
            s_cache.remove(ii);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return super.delete(force);
        }
    }

    public static List<MRecentItem> getFromUser(Properties ctx, int AD_User_ID) {
        int[] ids = new Query(ctx, "AD_RecentItem", "NVL(AD_User_ID,0)=?", null).setOnlyActiveRecords(true).setClient_ID().setParameters(AD_User_ID).setOrderBy("Updated DESC").getIDs();
        ArrayList<MRecentItem> ris = new ArrayList<MRecentItem>();
        int[] nArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            ris.add(MRecentItem.get(ctx, id));
            ++n2;
        }
        return ris;
    }

    public String getLabel() {
        if (this.m_label != null) {
            return this.m_label;
        }
        MWindow win = MWindow.get(this.getCtx(), this.getAD_Window_ID());
        MUserDefWin userDef = MUserDefWin.getBestMatch(this.getCtx(), this.getAD_Window_ID());
        String windowName = userDef != null && !Util.isEmpty(userDef.getName()) ? userDef.getName() : win.get_Translation("Name");
        MTable table2 = MTable.get(this.getCtx(), this.getAD_Table_ID());
        PO po = table2.getPO(this.getRecord_ID(), null);
        if (po == null) {
            this.deleteEx(true, null);
            return null;
        }
        String titleLogic = win.getTitleLogic();
        StringBuilder recordIdentifier = new StringBuilder("");
        if (!Util.isEmpty(titleLogic) && !Util.isEmpty(titleLogic = Env.parseVariable(titleLogic, po, null, false))) {
            recordIdentifier.append(" ").append(titleLogic);
        }
        if (recordIdentifier.length() == 0) {
            if (po.get_ColumnIndex("DocumentNo") != -1) {
                recordIdentifier.append(" ").append(po.get_ValueAsString("DocumentNo"));
            }
            if (po.get_ColumnIndex("Value") != -1) {
                recordIdentifier.append(" ").append(po.get_ValueAsString("Value"));
            }
            if (po.get_ColumnIndex("Name") != -1) {
                recordIdentifier.append(" ").append(po.get_ValueAsString("Name"));
            }
            if (recordIdentifier.length() == 0) {
                recordIdentifier.append(" ").append(po.toString());
            }
            if (recordIdentifier.length() == 0) {
                recordIdentifier.append(" [").append(po.get_ID()).append("]");
            }
            if (recordIdentifier.length() == 0) {
                recordIdentifier.append(" [no identifier]");
            }
        }
        this.m_label = String.valueOf(windowName) + ": " + recordIdentifier.substring(1);
        if (s_log.isLoggable(Level.INFO)) {
            s_log.info(this.m_label);
        }
        return this.m_label;
    }

    public static synchronized void clearLabel(int AD_Table_ID, int Record_ID) {
        for (MRecentItem retValue : s_cache.values()) {
            if (retValue.getAD_Table_ID() != AD_Table_ID || retValue.getRecord_ID() != Record_ID) continue;
            retValue.clearLabel();
        }
    }

    private void clearLabel() {
        this.m_label = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MRecentItem[").append(this.get_ID()).append("]=").append(this.getLabel());
        return sb.toString();
    }
}

