/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MRMALine;
import org.compiere.model.MTax;
import org.compiere.model.X_M_RMATax;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MRMATax
extends X_M_RMATax {
    private static final long serialVersionUID = -8702466449639865049L;
    private static CLogger s_log = CLogger.getCLogger(MRMATax.class);
    private MTax m_tax = null;
    private Integer m_precision = null;

    public static MRMATax get(MRMALine line, int precision, boolean oldTax, String trxName) {
        boolean isOldTax;
        MRMATax retValue;
        block14: {
            retValue = null;
            if (line == null || line.getM_RMA_ID() == 0) {
                s_log.fine("No RMA");
                return null;
            }
            int C_Tax_ID = line.getC_Tax_ID();
            boolean bl = isOldTax = oldTax && line.is_ValueChanged("C_Tax_ID");
            if (isOldTax) {
                Object old = line.get_ValueOld("C_Tax_ID");
                if (old == null) {
                    s_log.fine("No Old Tax");
                    return null;
                }
                C_Tax_ID = (Integer)old;
            }
            if (C_Tax_ID == 0) {
                s_log.fine("No Tax");
                return null;
            }
            String sql = "SELECT * FROM M_RMATax WHERE M_RMA_ID=? AND C_Tax_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, line.getM_RMA_ID());
                    pstmt.setInt(2, C_Tax_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = new MRMATax(line.getCtx(), rs, trxName);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block14;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue != null) {
            retValue.setPrecision(precision);
            retValue.set_TrxName(trxName);
            if (s_log.isLoggable(Level.FINE)) {
                s_log.fine("(old=" + oldTax + ") " + retValue);
            }
            return retValue;
        }
        if (isOldTax) {
            return null;
        }
        retValue = new MRMATax(line.getCtx(), 0, trxName);
        retValue.set_TrxName(trxName);
        retValue.setClientOrg(line);
        retValue.setM_RMA_ID(line.getM_RMA_ID());
        retValue.setC_Tax_ID(line.getC_Tax_ID());
        retValue.setPrecision(precision);
        retValue.setIsTaxIncluded(line.getParent().isTaxIncluded());
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("(new) " + retValue);
        }
        return retValue;
    }

    public MRMATax(Properties ctx, int ignored, String trxName) {
        super(ctx, 0, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
        this.setTaxAmt(Env.ZERO);
        this.setTaxBaseAmt(Env.ZERO);
        this.setIsTaxIncluded(false);
    }

    public MRMATax(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    private int getPrecision() {
        if (this.m_precision == null) {
            return 2;
        }
        return this.m_precision;
    }

    protected void setPrecision(int precision) {
        this.m_precision = precision;
    }

    protected MTax getTax() {
        if (this.m_tax == null) {
            this.m_tax = MTax.get(this.getCtx(), this.getC_Tax_ID());
        }
        return this.m_tax;
    }

    public boolean calculateTaxFromLines() {
        MTax tax;
        boolean documentLevel;
        BigDecimal taxAmt;
        BigDecimal taxBaseAmt;
        block11: {
            taxBaseAmt = Env.ZERO;
            taxAmt = Env.ZERO;
            documentLevel = this.getTax().isDocumentLevel();
            tax = this.getTax();
            String sql = "SELECT LineNetAmt FROM M_RMALine WHERE M_RMA_ID=? AND C_Tax_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getM_RMA_ID());
                    pstmt.setInt(2, this.getC_Tax_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        BigDecimal baseAmt = rs.getBigDecimal(1);
                        taxBaseAmt = taxBaseAmt.add(baseAmt);
                        if (documentLevel) continue;
                        taxAmt = taxAmt.add(tax.calculateTax(baseAmt, this.isTaxIncluded(), this.getPrecision()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, this.get_TrxName(), e);
                    taxBaseAmt = null;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (taxBaseAmt == null) {
            return false;
        }
        if (documentLevel) {
            taxAmt = tax.calculateTax(taxBaseAmt, this.isTaxIncluded(), this.getPrecision());
        }
        this.setTaxAmt(taxAmt);
        if (this.isTaxIncluded()) {
            this.setTaxBaseAmt(taxBaseAmt.subtract(taxAmt));
        } else {
            this.setTaxBaseAmt(taxBaseAmt);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.toString());
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MRMATax[").append("M_RMA_ID=").append(this.getM_RMA_ID()).append(", C_Tax_ID=").append(this.getC_Tax_ID()).append(", Base=").append(this.getTaxBaseAmt()).append(", Tax=").append(this.getTaxAmt()).append("]");
        return sb.toString();
    }
}

