/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.base.Core;
import org.adempiere.base.IProductPricing;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.ITaxProvider;
import org.compiere.model.MCharge;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MRMA;
import org.compiere.model.MRMATax;
import org.compiere.model.MTax;
import org.compiere.model.MTaxProvider;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.model.Tax;
import org.compiere.model.X_M_RMALine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MRMALine
extends X_M_RMALine {
    private static final long serialVersionUID = 3088864372141663734L;
    protected MInOutLine m_ioLine = null;
    protected MProduct m_product = null;
    protected MCharge m_charge = null;
    protected MTax m_tax = null;
    protected MRMA m_parent = null;
    protected int precision = 0;
    protected BigDecimal unitAmount = Env.ZERO;
    protected BigDecimal originalQty = Env.ZERO;
    protected int taxId = 0;

    public MRMALine(Properties ctx, int M_RMALine_ID, String trxName) {
        super(ctx, M_RMALine_ID, trxName);
        if (M_RMALine_ID == 0) {
            this.setQty(Env.ONE);
            this.setQtyDelivered(Env.ZERO);
        }
        this.init();
    }

    public MRMALine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.init();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void init() {
        this.getShipLine();
        if (this.m_ioLine != null) {
            if (this.getInvoiceLineId() != 0) {
                MInvoiceLine invoiceLine = new MInvoiceLine(this.getCtx(), this.getInvoiceLineId(), this.get_TrxName());
                this.precision = invoiceLine.getPrecision();
                this.unitAmount = invoiceLine.getPriceEntered();
                this.originalQty = invoiceLine.getQtyInvoiced();
                this.taxId = invoiceLine.getC_Tax_ID();
                return;
            } else {
                if (this.m_ioLine.getC_OrderLine_ID() == 0) throw new IllegalStateException("No Invoice/Order line found the Shipment/Receipt line associated");
                MOrderLine orderLine = new MOrderLine(this.getCtx(), this.m_ioLine.getC_OrderLine_ID(), this.get_TrxName());
                this.precision = orderLine.getPrecision();
                this.unitAmount = orderLine.getPriceEntered();
                this.originalQty = orderLine.getQtyDelivered();
                this.taxId = orderLine.getC_Tax_ID();
            }
            return;
        } else if (this.getC_Charge_ID() != 0) {
            MCharge charge = MCharge.get(this.getCtx(), this.getC_Charge_ID());
            this.unitAmount = charge.getChargeAmt();
            MInvoice invoice = this.getParent().getOriginalInvoice();
            if (invoice != null) {
                this.precision = invoice.getPrecision();
            } else {
                MOrder order = this.getParent().getOriginalOrder();
                if (order == null) throw new IllegalStateException("No Invoice/Order found the Shipment/Receipt associated");
                this.precision = order.getPrecision();
            }
            String sql = "SELECT C_Tax_ID FROM C_Tax WHERE AD_Client_ID=? AND IsActive='Y' AND IsTaxExempt='Y' AND ValidFrom < SYSDATE ORDER BY IsDefault DESC";
            this.taxId = DB.getSQLValueEx(null, sql, Env.getAD_Client_ID(this.getCtx()));
            this.m_ioLine = null;
            return;
        } else {
            if (this.getM_Product_ID() == 0) return;
            IProductPricing pp = Core.getProductPricing();
            pp.setRMALine(this, this.get_TrxName());
            MInvoice invoice = this.getParent().getOriginalInvoice();
            if (invoice != null) {
                pp.setM_PriceList_ID(invoice.getM_PriceList_ID());
                pp.setPriceDate(invoice.getDateInvoiced());
                this.precision = invoice.getPrecision();
                this.taxId = Tax.get(this.getCtx(), this.getM_Product_ID(), this.getC_Charge_ID(), invoice.getDateInvoiced(), invoice.getDateInvoiced(), this.getAD_Org_ID(), this.getParent().getShipment().getM_Warehouse_ID(), invoice.getC_BPartner_Location_ID(), invoice.getC_BPartner_Location_ID(), this.getParent().isSOTrx(), this.get_TrxName());
            } else {
                MOrder order = this.getParent().getOriginalOrder();
                if (order == null) throw new IllegalStateException("No Invoice/Order found the Shipment/Receipt associated");
                pp.setM_PriceList_ID(order.getM_PriceList_ID());
                pp.setPriceDate(order.getDateOrdered());
                this.precision = order.getPrecision();
                this.taxId = Tax.get(this.getCtx(), this.getM_Product_ID(), this.getC_Charge_ID(), order.getDateOrdered(), order.getDateOrdered(), this.getAD_Org_ID(), order.getM_Warehouse_ID(), order.getC_BPartner_Location_ID(), order.getC_BPartner_Location_ID(), this.getParent().isSOTrx(), this.get_TrxName());
            }
            pp.calculatePrice();
            this.unitAmount = pp.getPriceStd();
            this.m_ioLine = null;
        }
    }

    public MRMA getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MRMA(this.getCtx(), this.getM_RMA_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    @Override
    public void setM_InOutLine_ID(int M_InOutLine_ID) {
        super.setM_InOutLine_ID(M_InOutLine_ID);
        this.m_ioLine = null;
    }

    public MInOutLine getShipLine() {
        if ((this.m_ioLine == null || this.is_ValueChanged("M_InOutLine_ID")) && this.getM_InOutLine_ID() != 0) {
            this.m_ioLine = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
        }
        return this.m_ioLine;
    }

    protected int getInvoiceLineId() {
        int invoiceLine_ID = new Query(this.getCtx(), "C_InvoiceLine", "M_InOutLine_ID=?", this.get_TrxName()).setParameters(this.getM_InOutLine_ID()).firstId();
        return invoiceLine_ID <= 0 ? 0 : invoiceLine_ID;
    }

    public BigDecimal getUnitAmt() {
        return this.unitAmount;
    }

    public BigDecimal getTotalAmt() {
        BigDecimal bd = this.getAmt().multiply(this.getQty());
        int precision = this.getPrecision();
        if (bd.scale() > precision) {
            bd = bd.setScale(precision, RoundingMode.HALF_UP);
        }
        return bd;
    }

    public boolean isShipLineInvoiced() {
        return this.getInvoiceLineId() != 0;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord && this.getParent().isComplete()) {
            this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "M_RMA"));
            return false;
        }
        if (this.getM_InOutLine_ID() == 0 && this.getC_Charge_ID() == 0 && this.getM_Product_ID() == 0) {
            this.log.saveError("FillShipLineOrProductOrCharge", "");
            return false;
        }
        if (this.getM_Product_ID() != 0 && this.getC_Charge_ID() != 0) {
            this.log.saveError("JustProductOrCharge", "");
            return false;
        }
        this.init();
        if (this.m_ioLine != null) {
            String whereClause;
            int[] lineIds;
            if (!this.checkQty()) {
                this.log.saveError("AmtReturned>Shipped", "");
                return false;
            }
            if ((newRecord || this.is_ValueChanged("M_InOutLine_ID")) && (lineIds = MRMALine.getAllIDs("M_RMALine", whereClause = "M_RMA_ID=" + this.getM_RMA_ID() + " AND M_InOutLine_ID=" + this.getM_InOutLine_ID() + " AND M_RMALine_ID!=" + this.getM_RMALine_ID(), this.get_TrxName())).length > 0) {
                this.log.saveError("InOutLineAlreadyEntered", "");
                return false;
            }
        }
        if (this.getM_Product_ID() != 0 && this.getQty().doubleValue() <= 0.0 && !"VO".equals(this.getParent().getDocAction())) {
            if (this.getQty().signum() == 0) {
                this.setQty(Env.ONE);
            }
            if (this.getAmt().signum() == 0) {
                this.setAmt(this.getUnitAmt());
            }
        }
        if (this.getC_Charge_ID() != 0 && this.getQty().doubleValue() <= 0.0 && !"VO".equals(this.getParent().getDocAction())) {
            if (this.getQty().signum() == 0) {
                this.setQty(Env.ONE);
            }
            if (this.getAmt().signum() == 0) {
                this.setAmt(this.getUnitAmt());
            }
        }
        if (this.getM_InOutLine_ID() != 0 && !"VO".equals(this.getParent().getDocAction())) {
            this.setM_Product_ID(this.m_ioLine.getM_Product_ID());
            this.setC_Charge_ID(this.m_ioLine.getC_Charge_ID());
            this.setAmt(this.getUnitAmt());
            if (newRecord && this.getQty().signum() == 0) {
                this.setQty(this.originalQty);
            }
        }
        if (this.getC_Tax_ID() == 0) {
            this.setC_Tax_ID(this.taxId);
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 FROM M_RMALine WHERE M_RMA_ID=?";
            int ii = DB.getSQLValue(this.get_TrxName(), sql, this.getM_RMA_ID());
            this.setLine(ii);
        }
        this.setLineNetAmt(this.getTotalAmt());
        return true;
    }

    public boolean checkQty() {
        if (this.m_ioLine.getMovementQty().compareTo(this.getQty()) < 0) {
            return false;
        }
        BigDecimal totalQty = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(Qty) FROM M_RMALine rl JOIN M_RMA r ON (r.M_RMA_ID = rl.M_RMA_ID) WHERE M_InOutLine_ID = ? AND M_RMALine_ID != ? AND r.Processed = 'Y' AND r.DocStatus IN ('CO','CL')", this.getM_InOutLine_ID(), this.getM_RMALine_ID());
        if (totalQty == null) {
            totalQty = Env.ZERO;
        }
        totalQty = totalQty.add(this.getQty());
        return this.m_ioLine.getMovementQty().compareTo(totalQty) >= 0;
    }

    protected boolean updateOrderTax(boolean oldTax) {
        MRMATax tax = MRMATax.get(this, this.getPrecision(), oldTax, this.get_TrxName());
        if (tax != null) {
            if (!tax.calculateTaxFromLines()) {
                return false;
            }
            if (tax.getTaxAmt().signum() != 0 ? !tax.save(this.get_TrxName()) : !tax.is_new() && !tax.delete(false, this.get_TrxName())) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        MTax tax = new MTax(this.getCtx(), this.getC_Tax_ID(), this.get_TrxName());
        MTaxProvider provider = new MTaxProvider(tax.getCtx(), tax.getC_TaxProvider_ID(), tax.get_TrxName());
        ITaxProvider calculator = Core.getTaxProvider(provider);
        if (calculator == null) {
            throw new AdempiereException(Msg.getMsg(this.getCtx(), "TaxNoProvider"));
        }
        return calculator.recalculateTax(provider, this, newRecord);
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        return this.updateHeaderAmt();
    }

    public boolean updateHeaderAmt() {
        if (this.isProcessed() && !this.is_ValueChanged("Processed")) {
            return true;
        }
        MTax tax = new MTax(this.getCtx(), this.getC_Tax_ID(), this.get_TrxName());
        MTaxProvider provider = new MTaxProvider(tax.getCtx(), tax.getC_TaxProvider_ID(), tax.get_TrxName());
        ITaxProvider calculator = Core.getTaxProvider(provider);
        if (calculator == null) {
            throw new AdempiereException(Msg.getMsg(this.getCtx(), "TaxNoProvider"));
        }
        if (!calculator.updateRMATax(provider, this)) {
            return false;
        }
        return calculator.updateHeaderTax(provider, this);
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(String.valueOf(desc) + " | " + description);
        }
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getC_UOM_ID() {
        if (this.m_ioLine == null && this.getC_Charge_ID() != 0) {
            return 100;
        }
        if (this.m_ioLine == null && this.getM_Product_ID() != 0) {
            MProduct product = this.getProduct();
            return product.getC_UOM_ID();
        }
        return this.m_ioLine.getC_UOM_ID();
    }

    public MProduct getProduct() {
        if (this.m_product == null && this.getM_Product_ID() != 0) {
            this.m_product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        }
        return this.m_product;
    }

    public MCharge getCharge() {
        if (this.m_charge == null && this.getC_Charge_ID() != 0) {
            this.m_charge = MCharge.get(this.getCtx(), this.getC_Charge_ID());
        }
        return this.m_charge;
    }

    protected MTax getTax() {
        if (this.m_tax == null) {
            this.m_tax = MTax.get(this.getCtx(), this.getC_Tax_ID());
        }
        return this.m_tax;
    }

    public int getC_Project_ID() {
        if (this.m_ioLine == null) {
            return 0;
        }
        return this.m_ioLine.getC_Project_ID();
    }

    public int getC_ProjectPhase_ID() {
        if (this.m_ioLine == null) {
            return 0;
        }
        return this.m_ioLine.getC_ProjectPhase_ID();
    }

    public int getC_ProjectTask_ID() {
        if (this.m_ioLine == null) {
            return 0;
        }
        return this.m_ioLine.getC_ProjectTask_ID();
    }

    public int getC_Activity_ID() {
        if (this.m_ioLine == null) {
            return 0;
        }
        return this.m_ioLine.getC_Activity_ID();
    }

    public int getC_Campaign_ID() {
        if (this.m_ioLine == null) {
            return 0;
        }
        return this.m_ioLine.getC_Campaign_ID();
    }

    public int getAD_OrgTrx_ID() {
        if (this.m_ioLine == null) {
            return 0;
        }
        return this.m_ioLine.getAD_OrgTrx_ID();
    }

    public int getUser1_ID() {
        if (this.m_ioLine == null) {
            return 0;
        }
        return this.m_ioLine.getUser1_ID();
    }

    public int getUser2_ID() {
        if (this.m_ioLine == null) {
            return 0;
        }
        return this.m_ioLine.getUser2_ID();
    }

    public int getM_AttributeSetInstance_ID() {
        if (this.m_ioLine == null) {
            return 0;
        }
        return this.m_ioLine.getM_AttributeSetInstance_ID();
    }

    public int getM_Locator_ID() {
        if (this.m_ioLine == null && this.getC_Charge_ID() != 0) {
            return 0;
        }
        if (this.m_ioLine == null && this.getM_Product_ID() != 0) {
            MInOut shipment = this.getParent().getShipment();
            MWarehouse warehouse = new MWarehouse(this.getCtx(), shipment.getM_Warehouse_ID(), this.get_TrxName());
            MLocator locator = MLocator.getDefault(warehouse);
            return locator.getM_Locator_ID();
        }
        return this.m_ioLine.getM_Locator_ID();
    }

    public void clearParent() {
        this.m_parent = null;
    }
}

