/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MTable;
import org.compiere.model.Restriction;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public class MQuery
implements Serializable {
    private static final long serialVersionUID = 481623650333512326L;
    private static CLogger s_log = CLogger.getCLogger(MQuery.class);
    private String m_TableName = "";
    private int m_AD_PInstance_ID = 0;
    private ArrayList<Restriction> m_list = new ArrayList();
    private int m_recordCount = 999999;
    private boolean m_newRecord = false;
    private static final String NEWRECORD = "2=3";
    private String m_zoomTable;
    private String m_zoomColumn;
    private Object m_zoomValue;
    public static final String EQUAL = "=";
    public static final int EQUAL_INDEX = 0;
    public static final String NOT_EQUAL = "!=";
    public static final int NOT_EQUAL_INDEX = 1;
    public static final String LIKE = " LIKE ";
    public static final String NOT_LIKE = " NOT LIKE ";
    public static final String GREATER = ">";
    public static final String GREATER_EQUAL = ">=";
    public static final String LESS = "<";
    public static final String LESS_EQUAL = "<=";
    public static final String BETWEEN = " BETWEEN ";
    public static final int BETWEEN_INDEX = 8;
    public static final String NOT_NULL = " IS NOT NULL ";
    public static final String NULL = " IS NULL ";
    public static final ValueNamePair[] OPERATORS = new ValueNamePair[]{new ValueNamePair("=", " = "), new ValueNamePair("!=", " != "), new ValueNamePair(" LIKE ", " ~ "), new ValueNamePair(" NOT LIKE ", " !~ "), new ValueNamePair(">", " > "), new ValueNamePair(">=", " >= "), new ValueNamePair("<", " < "), new ValueNamePair("<=", " <= "), new ValueNamePair(" BETWEEN ", " >-< "), new ValueNamePair(" IS NULL ", " NULL "), new ValueNamePair(" IS NOT NULL ", " !NULL ")};
    public static final ValueNamePair[] OPERATORS_LOOKUP = new ValueNamePair[]{new ValueNamePair("=", " = "), new ValueNamePair("!=", " != "), new ValueNamePair(" IS NULL ", " NULL "), new ValueNamePair(" IS NOT NULL ", " !NULL ")};
    public static final ValueNamePair[] OPERATORS_ENCRYPTED = new ValueNamePair[]{new ValueNamePair(" IS NULL ", " NULL "), new ValueNamePair(" IS NOT NULL ", " !NULL ")};
    public static final ValueNamePair[] OPERATORS_NUMBERS = new ValueNamePair[]{new ValueNamePair("=", " = "), new ValueNamePair("!=", " != "), new ValueNamePair(">", " > "), new ValueNamePair(">=", " >= "), new ValueNamePair("<", " < "), new ValueNamePair("<=", " <= "), new ValueNamePair(" BETWEEN ", " >-< "), new ValueNamePair(" IS NULL ", " NULL "), new ValueNamePair(" IS NOT NULL ", " !NULL ")};

    public static MQuery get(Properties ctx, int AD_PInstance_ID, String TableName) {
        MQuery query;
        block39: {
            if (s_log.isLoggable(Level.INFO)) {
                s_log.info("AD_PInstance_ID=" + AD_PInstance_ID + ", TableName=" + TableName);
            }
            query = new MQuery(TableName);
            boolean isTemporaryTable = false;
            MTable table2 = null;
            if (TableName.startsWith("T_")) {
                query.addRestriction(String.valueOf(TableName) + ".AD_PInstance_ID=" + AD_PInstance_ID);
                isTemporaryTable = true;
                table2 = MTable.get(ctx, TableName);
            }
            boolean isFinancialReport = "T_Report".equals(TableName) || "T_ReportStatement".equals(TableName);
            query.m_AD_PInstance_ID = AD_PInstance_ID;
            String SQL = "SELECT COUNT(*) FROM AD_PInstance_Para WHERE AD_PInstance_ID=?";
            int rows = DB.getSQLValue(null, SQL, AD_PInstance_ID);
            if (rows < 1) {
                return query;
            }
            boolean trl = !Env.isBaseLanguage(ctx, "AD_Process_Para");
            SQL = !trl ? "SELECT ip.ParameterName,ip.P_String,ip.P_String_To,ip.P_Number,ip.P_Number_To,ip.P_Date,ip.P_Date_To, ip.Info,ip.Info_To, pp.Name, pp.IsRange, pp.AD_Reference_ID FROM AD_PInstance_Para ip, AD_PInstance i, AD_Process_Para pp WHERE i.AD_PInstance_ID=ip.AD_PInstance_ID AND pp.AD_Process_ID=i.AD_Process_ID AND pp.ColumnName=ip.ParameterName AND pp.IsActive='Y' AND ip.AD_PInstance_ID=? ORDER BY pp.SeqNo" : "SELECT ip.ParameterName,ip.P_String,ip.P_String_To, ip.P_Number,ip.P_Number_To,ip.P_Date,ip.P_Date_To, ip.Info,ip.Info_To, ppt.Name, pp.IsRange, pp.AD_Reference_ID FROM AD_PInstance_Para ip, AD_PInstance i, AD_Process_Para pp, AD_Process_Para_Trl ppt WHERE i.AD_PInstance_ID=ip.AD_PInstance_ID AND pp.AD_Process_ID=i.AD_Process_ID AND pp.ColumnName=ip.ParameterName AND pp.IsActive='Y' AND pp.AD_Process_Para_ID=ppt.AD_Process_Para_ID AND ip.AD_PInstance_ID=? AND ppt.AD_Language=? ORDER BY pp.SeqNo";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(SQL, null);
                    pstmt.setInt(1, AD_PInstance_ID);
                    if (trl) {
                        pstmt.setString(2, Env.getAD_Language(ctx));
                    }
                    rs = pstmt.executeQuery();
                    int row = 0;
                    while (rs.next()) {
                        if (row == rows) {
                            s_log.log(Level.SEVERE, "(Parameter) - more rows than expected");
                            break;
                        }
                        String ParameterName = rs.getString(1);
                        String P_String = rs.getString(2);
                        String P_String_To = rs.getString(3);
                        Double P_Number = null;
                        double d = rs.getDouble(4);
                        if (!rs.wasNull()) {
                            P_Number = d;
                        }
                        Double P_Number_To = null;
                        d = rs.getDouble(5);
                        if (!rs.wasNull()) {
                            P_Number_To = d;
                        }
                        Timestamp P_Date = rs.getTimestamp(6);
                        Timestamp P_Date_To = rs.getTimestamp(7);
                        String Info2 = rs.getString(8);
                        String Info_To = rs.getString(9);
                        String Name2 = rs.getString(10);
                        boolean isRange = "Y".equals(rs.getString(11));
                        int Reference_ID = rs.getInt(12);
                        if (s_log.isLoggable(Level.FINE)) {
                            s_log.fine(String.valueOf(ParameterName) + " S=" + P_String + "-" + P_String_To + ", N=" + P_Number + "-" + P_Number_To + ", D=" + P_Date + "-" + P_Date_To + "; Name=" + Name2 + ", Info=" + Info2 + "-" + Info_To + ", Range=" + isRange);
                        }
                        if (isTemporaryTable && !isFinancialReport && table2 != null && table2.getColumn(ParameterName) == null) {
                            if (s_log.isLoggable(Level.INFO)) {
                                s_log.info("Skip parameter " + ParameterName + " because there is no column in table " + TableName);
                            }
                        } else if (P_String != null) {
                            if (P_String_To == null) {
                                if (P_String.indexOf(37) == -1) {
                                    query.addRestriction(ParameterName, EQUAL, P_String, Name2, Info2);
                                } else {
                                    query.addRestriction(ParameterName, LIKE, P_String, Name2, Info2);
                                }
                            } else {
                                query.addRangeRestriction(ParameterName, P_String, P_String_To, Name2, Info2, Info_To);
                            }
                        } else if (P_Number != null || P_Number_To != null) {
                            if (P_Number_To == null) {
                                if (isRange) {
                                    query.addRestriction(ParameterName, GREATER_EQUAL, P_Number, Name2, Info2);
                                } else {
                                    query.addRestriction(ParameterName, EQUAL, P_Number, Name2, Info2);
                                }
                            } else if (P_Number == null) {
                                query.addRestriction(ParameterName, LESS_EQUAL, P_Number_To, Name2, Info2);
                            } else {
                                query.addRangeRestriction(ParameterName, P_Number, P_Number_To, Name2, Info2, Info_To);
                            }
                        } else if (P_Date != null || P_Date_To != null) {
                            String paramName;
                            String string = paramName = Reference_ID == 16 ? ParameterName : "TRUNC(" + ParameterName + ")";
                            if (P_Date_To == null) {
                                if (isRange) {
                                    query.addRestriction(paramName, GREATER_EQUAL, P_Date, Name2, Info2);
                                } else {
                                    query.addRestriction(paramName, EQUAL, P_Date, Name2, Info2);
                                }
                            } else if (P_Date == null) {
                                query.addRestriction(paramName, LESS_EQUAL, P_Date_To, Name2, Info2);
                            } else {
                                query.addRangeRestriction(paramName, P_Date, P_Date_To, Name2, Info2, Info_To);
                            }
                        }
                        ++row;
                    }
                }
                catch (SQLException e2) {
                    s_log.log(Level.SEVERE, SQL, e2);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block39;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (s_log.isLoggable(Level.INFO)) {
            s_log.info(query.toString());
        }
        return query;
    }

    public static String getZoomColumnName(String columnName) {
        if (columnName == null) {
            return null;
        }
        if (columnName.equals("SalesRep_ID")) {
            return "AD_User_ID";
        }
        if (columnName.equals("C_DocTypeTarget_ID")) {
            return "C_DocType_ID";
        }
        if (columnName.equals("Bill_BPartner_ID")) {
            return "C_BPartner_ID";
        }
        if (columnName.equals("Bill_Location_ID") || columnName.equals("BillTo_ID")) {
            return "C_BPartner_Location_ID";
        }
        if (columnName.equals("Account_ID")) {
            return "C_ElementValue_ID";
        }
        if (columnName.equals("C_LocFrom_ID") || columnName.equals("C_LocTo_ID")) {
            return "C_Location_ID";
        }
        if (columnName.equals("C_UOM_To_ID")) {
            return "C_UOM_ID";
        }
        if (columnName.equals("M_AttributeSetInstanceTo_ID")) {
            return "M_AttributeSetInstance_ID";
        }
        if (columnName.equals("M_LocatorTo_ID")) {
            return "M_Locator_ID";
        }
        if (columnName.equals("AD_OrgBP_ID") || columnName.equals("AD_OrgTrx_ID") || columnName.equals("AD_OrgTo_ID")) {
            return "AD_Org_ID";
        }
        return columnName;
    }

    public static String getZoomTableName(String columnName) {
        String tableName = MQuery.getZoomColumnName(columnName);
        int index = tableName.lastIndexOf("_ID");
        if (index != -1) {
            return tableName.substring(0, index);
        }
        return tableName;
    }

    public static MQuery getEqualQuery(String columnName, Object value) {
        MQuery query = new MQuery();
        query.addRestriction(columnName, EQUAL, value);
        query.setRecordCount(1);
        return query;
    }

    public static MQuery getEqualQuery(String columnName, int value) {
        MQuery query = new MQuery();
        if (columnName.endsWith("_ID")) {
            query.setTableName(columnName.substring(0, columnName.length() - 3));
        }
        query.addRestriction(columnName, EQUAL, (Object)value);
        query.setRecordCount(1);
        return query;
    }

    public static MQuery getNoRecordQuery(String tableName, boolean newRecord) {
        MQuery query = new MQuery(tableName);
        if (newRecord) {
            query.addRestriction(NEWRECORD);
        } else {
            query.addRestriction("1=2");
        }
        query.setRecordCount(0);
        return query;
    }

    public MQuery() {
    }

    public MQuery(String TableName) {
        this.m_TableName = TableName;
    }

    public MQuery(int AD_Table_ID) {
        this.m_TableName = MTable.getTableName(Env.getCtx(), AD_Table_ID);
    }

    public int getRecordCount() {
        return this.m_recordCount;
    }

    public void setRecordCount(int count) {
        this.m_recordCount = count;
    }

    public void addRestriction(String ColumnName, String Operator, Object Code, String InfoName, String InfoDisplay, boolean andCondition, int depth) {
        Restriction r = new Restriction(ColumnName, Operator, Code, InfoName, InfoDisplay, andCondition, depth);
        this.m_list.add(r);
    }

    public void addRestriction(String ColumnName, String Operator, Object Code, String InfoName, String InfoDisplay) {
        Restriction r = new Restriction(ColumnName, Operator, Code, InfoName, InfoDisplay, true, 0);
        this.m_list.add(r);
    }

    public void addRestriction(String ColumnName, String Operator, Object Code) {
        Restriction r = new Restriction(ColumnName, Operator, Code, null, null, true, 0);
        this.m_list.add(r);
    }

    public void addRestriction(String ColumnName, String Operator, int Code) {
        Restriction r = new Restriction(ColumnName, Operator, Code, null, null, true, 0);
        this.m_list.add(r);
    }

    public void addRangeRestriction(String ColumnName, Object Code, Object Code_to, String InfoName, String InfoDisplay, String InfoDisplay_to, boolean andCondition, int depth) {
        Restriction r = new Restriction(ColumnName, Code, Code_to, InfoName, InfoDisplay, InfoDisplay_to, andCondition, depth);
        this.m_list.add(r);
    }

    public void addRangeRestriction(String ColumnName, Object Code, Object Code_to, String InfoName, String InfoDisplay, String InfoDisplay_to) {
        Restriction r = new Restriction(ColumnName, Code, Code_to, InfoName, InfoDisplay, InfoDisplay_to, true, 0);
        this.m_list.add(r);
    }

    public void addRangeRestriction(String ColumnName, Object Code, Object Code_to) {
        Restriction r = new Restriction(ColumnName, Code, Code_to, null, null, null, true, 0);
        this.m_list.add(r);
    }

    protected void addRestriction(Restriction r) {
        this.m_list.add(r);
    }

    public void addRestriction(String whereClause, boolean andCondition, int joinDepth) {
        if (whereClause == null || whereClause.trim().length() == 0) {
            return;
        }
        Restriction r = new Restriction(whereClause, andCondition, joinDepth);
        this.m_list.add(r);
        this.m_newRecord = whereClause.equals(NEWRECORD);
    }

    public void addRestriction(String whereClause) {
        if (whereClause == null || whereClause.trim().length() == 0) {
            return;
        }
        Restriction r = new Restriction(whereClause, true, 0);
        this.m_list.add(r);
        this.m_newRecord = whereClause.equals(NEWRECORD);
    }

    public boolean isNewRecordQuery() {
        return this.m_newRecord;
    }

    public String getWhereClause() {
        return this.getWhereClause(false);
    }

    public String getWhereClause(boolean fullyQualified) {
        int currentDepth = 0;
        boolean qualified = fullyQualified;
        if (qualified && (this.m_TableName == null || this.m_TableName.length() == 0)) {
            qualified = false;
        }
        StringBuilder sb = new StringBuilder();
        if (!this.isActive()) {
            return sb.toString();
        }
        sb.append('(');
        int i2 = 0;
        while (i2 < this.m_list.size()) {
            Restriction r = this.m_list.get(i2);
            if (i2 != 0) {
                sb.append(r.andCondition ? " AND " : " OR ");
            }
            while (currentDepth < r.joinDepth) {
                sb.append('(');
                ++currentDepth;
            }
            if (qualified) {
                sb.append(r.getSQL(this.m_TableName));
            } else {
                sb.append(r.getSQL(null));
            }
            while (currentDepth > r.joinDepth) {
                sb.append(')');
                --currentDepth;
            }
            ++i2;
        }
        while (currentDepth > 0) {
            sb.append(')');
            --currentDepth;
        }
        sb.append(')');
        return sb.toString();
    }

    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        int currentDepth = 0;
        if (this.m_TableName != null) {
            sb.append(this.m_TableName).append(": ");
        }
        int i2 = 0;
        while (i2 < this.m_list.size()) {
            Restriction r = this.m_list.get(i2);
            while (currentDepth < r.joinDepth) {
                sb.append('(');
                ++currentDepth;
            }
            while (currentDepth > r.joinDepth) {
                sb.append(')');
                --currentDepth;
            }
            if (i2 != 0) {
                sb.append(r.andCondition ? " AND " : " OR ");
            }
            sb.append(r.getInfoName()).append(r.getInfoOperator()).append(r.getInfoDisplayAll());
            ++i2;
        }
        while (currentDepth > 0) {
            sb.append(')');
            --currentDepth;
        }
        return sb.toString();
    }

    public String getWhereClause(int index) {
        StringBuilder sb = new StringBuilder();
        if (index >= 0 && index < this.m_list.size()) {
            Restriction r = this.m_list.get(index);
            sb.append(r.getSQL(null));
        }
        return sb.toString();
    }

    public int getRestrictionCount() {
        return this.m_list.size();
    }

    public boolean isActive() {
        return this.m_list.size() != 0;
    }

    public String getTableName() {
        return this.m_TableName;
    }

    public void setTableName(String TableName) {
        this.m_TableName = TableName;
    }

    public String getColumnName(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        Restriction r = this.m_list.get(index);
        return r.ColumnName;
    }

    protected void setColumnName(int index, String ColumnName) {
        if (index < 0 || index >= this.m_list.size()) {
            return;
        }
        Restriction r = this.m_list.get(index);
        r.ColumnName = ColumnName;
    }

    public String getOperator(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        Restriction r = this.m_list.get(index);
        return r.Operator;
    }

    public Object getCode(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        Restriction r = this.m_list.get(index);
        return r.Code;
    }

    public String getInfoDisplay(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        Restriction r = this.m_list.get(index);
        return r.InfoDisplay;
    }

    public String getInfoDisplay_to(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        Restriction r = this.m_list.get(index);
        return r.InfoDisplay_to;
    }

    public String getInfoName(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        Restriction r = this.m_list.get(index);
        return r.InfoName;
    }

    public String getInfoOperator(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        Restriction r = this.m_list.get(index);
        return r.getInfoOperator();
    }

    public String getInfoDisplayAll(int index) {
        if (index < 0 || index >= this.m_list.size()) {
            return null;
        }
        Restriction r = this.m_list.get(index);
        return r.getInfoDisplayAll();
    }

    public String toString() {
        if (this.isActive()) {
            return this.getWhereClause(true);
        }
        return "MQuery[" + this.m_TableName + ",Restrictions=0]";
    }

    public String getDisplayName(Properties ctx) {
        String keyColumn = null;
        keyColumn = this.m_TableName != null ? String.valueOf(this.m_TableName) + "_ID" : this.getColumnName(0);
        String retValue = Msg.translate(ctx, keyColumn);
        if (retValue != null && retValue.length() > 0) {
            return retValue;
        }
        return this.m_TableName;
    }

    public MQuery deepCopy() {
        MQuery newQuery = new MQuery(this.m_TableName);
        int i2 = 0;
        while (i2 < this.m_list.size()) {
            newQuery.addRestriction(this.m_list.get(i2));
            ++i2;
        }
        return newQuery;
    }

    public int getAD_PInstance_ID() {
        return this.m_AD_PInstance_ID;
    }

    public void setZoomTableName(String tableName) {
        this.m_zoomTable = tableName;
    }

    public String getZoomTableName() {
        return this.m_zoomTable;
    }

    public void setZoomColumnName(String column) {
        this.m_zoomColumn = column;
    }

    public String getZoomColumnName() {
        return this.m_zoomColumn;
    }

    public void setZoomValue(Object value) {
        this.m_zoomValue = value;
    }

    public Object getZoomValue() {
        return this.m_zoomValue;
    }
}

