/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.NegativeInventoryDisallowedException;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MTransaction;
import org.compiere.model.X_C_ProjectIssue;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MProjectIssue
extends X_C_ProjectIssue {
    private static final long serialVersionUID = 4714411434615096132L;
    private MProject m_parent = null;

    public MProjectIssue(Properties ctx, int C_ProjectIssue_ID, String trxName) {
        super(ctx, C_ProjectIssue_ID, trxName);
        if (C_ProjectIssue_ID == 0) {
            this.setMovementQty(Env.ZERO);
            this.setPosted(false);
            this.setProcessed(false);
        }
    }

    public MProjectIssue(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProjectIssue(MProject project) {
        this(project.getCtx(), 0, project.get_TrxName());
        this.setClientOrg(project.getAD_Client_ID(), project.getAD_Org_ID());
        this.setC_Project_ID(project.getC_Project_ID());
        this.setLine(this.getNextLine());
        this.m_parent = project;
        this.setMovementDate(new Timestamp(System.currentTimeMillis()));
        this.setMovementQty(Env.ZERO);
        this.setPosted(false);
        this.setProcessed(false);
    }

    private int getNextLine() {
        return DB.getSQLValue(this.get_TrxName(), "SELECT COALESCE(MAX(Line),0)+10 FROM C_ProjectIssue WHERE C_Project_ID=?", this.getC_Project_ID());
    }

    public void setMandatory(int M_Locator_ID, int M_Product_ID, BigDecimal MovementQty) {
        this.setM_Locator_ID(M_Locator_ID);
        this.setM_Product_ID(M_Product_ID);
        this.setMovementQty(MovementQty);
    }

    public MProject getParent() {
        if (this.m_parent == null && this.getC_Project_ID() != 0) {
            this.m_parent = new MProject(this.getCtx(), this.getC_Project_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public boolean process() {
        Timestamp t;
        if (!this.save()) {
            return false;
        }
        if (this.getM_Product_ID() == 0) {
            this.log.log(Level.SEVERE, "No Product");
            return false;
        }
        MProduct product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        if (!product.isStocked()) {
            this.setProcessed(true);
            return this.save();
        }
        MTransaction mTrx = new MTransaction(this.getCtx(), this.getAD_Org_ID(), "W+", this.getM_Locator_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.getMovementQty().negate(), this.getMovementDate(), this.get_TrxName());
        mTrx.setC_ProjectIssue_ID(this.getC_ProjectIssue_ID());
        MLocator loc = MLocator.get(this.getCtx(), this.getM_Locator_ID());
        Timestamp dateMPolicy = this.getMovementDate();
        if (this.getM_AttributeSetInstance_ID() > 0 && (t = MStorageOnHand.getDateMaterialPolicy(this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.get_TrxName())) != null) {
            dateMPolicy = t;
        }
        boolean ok = true;
        try {
            if (this.getMovementQty().negate().signum() < 0) {
                String MMPolicy = product.getMMPolicy();
                Timestamp minGuaranteeDate = this.getMovementDate();
                int M_Warehouse_ID = this.getM_Locator_ID() > 0 ? this.getM_Locator().getM_Warehouse_ID() : this.getC_Project().getM_Warehouse_ID();
                MStorageOnHand[] storages = MStorageOnHand.getWarehouse(this.getCtx(), M_Warehouse_ID, this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), minGuaranteeDate, "F".equals(MMPolicy), true, this.getM_Locator_ID(), this.get_TrxName(), true);
                BigDecimal qtyToIssue = this.getMovementQty();
                MStorageOnHand[] mStorageOnHandArray = storages;
                int n = storages.length;
                int n2 = 0;
                while (n2 < n) {
                    MStorageOnHand storage = mStorageOnHandArray[n2];
                    if (storage.getQtyOnHand().compareTo(qtyToIssue) >= 0) {
                        storage.addQtyOnHand(qtyToIssue.negate());
                        qtyToIssue = BigDecimal.ZERO;
                    } else {
                        qtyToIssue = qtyToIssue.subtract(storage.getQtyOnHand());
                        storage.addQtyOnHand(storage.getQtyOnHand().negate());
                    }
                    if (qtyToIssue.signum() == 0) break;
                    ++n2;
                }
                if (qtyToIssue.signum() > 0) {
                    ok = MStorageOnHand.add(this.getCtx(), loc.getM_Warehouse_ID(), this.getM_Locator_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), qtyToIssue.negate(), dateMPolicy, this.get_TrxName());
                }
            } else {
                ok = MStorageOnHand.add(this.getCtx(), loc.getM_Warehouse_ID(), this.getM_Locator_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.getMovementQty().negate(), dateMPolicy, this.get_TrxName());
            }
        }
        catch (NegativeInventoryDisallowedException e) {
            this.log.severe(e.getMessage());
            StringBuilder error = new StringBuilder();
            error.append(Msg.getElement(this.getCtx(), "Line")).append(" ").append(this.getLine()).append(": ");
            error.append(e.getMessage()).append("\n");
            throw new AdempiereException(error.toString());
        }
        if (ok) {
            if (mTrx.save(this.get_TrxName())) {
                this.setProcessed(true);
                if (this.save()) {
                    return true;
                }
                this.log.log(Level.SEVERE, "Issue not saved");
            } else {
                this.log.log(Level.SEVERE, "Transaction not saved");
            }
        } else {
            this.log.log(Level.SEVERE, "Storage not updated");
        }
        return false;
    }
}

