/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.base.AbstractProductPricing;
import org.compiere.model.I_C_InvoiceLine;
import org.compiere.model.I_C_OrderLine;
import org.compiere.model.I_C_ProjectLine;
import org.compiere.model.I_M_RMALine;
import org.compiere.model.I_M_RequisitionLine;
import org.compiere.model.MDiscountSchema;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trace;

public class MProductPricing
extends AbstractProductPricing {
    private String trxName = null;
    private int m_M_PriceList_Version_ID = 0;
    private Timestamp m_PriceDate;
    private int m_precision = -1;
    private boolean m_calculated = false;
    private boolean m_vendorbreak = false;
    private boolean m_useVendorBreak;
    private Boolean m_found = null;
    private BigDecimal m_PriceList = Env.ZERO;
    private BigDecimal m_PriceStd = Env.ZERO;
    private BigDecimal m_PriceLimit = Env.ZERO;
    private int m_C_Currency_ID = 0;
    private boolean m_enforcePriceLimit = false;
    private int m_C_UOM_ID = 0;
    private int m_M_Product_Category_ID;
    private boolean m_discountSchema = false;
    private boolean m_isTaxIncluded = false;
    protected CLogger log = CLogger.getCLogger(this.getClass());

    public MProductPricing() {
    }

    public MProductPricing(int M_Product_ID, int C_BPartner_ID, BigDecimal Qty, boolean isSOTrx, String trxName) {
        this.setInitialValues(M_Product_ID, C_BPartner_ID, Qty, isSOTrx, trxName);
    }

    public MProductPricing(int M_Product_ID, int C_BPartner_ID, BigDecimal Qty, boolean isSOTrx) {
        this(M_Product_ID, C_BPartner_ID, Qty, isSOTrx, null);
    }

    @Override
    public void setInitialValues(int M_Product_ID, int C_BPartner_ID, BigDecimal qty, boolean isSOTrx, String trxName) {
        super.setInitialValues(M_Product_ID, C_BPartner_ID, qty, isSOTrx, trxName);
        this.checkVendorBreak();
    }

    private void checkVendorBreak() {
        int thereAreVendorBreakRecords = DB.getSQLValue(this.trxName, "SELECT count(M_Product_ID) FROM M_ProductPriceVendorBreak WHERE M_Product_ID=? AND (C_BPartner_ID=? OR C_BPartner_ID is NULL)", this.m_M_Product_ID, this.m_C_BPartner_ID);
        this.m_useVendorBreak = thereAreVendorBreakRecords > 0;
    }

    @Override
    public boolean calculatePrice() {
        if (this.m_M_Product_ID == 0 || this.m_found != null && !this.m_found.booleanValue()) {
            return false;
        }
        if (this.m_useVendorBreak) {
            if (!this.m_calculated) {
                this.m_calculated = this.calculatePLV_VB();
                if (this.m_calculated) {
                    this.m_vendorbreak = true;
                }
            }
            if (!this.m_calculated) {
                this.m_calculated = this.calculatePL_VB();
                if (this.m_calculated) {
                    this.m_vendorbreak = true;
                }
            }
            if (!this.m_calculated) {
                this.m_calculated = this.calculateBPL_VB();
                if (this.m_calculated) {
                    this.m_vendorbreak = true;
                }
            }
        }
        if (!this.m_calculated) {
            this.m_calculated = this.calculatePLV();
        }
        if (!this.m_calculated) {
            this.m_calculated = this.calculatePL();
        }
        if (!this.m_calculated) {
            this.m_calculated = this.calculateBPL();
        }
        if (!this.m_calculated) {
            this.setBaseInfo();
        }
        if (this.m_calculated && !this.m_vendorbreak) {
            this.calculateDiscount();
        }
        this.setPrecision();
        this.m_found = this.m_calculated;
        return this.m_calculated;
    }

    private boolean calculatePLV() {
        block11: {
            if (this.m_M_Product_ID == 0 || this.m_M_PriceList_Version_ID == 0) {
                return false;
            }
            String sql = "SELECT bomPriceStd(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceStd, bomPriceList(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceList, bomPriceLimit(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceLimit, p.C_UOM_ID,pv.ValidFrom,pl.C_Currency_ID,p.M_Product_Category_ID, pl.EnforcePriceLimit, pl.IsTaxIncluded FROM M_Product p INNER JOIN M_ProductPrice pp ON (p.M_Product_ID=pp.M_Product_ID) INNER JOIN  M_PriceList_Version pv ON (pp.M_PriceList_Version_ID=pv.M_PriceList_Version_ID) INNER JOIN M_Pricelist pl ON (pv.M_PriceList_ID=pl.M_PriceList_ID) WHERE pv.IsActive='Y' AND pp.IsActive='Y' AND p.M_Product_ID=? AND pv.M_PriceList_Version_ID=?";
            this.m_calculated = false;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.trxName);
                    pstmt.setInt(1, this.m_M_Product_ID);
                    pstmt.setInt(2, this.m_M_PriceList_Version_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.m_PriceStd = rs.getBigDecimal(1);
                        if (rs.wasNull()) {
                            this.m_PriceStd = Env.ZERO;
                        }
                        this.m_PriceList = rs.getBigDecimal(2);
                        if (rs.wasNull()) {
                            this.m_PriceList = Env.ZERO;
                        }
                        this.m_PriceLimit = rs.getBigDecimal(3);
                        if (rs.wasNull()) {
                            this.m_PriceLimit = Env.ZERO;
                        }
                        this.m_C_UOM_ID = rs.getInt(4);
                        this.m_C_Currency_ID = rs.getInt(6);
                        this.m_M_Product_Category_ID = rs.getInt(7);
                        this.m_enforcePriceLimit = "Y".equals(rs.getString(8));
                        this.m_isTaxIncluded = "Y".equals(rs.getString(9));
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("M_PriceList_Version_ID=" + this.m_M_PriceList_Version_ID + " - " + this.m_PriceStd);
                        }
                        this.m_calculated = true;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    this.m_calculated = false;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return this.m_calculated;
    }

    private boolean calculatePL() {
        block14: {
            if (this.m_M_Product_ID == 0) {
                return false;
            }
            if (this.m_M_PriceList_ID == 0) {
                this.log.log(Level.SEVERE, "No PriceList");
                Trace.printStack();
                return false;
            }
            String sql = "SELECT bomPriceStd(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceStd, bomPriceList(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceList, bomPriceLimit(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceLimit, p.C_UOM_ID,pv.ValidFrom,pl.C_Currency_ID,p.M_Product_Category_ID,pl.EnforcePriceLimit FROM M_Product p INNER JOIN M_ProductPrice pp ON (p.M_Product_ID=pp.M_Product_ID) INNER JOIN  M_PriceList_Version pv ON (pp.M_PriceList_Version_ID=pv.M_PriceList_Version_ID) INNER JOIN M_Pricelist pl ON (pv.M_PriceList_ID=pl.M_PriceList_ID) WHERE pv.IsActive='Y' AND pp.IsActive='Y' AND p.M_Product_ID=? AND pv.M_PriceList_ID=? ORDER BY pv.ValidFrom DESC";
            this.m_calculated = false;
            if (this.m_PriceDate == null) {
                this.m_PriceDate = new Timestamp(System.currentTimeMillis());
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.trxName);
                    pstmt.setInt(1, this.m_M_Product_ID);
                    pstmt.setInt(2, this.m_M_PriceList_ID);
                    rs = pstmt.executeQuery();
                    while (!this.m_calculated && rs.next()) {
                        Timestamp plDate = rs.getTimestamp(5);
                        if (plDate != null && this.m_PriceDate.before(plDate)) continue;
                        this.m_PriceStd = rs.getBigDecimal(1);
                        if (rs.wasNull()) {
                            this.m_PriceStd = Env.ZERO;
                        }
                        this.m_PriceList = rs.getBigDecimal(2);
                        if (rs.wasNull()) {
                            this.m_PriceList = Env.ZERO;
                        }
                        this.m_PriceLimit = rs.getBigDecimal(3);
                        if (rs.wasNull()) {
                            this.m_PriceLimit = Env.ZERO;
                        }
                        this.m_C_UOM_ID = rs.getInt(4);
                        this.m_C_Currency_ID = rs.getInt(6);
                        this.m_M_Product_Category_ID = rs.getInt(7);
                        this.m_enforcePriceLimit = "Y".equals(rs.getString(8));
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("M_PriceList_ID=" + this.m_M_PriceList_ID + "(" + plDate + ")" + " - " + this.m_PriceStd);
                        }
                        this.m_calculated = true;
                        break;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    this.m_calculated = false;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block14;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (!this.m_calculated) {
            this.log.finer("Not found (PL)");
        }
        return this.m_calculated;
    }

    private boolean calculateBPL() {
        block13: {
            if (this.m_M_Product_ID == 0 || this.m_M_PriceList_ID == 0) {
                return false;
            }
            String sql = "SELECT bomPriceStd(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceStd, bomPriceList(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceList, bomPriceLimit(p.M_Product_ID,pv.M_PriceList_Version_ID) AS PriceLimit, p.C_UOM_ID,pv.ValidFrom,pl.C_Currency_ID,p.M_Product_Category_ID, pl.EnforcePriceLimit, pl.IsTaxIncluded FROM M_Product p INNER JOIN M_ProductPrice pp ON (p.M_Product_ID=pp.M_Product_ID) INNER JOIN  M_PriceList_Version pv ON (pp.M_PriceList_Version_ID=pv.M_PriceList_Version_ID) INNER JOIN M_Pricelist bpl ON (pv.M_PriceList_ID=bpl.M_PriceList_ID) INNER JOIN M_Pricelist pl ON (bpl.M_PriceList_ID=pl.BasePriceList_ID) WHERE pv.IsActive='Y' AND pp.IsActive='Y' AND p.M_Product_ID=? AND pl.M_PriceList_ID=? ORDER BY pv.ValidFrom DESC";
            this.m_calculated = false;
            if (this.m_PriceDate == null) {
                this.m_PriceDate = new Timestamp(System.currentTimeMillis());
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.trxName);
                    pstmt.setInt(1, this.m_M_Product_ID);
                    pstmt.setInt(2, this.m_M_PriceList_ID);
                    rs = pstmt.executeQuery();
                    while (!this.m_calculated && rs.next()) {
                        Timestamp plDate = rs.getTimestamp(5);
                        if (plDate != null && this.m_PriceDate.before(plDate)) continue;
                        this.m_PriceStd = rs.getBigDecimal(1);
                        if (rs.wasNull()) {
                            this.m_PriceStd = Env.ZERO;
                        }
                        this.m_PriceList = rs.getBigDecimal(2);
                        if (rs.wasNull()) {
                            this.m_PriceList = Env.ZERO;
                        }
                        this.m_PriceLimit = rs.getBigDecimal(3);
                        if (rs.wasNull()) {
                            this.m_PriceLimit = Env.ZERO;
                        }
                        this.m_C_UOM_ID = rs.getInt(4);
                        this.m_C_Currency_ID = rs.getInt(6);
                        this.m_M_Product_Category_ID = rs.getInt(7);
                        this.m_enforcePriceLimit = "Y".equals(rs.getString(8));
                        this.m_isTaxIncluded = "Y".equals(rs.getString(9));
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("M_PriceList_ID=" + this.m_M_PriceList_ID + "(" + plDate + ")" + " - " + this.m_PriceStd);
                        }
                        this.m_calculated = true;
                        break;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    this.m_calculated = false;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block13;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (!this.m_calculated) {
            this.log.finer("Not found (BPL)");
        }
        return this.m_calculated;
    }

    private boolean calculatePLV_VB() {
        block11: {
            if (this.m_M_Product_ID == 0 || this.m_M_PriceList_Version_ID == 0) {
                return false;
            }
            String sql = "SELECT pp.PriceStd, pp.PriceList, pp.PriceLimit, p.C_UOM_ID,pv.ValidFrom,pl.C_Currency_ID,p.M_Product_Category_ID, pl.EnforcePriceLimit, pl.IsTaxIncluded FROM M_Product p INNER JOIN M_ProductPriceVendorBreak pp ON (p.M_Product_ID=pp.M_Product_ID) INNER JOIN  M_PriceList_Version pv ON (pp.M_PriceList_Version_ID=pv.M_PriceList_Version_ID) INNER JOIN M_Pricelist pl ON (pv.M_PriceList_ID=pl.M_PriceList_ID) WHERE pv.IsActive='Y' AND pp.IsActive='Y' AND p.M_Product_ID=? AND pv.M_PriceList_Version_ID=? AND (pp.C_BPartner_ID=? OR pp.C_BPartner_ID is NULL) AND ?>=pp.BreakValue ORDER BY  pp.C_BPartner_ID, BreakValue DESC";
            this.m_calculated = false;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.trxName);
                    pstmt.setInt(1, this.m_M_Product_ID);
                    pstmt.setInt(2, this.m_M_PriceList_Version_ID);
                    pstmt.setInt(3, this.m_C_BPartner_ID);
                    pstmt.setBigDecimal(4, this.m_Qty);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.m_PriceStd = rs.getBigDecimal(1);
                        if (rs.wasNull()) {
                            this.m_PriceStd = Env.ZERO;
                        }
                        this.m_PriceList = rs.getBigDecimal(2);
                        if (rs.wasNull()) {
                            this.m_PriceList = Env.ZERO;
                        }
                        this.m_PriceLimit = rs.getBigDecimal(3);
                        if (rs.wasNull()) {
                            this.m_PriceLimit = Env.ZERO;
                        }
                        this.m_C_UOM_ID = rs.getInt(4);
                        this.m_C_Currency_ID = rs.getInt(6);
                        this.m_M_Product_Category_ID = rs.getInt(7);
                        this.m_enforcePriceLimit = "Y".equals(rs.getString(8));
                        this.m_isTaxIncluded = "Y".equals(rs.getString(9));
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("M_PriceList_Version_ID=" + this.m_M_PriceList_Version_ID + " - " + this.m_PriceStd);
                        }
                        this.m_calculated = true;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    this.m_calculated = false;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return this.m_calculated;
    }

    private boolean calculatePL_VB() {
        block14: {
            if (this.m_M_Product_ID == 0) {
                return false;
            }
            if (this.m_M_PriceList_ID == 0) {
                this.log.log(Level.SEVERE, "No PriceList");
                Trace.printStack();
                return false;
            }
            String sql = "SELECT pp.PriceStd, pp.PriceList, pp.PriceLimit, p.C_UOM_ID,pv.ValidFrom,pl.C_Currency_ID,p.M_Product_Category_ID,pl.EnforcePriceLimit FROM M_Product p INNER JOIN M_ProductPriceVendorBreak pp ON (p.M_Product_ID=pp.M_Product_ID) INNER JOIN  M_PriceList_Version pv ON (pp.M_PriceList_Version_ID=pv.M_PriceList_Version_ID) INNER JOIN M_Pricelist pl ON (pv.M_PriceList_ID=pl.M_PriceList_ID) WHERE pv.IsActive='Y' AND pp.IsActive='Y' AND p.M_Product_ID=? AND pv.M_PriceList_ID=? AND (pp.C_BPartner_ID=? OR pp.C_BPartner_ID is NULL) AND ?>=pp.BreakValue ORDER BY pp.C_BPartner_ID, pv.ValidFrom DESC, BreakValue DESC";
            this.m_calculated = false;
            if (this.m_PriceDate == null) {
                this.m_PriceDate = new Timestamp(System.currentTimeMillis());
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.trxName);
                    pstmt.setInt(1, this.m_M_Product_ID);
                    pstmt.setInt(2, this.m_M_PriceList_ID);
                    pstmt.setInt(3, this.m_C_BPartner_ID);
                    pstmt.setBigDecimal(4, this.m_Qty);
                    rs = pstmt.executeQuery();
                    while (!this.m_calculated && rs.next()) {
                        Timestamp plDate = rs.getTimestamp(5);
                        if (plDate != null && this.m_PriceDate.before(plDate)) continue;
                        this.m_PriceStd = rs.getBigDecimal(1);
                        if (rs.wasNull()) {
                            this.m_PriceStd = Env.ZERO;
                        }
                        this.m_PriceList = rs.getBigDecimal(2);
                        if (rs.wasNull()) {
                            this.m_PriceList = Env.ZERO;
                        }
                        this.m_PriceLimit = rs.getBigDecimal(3);
                        if (rs.wasNull()) {
                            this.m_PriceLimit = Env.ZERO;
                        }
                        this.m_C_UOM_ID = rs.getInt(4);
                        this.m_C_Currency_ID = rs.getInt(6);
                        this.m_M_Product_Category_ID = rs.getInt(7);
                        this.m_enforcePriceLimit = "Y".equals(rs.getString(8));
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("M_PriceList_ID=" + this.m_M_PriceList_ID + "(" + plDate + ")" + " - " + this.m_PriceStd);
                        }
                        this.m_calculated = true;
                        break;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    this.m_calculated = false;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block14;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (!this.m_calculated) {
            this.log.finer("Not found (PL)");
        }
        return this.m_calculated;
    }

    private boolean calculateBPL_VB() {
        block13: {
            if (this.m_M_Product_ID == 0 || this.m_M_PriceList_ID == 0) {
                return false;
            }
            String sql = "SELECT pp.PriceStd, pp.PriceList, pp.PriceLimit, p.C_UOM_ID,pv.ValidFrom,pl.C_Currency_ID,p.M_Product_Category_ID, pl.EnforcePriceLimit, pl.IsTaxIncluded FROM M_Product p INNER JOIN M_ProductPriceVendorBreak pp ON (p.M_Product_ID=pp.M_Product_ID) INNER JOIN  M_PriceList_Version pv ON (pp.M_PriceList_Version_ID=pv.M_PriceList_Version_ID) INNER JOIN M_Pricelist bpl ON (pv.M_PriceList_ID=bpl.M_PriceList_ID) INNER JOIN M_Pricelist pl ON (bpl.M_PriceList_ID=pl.BasePriceList_ID) WHERE pv.IsActive='Y' AND pp.IsActive='Y' AND p.M_Product_ID=? AND pl.M_PriceList_ID=? AND (pp.C_BPartner_ID=? OR pp.C_BPartner_ID is NULL) AND ?>=pp.BreakValue ORDER BY pp.C_BPartner_ID, pv.ValidFrom DESC, BreakValue DESC";
            this.m_calculated = false;
            if (this.m_PriceDate == null) {
                this.m_PriceDate = new Timestamp(System.currentTimeMillis());
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.trxName);
                    pstmt.setInt(1, this.m_M_Product_ID);
                    pstmt.setInt(2, this.m_M_PriceList_ID);
                    pstmt.setInt(3, this.m_C_BPartner_ID);
                    pstmt.setBigDecimal(4, this.m_Qty);
                    rs = pstmt.executeQuery();
                    while (!this.m_calculated && rs.next()) {
                        Timestamp plDate = rs.getTimestamp(5);
                        if (plDate != null && this.m_PriceDate.before(plDate)) continue;
                        this.m_PriceStd = rs.getBigDecimal(1);
                        if (rs.wasNull()) {
                            this.m_PriceStd = Env.ZERO;
                        }
                        this.m_PriceList = rs.getBigDecimal(2);
                        if (rs.wasNull()) {
                            this.m_PriceList = Env.ZERO;
                        }
                        this.m_PriceLimit = rs.getBigDecimal(3);
                        if (rs.wasNull()) {
                            this.m_PriceLimit = Env.ZERO;
                        }
                        this.m_C_UOM_ID = rs.getInt(4);
                        this.m_C_Currency_ID = rs.getInt(6);
                        this.m_M_Product_Category_ID = rs.getInt(7);
                        this.m_enforcePriceLimit = "Y".equals(rs.getString(8));
                        this.m_isTaxIncluded = "Y".equals(rs.getString(9));
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("M_PriceList_ID=" + this.m_M_PriceList_ID + "(" + plDate + ")" + " - " + this.m_PriceStd);
                        }
                        this.m_calculated = true;
                        break;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    this.m_calculated = false;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block13;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (!this.m_calculated) {
            this.log.finer("Not found (BPL)");
        }
        return this.m_calculated;
    }

    private void setBaseInfo() {
        if (this.m_M_Product_ID == 0) {
            return;
        }
        MProduct product = MProduct.get(Env.getCtx(), this.m_M_Product_ID);
        if (product != null) {
            this.m_C_UOM_ID = product.getC_UOM_ID();
            this.m_M_Product_Category_ID = product.getM_Product_Category_ID();
        }
    }

    public boolean isTaxIncluded() {
        return this.m_isTaxIncluded;
    }

    private void calculateDiscount() {
        BigDecimal FlatDiscount;
        int M_DiscountSchema_ID;
        block10: {
            this.m_discountSchema = false;
            if (this.m_C_BPartner_ID == 0 || this.m_M_Product_ID == 0) {
                return;
            }
            M_DiscountSchema_ID = 0;
            FlatDiscount = null;
            String sql = "SELECT COALESCE(p.M_DiscountSchema_ID,g.M_DiscountSchema_ID), COALESCE(p.PO_DiscountSchema_ID,g.PO_DiscountSchema_ID), p.FlatDiscount FROM C_BPartner p INNER JOIN C_BP_Group g ON (p.C_BP_Group_ID=g.C_BP_Group_ID) WHERE p.C_BPartner_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.trxName);
                    pstmt.setInt(1, this.m_C_BPartner_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        M_DiscountSchema_ID = rs.getInt(this.m_isSOTrx ? 1 : 2);
                        FlatDiscount = rs.getBigDecimal(3);
                        if (FlatDiscount == null) {
                            FlatDiscount = Env.ZERO;
                        }
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (M_DiscountSchema_ID == 0) {
            return;
        }
        MDiscountSchema sd = MDiscountSchema.get(Env.getCtx(), M_DiscountSchema_ID);
        if (sd.get_ID() == 0 || "B".equals(sd.getDiscountType()) && !"L".equals(sd.getCumulativeLevel())) {
            return;
        }
        this.m_discountSchema = true;
        this.m_PriceStd = sd.calculatePrice(this.m_Qty, this.m_PriceStd, this.m_M_Product_ID, this.m_M_Product_Category_ID, FlatDiscount);
    }

    @Override
    public BigDecimal getDiscount() {
        BigDecimal Discount = Env.ZERO;
        if (this.m_PriceList.intValue() != 0) {
            Discount = BigDecimal.valueOf((this.m_PriceList.doubleValue() - this.m_PriceStd.doubleValue()) / this.m_PriceList.doubleValue() * 100.0);
        }
        if (Discount.scale() > 2) {
            Discount = Discount.setScale(2, RoundingMode.HALF_UP);
        }
        return Discount;
    }

    @Override
    public void setM_PriceList_ID(int M_PriceList_ID) {
        super.setM_PriceList_ID(M_PriceList_ID);
        this.m_calculated = false;
    }

    public int getM_PriceList_Version_ID() {
        return this.m_M_PriceList_Version_ID;
    }

    @Override
    public void setM_PriceList_Version_ID(int M_PriceList_Version_ID) {
        super.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        this.m_calculated = false;
    }

    @Override
    public void setPriceDate(Timestamp priceDate) {
        super.setPriceDate(priceDate);
        this.m_calculated = false;
    }

    private void setPrecision() {
        if (this.m_M_PriceList_ID != 0) {
            this.m_precision = MPriceList.getPricePrecision(Env.getCtx(), this.getM_PriceList_ID());
        }
    }

    public int getPrecision() {
        return this.m_precision;
    }

    private BigDecimal round(BigDecimal bd) {
        if (this.m_precision >= 0 && bd.scale() > this.m_precision) {
            return bd.setScale(this.m_precision, RoundingMode.HALF_UP);
        }
        return bd;
    }

    @Override
    public int getC_UOM_ID() {
        if (!this.m_calculated) {
            this.calculatePrice();
        }
        return this.m_C_UOM_ID;
    }

    @Override
    public BigDecimal getPriceList() {
        if (!this.m_calculated) {
            this.calculatePrice();
        }
        return this.round(this.m_PriceList);
    }

    @Override
    public BigDecimal getPriceStd() {
        if (!this.m_calculated) {
            this.calculatePrice();
        }
        return this.round(this.m_PriceStd);
    }

    @Override
    public BigDecimal getPriceLimit() {
        if (!this.m_calculated) {
            this.calculatePrice();
        }
        return this.round(this.m_PriceLimit);
    }

    @Override
    public int getC_Currency_ID() {
        if (!this.m_calculated) {
            this.calculatePrice();
        }
        return this.m_C_Currency_ID;
    }

    @Override
    public boolean isEnforcePriceLimit() {
        if (!this.m_calculated) {
            this.calculatePrice();
        }
        return this.m_enforcePriceLimit;
    }

    @Override
    public boolean isDiscountSchema() {
        return this.m_discountSchema || this.m_useVendorBreak;
    }

    @Override
    public boolean isCalculated() {
        return this.m_calculated;
    }

    @Override
    public void setOrderLine(I_C_OrderLine orderLine, String trxName) {
        super.setOrderLine(orderLine, trxName);
        this.checkVendorBreak();
    }

    @Override
    public void setInvoiceLine(I_C_InvoiceLine invoiceLine, String trxName) {
        super.setInvoiceLine(invoiceLine, trxName);
        this.checkVendorBreak();
    }

    @Override
    public void setProjectLine(I_C_ProjectLine projectLine, String trxName) {
        super.setProjectLine(projectLine, trxName);
        this.checkVendorBreak();
    }

    @Override
    public void setRequisitionLine(I_M_RequisitionLine reqLine, String trxName) {
        super.setRequisitionLine(reqLine, trxName);
        this.checkVendorBreak();
    }

    @Override
    public void setRMALine(I_M_RMALine rmaLine, String trxName) {
        super.setRMALine(rmaLine, trxName);
        this.checkVendorBreak();
    }
}

