/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.IProcessUI;
import org.adempiere.util.PaymentUtil;
import org.compiere.model.MBankAccountProcessor;
import org.compiere.model.MClient;
import org.compiere.model.MOnlineTrxHistory;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentProcessor;
import org.compiere.model.MPaymentValidate;
import org.compiere.model.MSysConfig;
import org.compiere.model.PO;
import org.compiere.model.PaymentInterface;
import org.compiere.model.PaymentProcessor;
import org.compiere.model.X_C_PaymentTransaction;
import org.compiere.process.ProcessCall;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.IBAN;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class MPaymentTransaction
extends X_C_PaymentTransaction
implements ProcessCall,
PaymentInterface {
    private static final long serialVersionUID = 8722189788479132158L;
    private MBankAccountProcessor[] m_mBankAccountProcessors = null;
    private MBankAccountProcessor m_mBankAccountProcessor = null;
    private String m_errorMessage = null;
    private IProcessUI m_processUI;

    public MPaymentTransaction(Properties ctx, int C_PaymentTransaction_ID, String trxName) {
        super(ctx, C_PaymentTransaction_ID, trxName);
        if (C_PaymentTransaction_ID == 0) {
            this.setTrxType("S");
            this.setR_AvsAddr("X");
            this.setR_AvsZip("X");
            this.setIsReceipt(true);
            this.setIsApproved(false);
            this.setIsOnline(false);
            this.setIsSelfService(false);
            this.setIsDelayedCapture(false);
            this.setProcessed(false);
            this.setPayAmt(Env.ZERO);
            this.setTaxAmt(Env.ZERO);
            this.setDateTrx(new Timestamp(System.currentTimeMillis()));
            this.setTenderType("K");
        }
    }

    public MPaymentTransaction(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        String encrpytedCvv;
        if (this.getCreditCardVV() != null && !(encrpytedCvv = PaymentUtil.encrpytCvv(this.getCreditCardVV())).equals(this.getCreditCardVV())) {
            this.setCreditCardVV(encrpytedCvv);
        }
        if (MSysConfig.getBooleanValue("IBAN_VALIDATION", true, Env.getAD_Client_ID(Env.getCtx())) && !Util.isEmpty(this.getIBAN())) {
            this.setIBAN(IBAN.normalizeIBAN(this.getIBAN()));
            if (!IBAN.isValid(this.getIBAN())) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), "InvalidIBAN"));
                return false;
            }
        }
        return true;
    }

    public void setAmount(int C_Currency_ID, BigDecimal payAmt) {
        if (C_Currency_ID == 0) {
            C_Currency_ID = MClient.get(this.getCtx()).getC_Currency_ID();
        }
        this.setC_Currency_ID(C_Currency_ID);
        this.setPayAmt(payAmt);
    }

    public boolean setCreditCard(String TrxType, String creditCardType, String creditCardNumber, String creditCardVV, int creditCardExpMM, int creditCardExpYY) {
        this.setTenderType("C");
        this.setTrxType(TrxType);
        this.setCreditCardType(creditCardType);
        this.setCreditCardNumber(creditCardNumber);
        this.setCreditCardVV(creditCardVV);
        this.setCreditCardExpMM(creditCardExpMM);
        this.setCreditCardExpYY(creditCardExpYY);
        int check = MPaymentValidate.validateCreditCardNumber(creditCardNumber, creditCardType).length() + MPaymentValidate.validateCreditCardExp(creditCardExpMM, creditCardExpYY).length();
        if (creditCardVV.length() > 0) {
            check += MPaymentValidate.validateCreditCardVV(creditCardVV, creditCardType).length();
        }
        return check == 0;
    }

    public boolean setCreditCard(String TrxType, String creditCardType, String creditCardNumber, String creditCardVV, String creditCardExp) {
        return this.setCreditCard(TrxType, creditCardType, creditCardNumber, creditCardVV, MPaymentValidate.getCreditCardExpMM(creditCardExp), MPaymentValidate.getCreditCardExpYY(creditCardExp));
    }

    public boolean setPaymentProcessor() {
        return this.setPaymentProcessor(this.getTenderType(), this.getCreditCardType(), this.getC_PaymentProcessor_ID());
    }

    public boolean setPaymentProcessor(String tender, String CCType, int C_PaymentProcessor_ID) {
        this.m_mBankAccountProcessor = null;
        if (this.m_mBankAccountProcessors == null || this.m_mBankAccountProcessors.length == 0) {
            this.m_mBankAccountProcessors = MBankAccountProcessor.find(this.getCtx(), tender, CCType, this.getAD_Client_ID(), this.getC_Currency_ID(), this.getPayAmt(), this.get_TrxName());
        }
        if (this.m_mBankAccountProcessors == null || this.m_mBankAccountProcessors.length == 0) {
            this.m_mBankAccountProcessors = MBankAccountProcessor.find(this.getCtx(), tender, CCType, this.getAD_Client_ID(), this.getC_Currency_ID(), Env.ZERO, this.get_TrxName());
        }
        if (this.m_mBankAccountProcessors == null || this.m_mBankAccountProcessors.length == 0) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.m_mBankAccountProcessors.length) {
            MBankAccountProcessor bankAccountProcessor = this.m_mBankAccountProcessors[i2];
            if (bankAccountProcessor.accepts(tender, CCType) && (C_PaymentProcessor_ID == 0 || bankAccountProcessor.getC_PaymentProcessor_ID() == C_PaymentProcessor_ID)) {
                this.m_mBankAccountProcessor = this.m_mBankAccountProcessors[i2];
                break;
            }
            ++i2;
        }
        if (this.m_mBankAccountProcessor != null) {
            this.setC_BankAccount_ID(this.m_mBankAccountProcessor.getC_BankAccount_ID());
            this.setC_PaymentProcessor_ID(this.m_mBankAccountProcessor.getC_PaymentProcessor_ID());
        }
        return this.m_mBankAccountProcessor != null;
    }

    public boolean processOnline() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Amt=" + this.getPayAmt());
        }
        this.setIsOnline(true);
        this.setErrorMessage(null);
        if (this.getTrxType().equals("V") || this.getTrxType().equals("C")) {
            if (this.isVoided()) {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Already voided - " + this.getR_Result() + " - " + this.getR_RespMsg());
                }
                this.setErrorMessage(Msg.getMsg(Env.getCtx(), "PaymentTransactionAlreadyVoided"));
                return true;
            }
        } else if (this.getTrxType().equals("D")) {
            if (this.isDelayedCapture()) {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Already delayed capture - " + this.getR_Result() + " - " + this.getR_RespMsg());
                }
                this.setErrorMessage(Msg.getMsg(Env.getCtx(), "PaymentTransactionAlreadyDelayedCapture"));
                return true;
            }
        } else if (this.isApproved()) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Already processed - " + this.getR_Result() + " - " + this.getR_RespMsg());
            }
            this.setErrorMessage(Msg.getMsg(Env.getCtx(), "PaymentTransactionAlreadyProcessed"));
            return true;
        }
        if (this.m_mBankAccountProcessor == null) {
            this.setPaymentProcessor();
        }
        if (this.m_mBankAccountProcessor == null) {
            if (this.getC_PaymentProcessor_ID() > 0) {
                MPaymentProcessor pp = new MPaymentProcessor(this.getCtx(), this.getC_PaymentProcessor_ID(), this.get_TrxName());
                this.log.log(Level.WARNING, "No Payment Processor Model " + pp.toString());
                this.setErrorMessage(String.valueOf(Msg.getMsg(Env.getCtx(), "PaymentNoProcessorModel")) + ": " + pp.toString());
            } else {
                this.log.log(Level.WARNING, "No Payment Processor Model");
                this.setErrorMessage(Msg.getMsg(Env.getCtx(), "PaymentNoProcessorModel"));
            }
            return false;
        }
        boolean approved = false;
        boolean processed = false;
        try {
            PaymentProcessor pp = PaymentProcessor.create(this.m_mBankAccountProcessor, this);
            if (pp == null) {
                this.setErrorMessage(Msg.getMsg(Env.getCtx(), "PaymentNoProcessor"));
            } else {
                approved = pp.processCC();
                this.setCreditCardNumber(PaymentUtil.encrpytCreditCard(this.getCreditCardNumber()));
                this.setCreditCardVV(PaymentUtil.encrpytCvv(this.getCreditCardVV()));
                this.setIsApproved(approved);
                if (this.getTrxType().equals("V") || this.getTrxType().equals("C")) {
                    this.setIsVoided(approved);
                } else if (this.getTrxType().equals("D")) {
                    this.setIsDelayedCapture(approved);
                }
                if (approved) {
                    this.setErrorMessage(null);
                    if (!(this.getTrxType().equals("A") || this.getTrxType().equals("F") || this.getTrxType().equals("V"))) {
                        MPayment m_mPayment = this.createPayment(this.get_TrxName());
                        m_mPayment.saveEx();
                        this.setC_Payment_ID(m_mPayment.getC_Payment_ID());
                        processed = m_mPayment.processIt("CO");
                        if (!processed) {
                            this.setErrorMessage(Msg.getMsg(Env.getCtx(), "PaymentNotProcessed"));
                        } else {
                            m_mPayment.saveEx();
                        }
                    } else {
                        processed = true;
                    }
                } else if (this.getTrxType().equals("V") || this.getTrxType().equals("C")) {
                    this.setErrorMessage("From " + this.getCreditCardName() + ": " + this.getR_VoidMsg());
                } else {
                    this.setErrorMessage("From " + this.getCreditCardName() + ": " + this.getR_RespMsg());
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "processOnline", e);
            this.setErrorMessage(String.valueOf(Msg.getMsg(Env.getCtx(), "PaymentNotProcessed")) + ": " + e.getMessage());
        }
        this.setIsApproved(approved);
        this.setProcessed(processed);
        if (this.getTrxType().equals("V") || this.getTrxType().equals("C")) {
            this.setIsVoided(approved);
        } else if (this.getTrxType().equals("D")) {
            this.setIsDelayedCapture(approved);
        }
        MOnlineTrxHistory history = new MOnlineTrxHistory(this.getCtx(), 0, this.get_TrxName());
        history.setAD_Table_ID(200031);
        history.setRecord_ID(this.getC_PaymentTransaction_ID());
        history.setIsError(!approved || !processed);
        history.setProcessed(approved && processed);
        StringBuilder msg = new StringBuilder();
        if (approved) {
            if (this.getTrxType().equals("V") || this.getTrxType().equals("C")) {
                msg.append(String.valueOf(this.getR_VoidMsg()) + "\n");
            } else {
                msg.append("Result: " + this.getR_Result() + "\n");
                msg.append("Response Message: " + this.getR_RespMsg() + "\n");
                msg.append("Reference: " + this.getR_PnRef() + "\n");
                msg.append("Authorization Code: " + this.getR_AuthCode() + "\n");
            }
        } else {
            msg.append("ERROR: " + this.getErrorMessage() + "\n");
        }
        msg.append("Transaction Type: " + this.getTrxType());
        history.setTextMsg(msg.toString());
        history.saveEx();
        return approved && processed;
    }

    public boolean voidOnlineAuthorizationPaymentTransaction() {
        if (this.getTenderType().equals("C") && this.isOnline() && this.getTrxType().equals("A") && !this.isVoided() && !this.isDelayedCapture()) {
            boolean ok = false;
            try {
                MPaymentTransaction m_mPaymentTransaction = MPaymentTransaction.copyFrom(this, new Timestamp(System.currentTimeMillis()), "V", this.getR_PnRef(), this.get_TrxName());
                m_mPaymentTransaction.setIsApproved(false);
                m_mPaymentTransaction.setIsVoided(false);
                m_mPaymentTransaction.setIsDelayedCapture(false);
                ok = m_mPaymentTransaction.processOnline();
                m_mPaymentTransaction.setRef_PaymentTransaction_ID(this.getC_PaymentTransaction_ID());
                m_mPaymentTransaction.saveEx();
                if (ok) {
                    this.setIsVoided(true);
                    this.setR_VoidMsg(m_mPaymentTransaction.getR_VoidMsg());
                    this.setRef_PaymentTransaction_ID(m_mPaymentTransaction.getC_PaymentTransaction_ID());
                } else {
                    this.setErrorMessage(m_mPaymentTransaction.getErrorMessage());
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "voidOnlineAuthorizationPaymentTransaction", e);
                this.setErrorMessage(String.valueOf(Msg.getMsg(Env.getCtx(), "PaymentNotProcessed")) + ": " + e.getMessage());
            }
            return ok;
        }
        return true;
    }

    public boolean delayCaptureOnlineAuthorizationPaymentTransaction(int C_Invoice_ID) {
        if (this.getTenderType().equals("C") && this.isOnline() && this.getTrxType().equals("A") && !this.isVoided() && !this.isDelayedCapture()) {
            boolean ok = false;
            try {
                MPaymentTransaction m_mPaymentTransaction = MPaymentTransaction.copyFrom(this, new Timestamp(System.currentTimeMillis()), "D", this.getR_PnRef(), this.get_TrxName());
                m_mPaymentTransaction.setIsApproved(false);
                m_mPaymentTransaction.setIsVoided(false);
                m_mPaymentTransaction.setIsDelayedCapture(false);
                if (C_Invoice_ID != 0) {
                    m_mPaymentTransaction.setC_Invoice_ID(C_Invoice_ID);
                }
                ok = m_mPaymentTransaction.processOnline();
                m_mPaymentTransaction.setRef_PaymentTransaction_ID(this.getC_PaymentTransaction_ID());
                m_mPaymentTransaction.saveEx();
                if (ok) {
                    if (C_Invoice_ID != 0) {
                        this.setC_Invoice_ID(C_Invoice_ID);
                    }
                    this.setIsDelayedCapture(true);
                    this.setRef_PaymentTransaction_ID(m_mPaymentTransaction.getC_PaymentTransaction_ID());
                } else {
                    this.setErrorMessage(m_mPaymentTransaction.getErrorMessage());
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "delayCaptureOnlineAuthorizationPaymentTransaction", e);
                this.setErrorMessage(String.valueOf(Msg.getMsg(Env.getCtx(), "PaymentNotProcessed")) + ": " + e.getMessage());
            }
            return ok;
        }
        return true;
    }

    public String getCreditCardName() {
        return this.getCreditCardName(this.getCreditCardType());
    }

    public String getCreditCardName(String CreditCardType) {
        if (CreditCardType == null) {
            return "--";
        }
        if ("M".equals(CreditCardType)) {
            return "MasterCard";
        }
        if ("V".equals(CreditCardType)) {
            return "Visa";
        }
        if ("A".equals(CreditCardType)) {
            return "Amex";
        }
        if ("C".equals(CreditCardType)) {
            return "ATM";
        }
        if ("D".equals(CreditCardType)) {
            return "Diners";
        }
        if ("N".equals(CreditCardType)) {
            return "Discover";
        }
        if ("P".equals(CreditCardType)) {
            return "PurchaseCard";
        }
        return "?" + CreditCardType + "?";
    }

    public void setErrorMessage(String errorMessage) {
        this.m_errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    public MPayment createPayment(String trxName) {
        MPayment payment = new MPayment(this.getCtx(), 0, trxName);
        payment.setA_City(this.getA_City());
        payment.setA_Country(this.getA_Country());
        payment.setA_EMail(this.getA_EMail());
        payment.setA_Ident_DL(this.getA_Ident_DL());
        payment.setA_Ident_SSN(this.getA_Ident_SSN());
        payment.setA_Name(this.getA_Name());
        payment.setA_State(this.getA_State());
        payment.setA_Street(this.getA_Street());
        payment.setA_Zip(this.getA_Zip());
        payment.setAccountNo(this.getAccountNo());
        payment.setIBAN(this.getIBAN());
        payment.setAD_Org_ID(this.getAD_Org_ID());
        payment.setC_BankAccount_ID(this.getC_BankAccount_ID());
        payment.setC_BP_BankAccount_ID(this.getC_BP_BankAccount_ID());
        payment.setC_BPartner_ID(this.getC_BPartner_ID());
        payment.setC_ConversionType_ID(this.getC_ConversionType_ID());
        payment.setC_Currency_ID(this.getC_Currency_ID());
        payment.setC_Invoice_ID(this.getC_Invoice_ID());
        payment.setC_Order_ID(this.getC_Order_ID());
        payment.setC_PaymentProcessor_ID(this.getC_PaymentProcessor_ID());
        payment.setC_POSTenderType_ID(this.getC_POSTenderType_ID());
        payment.setCheckNo(this.getCheckNo());
        payment.setCreditCardExpMM(this.getCreditCardExpMM());
        payment.setCreditCardExpYY(this.getCreditCardExpYY());
        payment.setCreditCardNumber(this.getCreditCardNumber());
        payment.setCreditCardType(this.getCreditCardType());
        payment.setCreditCardVV(this.getCreditCardVV());
        payment.setCustomerAddressID(this.getCustomerAddressID());
        payment.setCustomerPaymentProfileID(this.getCustomerPaymentProfileID());
        payment.setCustomerProfileID(this.getCustomerProfileID());
        payment.setDateTrx(this.getDateTrx());
        payment.setDescription(this.getDescription());
        payment.setIsActive(this.isActive());
        payment.setIsApproved(this.isApproved());
        payment.setIsDelayedCapture(this.isDelayedCapture());
        payment.setIsOnline(this.isOnline());
        payment.setIsReceipt(this.isReceipt());
        payment.setIsSelfService(this.isSelfService());
        payment.setIsVoided(this.isVoided());
        payment.setMicr(this.getMicr());
        payment.setOrig_TrxID(this.getOrig_TrxID());
        payment.setPayAmt(this.getPayAmt());
        payment.setPONum(this.getPONum());
        payment.setProcessed(this.isProcessed());
        payment.setR_AuthCode(this.getR_AuthCode());
        payment.setR_AvsAddr(this.getR_AvsAddr());
        payment.setR_AvsZip(this.getR_AvsZip());
        payment.setR_CVV2Match(this.isR_CVV2Match());
        payment.setR_Info(this.getR_Info());
        payment.setR_PnRef(this.getR_PnRef());
        payment.setR_RespMsg(this.getR_RespMsg());
        payment.setR_Result(this.getR_Result());
        payment.setR_VoidMsg(this.getR_VoidMsg());
        payment.setRoutingNo(this.getRoutingNo());
        payment.setSwiftCode(this.getSwiftCode());
        payment.setTaxAmt(this.getTaxAmt());
        payment.setTenderType(this.getTenderType());
        payment.setTrxType(this.getTrxType());
        payment.setVoiceAuthCode(this.getVoiceAuthCode());
        payment.setDateAcct(payment.getDateTrx());
        return payment;
    }

    @Override
    public boolean startProcess(Properties ctx, ProcessInfo pi, Trx trx) {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("startProcess - " + pi.getRecord_ID());
        }
        boolean retValue = false;
        if (pi.getRecord_ID() != this.get_ID()) {
            this.log.log(Level.SEVERE, "startProcess - Not same Payment - " + pi.getRecord_ID());
            return false;
        }
        retValue = this.processOnline();
        this.saveEx();
        return retValue;
    }

    @Override
    public void setProcessUI(IProcessUI processUI) {
        this.m_processUI = processUI;
    }

    @Override
    public PO getPO() {
        return this;
    }

    public static MPaymentTransaction copyFrom(MPaymentTransaction from, Timestamp dateTrx, String trxType, String orig_TrxID, String trxName) {
        MPaymentTransaction to = new MPaymentTransaction(from.getCtx(), 0, trxName);
        to.set_TrxName(trxName);
        PO.copyValues(from, to, from.getAD_Client_ID(), from.getAD_Org_ID());
        to.set_ValueNoCheck("C_PaymentTransaction_ID", I_ZERO);
        to.setA_City(from.getA_City());
        to.setA_Country(from.getA_Country());
        to.setA_EMail(from.getA_EMail());
        to.setA_Ident_DL(from.getA_Ident_DL());
        to.setA_Ident_SSN(from.getA_Ident_SSN());
        to.setA_Name(from.getA_Name());
        to.setA_State(from.getA_State());
        to.setA_Street(from.getA_Street());
        to.setA_Zip(from.getA_Zip());
        to.setAccountNo(from.getAccountNo());
        to.setIBAN(from.getIBAN());
        to.setAD_Org_ID(from.getAD_Org_ID());
        to.setC_BankAccount_ID(from.getC_BankAccount_ID());
        to.setC_BP_BankAccount_ID(from.getC_BP_BankAccount_ID());
        to.setC_BPartner_ID(from.getC_BPartner_ID());
        to.setC_ConversionType_ID(from.getC_ConversionType_ID());
        to.setC_Currency_ID(from.getC_Currency_ID());
        to.setC_Invoice_ID(from.getC_Invoice_ID());
        to.setC_Order_ID(from.getC_Order_ID());
        to.setC_PaymentProcessor_ID(from.getC_PaymentProcessor_ID());
        to.setC_POSTenderType_ID(from.getC_POSTenderType_ID());
        to.setCheckNo(from.getCheckNo());
        to.setCreditCardExpMM(from.getCreditCardExpMM());
        to.setCreditCardExpYY(from.getCreditCardExpYY());
        to.setCreditCardNumber(from.getCreditCardNumber());
        to.setCreditCardType(from.getCreditCardType());
        to.setCreditCardVV(from.getCreditCardVV());
        to.setCustomerAddressID(from.getCustomerAddressID());
        to.setCustomerPaymentProfileID(from.getCustomerPaymentProfileID());
        to.setCustomerProfileID(from.getCustomerProfileID());
        to.setDateTrx(dateTrx);
        to.setDescription(from.getDescription());
        to.setIsActive(from.isActive());
        to.setIsApproved(false);
        to.setIsDelayedCapture(false);
        to.setIsOnline(from.isOnline());
        to.setIsReceipt(from.isReceipt());
        to.setIsSelfService(from.isSelfService());
        to.setIsVoided(false);
        to.setMicr(from.getMicr());
        to.setOrig_TrxID(orig_TrxID);
        to.setPayAmt(from.getPayAmt());
        to.setPONum(from.getPONum());
        to.setProcessed(false);
        to.setR_AuthCode(null);
        to.setR_AvsAddr(null);
        to.setR_AvsZip(null);
        to.setR_CVV2Match(false);
        to.setR_Info(null);
        to.setR_PnRef(null);
        to.setR_RespMsg(null);
        to.setR_Result(null);
        to.setR_VoidMsg(null);
        to.setRoutingNo(from.getRoutingNo());
        to.setSwiftCode(from.getSwiftCode());
        to.setTaxAmt(from.getTaxAmt());
        to.setTenderType(from.getTenderType());
        to.setTrxType(trxType);
        to.setVoiceAuthCode(from.getVoiceAuthCode());
        if (!to.save(trxName)) {
            throw new IllegalStateException("Could not create Payment Transaction");
        }
        return to;
    }

    public static int[] getAuthorizationPaymentTransactionIDs(int C_Order_ID, int C_Invoice_ID, String trxName) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("TenderType='").append("C").append("' ");
        whereClause.append("AND TrxType='").append("A").append("' ");
        if (C_Order_ID > 0 && C_Invoice_ID > 0) {
            whereClause.append(" AND (C_Order_ID=").append(C_Order_ID).append(" OR C_Invoice_ID=").append(C_Invoice_ID).append(")");
        } else if (C_Order_ID > 0) {
            whereClause.append(" AND C_Order_ID=").append(C_Order_ID);
        } else if (C_Invoice_ID > 0) {
            whereClause.append(" AND C_Invoice_ID=").append(C_Invoice_ID);
        }
        whereClause.append(" AND IsApproved='Y' AND IsVoided='N' AND IsDelayedCapture='N' ");
        whereClause.append("ORDER BY DateTrx DESC");
        return MPaymentTransaction.getAllIDs("C_PaymentTransaction", whereClause.toString(), trxName);
    }

    public static int[] getAuthorizationPaymentTransactionIDs(int[] orderIDList, int C_Invoice_ID, String trxName) {
        String orderIDs;
        StringBuilder sb = new StringBuilder();
        if (orderIDList != null) {
            int[] nArray = orderIDList;
            int n = orderIDList.length;
            int n2 = 0;
            while (n2 < n) {
                int orderID = nArray[n2];
                sb.append(orderID).append(",");
                ++n2;
            }
        }
        if ((orderIDs = sb.toString()).length() > 0) {
            orderIDs = orderIDs.substring(0, orderIDs.length() - 1);
        }
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("TenderType='").append("C").append("' ");
        whereClause.append("AND TrxType='").append("A").append("' ");
        if (orderIDs.length() > 0 && C_Invoice_ID > 0) {
            whereClause.append(" AND (C_Order_ID IN (").append(orderIDs).append(") OR C_Invoice_ID=").append(C_Invoice_ID).append(")");
        } else if (orderIDs.length() > 0) {
            whereClause.append(" AND C_Order_ID IN ('").append(orderIDs).append(")");
        } else if (C_Invoice_ID > 0) {
            whereClause.append(" AND C_Invoice_ID=").append(C_Invoice_ID);
        }
        whereClause.append(" AND IsApproved='Y' AND IsVoided='N' AND IsDelayedCapture='N' ");
        whereClause.append("ORDER BY DateTrx DESC");
        return MPaymentTransaction.getAllIDs("C_PaymentTransaction", whereClause.toString(), trxName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MPaymentTransaction[");
        sb.append(this.get_ID()).append("-").append(",Receipt=").append(this.isReceipt()).append(",PayAmt=").append(this.getPayAmt());
        return sb.toString();
    }
}

