/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.Lookup;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.NamePair;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;

public class MPaymentLookup
extends Lookup
implements Serializable {
    private static final long serialVersionUID = 2876345457828980720L;
    private Properties m_ctx;
    private boolean m_isSOTrx = false;
    private String m_validationCode;

    public MPaymentLookup(Properties ctx, int windowNo, String validationCode) {
        super(19, windowNo);
        this.m_ctx = ctx;
        this.m_isSOTrx = "Y".equals(Env.getContext(Env.getCtx(), windowNo, "IsSOTrx"));
        this.m_validationCode = validationCode;
    }

    @Override
    public String getDisplay(Object key) {
        ValueNamePair[] values;
        if (key == null) {
            return null;
        }
        ValueNamePair[] valueNamePairArray = values = this.getData();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            ValueNamePair value = valueNamePairArray[n2];
            if (value.getValue().equals(key.toString())) {
                return value.getName();
            }
            ++n2;
        }
        StringBuilder msgreturn = new StringBuilder("<").append(key.toString()).append(">");
        return msgreturn.toString();
    }

    @Override
    public NamePair get(Object key) {
        ValueNamePair[] values;
        if (key == null) {
            return null;
        }
        ValueNamePair[] valueNamePairArray = values = this.getData();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            ValueNamePair value = valueNamePairArray[n2];
            if (value.getValue().equals(key.toString())) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        ValueNamePair[] values;
        ValueNamePair[] valueNamePairArray = values = this.getData();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            ValueNamePair value = valueNamePairArray[n2];
            if (value.getValue().equals(key.toString())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean containsKeyNoDirect(Object key) {
        return this.containsKey(key);
    }

    @Override
    public String getColumnName() {
        return "PaymentRule";
    }

    private ValueNamePair[] getData() {
        ArrayList<ValueNamePair> list;
        block12: {
            String ad_language = Env.getAD_Language(this.m_ctx);
            boolean isBaseLanguage = Env.isBaseLanguage(ad_language, "AD_Ref_List");
            StringBuilder sb = new StringBuilder();
            if (isBaseLanguage) {
                sb.append("SELECT r.Value, r.Name FROM AD_Ref_List r WHERE r.AD_Reference_ID=? AND r.IsActive='Y'");
            } else {
                sb.append("SELECT r.Value, t.Name FROM AD_Ref_List_Trl t");
                sb.append(" INNER JOIN AD_Ref_List r ON (r.AD_Ref_List_ID=t.AD_Ref_List_ID)");
                sb.append(" WHERE r.AD_Reference_ID=? AND t.AD_Language=? AND r.IsActive='Y'");
            }
            String wc = this.getWhereClause();
            if (wc != null && wc.length() > 0) {
                wc = wc.replace("AD_Ref_List", "r");
                wc = wc.replace("AD_Ref_List_Trl", "t");
                sb.append(" AND ").append(wc);
            }
            if (isBaseLanguage) {
                sb.append(" ORDER BY r.Name");
            } else {
                sb.append(" ORDER BY t.Name");
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            list = new ArrayList<ValueNamePair>();
            try {
                try {
                    pstmt = DB.prepareStatement(sb.toString(), null);
                    pstmt.setInt(1, 195);
                    if (!isBaseLanguage) {
                        pstmt.setString(2, ad_language);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new ValueNamePair(rs.getString(1), rs.getString(2)));
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sb.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block12;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        ValueNamePair[] retValue = new ValueNamePair[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    @Override
    public String getValidation() {
        if (Util.isEmpty(this.m_validationCode, true)) {
            return "";
        }
        return this.m_validationCode.trim();
    }

    private String getWhereClause() {
        String whereClause = "";
        String validation = this.getValidation();
        if (validation == null) {
            validation = "";
        }
        if (whereClause.length() == 0) {
            whereClause = validation;
        } else if (validation.length() > 0) {
            whereClause = String.valueOf(whereClause) + " AND " + validation;
        }
        if (whereClause.indexOf(64) != -1) {
            String validated = Env.parseContext(Env.getCtx(), this.getWindowNo(), whereClause, false);
            if (validated.length() == 0) {
                this.log.severe(String.valueOf(this.getColumnName()) + " - Cannot Parse=" + whereClause);
            } else {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(String.valueOf(this.getColumnName()) + " - Parsed: " + validated);
                }
                return validated;
            }
        }
        return whereClause;
    }

    @Override
    public ArrayList<Object> getData(boolean mandatory, boolean onlyValidated, boolean onlyActive, boolean temporary, boolean shortlist) {
        ValueNamePair[] values;
        ArrayList<Object> list = new ArrayList<Object>();
        ValueNamePair[] valueNamePairArray = values = this.getData();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            ValueNamePair value = valueNamePairArray[n2];
            String PaymentRule = value.getValue();
            if (!("D".equals(PaymentRule) && !this.m_isSOTrx || "T".equals(PaymentRule) && this.m_isSOTrx)) {
                list.add(value);
            }
            ++n2;
        }
        return list;
    }

    @Override
    public int refresh() {
        this.fillComboBox(this.isMandatory(), true, true, false, false);
        return super.getSize();
    }
}

