/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MDepositBatch;
import org.compiere.model.MDepositBatchLine;
import org.compiere.model.MDocType;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentAllocate;
import org.compiere.model.MPaymentBatch;
import org.compiere.model.X_C_PaySelectionCheck;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class MPaySelectionCheck
extends X_C_PaySelectionCheck {
    private static final long serialVersionUID = 2130445794890189020L;
    private static CLogger s_log = CLogger.getCLogger(MPaySelectionCheck.class);
    private MPaySelection m_parent = null;
    private MPaySelectionLine[] m_lines = null;

    public static MPaySelectionCheck getOfPayment(Properties ctx, int C_Payment_ID, String trxName) {
        int count;
        MPaySelectionCheck retValue;
        block10: {
            retValue = null;
            String sql = "SELECT * FROM C_PaySelectionCheck WHERE C_Payment_ID=?";
            count = 0;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, C_Payment_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MPaySelectionCheck psc = new MPaySelectionCheck(ctx, rs, trxName);
                        if (retValue == null) {
                            retValue = psc;
                        } else if (!retValue.isProcessed() && psc.isProcessed()) {
                            retValue = psc;
                        }
                        ++count;
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (count > 1) {
            s_log.warning("More then one for C_Payment_ID=" + C_Payment_ID);
        }
        return retValue;
    }

    public static MPaySelectionCheck createForPayment(Properties ctx, int C_Payment_ID, String trxName) {
        if (C_Payment_ID == 0) {
            return null;
        }
        MPayment payment = new MPayment(ctx, C_Payment_ID, null);
        String PaymentRule = "S";
        if (payment.getTenderType().equals("C")) {
            PaymentRule = "K";
        } else if (payment.getTenderType().equals("D")) {
            PaymentRule = "D";
        } else if (payment.getTenderType().equals("A")) {
            PaymentRule = "T";
        } else if (payment.getTenderType().equals("X")) {
            PaymentRule = "B";
        }
        MPaySelection ps = new MPaySelection(ctx, 0, trxName);
        ps.setAD_Org_ID(payment.getAD_Org_ID());
        ps.setC_BankAccount_ID(payment.getC_BankAccount_ID());
        ps.setName(String.valueOf(Msg.translate(ctx, "C_Payment_ID")) + ": " + payment.getDocumentNo());
        ps.setDescription(payment.getDescription());
        ps.setPayDate(payment.getDateTrx());
        ps.setTotalAmt(payment.getPayAmt());
        ps.setIsApproved(true);
        ps.saveEx();
        MPaySelectionCheck psc = new MPaySelectionCheck(ps, PaymentRule);
        psc.setC_BPartner_ID(payment.getC_BPartner_ID());
        psc.setC_Payment_ID(payment.getC_Payment_ID());
        psc.setIsReceipt(payment.isReceipt());
        psc.setPayAmt(payment.getPayAmt());
        psc.setDiscountAmt(payment.getDiscountAmt());
        psc.setWriteOffAmt(payment.getWriteOffAmt());
        psc.setQty(1);
        psc.setDocumentNo(payment.getDocumentNo());
        psc.setProcessed(true);
        psc.setIsGeneratedDraft(!payment.isProcessed());
        psc.saveEx();
        MPaySelectionLine psl = null;
        if (payment.getC_Invoice_ID() != 0) {
            psl = new MPaySelectionLine(ps, 10, PaymentRule);
            psl.setC_Invoice_ID(payment.getC_Invoice_ID());
            psl.setIsSOTrx(payment.isReceipt());
            psl.setOpenAmt(payment.getPayAmt().add(payment.getDiscountAmt()));
            psl.setPayAmt(payment.getPayAmt());
            psl.setDiscountAmt(payment.getDiscountAmt());
            psl.setWriteOffAmt(payment.getWriteOffAmt());
            psl.setDifferenceAmt(Env.ZERO);
            psl.setC_PaySelectionCheck_ID(psc.getC_PaySelectionCheck_ID());
            psl.setProcessed(true);
            psl.saveEx();
        } else {
            MPaymentAllocate[] pAllocs = MPaymentAllocate.get(payment);
            if (pAllocs.length != 0) {
                int numInv = 0;
                int i2 = 0;
                while (i2 < pAllocs.length) {
                    MPaymentAllocate pAlloc = pAllocs[i2];
                    if (pAlloc.getC_Invoice_ID() != 0) {
                        MPaySelectionLine psla = null;
                        psla = new MPaySelectionLine(ps, 10 * (i2 + 1), PaymentRule);
                        psla.setC_Invoice_ID(pAlloc.getC_Invoice_ID());
                        psla.setIsSOTrx(payment.isReceipt());
                        psla.setOpenAmt(pAlloc.getAmount().add(pAlloc.getDiscountAmt()));
                        psla.setPayAmt(pAlloc.getAmount());
                        psla.setDiscountAmt(pAlloc.getDiscountAmt());
                        psla.setWriteOffAmt(pAlloc.getWriteOffAmt());
                        psla.setDifferenceAmt(Env.ZERO);
                        psla.setC_PaySelectionCheck_ID(psc.getC_PaySelectionCheck_ID());
                        psla.setProcessed(true);
                        psla.saveEx();
                        ++numInv;
                    }
                    ++i2;
                }
                if (numInv > 0) {
                    psc.setQty(numInv);
                    psc.saveEx();
                }
            }
        }
        ps.setProcessed(true);
        ps.saveEx();
        return psc;
    }

    public static MPaySelectionCheck[] get(int C_PaySelection_ID, String PaymentRule, String trxName) {
        ArrayList<MPaySelectionCheck> list;
        block7: {
            if (s_log.isLoggable(Level.FINE)) {
                s_log.fine("C_PaySelection_ID=" + C_PaySelection_ID + ", PaymentRule=" + PaymentRule);
            }
            list = new ArrayList<MPaySelectionCheck>();
            String sql = "SELECT * FROM C_PaySelectionCheck WHERE C_PaySelection_ID=? AND PaymentRule=? ORDER BY C_PaySelectionCheck_ID";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, C_PaySelection_ID);
                    pstmt.setString(2, PaymentRule);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MPaySelectionCheck check = new MPaySelectionCheck(Env.getCtx(), rs, trxName);
                        list.add(check);
                    }
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MPaySelectionCheck[] retValue = new MPaySelectionCheck[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MPaySelectionCheck[] get(int C_PaySelection_ID, String PaymentRule, int startDocumentNo, String trxName) {
        MPaySelectionCheck[] checks = MPaySelectionCheck.get(C_PaySelection_ID, PaymentRule, trxName);
        int docNo = startDocumentNo;
        MPaySelectionCheck[] mPaySelectionCheckArray = checks;
        int n = checks.length;
        int n2 = 0;
        while (n2 < n) {
            MPaySelectionCheck check = mPaySelectionCheckArray[n2];
            check.setDocumentNo(String.valueOf(docNo++));
            check.saveEx();
            ++n2;
        }
        return checks;
    }

    /*
     * Unable to fully structure code
     */
    public static void confirmPrint(MPaySelectionCheck check, MPaymentBatch batch) {
        localTrx = false;
        trxName = check.get_TrxName();
        trx = null;
        if (trxName == null) {
            localTrx = true;
            trxName = Trx.createTrxName("ConfirmPrintSingle");
            trx = Trx.get(trxName, true);
            trx.setDisplayName(String.valueOf(MPaySelectionCheck.class.getName()) + "_confirmPrint");
            check.set_TrxName(trxName);
        }
        try {
            block26: {
                payment = new MPayment(check.getCtx(), check.getC_Payment_ID(), trxName);
                if (check.getC_Payment_ID() == 0) break block26;
                if (check.getPaymentRule().equals("S")) {
                    payment.setCheckNo(check.getDocumentNo());
                    payment.saveEx();
                }
                ** GOTO lbl70
            }
            payment = new MPayment(check.getCtx(), 0, trxName);
            payment.setAD_Org_ID(check.getAD_Org_ID());
            if (check.getPaymentRule().equals("S")) {
                payment.setBankCheck(check.getParent().getC_BankAccount_ID(), false, check.getDocumentNo());
            } else if (check.getPaymentRule().equals("K")) {
                payment.setTenderType("C");
            } else if (check.getPaymentRule().equals("T") || check.getPaymentRule().equals("D")) {
                payment.setBankACH(check);
            } else {
                MPaySelectionCheck.s_log.log(Level.SEVERE, "Unsupported Payment Rule=" + check.getPaymentRule());
                return;
            }
            try {
                payment.setTrxType("C");
                payment.setAmount(check.getParent().getC_Currency_ID(), check.getPayAmt());
                payment.setDiscountAmt(check.getDiscountAmt());
                payment.setWriteOffAmt(check.getWriteOffAmt());
                payment.setDateTrx(check.getParent().getPayDate());
                payment.setDateAcct(payment.getDateTrx());
                payment.setC_BPartner_ID(check.getC_BPartner_ID());
                if (batch != null) {
                    if (batch.getC_PaymentBatch_ID() == 0) {
                        batch.saveEx(trxName);
                    }
                    payment.setC_PaymentBatch_ID(batch.getC_PaymentBatch_ID());
                }
                psls = check.getPaySelectionLines(true);
                if (MPaySelectionCheck.s_log.isLoggable(Level.FINE)) {
                    MPaySelectionCheck.s_log.fine("confirmPrint - " + check + " (#SelectionLines=" + psls.length + ")");
                }
                if (check.getQty() == 1 && psls != null && psls.length == 1) {
                    psl = psls[0];
                    if (MPaySelectionCheck.s_log.isLoggable(Level.FINE)) {
                        MPaySelectionCheck.s_log.fine("Map to Invoice " + psl);
                    }
                    payment.setC_Invoice_ID(psl.getC_Invoice_ID());
                    payment.setDiscountAmt(psl.getDiscountAmt());
                    payment.setWriteOffAmt(psl.getWriteOffAmt());
                    overUnder = psl.getOpenAmt().subtract(psl.getPayAmt()).subtract(psl.getDiscountAmt()).subtract(psl.getWriteOffAmt()).subtract(psl.getDifferenceAmt());
                    payment.setOverUnderAmt(overUnder);
                } else {
                    payment.setWriteOffAmt(Env.ZERO);
                    payment.setDiscountAmt(Env.ZERO);
                }
                payment.saveEx();
                C_Payment_ID = payment.get_ID();
                if (C_Payment_ID < 1) {
                    MPaySelectionCheck.s_log.log(Level.SEVERE, "Payment not created=" + check);
                } else {
                    check.setC_Payment_ID(C_Payment_ID);
                    check.saveEx();
                    if (!payment.processIt("CO")) {
                        throw new AdempiereException("Failed when processing document - " + payment.getProcessMsg());
                    }
                    payment.saveEx();
                }
lbl70:
                // 3 sources

                check.setIsPrinted(true);
                check.setProcessed(true);
                check.saveEx();
            }
            catch (Exception e) {
                if (localTrx && trx != null) {
                    trx.rollback();
                    trx.close();
                    trx = null;
                }
                throw new AdempiereException(e);
            }
        }
        finally {
            if (localTrx && trx != null) {
                trx.commit();
                trx.close();
            }
        }
    }

    public static int confirmPrint(MPaySelectionCheck[] checks, MPaymentBatch batch, boolean createDepositBatch) {
        boolean localTrx = false;
        String trxName = null;
        int lastDocumentNo = 0;
        if (checks.length > 0) {
            Boolean isDebit;
            trxName = checks[0].get_TrxName();
            Properties ctx = checks[0].getCtx();
            int c_BankAccount_ID = checks[0].getC_PaySelection().getC_BankAccount_ID();
            String paymentRule = checks[0].getPaymentRule();
            if ("T".compareTo(paymentRule) == 0 || "S".compareTo(paymentRule) == 0 || "P".compareTo(paymentRule) == 0) {
                isDebit = false;
            } else if ("D".compareTo(paymentRule) == 0) {
                isDebit = true;
            } else {
                isDebit = false;
                createDepositBatch = false;
            }
            Trx trx = null;
            if (trxName == null) {
                localTrx = true;
                trxName = Trx.createTrxName("ConfirmPrintMulti");
                trx = Trx.get(trxName, true);
            }
            try {
                try {
                    MDepositBatch depositBatch = null;
                    if (createDepositBatch) {
                        depositBatch = new MDepositBatch(ctx, 0, trxName);
                        depositBatch.setC_BankAccount_ID(c_BankAccount_ID);
                        if (isDebit.booleanValue()) {
                            depositBatch.setC_DocType_ID(MDocType.getDocType("ARR"));
                        } else {
                            depositBatch.setC_DocType_ID(MDocType.getDocType("APP"));
                        }
                        depositBatch.setDateDeposit(new Timestamp(new Date().getTime()));
                        depositBatch.setDateDoc(new Timestamp(new Date().getTime()));
                        depositBatch.saveEx();
                    }
                    int i2 = 0;
                    while (i2 < checks.length) {
                        MPaySelectionCheck check = checks[i2];
                        if (localTrx) {
                            check.set_TrxName(trxName);
                        }
                        MPaySelectionCheck.confirmPrint(check, batch);
                        if (createDepositBatch) {
                            MDepositBatchLine depositBatchLine = new MDepositBatchLine(depositBatch);
                            depositBatchLine.setC_Payment_ID(check.getC_Payment_ID());
                            depositBatchLine.setProcessed(true);
                            depositBatchLine.saveEx();
                        }
                        try {
                            int no = Integer.parseInt(check.getDocumentNo());
                            if (lastDocumentNo < no) {
                                lastDocumentNo = no;
                            }
                        }
                        catch (NumberFormatException ex) {
                            s_log.log(Level.SEVERE, "DocumentNo=" + check.getDocumentNo(), ex);
                        }
                        ++i2;
                    }
                    if (createDepositBatch) {
                        depositBatch.setProcessed(true);
                        depositBatch.saveEx();
                    }
                }
                catch (Exception e) {
                    if (localTrx && trx != null) {
                        trx.rollback();
                        trx.close();
                        trx = null;
                    }
                    throw new AdempiereException(e);
                }
            }
            finally {
                if (localTrx && trx != null) {
                    trx.commit();
                    trx.close();
                }
            }
        }
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("Last Document No = " + lastDocumentNo);
        }
        return lastDocumentNo;
    }

    public static int confirmPrint(MPaySelectionCheck[] checks, MPaymentBatch batch) {
        return MPaySelectionCheck.confirmPrint(checks, batch, false);
    }

    public MPaySelectionCheck(Properties ctx, int C_PaySelectionCheck_ID, String trxName) {
        super(ctx, C_PaySelectionCheck_ID, trxName);
        if (C_PaySelectionCheck_ID == 0) {
            this.setPayAmt(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setWriteOffAmt(Env.ZERO);
            this.setIsPrinted(false);
            this.setIsReceipt(false);
            this.setQty(0);
        }
    }

    public MPaySelectionCheck(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPaySelectionCheck(MPaySelectionLine line, String PaymentRule) {
        this(line.getCtx(), 0, line.get_TrxName());
        this.setClientOrg(line);
        this.setC_PaySelection_ID(line.getC_PaySelection_ID());
        int C_BPartner_ID = line.getInvoice().getC_BPartner_ID();
        this.setC_BPartner_ID(C_BPartner_ID);
        if ("D".equals(PaymentRule)) {
            MBPBankAccount[] bas = MBPBankAccount.getOfBPartner(line.getCtx(), C_BPartner_ID);
            int i2 = 0;
            while (i2 < bas.length) {
                MBPBankAccount account = bas[i2];
                if (account.isDirectDebit()) {
                    this.setC_BP_BankAccount_ID(account.getC_BP_BankAccount_ID());
                    break;
                }
                ++i2;
            }
        } else if ("T".equals(PaymentRule)) {
            MBPBankAccount[] bas = MBPBankAccount.getOfBPartner(line.getCtx(), C_BPartner_ID);
            int i3 = 0;
            while (i3 < bas.length) {
                MBPBankAccount account = bas[i3];
                if (account.isDirectDeposit()) {
                    this.setC_BP_BankAccount_ID(account.getC_BP_BankAccount_ID());
                    break;
                }
                ++i3;
            }
        }
        this.setPaymentRule(PaymentRule);
        this.setIsReceipt(line.isSOTrx());
        this.setPayAmt(line.getPayAmt());
        this.setDiscountAmt(line.getDiscountAmt());
        this.setWriteOffAmt(line.getWriteOffAmt());
        this.setQty(1);
    }

    public MPaySelectionCheck(MPaySelection ps, String PaymentRule) {
        this(ps.getCtx(), 0, ps.get_TrxName());
        this.setClientOrg(ps);
        this.setC_PaySelection_ID(ps.getC_PaySelection_ID());
        this.setPaymentRule(PaymentRule);
    }

    public void addLine(MPaySelectionLine line) {
        if (this.getC_BPartner_ID() != line.getInvoice().getC_BPartner_ID()) {
            throw new IllegalArgumentException("Line for different BPartner");
        }
        if (this.isReceipt() == line.isSOTrx()) {
            this.setPayAmt(this.getPayAmt().add(line.getPayAmt()));
            this.setDiscountAmt(this.getDiscountAmt().add(line.getDiscountAmt()));
            this.setWriteOffAmt(this.getWriteOffAmt().add(line.getWriteOffAmt()));
        } else {
            this.setPayAmt(this.getPayAmt().subtract(line.getPayAmt()));
            this.setDiscountAmt(this.getDiscountAmt().subtract(line.getDiscountAmt()));
            this.setWriteOffAmt(this.getWriteOffAmt().subtract(line.getWriteOffAmt()));
        }
        this.setQty(this.getQty() + 1);
    }

    public MPaySelection getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MPaySelection(this.getCtx(), this.getC_PaySelection_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public boolean isValid() {
        if (this.getC_BP_BankAccount_ID() != 0) {
            return true;
        }
        return !this.isDirect();
    }

    public boolean isDirect() {
        return "T".equals(this.getPaymentRule()) || "D".equals(this.getPaymentRule());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MPaymentCheck[");
        sb.append(this.get_ID()).append("-").append(this.getDocumentNo()).append("-").append(this.getPayAmt()).append(",PaymetRule=").append(this.getPaymentRule()).append(",Qty=").append(this.getQty()).append("]");
        return sb.toString();
    }

    public MPaySelectionLine[] getPaySelectionLines(boolean requery) {
        ArrayList<MPaySelectionLine> list;
        block7: {
            if (this.m_lines != null && !requery) {
                MPaySelectionCheck.set_TrxName(this.m_lines, this.get_TrxName());
                return this.m_lines;
            }
            list = new ArrayList<MPaySelectionLine>();
            String sql = "SELECT * FROM C_PaySelectionLine WHERE C_PaySelectionCheck_ID=? ORDER BY Line";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getC_PaySelectionCheck_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MPaySelectionLine(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_lines = new MPaySelectionLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public static boolean deleteGeneratedDraft(Properties ctx, int C_Payment_ID, String trxName) {
        MPaySelectionCheck mpsc = MPaySelectionCheck.getOfPayment(ctx, C_Payment_ID, trxName);
        if (mpsc != null && mpsc.isGeneratedDraft()) {
            MPaySelection mps = new MPaySelection(ctx, mpsc.getC_PaySelection_ID(), trxName);
            MPaySelectionLine[] mpsl = mps.getLines(true);
            int i2 = 0;
            while (i2 < mpsl.length) {
                if (!mpsl[i2].delete(true, trxName)) {
                    return false;
                }
                ++i2;
            }
            if (!mpsc.delete(true, trxName)) {
                return false;
            }
            if (!mps.delete(true, trxName)) {
                return false;
            }
        }
        return true;
    }
}

