/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.adempiere.base.Core;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.BPartnerNoBillToAddressException;
import org.adempiere.exceptions.BPartnerNoShipToAddressException;
import org.adempiere.exceptions.FillMandatoryException;
import org.adempiere.model.ITaxProvider;
import org.adempiere.process.SalesOrderRateInquiryProcess;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MBankAccount;
import org.compiere.model.MClientInfo;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MDocTypeCounter;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoicePaySchedule;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrderLandedCost;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrderPaySchedule;
import org.compiere.model.MOrderTax;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MPeriod;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductBOM;
import org.compiere.model.MProject;
import org.compiere.model.MRefList;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MShippingTransaction;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MStorageReservation;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTax;
import org.compiere.model.MTaxProvider;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_DocType;
import org.compiere.model.X_C_Order;
import org.compiere.model.X_C_OrderLine;
import org.compiere.model.X_C_POSPayment;
import org.compiere.model.X_C_POSTenderType;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class MOrder
extends X_C_Order
implements DocAction {
    private static final long serialVersionUID = -7784588474522162502L;
    protected MOrderLine[] m_lines = null;
    protected MOrderTax[] m_taxes = null;
    protected boolean m_forceCreation = false;
    public static final String DocSubTypeSO_Standard = "SO";
    public static final String DocSubTypeSO_Quotation = "OB";
    public static final String DocSubTypeSO_Proposal = "ON";
    public static final String DocSubTypeSO_Prepay = "PR";
    public static final String DocSubTypeSO_POS = "WR";
    public static final String DocSubTypeSO_Warehouse = "WP";
    public static final String DocSubTypeSO_OnCredit = "WI";
    public static final String DocSubTypeSO_RMA = "RM";
    private static volatile boolean recursiveCall = false;
    protected String m_processMsg = null;
    protected boolean m_justPrepared = false;

    public static MOrder copyFrom(MOrder from, Timestamp dateDoc, int C_DocTypeTarget_ID, boolean isSOTrx, boolean counter, boolean copyASI, String trxName) {
        MOrder to = new MOrder(from.getCtx(), 0, trxName);
        to.set_TrxName(trxName);
        PO.copyValues(from, to, from.getAD_Client_ID(), from.getAD_Org_ID());
        to.set_ValueNoCheck("C_Order_ID", I_ZERO);
        to.set_ValueNoCheck("DocumentNo", null);
        to.setDocStatus("DR");
        to.setDocAction("CO");
        to.setC_DocType_ID(0);
        to.setC_DocTypeTarget_ID(C_DocTypeTarget_ID);
        to.setIsSOTrx(isSOTrx);
        to.setIsSelected(false);
        to.setDateOrdered(dateDoc);
        to.setDateAcct(dateDoc);
        to.setDatePromised(dateDoc);
        to.setDatePrinted(null);
        to.setIsPrinted(false);
        to.setIsApproved(false);
        to.setIsCreditApproved(false);
        to.setC_Payment_ID(0);
        to.setC_CashLine_ID(0);
        to.setGrandTotal(Env.ZERO);
        to.setTotalLines(Env.ZERO);
        to.setIsDelivered(false);
        to.setIsInvoiced(false);
        to.setIsSelfService(false);
        to.setIsTransferred(false);
        to.setPosted(false);
        to.setProcessed(false);
        if (counter) {
            to.setRef_Order_ID(from.getC_Order_ID());
            MOrg org = MOrg.get(from.getCtx(), from.getAD_Org_ID());
            int counterC_BPartner_ID = org.getLinkedC_BPartner_ID(trxName);
            if (counterC_BPartner_ID == 0) {
                return null;
            }
            to.setBPartner(MBPartner.get(from.getCtx(), counterC_BPartner_ID));
        } else {
            to.setRef_Order_ID(0);
        }
        if (!to.save(trxName)) {
            throw new IllegalStateException("Could not create Order");
        }
        if (counter) {
            from.setRef_Order_ID(to.getC_Order_ID());
        }
        if (to.copyLinesFrom(from, counter, copyASI) == 0) {
            throw new IllegalStateException("Could not create Order Lines");
        }
        to.setLink_Order_ID(0);
        return to;
    }

    public MOrder(Properties ctx, int C_Order_ID, String trxName) {
        super(ctx, C_Order_ID, trxName);
        if (C_Order_ID == 0) {
            this.setDocStatus("DR");
            this.setDocAction(DocSubTypeSO_Prepay);
            this.setDeliveryRule("A");
            this.setFreightCostRule("I");
            this.setInvoiceRule("I");
            this.setPaymentRule("P");
            this.setPriorityRule("5");
            this.setDeliveryViaRule("P");
            this.setIsDiscountPrinted(false);
            this.setIsSelected(false);
            this.setIsTaxIncluded(false);
            this.setIsSOTrx(true);
            this.setIsDropShip(false);
            this.setSendEMail(false);
            this.setIsApproved(false);
            this.setIsPrinted(false);
            this.setIsCreditApproved(false);
            this.setIsDelivered(false);
            this.setIsInvoiced(false);
            this.setIsTransferred(false);
            this.setIsSelfService(false);
            super.setProcessed(false);
            this.setProcessing(false);
            this.setPosted(false);
            this.setDateAcct(new Timestamp(System.currentTimeMillis()));
            this.setDatePromised(new Timestamp(System.currentTimeMillis()));
            this.setDateOrdered(new Timestamp(System.currentTimeMillis()));
            this.setFreightAmt(Env.ZERO);
            this.setChargeAmt(Env.ZERO);
            this.setTotalLines(Env.ZERO);
            this.setGrandTotal(Env.ZERO);
        }
    }

    public MOrder(MProject project, boolean IsSOTrx, String DocSubTypeSO) {
        this(project.getCtx(), 0, project.get_TrxName());
        this.setAD_Client_ID(project.getAD_Client_ID());
        this.setAD_Org_ID(project.getAD_Org_ID());
        this.setC_Campaign_ID(project.getC_Campaign_ID());
        this.setSalesRep_ID(project.getSalesRep_ID());
        this.setC_Project_ID(project.getC_Project_ID());
        this.setDescription(project.getName());
        Timestamp ts = project.getDateContract();
        if (ts != null) {
            this.setDateOrdered(ts);
        }
        if ((ts = project.getDateFinish()) != null) {
            this.setDatePromised(ts);
        }
        this.setC_BPartner_ID(project.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(project.getC_BPartner_Location_ID());
        this.setAD_User_ID(project.getAD_User_ID());
        this.setM_Warehouse_ID(project.getM_Warehouse_ID());
        this.setM_PriceList_ID(project.getM_PriceList_ID());
        this.setC_PaymentTerm_ID(project.getC_PaymentTerm_ID());
        this.setIsSOTrx(IsSOTrx);
        if (IsSOTrx) {
            if (DocSubTypeSO == null || DocSubTypeSO.length() == 0) {
                this.setC_DocTypeTarget_ID(DocSubTypeSO_OnCredit);
            } else {
                this.setC_DocTypeTarget_ID(DocSubTypeSO);
            }
        } else {
            this.setC_DocTypeTarget_ID();
        }
    }

    public MOrder(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(String.valueOf(desc) + " | " + description);
        }
    }

    @Override
    public void setC_BPartner_ID(int C_BPartner_ID) {
        super.setC_BPartner_ID(C_BPartner_ID);
        super.setBill_BPartner_ID(C_BPartner_ID);
    }

    @Override
    public void setC_BPartner_Location_ID(int C_BPartner_Location_ID) {
        super.setC_BPartner_Location_ID(C_BPartner_Location_ID);
        super.setBill_Location_ID(C_BPartner_Location_ID);
    }

    @Override
    public void setAD_User_ID(int AD_User_ID) {
        super.setAD_User_ID(AD_User_ID);
        super.setBill_User_ID(AD_User_ID);
    }

    public void setShip_BPartner_ID(int C_BPartner_ID) {
        super.setC_BPartner_ID(C_BPartner_ID);
    }

    public void setShip_Location_ID(int C_BPartner_Location_ID) {
        super.setC_BPartner_Location_ID(C_BPartner_Location_ID);
    }

    public void setShip_User_ID(int AD_User_ID) {
        super.setAD_User_ID(AD_User_ID);
    }

    @Override
    public void setM_Warehouse_ID(int M_Warehouse_ID) {
        super.setM_Warehouse_ID(M_Warehouse_ID);
    }

    @Override
    public void setIsDropShip(boolean IsDropShip) {
        super.setIsDropShip(IsDropShip);
    }

    public void setC_DocTypeTarget_ID(String DocSubTypeSO_x) {
        String sql = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID=? AND AD_Org_ID IN (0," + this.getAD_Org_ID() + ") AND DocSubTypeSO=? " + " AND IsActive='Y' " + "ORDER BY AD_Org_ID DESC, IsDefault DESC";
        int C_DocType_ID = DB.getSQLValue(null, sql, this.getAD_Client_ID(), DocSubTypeSO_x);
        if (C_DocType_ID <= 0) {
            this.log.severe("Not found for AD_Client_ID=" + this.getAD_Client_ID() + ", SubType=" + DocSubTypeSO_x);
        } else {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("(SO) - " + DocSubTypeSO_x);
            }
            this.setC_DocTypeTarget_ID(C_DocType_ID);
            this.setIsSOTrx(true);
        }
    }

    public void setC_DocTypeTarget_ID() {
        if (this.isSOTrx()) {
            this.setC_DocTypeTarget_ID(DocSubTypeSO_Standard);
            return;
        }
        String sql = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID=? AND AD_Org_ID IN (0," + this.getAD_Org_ID() + ") AND DocBaseType='POO' " + "ORDER BY AD_Org_ID DESC, IsDefault DESC";
        int C_DocType_ID = DB.getSQLValue(null, sql, this.getAD_Client_ID());
        if (C_DocType_ID <= 0) {
            this.log.severe("No POO found for AD_Client_ID=" + this.getAD_Client_ID());
        } else {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("(PO) - " + C_DocType_ID);
            }
            this.setC_DocTypeTarget_ID(C_DocType_ID);
        }
    }

    public void setBPartner(MBPartner bp) {
        MBPartnerLocation[] locs;
        String ss;
        if (bp == null) {
            return;
        }
        this.setC_BPartner_ID(bp.getC_BPartner_ID());
        int ii = 0;
        ii = this.isSOTrx() ? bp.getC_PaymentTerm_ID() : bp.getPO_PaymentTerm_ID();
        if (ii != 0) {
            this.setC_PaymentTerm_ID(ii);
        }
        if ((ii = this.isSOTrx() ? bp.getM_PriceList_ID() : bp.getPO_PriceList_ID()) != 0) {
            this.setM_PriceList_ID(ii);
        }
        if ((ss = bp.getDeliveryRule()) != null) {
            this.setDeliveryRule(ss);
        }
        if ((ss = bp.getDeliveryViaRule()) != null) {
            this.setDeliveryViaRule(ss);
        }
        if ((ss = bp.getInvoiceRule()) != null) {
            this.setInvoiceRule(ss);
        }
        if ((ss = bp.getPaymentRule()) != null) {
            this.setPaymentRule(ss);
        }
        if ((ii = bp.getSalesRep_ID()) != 0) {
            this.setSalesRep_ID(ii);
        }
        if ((locs = bp.getLocations(false)) != null) {
            int i2 = 0;
            while (i2 < locs.length) {
                if (locs[i2].isShipTo()) {
                    super.setC_BPartner_Location_ID(locs[i2].getC_BPartner_Location_ID());
                }
                if (locs[i2].isBillTo()) {
                    this.setBill_Location_ID(locs[i2].getC_BPartner_Location_ID());
                }
                ++i2;
            }
            if (this.getC_BPartner_Location_ID() == 0 && locs.length > 0) {
                super.setC_BPartner_Location_ID(locs[0].getC_BPartner_Location_ID());
            }
            if (this.getBill_Location_ID() == 0 && locs.length > 0) {
                this.setBill_Location_ID(locs[0].getC_BPartner_Location_ID());
            }
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            throw new BPartnerNoShipToAddressException(bp);
        }
        if (this.getBill_Location_ID() == 0) {
            throw new BPartnerNoBillToAddressException(bp);
        }
        MUser[] contacts = bp.getContacts(false);
        if (contacts != null && contacts.length == 1) {
            this.setAD_User_ID(contacts[0].getAD_User_ID());
        }
    }

    public int copyLinesFrom(MOrder otherOrder, boolean counter, boolean copyASI) {
        if (this.isProcessed() || this.isPosted() || otherOrder == null) {
            return 0;
        }
        MOrderLine[] fromLines = otherOrder.getLines(false, null);
        int count = 0;
        int i2 = 0;
        while (i2 < fromLines.length) {
            MOrderLine line = new MOrderLine(this);
            PO.copyValues(fromLines[i2], line, this.getAD_Client_ID(), this.getAD_Org_ID());
            line.setC_Order_ID(this.getC_Order_ID());
            line.setQtyDelivered(Env.ZERO);
            line.setQtyInvoiced(Env.ZERO);
            line.setQtyReserved(Env.ZERO);
            line.setDateDelivered(null);
            line.setDateInvoiced(null);
            line.setOrder(this);
            line.set_ValueNoCheck("C_OrderLine_ID", I_ZERO);
            if (!copyASI) {
                line.setM_AttributeSetInstance_ID(0);
                line.setS_ResourceAssignment_ID(0);
            }
            if (counter) {
                line.setRef_OrderLine_ID(fromLines[i2].getC_OrderLine_ID());
            } else {
                line.setRef_OrderLine_ID(0);
            }
            line.setLink_OrderLine_ID(0);
            if (this.getC_BPartner_ID() != otherOrder.getC_BPartner_ID()) {
                line.setTax();
            }
            line.setProcessed(false);
            if (line.save(this.get_TrxName())) {
                ++count;
            }
            if (counter) {
                fromLines[i2].setRef_OrderLine_ID(line.getC_OrderLine_ID());
                fromLines[i2].saveEx(this.get_TrxName());
            }
            ++i2;
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "Line difference - From=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MOrder[").append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",IsSOTrx=").append(this.isSOTrx()).append(",C_DocType_ID=").append(this.getC_DocType_ID()).append(", GrandTotal=").append(this.getGrandTotal()).append("]");
        return sb.toString();
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID() > 0 ? this.getC_DocType_ID() : this.getC_DocTypeTarget_ID());
        return String.valueOf(dt.getNameTrl()) + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        ReportEngine re = ReportEngine.get(this.getCtx(), 0, this.getC_Order_ID(), this.get_TrxName());
        if (re == null) {
            return null;
        }
        MPrintFormat format = re.getPrintFormat();
        if (format.getJasperProcess_ID() > 0) {
            ProcessInfo pi = new ProcessInfo("", format.getJasperProcess_ID());
            pi.setRecord_ID(this.getC_Order_ID());
            pi.setIsBatch(true);
            ServerProcessCtl.process(pi, null);
            return pi.getPDFReport();
        }
        return re.getPDF(file);
    }

    @Override
    public void setM_PriceList_ID(int M_PriceList_ID) {
        MPriceList pl = MPriceList.get(this.getCtx(), M_PriceList_ID, null);
        if (pl.get_ID() == M_PriceList_ID) {
            super.setM_PriceList_ID(M_PriceList_ID);
            this.setC_Currency_ID(pl.getC_Currency_ID());
            this.setIsTaxIncluded(pl.isTaxIncluded());
        }
    }

    public MOrderLine[] getLines(String whereClause, String orderClause) {
        StringBuilder whereClauseFinal = new StringBuilder("C_Order_ID=? ");
        if (!Util.isEmpty(whereClause, true)) {
            whereClauseFinal.append(whereClause);
        }
        if (orderClause.length() == 0) {
            orderClause = "Line";
        }
        List<MOrderLine> list = new Query(this.getCtx(), "C_OrderLine", whereClauseFinal.toString(), this.get_TrxName()).setParameters(this.get_ID()).setOrderBy(orderClause).list();
        for (MOrderLine ol : list) {
            ol.setHeaderInfo(this);
        }
        return list.toArray(new MOrderLine[list.size()]);
    }

    public MOrderLine[] getLines(boolean requery, String orderBy) {
        if (this.m_lines != null && !requery) {
            MOrder.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        String orderClause = "";
        orderClause = orderBy != null && orderBy.length() > 0 ? String.valueOf(orderClause) + orderBy : String.valueOf(orderClause) + "Line";
        this.m_lines = this.getLines(null, orderClause);
        return this.m_lines;
    }

    public MOrderLine[] getLines() {
        return this.getLines(false, null);
    }

    public void renumberLines(int step) {
        int number = step;
        MOrderLine[] lines = this.getLines(true, null);
        int i2 = 0;
        while (i2 < lines.length) {
            MOrderLine line = lines[i2];
            line.setLine(number);
            line.saveEx(this.get_TrxName());
            number += step;
            ++i2;
        }
        this.m_lines = null;
    }

    public boolean isOrderLine(int C_OrderLine_ID) {
        if (this.m_lines == null) {
            this.getLines();
        }
        int i2 = 0;
        while (i2 < this.m_lines.length) {
            if (this.m_lines[i2].getC_OrderLine_ID() == C_OrderLine_ID) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public MOrderTax[] getTaxes(boolean requery) {
        if (this.m_taxes != null && !requery) {
            return this.m_taxes;
        }
        List<MOrderTax> list = new Query(this.getCtx(), "C_OrderTax", "C_Order_ID=?", this.get_TrxName()).setParameters(this.get_ID()).list();
        this.m_taxes = list.toArray(new MOrderTax[list.size()]);
        return this.m_taxes;
    }

    public MInvoice[] getInvoices() {
        String whereClause = "EXISTS (SELECT 1 FROM C_InvoiceLine il, C_OrderLine ol WHERE il.C_Invoice_ID=C_Invoice.C_Invoice_ID AND il.C_OrderLine_ID=ol.C_OrderLine_ID AND ol.C_Order_ID=?)";
        List<MInvoice> list = new Query(this.getCtx(), "C_Invoice", "EXISTS (SELECT 1 FROM C_InvoiceLine il, C_OrderLine ol WHERE il.C_Invoice_ID=C_Invoice.C_Invoice_ID AND il.C_OrderLine_ID=ol.C_OrderLine_ID AND ol.C_Order_ID=?)", this.get_TrxName()).setParameters(this.get_ID()).setOrderBy("C_Invoice_ID DESC").list();
        return list.toArray(new MInvoice[list.size()]);
    }

    public int getC_Invoice_ID() {
        String sql = "SELECT C_Invoice_ID FROM C_Invoice WHERE C_Order_ID=? AND DocStatus IN ('CO','CL') ORDER BY C_Invoice_ID DESC";
        int C_Invoice_ID = DB.getSQLValue(this.get_TrxName(), sql, this.get_ID());
        return C_Invoice_ID;
    }

    public MInOut[] getShipments() {
        String whereClause = "EXISTS (SELECT 1 FROM M_InOutLine iol, C_OrderLine ol WHERE iol.M_InOut_ID=M_InOut.M_InOut_ID AND iol.C_OrderLine_ID=ol.C_OrderLine_ID AND ol.C_Order_ID=?)";
        List<MInOut> list = new Query(this.getCtx(), "M_InOut", "EXISTS (SELECT 1 FROM M_InOutLine iol, C_OrderLine ol WHERE iol.M_InOut_ID=M_InOut.M_InOut_ID AND iol.C_OrderLine_ID=ol.C_OrderLine_ID AND ol.C_Order_ID=?)", this.get_TrxName()).setParameters(this.get_ID()).setOrderBy("M_InOut_ID DESC").list();
        return list.toArray(new MInOut[list.size()]);
    }

    public String getCurrencyISO() {
        return MCurrency.getISO_Code(this.getCtx(), this.getC_Currency_ID());
    }

    public int getPrecision() {
        return MCurrency.getStdPrecision(this.getCtx(), this.getC_Currency_ID());
    }

    public String getDocStatusName() {
        return MRefList.getListName(this.getCtx(), 131, this.getDocStatus());
    }

    @Override
    public void setDocAction(String DocAction2) {
        this.setDocAction(DocAction2, false);
    }

    public void setDocAction(String DocAction2, boolean forceCreation) {
        super.setDocAction(DocAction2);
        this.m_forceCreation = forceCreation;
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String set = "SET Processed='" + (processed ? "Y" : "N") + "' WHERE C_Order_ID=" + this.getC_Order_ID();
        int noLine = DB.executeUpdateEx("UPDATE C_OrderLine " + set, this.get_TrxName());
        int noTax = DB.executeUpdateEx("UPDATE C_OrderTax " + set, this.get_TrxName());
        this.m_lines = null;
        this.m_taxes = null;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("setProcessed - " + processed + " - Lines=" + noLine + ", Tax=" + noTax);
        }
    }

    public boolean validatePaySchedule() {
        MOrderPaySchedule[] schedule = MOrderPaySchedule.getOrderPaySchedule(this.getCtx(), this.getC_Order_ID(), 0, this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + schedule.length);
        }
        if (schedule.length == 0) {
            this.setIsPayScheduleValid(false);
            return false;
        }
        BigDecimal total = Env.ZERO;
        int i2 = 0;
        while (i2 < schedule.length) {
            schedule[i2].setParent(this);
            BigDecimal due = schedule[i2].getDueAmt();
            if (due != null) {
                total = total.add(due);
            }
            ++i2;
        }
        boolean valid = this.getGrandTotal().compareTo(total) == 0;
        this.setIsPayScheduleValid(valid);
        int i3 = 0;
        while (i3 < schedule.length) {
            if (schedule[i3].isValid() != valid) {
                schedule[i3].setIsValid(valid);
                schedule[i3].saveEx(this.get_TrxName());
            }
            ++i3;
        }
        return valid;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        int cnt;
        int ii;
        int context_AD_Org_ID;
        if (this.getAD_Org_ID() == 0 && (context_AD_Org_ID = Env.getAD_Org_ID(this.getCtx())) != 0) {
            this.setAD_Org_ID(context_AD_Org_ID);
            this.log.warning("Changed Org to Context=" + context_AD_Org_ID);
        }
        if (this.getAD_Client_ID() == 0) {
            this.m_processMsg = "AD_Client_ID = 0";
            return false;
        }
        if (newRecord && this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID(0);
        }
        if (this.getM_Warehouse_ID() == 0) {
            int ii2 = Env.getContextAsInt(this.getCtx(), "#M_Warehouse_ID");
            if (ii2 != 0) {
                this.setM_Warehouse_ID(ii2);
            } else {
                throw new FillMandatoryException(new String[]{"M_Warehouse_ID"});
            }
        }
        MWarehouse wh = MWarehouse.get(this.getCtx(), this.getM_Warehouse_ID());
        if ((newRecord || this.is_ValueChanged("AD_Org_ID") || this.is_ValueChanged("M_Warehouse_ID")) && wh.getAD_Org_ID() != this.getAD_Org_ID()) {
            this.log.saveWarning("WarehouseOrgConflict", "");
        }
        boolean disallowNegInv = wh.isDisallowNegativeInv();
        String DeliveryRule = this.getDeliveryRule();
        if (disallowNegInv && "F".equals(DeliveryRule) || DeliveryRule == null || DeliveryRule.length() == 0) {
            this.setDeliveryRule("A");
        }
        if (!newRecord && this.is_ValueChanged("M_Warehouse_ID")) {
            MOrderLine[] lines = this.getLines(false, null);
            int i2 = 0;
            while (i2 < lines.length) {
                if (!lines[i2].canChangeWarehouse()) {
                    return false;
                }
                ++i2;
            }
        }
        if (this.getC_BPartner_ID() == 0) {
            this.setBPartner(MBPartner.getTemplate(this.getCtx(), this.getAD_Client_ID()));
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            this.setBPartner(new MBPartner(this.getCtx(), this.getC_BPartner_ID(), null));
        }
        if (this.getBill_BPartner_ID() == 0) {
            this.setBill_BPartner_ID(this.getC_BPartner_ID());
            this.setBill_Location_ID(this.getC_BPartner_Location_ID());
        }
        if (this.getBill_Location_ID() == 0) {
            this.setBill_Location_ID(this.getC_BPartner_Location_ID());
        }
        if (this.getM_PriceList_ID() == 0 && (ii = DB.getSQLValueEx(null, "SELECT M_PriceList_ID FROM M_PriceList WHERE AD_Client_ID=? AND IsSOPriceList=? AND IsActive=?ORDER BY IsDefault DESC", this.getAD_Client_ID(), this.isSOTrx(), true)) != 0) {
            this.setM_PriceList_ID(ii);
        }
        if (this.getC_Currency_ID() == 0) {
            String sql = "SELECT C_Currency_ID FROM M_PriceList WHERE M_PriceList_ID=?";
            int ii3 = DB.getSQLValue(null, sql, this.getM_PriceList_ID());
            if (ii3 != 0) {
                this.setC_Currency_ID(ii3);
            } else {
                this.setC_Currency_ID(Env.getContextAsInt(this.getCtx(), "#C_Currency_ID"));
            }
        }
        if (this.getSalesRep_ID() == 0 && (ii = Env.getContextAsInt(this.getCtx(), "#SalesRep_ID")) != 0) {
            this.setSalesRep_ID(ii);
        }
        if (this.getC_DocTypeTarget_ID() == 0) {
            this.setC_DocTypeTarget_ID(DocSubTypeSO_Standard);
        }
        if (this.getC_PaymentTerm_ID() == 0) {
            ii = Env.getContextAsInt(this.getCtx(), "#C_PaymentTerm_ID");
            if (ii != 0) {
                this.setC_PaymentTerm_ID(ii);
            } else {
                String sql = "SELECT C_PaymentTerm_ID FROM C_PaymentTerm WHERE AD_Client_ID=? AND IsDefault='Y' AND IsActive='Y'";
                ii = DB.getSQLValue(null, sql, this.getAD_Client_ID());
                if (ii != 0) {
                    this.setC_PaymentTerm_ID(ii);
                }
            }
        }
        BigDecimal previousProcessedOn = (BigDecimal)this.get_ValueOld("ProcessedOn");
        if (!newRecord && previousProcessedOn != null && previousProcessedOn.signum() > 0) {
            int previousDocTypeID = (Integer)this.get_ValueOld("C_DocTypeTarget_ID");
            MDocType previousdt = MDocType.get(this.getCtx(), previousDocTypeID);
            if ((this.is_ValueChanged("C_DocType_ID") || this.is_ValueChanged("C_DocTypeTarget_ID")) && previousdt.isOverwriteSeqOnComplete()) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), "CannotChangeProcessedDocType"));
                return false;
            }
            if (this.is_ValueChanged("DateOrdered") && previousdt.isOverwriteDateOnComplete()) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), "CannotChangeProcessedDate"));
                return false;
            }
        }
        if (!newRecord && (this.is_ValueChanged("M_PriceList_ID") || this.is_ValueChanged("DateOrdered")) && (cnt = DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM C_OrderLine WHERE C_Order_ID=? AND M_Product_ID>0", this.getC_Order_ID())) > 0) {
            if (this.is_ValueChanged("M_PriceList_ID")) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), "CannotChangePl"));
                return false;
            }
            if (this.is_ValueChanged("DateOrdered")) {
                MPriceList pList = MPriceList.get(this.getCtx(), this.getM_PriceList_ID(), null);
                MPriceListVersion plOld = pList.getPriceListVersion((Timestamp)this.get_ValueOld("DateOrdered"));
                MPriceListVersion plNew = pList.getPriceListVersion((Timestamp)this.get_Value("DateOrdered"));
                if (plNew == null || !plNew.equals(plOld)) {
                    this.log.saveError("Error", Msg.getMsg(this.getCtx(), "CannotChangeDateOrdered"));
                    return false;
                }
            }
        }
        if (!recursiveCall && !newRecord && this.is_ValueChanged("C_PaymentTerm_ID")) {
            recursiveCall = true;
            try {
                MPaymentTerm pt = new MPaymentTerm(this.getCtx(), this.getC_PaymentTerm_ID(), this.get_TrxName());
                boolean valid = pt.applyOrder(this);
                this.setIsPayScheduleValid(valid);
            }
            finally {
                recursiveCall = false;
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        int no;
        String sql;
        if (!success || newRecord) {
            return success;
        }
        if (this.is_ValueChanged("Description") || this.is_ValueChanged("POReference")) {
            sql = "UPDATE C_Invoice i SET (Description,POReference)=(SELECT Description,POReference FROM C_Order o WHERE i.C_Order_ID=o.C_Order_ID) WHERE DocStatus NOT IN ('RE','CL') AND C_Order_ID=" + this.getC_Order_ID();
            no = DB.executeUpdateEx(sql, this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Description -> #" + no);
            }
        }
        if (this.is_ValueChanged("PaymentRule") || this.is_ValueChanged("C_PaymentTerm_ID") || this.is_ValueChanged("C_Payment_ID") || this.is_ValueChanged("C_CashLine_ID")) {
            sql = "UPDATE C_Invoice i SET (PaymentRule,C_PaymentTerm_ID,C_Payment_ID,C_CashLine_ID)=(SELECT PaymentRule,C_PaymentTerm_ID,C_Payment_ID,C_CashLine_ID FROM C_Order o WHERE i.C_Order_ID=o.C_Order_ID)WHERE DocStatus NOT IN ('RE','CL') AND C_Order_ID=" + this.getC_Order_ID();
            no = DB.executeUpdate(sql, this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Payment -> #" + no);
            }
        }
        if (this.is_ValueChanged("DateAcct")) {
            sql = "UPDATE C_Invoice i SET (DateAcct)=(SELECT DateAcct FROM C_Order o WHERE i.C_Order_ID=o.C_Order_ID)WHERE DocStatus NOT IN ('CO','RE','CL') AND Processed='N' AND C_Order_ID=" + this.getC_Order_ID();
            no = DB.executeUpdate(sql, this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("DateAcct -> #" + no);
            }
        }
        if (this.is_ValueChanged("AD_Org_ID") || this.is_ValueChanged("C_BPartner_ID") || this.is_ValueChanged("C_BPartner_Location_ID") || this.is_ValueChanged("DateOrdered") || this.is_ValueChanged("DatePromised") || this.is_ValueChanged("M_Warehouse_ID") || this.is_ValueChanged("M_Shipper_ID") || this.is_ValueChanged("C_Currency_ID")) {
            MOrderLine[] lines;
            MOrderLine[] mOrderLineArray = lines = this.getLines();
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                MOrderLine line = mOrderLineArray[n2];
                if (this.is_ValueChanged("AD_Org_ID")) {
                    line.setAD_Org_ID(this.getAD_Org_ID());
                }
                if (this.is_ValueChanged("C_BPartner_ID")) {
                    line.setC_BPartner_ID(this.getC_BPartner_ID());
                }
                if (this.is_ValueChanged("C_BPartner_Location_ID")) {
                    line.setC_BPartner_Location_ID(this.getC_BPartner_Location_ID());
                }
                if (this.is_ValueChanged("DateOrdered")) {
                    line.setDateOrdered(this.getDateOrdered());
                }
                if (this.is_ValueChanged("DatePromised")) {
                    line.setDatePromised(this.getDatePromised());
                }
                if (this.is_ValueChanged("M_Warehouse_ID")) {
                    line.setM_Warehouse_ID(this.getM_Warehouse_ID());
                }
                if (this.is_ValueChanged("M_Shipper_ID")) {
                    line.setM_Shipper_ID(this.getM_Shipper_ID());
                }
                if (this.is_ValueChanged("C_Currency_ID")) {
                    line.setC_Currency_ID(this.getC_Currency_ID());
                }
                line.saveEx();
                ++n2;
            }
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        return !this.isProcessed();
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("unlockIt - " + this.toString());
        }
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setDocAction(DocSubTypeSO_Prepay);
        return true;
    }

    @Override
    public String prepareIt() {
        MOrderLine[] lines;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocTypeTarget_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateAcct(), dt.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        if (this.isSOTrx() && this.getDeliveryViaRule().equals("S")) {
            if (this.getM_Shipper_ID() == 0) {
                this.m_processMsg = "@FillMandatory@" + Msg.getElement(this.getCtx(), "M_Shipper_ID");
                return "IN";
            }
            if (!this.calculateFreightCharge()) {
                return "IN";
            }
        }
        if ((lines = this.getLines(true, "M_Product_ID")).length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        if (this.getDeliveryRule() != null && this.getDeliveryRule().equals("O")) {
            int i2 = 0;
            while (i2 < lines.length) {
                MOrderLine line = lines[i2];
                MProduct product = line.getProduct();
                if (product != null && product.isExcludeAutoDelivery()) {
                    this.m_processMsg = "@M_Product_ID@ " + product.getValue() + " @IsExcludeAutoDelivery@";
                    return "IN";
                }
                ++i2;
            }
        }
        if (this.getC_DocType_ID() != this.getC_DocTypeTarget_ID()) {
            MDocType dtOld;
            if (this.getC_DocType_ID() != 0 && DocSubTypeSO_Standard.equals((dtOld = MDocType.get(this.getCtx(), this.getC_DocType_ID())).getDocSubTypeSO()) && !DocSubTypeSO_Standard.equals(dt.getDocSubTypeSO())) {
                int i3 = 0;
                while (i3 < lines.length) {
                    if (lines[i3].getM_Warehouse_ID() != this.getM_Warehouse_ID()) {
                        this.log.warning("different Warehouse " + lines[i3]);
                        this.m_processMsg = "@CannotChangeDocType@";
                        return "IN";
                    }
                    ++i3;
                }
            }
            if ("DR".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || this.getC_DocType_ID() == 0) {
                this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
            } else if (dt.isOffer()) {
                this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
            } else {
                this.m_processMsg = "@CannotChangeDocType@";
                return "IN";
            }
        }
        MOrderLine[] mOrderLineArray = this.getLines();
        int n = mOrderLineArray.length;
        int i3 = 0;
        while (i3 < n) {
            MProduct product;
            MOrderLine line = mOrderLineArray[i3];
            if (line.getM_Product_ID() > 0 && line.getM_AttributeSetInstance_ID() == 0 && (product = line.getProduct()).isASIMandatory(this.isSOTrx()) && product.getAttributeSet() != null && !product.getAttributeSet().excludeTableEntry(260, this.isSOTrx())) {
                StringBuilder msg = new StringBuilder("@M_AttributeSet_ID@ @IsMandatory@ (@Line@ #").append(line.getLine()).append(", @M_Product_ID@=").append(product.getValue()).append(")");
                this.m_processMsg = msg.toString();
                return "IN";
            }
            ++i3;
        }
        if (this.explodeBOM()) {
            lines = this.getLines(true, "M_Product_ID");
        }
        if (!this.reserveStock(dt, lines)) {
            String innerMsg = CLogger.retrieveErrorString("");
            this.m_processMsg = "Cannot reserve Stock";
            if (!Util.isEmpty(innerMsg)) {
                this.m_processMsg = String.valueOf(this.m_processMsg) + " -> " + innerMsg;
            }
            return "IN";
        }
        if (!this.calculateTaxTotal()) {
            this.m_processMsg = "Error calculating tax";
            return "IN";
        }
        if (this.getGrandTotal().signum() != 0 && ("P".equals(this.getPaymentRule()) || "D".equals(this.getPaymentRule()))) {
            if (!this.createPaySchedule()) {
                this.m_processMsg = "@ErrorPaymentSchedule@";
                return "IN";
            }
        } else if (MOrderPaySchedule.getOrderPaySchedule(this.getCtx(), this.getC_Order_ID(), 0, this.get_TrxName()).length > 0) {
            this.m_processMsg = "@ErrorPaymentSchedule@";
            return "IN";
        }
        if (!(!this.isSOTrx() || DocSubTypeSO_POS.equals(dt.getDocSubTypeSO()) && "B".equals(this.getPaymentRule()) && !MSysConfig.getBooleanValue("CHECK_CREDIT_ON_CASH_POS_ORDER", true, this.getAD_Client_ID(), this.getAD_Org_ID()) || DocSubTypeSO_Prepay.equals(dt.getDocSubTypeSO()) && !MSysConfig.getBooleanValue("CHECK_CREDIT_ON_PREPAY_ORDER", true, this.getAD_Client_ID(), this.getAD_Org_ID()))) {
            MBPartner bp = new MBPartner(this.getCtx(), this.getBill_BPartner_ID(), this.get_TrxName());
            if (this.getGrandTotal().signum() > 0) {
                if ("S".equals(bp.getSOCreditStatus())) {
                    this.m_processMsg = "@BPartnerCreditStop@ - @TotalOpenBalance@=" + bp.getTotalOpenBalance() + ", @SO_CreditLimit@=" + bp.getSO_CreditLimit();
                    return "IN";
                }
                if ("H".equals(bp.getSOCreditStatus())) {
                    this.m_processMsg = "@BPartnerCreditHold@ - @TotalOpenBalance@=" + bp.getTotalOpenBalance() + ", @SO_CreditLimit@=" + bp.getSO_CreditLimit();
                    return "IN";
                }
                BigDecimal grandTotal = MConversionRate.convertBase(this.getCtx(), this.getGrandTotal(), this.getC_Currency_ID(), this.getDateOrdered(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
                if ("H".equals(bp.getSOCreditStatus(grandTotal))) {
                    this.m_processMsg = "@BPartnerOverOCreditHold@ - @TotalOpenBalance@=" + bp.getTotalOpenBalance() + ", @GrandTotal@=" + grandTotal + ", @SO_CreditLimit@=" + bp.getSO_CreditLimit();
                    return "IN";
                }
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        return "IP";
    }

    protected boolean calculateFreightCharge() {
        MOrderLine ol;
        MClientInfo ci = MClientInfo.get(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName());
        if (ci.getC_ChargeFreight_ID() == 0 && ci.getM_ProductFreight_ID() == 0) {
            this.m_processMsg = "Product or Charge for Freight is not defined at Client window > Client Info tab";
            return false;
        }
        MOrderLine[] ols = this.getLines(false, "Line");
        if (ols.length == 0) {
            this.m_processMsg = "@NoLines@";
            return false;
        }
        PO freightLine = null;
        MOrderLine[] mOrderLineArray = ols;
        int n = ols.length;
        int n2 = 0;
        while (n2 < n) {
            ol = mOrderLineArray[n2];
            if (ol.getM_Product_ID() > 0 && ol.getM_Product_ID() == ci.getM_ProductFreight_ID() || ol.getC_Charge_ID() > 0 && ol.getC_Charge_ID() == ci.getC_ChargeFreight_ID()) {
                freightLine = ol;
                break;
            }
            ++n2;
        }
        if (this.getFreightCostRule().equals("I")) {
            boolean deleted;
            if (freightLine != null && !(deleted = freightLine.delete(false))) {
                ((X_C_OrderLine)freightLine).setC_BPartner_Location_ID(this.getC_BPartner_Location_ID());
                ((X_C_OrderLine)freightLine).setM_Shipper_ID(this.getM_Shipper_ID());
                ((MOrderLine)freightLine).setQty(BigDecimal.ONE);
                ((MOrderLine)freightLine).setPrice(BigDecimal.ZERO);
                freightLine.saveEx();
            }
        } else if (this.getFreightCostRule().equals("F")) {
            if (freightLine == null) {
                freightLine = new MOrderLine(this);
                if (ci.getC_ChargeFreight_ID() > 0) {
                    ((MOrderLine)freightLine).setC_Charge_ID(ci.getC_ChargeFreight_ID());
                } else if (ci.getM_ProductFreight_ID() > 0) {
                    ((X_C_OrderLine)freightLine).setM_Product_ID(ci.getM_ProductFreight_ID());
                } else {
                    throw new AdempiereException("Product or Charge for Freight is not defined at Client window > Client Info tab");
                }
            }
            ((X_C_OrderLine)freightLine).setC_BPartner_Location_ID(this.getC_BPartner_Location_ID());
            ((X_C_OrderLine)freightLine).setM_Shipper_ID(this.getM_Shipper_ID());
            ((MOrderLine)freightLine).setQty(BigDecimal.ONE);
            ((MOrderLine)freightLine).setPrice(this.getFreightAmt());
            freightLine.saveEx();
        } else if (this.getFreightCostRule().equals("C")) {
            if (ci.getC_UOM_Weight_ID() == 0) {
                this.m_processMsg = "UOM for Weight is not defined at Client window > Client Info tab";
                return false;
            }
            if (ci.getC_UOM_Length_ID() == 0) {
                this.m_processMsg = "UOM for Length is not defined at Client window > Client Info ta";
                return false;
            }
            mOrderLineArray = ols;
            n = ols.length;
            n2 = 0;
            while (n2 < n) {
                MProduct product;
                BigDecimal weight;
                ol = mOrderLineArray[n2];
                if (!(ol.getM_Product_ID() > 0 && ol.getM_Product_ID() == ci.getM_ProductFreight_ID() || ol.getC_Charge_ID() > 0 && ol.getC_Charge_ID() == ci.getC_ChargeFreight_ID() || ol.getM_Product_ID() <= 0 || (weight = (product = new MProduct(this.getCtx(), ol.getM_Product_ID(), this.get_TrxName())).getWeight()) != null && weight.compareTo(BigDecimal.ZERO) != 0)) {
                    this.m_processMsg = "No weight defined for product " + product.toString();
                    return false;
                }
                ++n2;
            }
            boolean ok = false;
            MShippingTransaction st = null;
            try {
                st = SalesOrderRateInquiryProcess.createShippingTransaction(this.getCtx(), this, "RI", this.isPriviledgedRate(), this.get_TrxName());
                ok = st.processOnline();
                st.saveEx();
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "processOnline", e);
            }
            if (ok) {
                if (freightLine == null) {
                    freightLine = new MOrderLine(this);
                    if (ci.getC_ChargeFreight_ID() > 0) {
                        ((MOrderLine)freightLine).setC_Charge_ID(ci.getC_ChargeFreight_ID());
                    } else if (ci.getM_ProductFreight_ID() > 0) {
                        ((X_C_OrderLine)freightLine).setM_Product_ID(ci.getM_ProductFreight_ID());
                    } else {
                        throw new AdempiereException("Product or Charge for Freight is not defined at Client window > Client Info tab");
                    }
                }
                ((X_C_OrderLine)freightLine).setC_BPartner_Location_ID(this.getC_BPartner_Location_ID());
                ((X_C_OrderLine)freightLine).setM_Shipper_ID(this.getM_Shipper_ID());
                ((MOrderLine)freightLine).setQty(BigDecimal.ONE);
                ((MOrderLine)freightLine).setPrice(st.getPrice());
                freightLine.saveEx();
            } else {
                this.m_processMsg = st.getErrorMessage();
                return false;
            }
        }
        return true;
    }

    protected boolean explodeBOM() {
        boolean retValue = false;
        String where = "AND IsActive='Y' AND EXISTS (SELECT * FROM M_Product p WHERE C_OrderLine.M_Product_ID=p.M_Product_ID AND\tp.IsBOM='Y' AND p.IsVerified='Y' AND p.IsStocked='N')";
        String sql = "SELECT COUNT(*) FROM C_OrderLine WHERE C_Order_ID=? " + where;
        int count = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Order_ID());
        while (count != 0) {
            retValue = true;
            this.renumberLines(1000);
            MOrderLine[] lines = this.getLines(where, "Line");
            int i2 = 0;
            while (i2 < lines.length) {
                MOrderLine line = lines[i2];
                MProduct product = MProduct.get(this.getCtx(), line.getM_Product_ID());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(product.getName());
                }
                int lineNo = line.getLine();
                MProductBOM[] mProductBOMArray = MProductBOM.getBOMLines(product);
                int n = mProductBOMArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MProductBOM bom = mProductBOMArray[n2];
                    MOrderLine newLine = new MOrderLine(this);
                    newLine.setLine(++lineNo);
                    newLine.setM_Product_ID(bom.getM_ProductBOM_ID(), true);
                    newLine.setQty(line.getQtyOrdered().multiply(bom.getBOMQty()));
                    if (bom.getDescription() != null) {
                        newLine.setDescription(bom.getDescription());
                    }
                    newLine.setPrice();
                    newLine.saveEx(this.get_TrxName());
                    ++n2;
                }
                line.setM_Product_ID(0);
                line.setM_AttributeSetInstance_ID(0);
                line.setPrice(Env.ZERO);
                line.setPriceLimit(Env.ZERO);
                line.setPriceList(Env.ZERO);
                line.setLineNetAmt(Env.ZERO);
                line.setFreightAmt(Env.ZERO);
                String description = product.getName();
                if (product.getDescription() != null) {
                    description = String.valueOf(description) + " " + product.getDescription();
                }
                if (line.getDescription() != null) {
                    description = String.valueOf(description) + " " + line.getDescription();
                }
                line.setDescription(description);
                line.saveEx(this.get_TrxName());
                ++i2;
            }
            this.m_lines = null;
            count = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Invoice_ID());
            this.renumberLines(10);
        }
        return retValue;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean reserveStock(MDocType dt, MOrderLine[] lines) {
        if (dt == null) {
            dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        }
        v0 = binding = dt.isProposal() == false;
        if ("VO".equals(this.getDocAction()) || "OB".equals(dt.getDocSubTypeSO()) && "CL".equals(this.getDocAction())) {
            binding = false;
        }
        isSOTrx = this.isSOTrx();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Binding=" + binding + " - IsSOTrx=" + isSOTrx);
        }
        header_M_Warehouse_ID = this.getM_Warehouse_ID();
        if ("SO".equals(dt.getDocSubTypeSO()) || "POO".equals(dt.getDocBaseType())) {
            header_M_Warehouse_ID = 0;
        }
        Volume = Env.ZERO;
        Weight = Env.ZERO;
        i = 0;
        while (i < lines.length) {
            line = lines[i];
            if (header_M_Warehouse_ID != 0) {
                if (header_M_Warehouse_ID != line.getM_Warehouse_ID()) {
                    line.setM_Warehouse_ID(header_M_Warehouse_ID);
                }
                if (this.getAD_Org_ID() != line.getAD_Org_ID()) {
                    line.setAD_Org_ID(this.getAD_Org_ID());
                }
            }
            if ((difference = (target = binding != false ? line.getQtyOrdered() : Env.ZERO).subtract(line.getQtyReserved()).subtract(line.getQtyDelivered())).signum() != 0 && line.getQtyOrdered().signum() >= 0) ** GOTO lbl31
            if (difference.signum() == 0 || line.getQtyReserved().signum() == 0) {
                product = line.getProduct();
                if (product != null) {
                    Volume = Volume.add(product.getVolume().multiply(line.getQtyOrdered()));
                    Weight = Weight.add(product.getWeight().multiply(line.getQtyOrdered()));
                }
            } else {
                if (line.getQtyOrdered().signum() < 0 && line.getQtyReserved().signum() > 0) {
                    difference = line.getQtyReserved().negate();
                }
lbl31:
                // 4 sources

                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Line=" + line.getLine() + " - Target=" + target + ",Difference=" + difference + " - Ordered=" + line.getQtyOrdered() + ",Reserved=" + line.getQtyReserved() + ",Delivered=" + line.getQtyDelivered());
                }
                if ((product = line.getProduct()) != null) {
                    if (product.isStocked() && !MStorageReservation.add(this.getCtx(), line.getM_Warehouse_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), difference, isSOTrx, this.get_TrxName())) {
                        return false;
                    }
                    line.setQtyReserved(line.getQtyReserved().add(difference));
                    if (!line.save(this.get_TrxName())) {
                        return false;
                    }
                    Volume = Volume.add(product.getVolume().multiply(line.getQtyOrdered()));
                    Weight = Weight.add(product.getWeight().multiply(line.getQtyOrdered()));
                }
            }
            ++i;
        }
        this.setVolume(Volume);
        this.setWeight(Weight);
        return true;
    }

    public boolean calculateTaxTotal() {
        MTaxProvider[] providers;
        this.log.fine("");
        DB.executeUpdateEx("DELETE C_OrderTax WHERE C_Order_ID=" + this.getC_Order_ID(), this.get_TrxName());
        this.m_taxes = null;
        MTaxProvider[] mTaxProviderArray = providers = this.getTaxProviders();
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            MTaxProvider provider = mTaxProviderArray[n2];
            ITaxProvider calculator = Core.getTaxProvider(provider);
            if (calculator == null) {
                throw new AdempiereException(Msg.getMsg(this.getCtx(), "TaxNoProvider"));
            }
            if (!calculator.calculateOrderTaxTotal(provider, this)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean createPaySchedule() {
        if (this.getC_PaymentTerm_ID() == 0) {
            return false;
        }
        MPaymentTerm pt = new MPaymentTerm(this.getCtx(), this.getC_PaymentTerm_ID(), null);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(pt.toString());
        }
        int numSchema = pt.getSchedule(false).length;
        MOrderPaySchedule[] schedule = MOrderPaySchedule.getOrderPaySchedule(this.getCtx(), this.getC_Order_ID(), 0, this.get_TrxName());
        if (schedule.length > 0) {
            if (numSchema == 0) {
                return false;
            }
            return this.validatePaySchedule();
        }
        boolean isValid = pt.applyOrder(this);
        if (numSchema == 0) {
            return true;
        }
        return isValid;
    }

    @Override
    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("approveIt - " + this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("rejectIt - " + this.toString());
        }
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String error;
        String valid;
        String msg;
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        String DocSubTypeSO = dt.getDocSubTypeSO();
        if (DocSubTypeSO_Prepay.equals(this.getDocAction())) {
            this.setProcessed(false);
            return "IP";
        }
        this.setDefiniteDocumentNo();
        if (DocSubTypeSO_Proposal.equals(DocSubTypeSO) || DocSubTypeSO_Quotation.equals(DocSubTypeSO)) {
            if (DocSubTypeSO_Quotation.equals(DocSubTypeSO)) {
                this.reserveStock(dt, this.getLines(true, "M_Product_ID"));
            }
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
            if (this.m_processMsg != null) {
                return "IN";
            }
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 9);
            if (this.m_processMsg != null) {
                return "IN";
            }
            this.setProcessed(true);
            return "CO";
        }
        if (!this.m_forceCreation && DocSubTypeSO_Prepay.equals(DocSubTypeSO) && this.getC_Payment_ID() == 0 && this.getC_CashLine_ID() == 0) {
            this.setProcessed(true);
            return DocSubTypeSO_Warehouse;
        }
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.getLines(true, null);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        StringBuilder info = new StringBuilder();
        boolean realTimePOS = MSysConfig.getBooleanValue("REAL_TIME_POS", false, this.getAD_Client_ID());
        MInOut shipment = null;
        if (DocSubTypeSO_OnCredit.equals(DocSubTypeSO) || DocSubTypeSO_Warehouse.equals(DocSubTypeSO) || DocSubTypeSO_POS.equals(DocSubTypeSO) || DocSubTypeSO_Prepay.equals(DocSubTypeSO)) {
            MWarehouse wh;
            if (!"F".equals(this.getDeliveryRule()) && !(wh = new MWarehouse(this.getCtx(), this.getM_Warehouse_ID(), this.get_TrxName())).isDisallowNegativeInv()) {
                this.setDeliveryRule("F");
            }
            if ((shipment = this.createShipment(dt, realTimePOS ? null : this.getDateOrdered())) == null) {
                return "IN";
            }
            info.append("@M_InOut_ID@: ").append(shipment.getDocumentNo());
            msg = shipment.getProcessMsg();
            if (msg != null && msg.length() > 0) {
                info.append(" (").append(msg).append(")");
            }
        }
        if (DocSubTypeSO_POS.equals(DocSubTypeSO) || DocSubTypeSO_OnCredit.equals(DocSubTypeSO) || DocSubTypeSO_Prepay.equals(DocSubTypeSO)) {
            MInvoice invoice = this.createInvoice(dt, shipment, realTimePOS ? null : this.getDateOrdered());
            if (invoice == null) {
                return "IN";
            }
            info.append(" - @C_Invoice_ID@: ").append(invoice.getDocumentNo());
            String msg2 = invoice.getProcessMsg();
            if (msg2 != null && msg2.length() > 0) {
                info.append(" (").append(msg2).append(")");
            }
        }
        if ((msg = this.createPOSPayments()) != null) {
            this.m_processMsg = msg;
            return "IN";
        }
        MOrder counter = this.createCounterDoc();
        if (counter != null) {
            info.append(" - @CounterDoc@: @Order@=").append(counter.getDocumentNo());
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate(this, 9)) != null) {
            if (info.length() > 0) {
                info.append(" - ");
            }
            info.append(valid);
            this.m_processMsg = info.toString();
            return "IN";
        }
        if (!this.isSOTrx() && !Util.isEmpty(error = this.landedCostAllocation())) {
            this.m_processMsg = error;
            return "IN";
        }
        this.setProcessed(true);
        this.m_processMsg = info.toString();
        this.setDocAction("CL");
        return "CO";
    }

    protected String landedCostAllocation() {
        MOrderLandedCost[] landedCosts;
        MOrderLandedCost[] mOrderLandedCostArray = landedCosts = MOrderLandedCost.getOfOrder(this.getC_Order_ID(), this.get_TrxName());
        int n = landedCosts.length;
        int n2 = 0;
        while (n2 < n) {
            MOrderLandedCost landedCost = mOrderLandedCostArray[n2];
            String error = landedCost.distributeLandedCost();
            if (!Util.isEmpty(error)) {
                return error;
            }
            ++n2;
        }
        return "";
    }

    protected String createPOSPayments() {
        if (!this.isSOTrx()) {
            return null;
        }
        if (!DocSubTypeSO_POS.equals(this.getC_DocType().getDocSubTypeSO())) {
            return null;
        }
        if (!"M".equals(this.getPaymentRule())) {
            return null;
        }
        MInvoice[] invoices = this.getInvoices();
        if (invoices == null || invoices.length == 0) {
            return "@NoPOSInvoices@";
        }
        MInvoice lastInvoice = invoices[0];
        BigDecimal grandTotal = lastInvoice.getGrandTotal();
        List pps = new Query(this.getCtx(), "C_POSPayment", "C_Order_ID=?", this.get_TrxName()).setParameters(this.getC_Order_ID()).setOnlyActiveRecords(true).list();
        BigDecimal totalPOSPayments = Env.ZERO;
        for (X_C_POSPayment pp : pps) {
            totalPOSPayments = totalPOSPayments.add(pp.getPayAmt());
        }
        if (totalPOSPayments.compareTo(grandTotal) != 0) {
            return "@POSPaymentDiffers@ - @C_POSPayment_ID@=" + totalPOSPayments + ", @GrandTotal@=" + grandTotal;
        }
        String whereClause = "AD_Org_ID=? AND C_Currency_ID=?";
        MBankAccount ba = (MBankAccount)new Query(this.getCtx(), "C_BankAccount", whereClause, this.get_TrxName()).setParameters(this.getAD_Org_ID(), this.getC_Currency_ID()).setOrderBy("IsDefault DESC").first();
        if (ba == null) {
            return "@NoAccountOrgCurrency@";
        }
        MDocType[] doctypes = MDocType.getOfDocBaseType(this.getCtx(), "ARR");
        if (doctypes == null || doctypes.length == 0) {
            return "No document type for AR Receipt";
        }
        MDocType doctype = null;
        MDocType[] mDocTypeArray = doctypes;
        int n = doctypes.length;
        int n2 = 0;
        while (n2 < n) {
            MDocType doc = mDocTypeArray[n2];
            if (doc.getAD_Org_ID() == this.getAD_Org_ID()) {
                doctype = doc;
                break;
            }
            ++n2;
        }
        if (doctype == null) {
            doctype = doctypes[0];
        }
        for (X_C_POSPayment pp : pps) {
            X_C_POSTenderType tt = new X_C_POSTenderType(this.getCtx(), pp.getC_POSTenderType_ID(), this.get_TrxName());
            if (tt.isGuarantee() || pp.isPostDated()) continue;
            MPayment payment = new MPayment(this.getCtx(), 0, this.get_TrxName());
            payment.setAD_Org_ID(this.getAD_Org_ID());
            payment.setTenderType(pp.getTenderType());
            if ("C".equals(pp.getTenderType())) {
                payment.setTrxType("S");
                payment.setCreditCardType(pp.getCreditCardType());
                payment.setCreditCardNumber(pp.getCreditCardNumber());
                payment.setVoiceAuthCode(pp.getVoiceAuthCode());
            }
            payment.setC_BankAccount_ID(ba.getC_BankAccount_ID());
            payment.setRoutingNo(pp.getRoutingNo());
            payment.setAccountNo(pp.getAccountNo());
            payment.setSwiftCode(pp.getSwiftCode());
            payment.setIBAN(pp.getIBAN());
            payment.setCheckNo(pp.getCheckNo());
            payment.setMicr(pp.getMicr());
            payment.setIsPrepayment(false);
            payment.setDateAcct(this.getDateAcct());
            payment.setDateTrx(this.getDateOrdered());
            payment.setC_BPartner_ID(this.getC_BPartner_ID());
            payment.setC_Invoice_ID(lastInvoice.getC_Invoice_ID());
            payment.setC_DocType_ID(doctype.getC_DocType_ID());
            payment.setC_Currency_ID(this.getC_Currency_ID());
            payment.setPayAmt(pp.getPayAmt());
            payment.setA_Name(pp.getA_Name());
            payment.setC_POSTenderType_ID(pp.getC_POSTenderType_ID());
            payment.saveEx();
            pp.setC_Payment_ID(payment.getC_Payment_ID());
            pp.setProcessed(true);
            pp.saveEx();
            payment.setDocAction("CO");
            if (!payment.processIt("CO")) {
                return "Cannot Complete the Payment :" + payment;
            }
            payment.saveEx();
        }
        return null;
    }

    protected void setDefiniteDocumentNo() {
        String value;
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete() && this.getProcessedOn().signum() == 0) {
            this.setDateOrdered(TimeUtil.getDay(0L));
            if (this.getDateAcct().before(this.getDateOrdered())) {
                this.setDateAcct(this.getDateOrdered());
                MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), this.getC_DocType_ID(), this.getAD_Org_ID());
            }
        }
        if (dt.isOverwriteSeqOnComplete() && this.getProcessedOn().signum() == 0 && (value = DB.getDocumentNo(this.getC_DocType_ID(), this.get_TrxName(), true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    protected MInOut createShipment(MDocType dt, Timestamp movementDate) {
        MInOut shipment;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("For " + dt);
        }
        if (!(shipment = new MInOut(this, dt.getC_DocTypeShipment_ID(), movementDate)).save(this.get_TrxName())) {
            this.m_processMsg = "Could not create Shipment";
            return null;
        }
        MOrderLine[] oLines = this.getLines(true, null);
        int i2 = 0;
        while (i2 < oLines.length) {
            MOrderLine oLine = oLines[i2];
            MInOutLine ioLine = new MInOutLine(shipment);
            BigDecimal MovementQty = oLine.getQtyOrdered().subtract(oLine.getQtyDelivered());
            int M_Locator_ID = MStorageOnHand.getM_Locator_ID(oLine.getM_Warehouse_ID(), oLine.getM_Product_ID(), oLine.getM_AttributeSetInstance_ID(), MovementQty, this.get_TrxName());
            if (M_Locator_ID == 0) {
                MWarehouse wh = MWarehouse.get(this.getCtx(), oLine.getM_Warehouse_ID());
                M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
            }
            ioLine.setOrderLine(oLine, M_Locator_ID, MovementQty);
            ioLine.setQty(MovementQty);
            if (oLine.getQtyEntered().compareTo(oLine.getQtyOrdered()) != 0) {
                ioLine.setQtyEntered(MovementQty.multiply(oLine.getQtyEntered()).divide(oLine.getQtyOrdered(), 6, RoundingMode.HALF_UP));
            }
            if (!ioLine.save(this.get_TrxName())) {
                this.m_processMsg = "Could not create Shipment Line";
                return null;
            }
            ++i2;
        }
        if (!shipment.processIt("CO")) {
            throw new AdempiereException("Failed when processing document - " + shipment.getProcessMsg());
        }
        shipment.saveEx(this.get_TrxName());
        if (!"CO".equals(shipment.getDocStatus())) {
            this.m_processMsg = "@M_InOut_ID@: " + shipment.getProcessMsg();
            return null;
        }
        return shipment;
    }

    protected MInvoice createInvoice(MDocType dt, MInOut shipment, Timestamp invoiceDate) {
        MInvoiceLine iLine;
        int i2;
        MInvoice invoice;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(dt.toString());
        }
        if (!(invoice = new MInvoice(this, dt.getC_DocTypeInvoice_ID(), invoiceDate)).save(this.get_TrxName())) {
            this.m_processMsg = "Could not create Invoice";
            return null;
        }
        if (shipment != null) {
            if (!"D".equals(this.getInvoiceRule())) {
                this.setInvoiceRule("D");
            }
            MInOutLine[] sLines = shipment.getLines(false);
            i2 = 0;
            while (i2 < sLines.length) {
                MInOutLine sLine = sLines[i2];
                iLine = new MInvoiceLine(invoice);
                iLine.setShipLine(sLine);
                if (sLine.sameOrderLineUOM()) {
                    iLine.setQtyEntered(sLine.getQtyEntered());
                } else {
                    iLine.setQtyEntered(sLine.getMovementQty());
                }
                iLine.setQtyInvoiced(sLine.getMovementQty());
                if (!iLine.save(this.get_TrxName())) {
                    this.m_processMsg = "Could not create Invoice Line from Shipment Line";
                    return null;
                }
                sLine.setIsInvoiced(true);
                if (!sLine.save(this.get_TrxName())) {
                    this.log.warning("Could not update Shipment line: " + sLine);
                }
                ++i2;
            }
        } else {
            if (!"I".equals(this.getInvoiceRule())) {
                this.setInvoiceRule("I");
            }
            MOrderLine[] oLines = this.getLines();
            i2 = 0;
            while (i2 < oLines.length) {
                MOrderLine oLine = oLines[i2];
                iLine = new MInvoiceLine(invoice);
                iLine.setOrderLine(oLine);
                iLine.setQtyInvoiced(oLine.getQtyOrdered().subtract(oLine.getQtyInvoiced()));
                if (oLine.getQtyOrdered().compareTo(oLine.getQtyEntered()) == 0) {
                    iLine.setQtyEntered(iLine.getQtyInvoiced());
                } else {
                    iLine.setQtyEntered(iLine.getQtyInvoiced().multiply(oLine.getQtyEntered()).divide(oLine.getQtyOrdered(), 12, RoundingMode.HALF_UP));
                }
                if (!iLine.save(this.get_TrxName())) {
                    this.m_processMsg = "Could not create Invoice Line from Order Line";
                    return null;
                }
                ++i2;
            }
        }
        MOrderPaySchedule[] mOrderPayScheduleArray = MOrderPaySchedule.getOrderPaySchedule(this.getCtx(), this.getC_Order_ID(), 0, this.get_TrxName());
        int n = mOrderPayScheduleArray.length;
        int n2 = 0;
        while (n2 < n) {
            MOrderPaySchedule ops = mOrderPayScheduleArray[n2];
            MInvoicePaySchedule ips = new MInvoicePaySchedule(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(ops, ips);
            ips.setC_Invoice_ID(invoice.getC_Invoice_ID());
            ips.setAD_Org_ID(ops.getAD_Org_ID());
            ips.setProcessing(ops.isProcessing());
            ips.setIsActive(ops.isActive());
            if (!ips.save()) {
                this.m_processMsg = "ERROR: creating pay schedule for invoice from : " + ops.toString();
                return null;
            }
            ++n2;
        }
        if (!invoice.processIt("CO")) {
            throw new AdempiereException("Failed when processing document - " + invoice.getProcessMsg());
        }
        invoice.saveEx(this.get_TrxName());
        this.setC_CashLine_ID(invoice.getC_CashLine_ID());
        if (!"CO".equals(invoice.getDocStatus())) {
            this.m_processMsg = "@C_Invoice_ID@: " + invoice.getProcessMsg();
            return null;
        }
        return invoice;
    }

    protected MOrder createCounterDoc() {
        if (this.getRef_Order_ID() != 0) {
            return null;
        }
        MOrg org = MOrg.get(this.getCtx(), this.getAD_Org_ID());
        int counterC_BPartner_ID = org.getLinkedC_BPartner_ID(this.get_TrxName());
        if (counterC_BPartner_ID == 0) {
            return null;
        }
        MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        int counterAD_Org_ID = bp.getAD_OrgBP_ID_Int();
        if (counterAD_Org_ID == 0) {
            return null;
        }
        MBPartner counterBP = new MBPartner(this.getCtx(), counterC_BPartner_ID, null);
        MOrgInfo counterOrgInfo = MOrgInfo.get(this.getCtx(), counterAD_Org_ID, this.get_TrxName());
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Counter BP=" + counterBP.getName());
        }
        int C_DocTypeTarget_ID = 0;
        MDocTypeCounter counterDT = MDocTypeCounter.getCounterDocType(this.getCtx(), this.getC_DocType_ID());
        if (counterDT != null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(counterDT.toString());
            }
            if (!counterDT.isCreateCounter() || !counterDT.isValid()) {
                return null;
            }
            C_DocTypeTarget_ID = counterDT.getCounter_C_DocType_ID();
        } else {
            C_DocTypeTarget_ID = MDocTypeCounter.getCounterDocType_ID(this.getCtx(), this.getC_DocType_ID());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Indirect C_DocTypeTarget_ID=" + C_DocTypeTarget_ID);
            }
            if (C_DocTypeTarget_ID <= 0) {
                return null;
            }
        }
        MOrder counter = MOrder.copyFrom(this, this.getDateOrdered(), C_DocTypeTarget_ID, !this.isSOTrx(), true, false, this.get_TrxName());
        counter.setAD_Org_ID(counterAD_Org_ID);
        counter.setM_Warehouse_ID(counterOrgInfo.getM_Warehouse_ID());
        counter.setDatePromised(this.getDatePromised());
        counter.setSalesRep_ID(this.getSalesRep_ID());
        counter.saveEx(this.get_TrxName());
        MOrderLine[] counterLines = counter.getLines(true, null);
        int i2 = 0;
        while (i2 < counterLines.length) {
            MOrderLine counterLine = counterLines[i2];
            counterLine.setOrder(counter);
            counterLine.setPrice();
            counterLine.setTax();
            counterLine.saveEx(this.get_TrxName());
            ++i2;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(counter.toString());
        }
        if (counterDT != null && counterDT.getDocAction() != null) {
            counter.setDocAction(counterDT.getDocAction());
            if (!counter.processIt(counterDT.getDocAction())) {
                throw new AdempiereException("Failed when processing document - " + counter.getProcessMsg());
            }
            counter.saveEx(this.get_TrxName());
        }
        return counter;
    }

    @Override
    public boolean voidIt() {
        MOrderTax[] taxes;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if (this.getLink_Order_ID() > 0) {
            MOrder so = new MOrder(this.getCtx(), this.getLink_Order_ID(), this.get_TrxName());
            so.setLink_Order_ID(0);
            so.saveEx();
        }
        if (!this.createReversals()) {
            return false;
        }
        MOrderLine[] lines = this.getLines(true, "M_Product_ID");
        int i2 = 0;
        while (i2 < lines.length) {
            MOrderLine line = lines[i2];
            BigDecimal old = line.getQtyOrdered();
            if (old.signum() != 0) {
                line.addDescription(String.valueOf(Msg.getMsg(this.getCtx(), "Voided")) + " (" + old + ")");
                line.setQty(Env.ZERO);
                line.setLineNetAmt(Env.ZERO);
                line.saveEx(this.get_TrxName());
            }
            if (!this.isSOTrx()) {
                this.deleteMatchPOCostDetail(line);
            }
            if (line.getLink_OrderLine_ID() > 0) {
                MOrderLine soline = new MOrderLine(this.getCtx(), line.getLink_OrderLine_ID(), this.get_TrxName());
                soline.setLink_OrderLine_ID(0);
                soline.saveEx();
            }
            ++i2;
        }
        MOrderTax[] mOrderTaxArray = taxes = this.getTaxes(true);
        int n = taxes.length;
        int n2 = 0;
        while (n2 < n) {
            MOrderTax tax = mOrderTaxArray[n2];
            if (!tax.calculateTaxFromLines() || !tax.save()) {
                return false;
            }
            ++n2;
        }
        this.addDescription(Msg.getMsg(this.getCtx(), "Voided"));
        if (!this.reserveStock(null, lines)) {
            this.m_processMsg = "Cannot unreserve Stock (void)";
            return false;
        }
        MRequisitionLine.unlinkC_Order_ID(this.getCtx(), this.get_ID(), this.get_TrxName());
        MFactAcct.deleteEx(259, this.getC_Order_ID(), this.get_TrxName());
        this.setPosted(false);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setTotalLines(Env.ZERO);
        this.setGrandTotal(Env.ZERO);
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    protected boolean createReversals() {
        if (!this.isSOTrx()) {
            return true;
        }
        this.log.info("createReversals");
        StringBuilder info = new StringBuilder();
        info.append("@M_InOut_ID@:");
        MInOut[] shipments = this.getShipments();
        int i2 = 0;
        while (i2 < shipments.length) {
            MInOut ship = shipments[i2];
            if (!("CL".equals(ship.getDocStatus()) || "RE".equals(ship.getDocStatus()) || "VO".equals(ship.getDocStatus()))) {
                ship.set_TrxName(this.get_TrxName());
                if (!"CO".equals(ship.getDocStatus())) {
                    if (ship.voidIt()) {
                        ship.setDocStatus("VO");
                    }
                } else if (ship.reverseCorrectIt()) {
                    ship.setDocStatus("RE");
                    info.append(" ").append(ship.getDocumentNo());
                } else {
                    this.m_processMsg = "Could not reverse Shipment " + ship;
                    return false;
                }
                ship.setDocAction("--");
                ship.saveEx(this.get_TrxName());
            }
            ++i2;
        }
        info.append(" - @C_Invoice_ID@:");
        MInvoice[] invoices = this.getInvoices();
        int i3 = 0;
        while (i3 < invoices.length) {
            MInvoice invoice = invoices[i3];
            if (!("CL".equals(invoice.getDocStatus()) || "RE".equals(invoice.getDocStatus()) || "VO".equals(invoice.getDocStatus()))) {
                invoice.set_TrxName(this.get_TrxName());
                if (!"CO".equals(invoice.getDocStatus())) {
                    if (invoice.voidIt()) {
                        invoice.setDocStatus("VO");
                    }
                } else if (invoice.reverseCorrectIt()) {
                    invoice.setDocStatus("RE");
                    info.append(" ").append(invoice.getDocumentNo());
                } else {
                    this.m_processMsg = "Could not reverse Invoice " + invoice;
                    return false;
                }
                invoice.setDocAction("--");
                invoice.saveEx(this.get_TrxName());
            }
            ++i3;
        }
        this.m_processMsg = info.toString();
        return true;
    }

    @Override
    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        MOrderLine[] lines = this.getLines(true, "M_Product_ID");
        int i2 = 0;
        while (i2 < lines.length) {
            MOrderLine line = lines[i2];
            BigDecimal old = line.getQtyOrdered();
            if (old.compareTo(line.getQtyDelivered()) != 0) {
                line.setQtyLostSales(line.getQtyOrdered().subtract(line.getQtyDelivered()));
                line.setQtyOrdered(line.getQtyDelivered());
                line.addDescription("Close (" + old + ")");
                line.saveEx(this.get_TrxName());
            }
            ++i2;
        }
        if (!this.reserveStock(null, lines)) {
            this.m_processMsg = "Cannot unreserve Stock (close)";
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    public String reopenIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        if (!"CL".equals(this.getDocStatus())) {
            return "Not closed - can't reopen";
        }
        MOrderLine[] lines = this.getLines(true, "M_Product_ID");
        int i2 = 0;
        while (i2 < lines.length) {
            MOrderLine line = lines[i2];
            if (Env.ZERO.compareTo(line.getQtyLostSales()) != 0) {
                line.setQtyOrdered(line.getQtyLostSales().add(line.getQtyDelivered()));
                line.setQtyLostSales(Env.ZERO);
                String desc = line.getDescription();
                if (desc == null) {
                    desc = "";
                }
                Pattern pattern = Pattern.compile("( \\| )?Close \\(.*\\)");
                String[] parts = pattern.split(desc);
                desc = "";
                String[] stringArray = parts;
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    desc = desc.concat(s);
                    ++n2;
                }
                line.setDescription(desc);
                if (!line.save(this.get_TrxName())) {
                    return "Couldn't save orderline";
                }
            }
            ++i2;
        }
        if (!this.reserveStock(null, lines)) {
            this.m_processMsg = "Cannot unreserve Stock (close)";
            return "Failed to update reservations";
        }
        this.setDocStatus("CO");
        this.setDocAction("CL");
        if (!this.save(this.get_TrxName())) {
            return "Couldn't save reopened order";
        }
        return "";
    }

    @Override
    public boolean reverseCorrectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return this.voidIt();
    }

    @Override
    public boolean reverseAccrualIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        String DocSubTypeSO = dt.getDocSubTypeSO();
        if (DocSubTypeSO_Prepay.equals(DocSubTypeSO)) {
            X_C_DocType newDT = null;
            MDocType[] dts = MDocType.getOfClient(this.getCtx());
            int i2 = 0;
            while (i2 < dts.length) {
                MDocType type = dts[i2];
                if (DocSubTypeSO_Prepay.equals(type.getDocSubTypeSO()) && (type.isDefault() || newDT == null)) {
                    newDT = type;
                }
                ++i2;
            }
            if (newDT == null) {
                return false;
            }
            this.setC_DocType_ID(newDT.getC_DocType_ID());
        }
        if (!this.isSOTrx()) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Existing documents not modified - " + dt);
            }
        } else if (DocSubTypeSO_OnCredit.equals(DocSubTypeSO) || DocSubTypeSO_Warehouse.equals(DocSubTypeSO) || DocSubTypeSO_POS.equals(DocSubTypeSO)) {
            if (!this.createReversals()) {
                return false;
            }
        } else if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Existing documents not modified - SubType=" + DocSubTypeSO);
        }
        MFactAcct.deleteEx(259, this.getC_Order_ID(), this.get_TrxName());
        this.setPosted(false);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    @Override
    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "GrandTotal")).append("=").append(this.getGrandTotal());
        if (this.m_lines != null) {
            sb.append(" (#").append(this.m_lines.length).append(")");
        }
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return this.getGrandTotal();
    }

    protected String deleteMatchPOCostDetail(MOrderLine line) {
        MAcctSchema[] acctschemas = MAcctSchema.getClientAcctSchema(this.getCtx(), this.getAD_Client_ID());
        int asn = 0;
        while (asn < acctschemas.length) {
            MCostDetail cd;
            MMatchPO[] mPO;
            MAcctSchema as = acctschemas[asn];
            if (!as.isSkipOrg(this.getAD_Org_ID()) && (mPO = MMatchPO.getOrderLine(this.getCtx(), line.getC_OrderLine_ID(), this.get_TrxName())).length == 0 && (cd = MCostDetail.get(this.getCtx(), "C_OrderLine_ID=?", line.getC_OrderLine_ID(), line.getM_AttributeSetInstance_ID(), as.getC_AcctSchema_ID(), this.get_TrxName())) != null) {
                cd.setProcessed(false);
                cd.delete(true);
            }
            ++asn;
        }
        return "";
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }

    public void setProcessMessage(String processMsg) {
        this.m_processMsg = processMsg;
    }

    public MTaxProvider[] getTaxProviders() {
        MOrderLine[] lines;
        Hashtable<Integer, MTaxProvider> providers = new Hashtable<Integer, MTaxProvider>();
        MOrderLine[] mOrderLineArray = lines = this.getLines();
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MOrderLine line = mOrderLineArray[n2];
            MTax tax = new MTax(line.getCtx(), line.getC_Tax_ID(), line.get_TrxName());
            MTaxProvider provider = (MTaxProvider)providers.get(tax.getC_TaxProvider_ID());
            if (provider == null) {
                providers.put(tax.getC_TaxProvider_ID(), new MTaxProvider(tax.getCtx(), tax.getC_TaxProvider_ID(), tax.get_TrxName()));
            }
            ++n2;
        }
        MTaxProvider[] retValue = new MTaxProvider[providers.size()];
        providers.values().toArray(retValue);
        return retValue;
    }

    public int getDocTypeID() {
        return this.getC_DocType_ID() > 0 ? this.getC_DocType_ID() : this.getC_DocTypeTarget_ID();
    }
}

