/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MDocType;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MLocator;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MMovementLineConfirm;
import org.compiere.model.MPeriod;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.X_M_MovementConfirm;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;
import org.compiere.wf.MWorkflow;

public class MMovementConfirm
extends X_M_MovementConfirm
implements DocAction {
    private static final long serialVersionUID = -399427235334348654L;
    protected MMovementLineConfirm[] m_lines = null;
    protected MInventory m_inventoryFrom = null;
    protected MInventory m_inventoryTo = null;
    protected String m_inventoryInfo = null;
    protected List<MInventory> m_inventoryDoc = null;
    protected String m_processMsg = null;
    protected boolean m_justPrepared = false;

    public static MMovementConfirm create(MMovement move, boolean checkExisting) {
        MMovementConfirm[] confirmations;
        if (checkExisting && (confirmations = move.getConfirmations(false)).length > 0) {
            MMovementConfirm confirm = confirmations[0];
            return confirm;
        }
        MMovementConfirm confirm = new MMovementConfirm(move);
        confirm.saveEx(move.get_TrxName());
        MMovementLine[] moveLines = move.getLines(false);
        int i2 = 0;
        while (i2 < moveLines.length) {
            MMovementLine mLine = moveLines[i2];
            MMovementLineConfirm cLine = new MMovementLineConfirm(confirm);
            cLine.setMovementLine(mLine);
            cLine.saveEx(move.get_TrxName());
            ++i2;
        }
        return confirm;
    }

    public MMovementConfirm(Properties ctx, int M_MovementConfirm_ID, String trxName) {
        super(ctx, M_MovementConfirm_ID, trxName);
        if (M_MovementConfirm_ID == 0) {
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setIsApproved(false);
            this.setProcessed(false);
        }
    }

    public MMovementConfirm(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MMovementConfirm(MMovement move) {
        this(move.getCtx(), 0, move.get_TrxName());
        this.setClientOrg(move);
        this.setM_Movement_ID(move.getM_Movement_ID());
    }

    public MMovementLineConfirm[] getLines(boolean requery) {
        ArrayList<MMovementLineConfirm> list;
        block7: {
            if (this.m_lines != null && !requery) {
                MMovementConfirm.set_TrxName(this.m_lines, this.get_TrxName());
                return this.m_lines;
            }
            String sql = "SELECT * FROM M_MovementLineConfirm WHERE M_MovementConfirm_ID=?";
            list = new ArrayList<MMovementLineConfirm>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getM_MovementConfirm_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MMovementLineConfirm(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_lines = new MMovementLineConfirm[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(String.valueOf(desc) + " | " + description);
        }
    }

    @Override
    public void setIsApproved(boolean IsApproved) {
        if (IsApproved && !this.isApproved()) {
            int AD_User_ID = Env.getAD_User_ID(this.getCtx());
            MUser user = MUser.get(this.getCtx(), AD_User_ID);
            String info = String.valueOf(user.getName()) + ": " + Msg.translate(this.getCtx(), "IsApproved") + " - " + new Timestamp(System.currentTimeMillis());
            this.addDescription(info);
        }
        super.setIsApproved(IsApproved);
    }

    @Override
    public String getDocumentInfo() {
        return String.valueOf(Msg.getElement(this.getCtx(), "M_MovementConfirm_ID")) + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("unlockIt - " + this.toString());
        }
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("invalidateIt - " + this.toString());
        }
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!MPeriod.isOpen(this.getCtx(), this.getUpdated(), "MMM", this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MMovementLineConfirm[] lines = this.getLines(true);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        int i2 = 0;
        while (i2 < lines.length) {
            if (!lines[i2].isFullyConfirmed()) break;
            ++i2;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("approveIt - " + this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("rejectIt - " + this.toString());
        }
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("completeIt - " + this.toString());
        }
        this.m_inventoryDoc = new ArrayList<MInventory>();
        MMovement move = new MMovement(this.getCtx(), this.getM_Movement_ID(), this.get_TrxName());
        MMovementLineConfirm[] lines = this.getLines(false);
        int i2 = 0;
        while (i2 < lines.length) {
            MMovementLineConfirm confirm = lines[i2];
            confirm.set_TrxName(this.get_TrxName());
            if (!confirm.processLine()) {
                this.m_processMsg = "ShipLine not saved - " + confirm;
                return "IN";
            }
            if (confirm.isFullyConfirmed() && confirm.getScrappedQty().signum() == 0) {
                confirm.setProcessed(true);
                confirm.saveEx(this.get_TrxName());
            } else if (this.createDifferenceDoc(move, confirm)) {
                confirm.setProcessed(true);
                confirm.saveEx(this.get_TrxName());
            } else {
                this.log.log(Level.SEVERE, "completeIt - Scrapped=" + confirm.getScrappedQty() + " - Difference=" + confirm.getDifferenceQty());
                if (this.m_processMsg == null) {
                    this.m_processMsg = "Differnce Doc not created";
                }
                return "IN";
            }
            ++i2;
        }
        this.setProcessed(true);
        this.saveEx();
        ProcessInfo processInfo = MWorkflow.runDocumentActionWorkflow(move, "CO");
        if (processInfo.isError()) {
            this.m_processMsg = processInfo.getSummary();
            this.setProcessed(false);
            return "IN";
        }
        if (this.m_inventoryInfo != null) {
            for (MInventory inventory : this.m_inventoryDoc) {
                processInfo = MWorkflow.runDocumentActionWorkflow(inventory, "CO");
                if (!processInfo.isError()) continue;
                this.m_processMsg = processInfo.getSummary();
                this.setProcessed(false);
                return "IN";
            }
            this.m_processMsg = " @M_Inventory_ID@: " + this.m_inventoryInfo;
            this.addDescription(String.valueOf(Msg.translate(this.getCtx(), "M_Inventory_ID")) + ": " + this.m_inventoryInfo);
        }
        this.m_inventoryDoc = null;
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            this.setProcessed(false);
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    protected boolean createDifferenceDoc(MMovement move, MMovementLineConfirm confirm) {
        MInventoryLine line;
        MWarehouse wh;
        MLocator loc;
        MMovementLine mLine = confirm.getLine();
        if (Env.ZERO.compareTo(confirm.getDifferenceQty()) != 0) {
            loc = MLocator.get(this.getCtx(), mLine.getM_Locator_ID());
            if (this.m_inventoryFrom != null && this.m_inventoryFrom.getM_Warehouse_ID() != loc.getM_Warehouse_ID()) {
                this.m_inventoryFrom = null;
            }
            if (this.m_inventoryFrom == null) {
                wh = MWarehouse.get(this.getCtx(), loc.getM_Warehouse_ID());
                this.m_inventoryFrom = new MInventory(wh, this.get_TrxName());
                this.m_inventoryFrom.setDescription(String.valueOf(Msg.translate(this.getCtx(), "M_MovementConfirm_ID")) + " " + this.getDocumentNo());
                this.setInventoryDocType(this.m_inventoryFrom);
                if (!this.m_inventoryFrom.save(this.get_TrxName())) {
                    this.updateProcessMsg("Inventory not created");
                    return false;
                }
                if (this.getM_Inventory_ID() == 0) {
                    this.setM_Inventory_ID(this.m_inventoryFrom.getM_Inventory_ID());
                    this.m_inventoryInfo = this.m_inventoryFrom.getDocumentNo();
                } else {
                    this.m_inventoryInfo = String.valueOf(this.m_inventoryInfo) + "," + this.m_inventoryFrom.getDocumentNo();
                }
                this.m_inventoryDoc.add(this.m_inventoryFrom);
            }
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("createDifferenceDoc - Difference=" + confirm.getDifferenceQty());
            }
            line = new MInventoryLine(this.m_inventoryFrom, mLine.getM_Locator_ID(), mLine.getM_Product_ID(), mLine.getM_AttributeSetInstance_ID(), confirm.getDifferenceQty(), Env.ZERO);
            line.setDescription(Msg.translate(this.getCtx(), "DifferenceQty"));
            if (!line.save(this.get_TrxName())) {
                this.updateProcessMsg("Inventory Line not created");
                return false;
            }
            confirm.setM_InventoryLine_ID(line.getM_InventoryLine_ID());
        }
        if (Env.ZERO.compareTo(confirm.getScrappedQty()) != 0) {
            loc = MLocator.get(this.getCtx(), mLine.getM_LocatorTo_ID());
            if (this.m_inventoryTo != null && this.m_inventoryTo.getM_Warehouse_ID() != loc.getM_Warehouse_ID()) {
                this.m_inventoryTo = null;
            }
            if (this.m_inventoryTo == null) {
                wh = MWarehouse.get(this.getCtx(), loc.getM_Warehouse_ID());
                this.m_inventoryTo = new MInventory(wh, this.get_TrxName());
                this.m_inventoryTo.setDescription(String.valueOf(Msg.translate(this.getCtx(), "M_MovementConfirm_ID")) + " " + this.getDocumentNo());
                this.setInventoryDocType(this.m_inventoryTo);
                if (!this.m_inventoryTo.save(this.get_TrxName())) {
                    this.updateProcessMsg("Inventory not created");
                    return false;
                }
                if (this.getM_Inventory_ID() == 0) {
                    this.setM_Inventory_ID(this.m_inventoryTo.getM_Inventory_ID());
                    this.m_inventoryInfo = this.m_inventoryTo.getDocumentNo();
                } else {
                    this.m_inventoryInfo = String.valueOf(this.m_inventoryInfo) + "," + this.m_inventoryTo.getDocumentNo();
                }
                this.m_inventoryDoc.add(this.m_inventoryTo);
            }
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("createDifferenceDoc - Scrapped=" + confirm.getScrappedQty());
            }
            line = new MInventoryLine(this.m_inventoryTo, mLine.getM_LocatorTo_ID(), mLine.getM_Product_ID(), mLine.getM_AttributeSetInstance_ID(), confirm.getScrappedQty(), Env.ZERO);
            line.setDescription(Msg.translate(this.getCtx(), "ScrappedQty"));
            if (!line.save(this.get_TrxName())) {
                this.updateProcessMsg("Inventory Line not created");
                return false;
            }
            confirm.setM_InventoryLine_ID(line.getM_InventoryLine_ID());
        }
        return true;
    }

    protected void updateProcessMsg(String msg) {
        this.m_processMsg = this.m_processMsg != null ? String.valueOf(this.m_processMsg) + " " + msg : msg;
        ValueNamePair error = CLogger.retrieveError();
        if (error != null) {
            this.m_processMsg = String.valueOf(this.m_processMsg) + ": " + Msg.getMsg(Env.getCtx(), error.getValue()) + " " + error.getName();
        }
    }

    protected void setInventoryDocType(MInventory inventory) {
        MDocType[] doctypes;
        MDocType[] mDocTypeArray = doctypes = MDocType.getOfDocBaseType(Env.getCtx(), "MMI");
        int n = doctypes.length;
        int n2 = 0;
        while (n2 < n) {
            MDocType doctype = mDocTypeArray[n2];
            if ("PI".equals(doctype.getDocSubTypeInv())) {
                inventory.setC_DocType_ID(doctype.getC_DocType_ID());
                break;
            }
            ++n2;
        }
    }

    @Override
    public boolean voidIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("voidIt - " + this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("closeIt - " + this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reverseCorrectIt - " + this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reverseAccrualIt - " + this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("reActivateIt - " + this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "ApprovalAmt")).append("=").append(this.getApprovalAmt()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getUpdatedBy();
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }
}

