/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.NegativeInventoryDisallowedException;
import org.adempiere.exceptions.PeriodClosedException;
import org.compiere.model.MDocType;
import org.compiere.model.MLocator;
import org.compiere.model.MMovementConfirm;
import org.compiere.model.MMovementLine;
import org.compiere.model.MMovementLineMA;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MTransaction;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_Locator;
import org.compiere.model.X_M_Movement;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class MMovement
extends X_M_Movement
implements DocAction {
    private static final long serialVersionUID = 3201199540429467933L;
    protected MMovementLine[] m_lines = null;
    protected MMovementConfirm[] m_confirms = null;
    public static String REVERSE_INDICATOR = "^";
    protected String m_processMsg = null;
    protected boolean m_justPrepared = false;
    protected boolean m_reversal = false;

    public MMovement(Properties ctx, int M_Movement_ID, String trxName) {
        super(ctx, M_Movement_ID, trxName);
        if (M_Movement_ID == 0) {
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setIsApproved(false);
            this.setIsInTransit(false);
            this.setMovementDate(new Timestamp(System.currentTimeMillis()));
            this.setPosted(false);
            super.setProcessed(false);
        }
    }

    public MMovement(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MMovementLine[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            MMovement.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        String whereClause = "M_Movement_ID=?";
        List<MMovementLine> list = new Query(this.getCtx(), "M_MovementLine", "M_Movement_ID=?", this.get_TrxName()).setParameters(this.getM_Movement_ID()).setOrderBy("Line").list();
        this.m_lines = new MMovementLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public MMovementConfirm[] getConfirmations(boolean requery) {
        if (this.m_confirms != null && !requery) {
            return this.m_confirms;
        }
        List<MMovementConfirm> list = new Query(this.getCtx(), "M_MovementConfirm", "M_Movement_ID=?", this.get_TrxName()).setParameters(this.get_ID()).list();
        this.m_confirms = list.toArray(new MMovementConfirm[list.size()]);
        return this.m_confirms;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(String.valueOf(desc) + " | " + description);
        }
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return String.valueOf(dt.getNameTrl()) + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getC_DocType_ID() == 0) {
            MDocType[] types = MDocType.getOfDocBaseType(this.getCtx(), "MMM");
            if (types.length > 0) {
                this.setC_DocType_ID(types[0].getC_DocType_ID());
            } else {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@NotFound@ @C_DocType_ID@"));
                return false;
            }
        }
        return true;
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String sql = "UPDATE M_MovementLine SET Processed=? WHERE M_Movement_ID=?";
        int noLine = DB.executeUpdateEx("UPDATE M_MovementLine SET Processed=? WHERE M_Movement_ID=?", new Object[]{processed, this.get_ID()}, this.get_TrxName());
        this.m_lines = null;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Processed=" + processed + " - Lines=" + noLine);
        }
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getMovementDate(), dt.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MMovementLine[] lines = this.getLines(false);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        MMovementLine[] mMovementLineArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MMovementLine line = mMovementLineArray[n2];
            MProduct product = line.getProduct();
            if (line.getM_AttributeSetInstance_ID() == 0 && product != null && product.isASIMandatory(true) && product.getAttributeSet() != null && !product.getAttributeSet().excludeTableEntry(324, true)) {
                BigDecimal qtyDiff = line.getMovementQty();
                MMovementLineMA[] mas = MMovementLineMA.get(this.getCtx(), line.getM_MovementLine_ID(), this.get_TrxName());
                BigDecimal qtyma = Env.ZERO;
                MMovementLineMA[] mMovementLineMAArray = mas;
                int n3 = mas.length;
                int n4 = 0;
                while (n4 < n3) {
                    MMovementLineMA ma = mMovementLineMAArray[n4];
                    if (!ma.isAutoGenerated()) {
                        qtyma = qtyma.add(ma.getMovementQty());
                    }
                    ++n4;
                }
                if (qtyma.subtract(qtyDiff).signum() != 0) {
                    this.m_processMsg = "@Line@ " + line.getLine() + ": @FillMandatory@ @M_AttributeSetInstance_ID@";
                    return "IN";
                }
            }
            if (line.getM_AttributeSetInstanceTo_ID() == 0 && product != null && product.isASIMandatory(false) && line.getM_AttributeSetInstanceTo_ID() == 0 && product.getAttributeSet() != null && !product.getAttributeSet().excludeTableEntry(324, false)) {
                this.m_processMsg = "@Line@ " + line.getLine() + ": @FillMandatory@ @M_AttributeSetInstanceTo_ID@";
                return "IN";
            }
            ++n2;
        }
        if (dt.isInTransit()) {
            this.createConfirmation();
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    protected void createConfirmation() {
        MMovementConfirm[] confirmations = this.getConfirmations(false);
        if (confirmations.length > 0) {
            return;
        }
        MMovementConfirm.create(this, false);
    }

    @Override
    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setIsApproved(false);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String completeIt() {
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.setDefiniteDocumentNo();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MMovementConfirm[] confirmations = this.getConfirmations(true);
        int i2 = 0;
        while (i2 < confirmations.length) {
            MMovementConfirm confirm = confirmations[i2];
            if (!confirm.isProcessed()) {
                this.m_processMsg = "Open: @M_MovementConfirm_ID@ - " + confirm.getDocumentNo();
                return "IP";
            }
            ++i2;
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        StringBuilder errors = new StringBuilder();
        MMovementLine[] lines = this.getLines(false);
        int i3 = 0;
        while (i3 < lines.length) {
            block31: {
                MMovementLine line = lines[i3];
                MTransaction trxFrom = null;
                MProduct product = line.getProduct();
                try {
                    Object locatorTo;
                    if (product == null || !product.isStocked()) break block31;
                    if (!this.isReversal()) {
                        BigDecimal movementQty;
                        BigDecimal qtyOnLineMA = MMovementLineMA.getManualQty(line.getM_MovementLine_ID(), this.get_TrxName());
                        if (qtyOnLineMA.compareTo(movementQty = line.getMovementQty()) > 0) {
                            this.m_processMsg = "@Over_Qty_On_Attribute_Tab@ " + line.getLine();
                            return "IN";
                        }
                        this.checkMaterialPolicy(line, movementQty.subtract(qtyOnLineMA));
                    }
                    if (line.getM_AttributeSetInstance_ID() == 0) {
                        MMovementLineMA[] mas = MMovementLineMA.get(this.getCtx(), line.getM_MovementLine_ID(), this.get_TrxName());
                        int j = 0;
                        while (j < mas.length) {
                            MMovementLineMA ma = mas[j];
                            MLocator locator = new MLocator(this.getCtx(), line.getM_Locator_ID(), this.get_TrxName());
                            if (!MStorageOnHand.add(this.getCtx(), locator.getM_Warehouse_ID(), line.getM_Locator_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), ma.getMovementQty().negate(), ma.getDateMaterialPolicy(), this.get_TrxName())) {
                                String lastError = CLogger.retrieveErrorString("");
                                this.m_processMsg = "Cannot correct Inventory OnHand (MA) - " + lastError;
                                return "IN";
                            }
                            int M_AttributeSetInstanceTo_ID = line.getM_AttributeSetInstanceTo_ID();
                            if (M_AttributeSetInstanceTo_ID == 0 && line.getM_Locator_ID() != line.getM_LocatorTo_ID()) {
                                M_AttributeSetInstanceTo_ID = ma.getM_AttributeSetInstance_ID();
                            }
                            locatorTo = new MLocator(this.getCtx(), line.getM_LocatorTo_ID(), this.get_TrxName());
                            if (!MStorageOnHand.add(this.getCtx(), ((X_M_Locator)locatorTo).getM_Warehouse_ID(), line.getM_LocatorTo_ID(), line.getM_Product_ID(), M_AttributeSetInstanceTo_ID, ma.getMovementQty(), ma.getDateMaterialPolicy(), this.get_TrxName())) {
                                String lastError = CLogger.retrieveErrorString("");
                                this.m_processMsg = "Cannot correct Inventory OnHand (MA) - " + lastError;
                                return "IN";
                            }
                            trxFrom = new MTransaction(this.getCtx(), line.getAD_Org_ID(), "M-", line.getM_Locator_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), ma.getMovementQty().negate(), this.getMovementDate(), this.get_TrxName());
                            trxFrom.setM_MovementLine_ID(line.getM_MovementLine_ID());
                            if (!trxFrom.save()) {
                                this.m_processMsg = "Transaction From not inserted (MA)";
                                return "IN";
                            }
                            MTransaction trxTo = new MTransaction(this.getCtx(), line.getAD_Org_ID(), "M+", line.getM_LocatorTo_ID(), line.getM_Product_ID(), M_AttributeSetInstanceTo_ID, ma.getMovementQty(), this.getMovementDate(), this.get_TrxName());
                            trxTo.setM_MovementLine_ID(line.getM_MovementLine_ID());
                            if (!trxTo.save()) {
                                this.m_processMsg = "Transaction To not inserted (MA)";
                                return "IN";
                            }
                            ++j;
                        }
                    }
                    if (trxFrom == null) {
                        Timestamp dateMPolicy = null;
                        MStorageOnHand[] storages = null;
                        storages = line.getMovementQty().compareTo(Env.ZERO) > 0 ? MStorageOnHand.getWarehouse(this.getCtx(), 0, line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), null, "F".equals(product.getMMPolicy()), false, line.getM_Locator_ID(), this.get_TrxName()) : MStorageOnHand.getWarehouse(this.getCtx(), 0, line.getM_Product_ID(), line.getM_AttributeSetInstanceTo_ID(), null, "F".equals(product.getMMPolicy()), false, line.getM_LocatorTo_ID(), this.get_TrxName());
                        locatorTo = storages;
                        int M_AttributeSetInstanceTo_ID = storages.length;
                        int locator = 0;
                        while (locator < M_AttributeSetInstanceTo_ID) {
                            MStorageOnHand storage = locatorTo[locator];
                            if (storage.getQtyOnHand().compareTo(line.getMovementQty()) >= 0) {
                                dateMPolicy = storage.getDateMaterialPolicy();
                                break;
                            }
                            ++locator;
                        }
                        if (dateMPolicy == null && storages.length > 0) {
                            dateMPolicy = storages[0].getDateMaterialPolicy();
                        }
                        MLocator locator2 = new MLocator(this.getCtx(), line.getM_Locator_ID(), this.get_TrxName());
                        Timestamp effDateMPolicy = dateMPolicy;
                        if (dateMPolicy == null && line.getMovementQty().negate().signum() > 0) {
                            effDateMPolicy = this.getMovementDate();
                        }
                        if (!MStorageOnHand.add(this.getCtx(), locator2.getM_Warehouse_ID(), line.getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.getMovementQty().negate(), effDateMPolicy, this.get_TrxName())) {
                            String lastError = CLogger.retrieveErrorString("");
                            this.m_processMsg = "Cannot correct Inventory OnHand (MA) - " + lastError;
                            return "IN";
                        }
                        effDateMPolicy = dateMPolicy;
                        if (dateMPolicy == null && line.getMovementQty().signum() > 0) {
                            effDateMPolicy = this.getMovementDate();
                        }
                        MLocator locatorTo2 = new MLocator(this.getCtx(), line.getM_LocatorTo_ID(), this.get_TrxName());
                        if (!MStorageOnHand.add(this.getCtx(), locatorTo2.getM_Warehouse_ID(), line.getM_LocatorTo_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstanceTo_ID(), line.getMovementQty(), effDateMPolicy, this.get_TrxName())) {
                            String lastError = CLogger.retrieveErrorString("");
                            this.m_processMsg = "Cannot correct Inventory OnHand (MA) - " + lastError;
                            return "IN";
                        }
                        trxFrom = new MTransaction(this.getCtx(), line.getAD_Org_ID(), "M-", line.getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.getMovementQty().negate(), this.getMovementDate(), this.get_TrxName());
                        trxFrom.setM_MovementLine_ID(line.getM_MovementLine_ID());
                        if (!trxFrom.save()) {
                            this.m_processMsg = "Transaction From not inserted";
                            return "IN";
                        }
                        MTransaction trxTo = new MTransaction(this.getCtx(), line.getAD_Org_ID(), "M+", line.getM_LocatorTo_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstanceTo_ID(), line.getMovementQty(), this.getMovementDate(), this.get_TrxName());
                        trxTo.setM_MovementLine_ID(line.getM_MovementLine_ID());
                        if (!trxTo.save()) {
                            this.m_processMsg = "Transaction To not inserted";
                            return "IN";
                        }
                    }
                }
                catch (NegativeInventoryDisallowedException e) {
                    this.log.severe(e.getMessage());
                    errors.append(Msg.getElement(this.getCtx(), "Line")).append(" ").append(line.getLine()).append(": ");
                    errors.append(e.getMessage()).append("\n");
                }
            }
            ++i3;
        }
        if (errors.toString().length() > 0) {
            this.m_processMsg = errors.toString();
            return "IN";
        }
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    protected void setDefiniteDocumentNo() {
        String value;
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setMovementDate(TimeUtil.getDay(0L));
            MPeriod.testPeriodOpen(this.getCtx(), this.getMovementDate(), this.getC_DocType_ID(), this.getAD_Org_ID());
        }
        if (dt.isOverwriteSeqOnComplete() && (value = DB.getDocumentNo(this.getC_DocType_ID(), this.get_TrxName(), true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    protected void checkMaterialPolicy(MMovementLine line, BigDecimal qtyToDeliver) {
        int no = MMovementLineMA.deleteMovementLineMA(line.getM_MovementLine_ID(), this.get_TrxName());
        if (no > 0 && this.log.isLoggable(Level.CONFIG)) {
            this.log.config("Delete old #" + no);
        }
        if (Env.ZERO.compareTo(qtyToDeliver) == 0) {
            return;
        }
        boolean needSave = false;
        if (line.getM_AttributeSetInstance_ID() == 0) {
            MStorageOnHand[] storages;
            MProduct product = MProduct.get(this.getCtx(), line.getM_Product_ID());
            String MMPolicy = product.getMMPolicy();
            MStorageOnHand[] mStorageOnHandArray = storages = MStorageOnHand.getWarehouse(this.getCtx(), 0, line.getM_Product_ID(), 0, null, "F".equals(MMPolicy), true, line.getM_Locator_ID(), this.get_TrxName());
            int n = storages.length;
            int n2 = 0;
            while (n2 < n) {
                MMovementLineMA ma;
                MStorageOnHand storage = mStorageOnHandArray[n2];
                if (storage.getQtyOnHand().compareTo(qtyToDeliver) >= 0) {
                    ma = new MMovementLineMA(line, storage.getM_AttributeSetInstance_ID(), qtyToDeliver, storage.getDateMaterialPolicy(), true);
                    ma.saveEx();
                    qtyToDeliver = Env.ZERO;
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine(ma + ", QtyToDeliver=" + qtyToDeliver);
                    }
                } else {
                    ma = new MMovementLineMA(line, storage.getM_AttributeSetInstance_ID(), storage.getQtyOnHand(), storage.getDateMaterialPolicy(), true);
                    ma.saveEx();
                    qtyToDeliver = qtyToDeliver.subtract(storage.getQtyOnHand());
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine(ma + ", QtyToDeliver=" + qtyToDeliver);
                    }
                }
                if (qtyToDeliver.signum() == 0) break;
                ++n2;
            }
            if (qtyToDeliver.signum() != 0) {
                MMovementLineMA ma = MMovementLineMA.addOrCreate(line, 0, qtyToDeliver, this.getMovementDate(), true);
                ma.saveEx();
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("##: " + ma);
                }
            }
        }
        if (needSave) {
            line.saveEx();
        }
    }

    @Override
    public boolean voidIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
            if (this.m_processMsg != null) {
                return false;
            }
            MMovementLine[] lines = this.getLines(false);
            int i2 = 0;
            while (i2 < lines.length) {
                MMovementLine line = lines[i2];
                BigDecimal old = line.getMovementQty();
                if (old.compareTo(Env.ZERO) != 0) {
                    line.setMovementQty(Env.ZERO);
                    line.addDescription("Void (" + old + ")");
                    line.saveEx(this.get_TrxName());
                }
                ++i2;
            }
        } else {
            boolean accrual = false;
            try {
                MPeriod.testPeriodOpen(this.getCtx(), this.getMovementDate(), this.getC_DocType_ID(), this.getAD_Org_ID());
            }
            catch (PeriodClosedException e) {
                accrual = true;
            }
            if (accrual) {
                return this.reverseAccrualIt();
            }
            return this.reverseCorrectIt();
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        MMovement reversal = this.reverse(false);
        if (reversal == null) {
            return false;
        }
        this.m_processMsg = reversal.getDocumentNo();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        return this.m_processMsg == null;
    }

    protected MMovement reverse(boolean accrual) {
        Timestamp reversalDate;
        Timestamp timestamp = reversalDate = accrual ? Env.getContextAsDate(this.getCtx(), "#Date") : this.getMovementDate();
        if (reversalDate == null) {
            reversalDate = new Timestamp(System.currentTimeMillis());
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), reversalDate, dt.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return null;
        }
        MMovement reversal = new MMovement(this.getCtx(), 0, this.get_TrxName());
        MMovement.copyValues(this, reversal, this.getAD_Client_ID(), this.getAD_Org_ID());
        reversal.setDocStatus("DR");
        reversal.setDocAction("CO");
        reversal.setIsApproved(false);
        reversal.setIsInTransit(false);
        reversal.setPosted(false);
        reversal.setProcessed(false);
        reversal.setMovementDate(reversalDate);
        reversal.setDocumentNo(String.valueOf(this.getDocumentNo()) + REVERSE_INDICATOR);
        reversal.addDescription("{->" + this.getDocumentNo() + ")");
        reversal.setReversal_ID(this.getM_Movement_ID());
        if (!reversal.save()) {
            this.m_processMsg = "Could not create Movement Reversal";
            return null;
        }
        reversal.setReversal(true);
        MMovementLine[] oLines = this.getLines(true);
        int i2 = 0;
        while (i2 < oLines.length) {
            MMovementLine oLine = oLines[i2];
            MMovementLine rLine = new MMovementLine(this.getCtx(), 0, this.get_TrxName());
            MMovement.copyValues(oLine, rLine, oLine.getAD_Client_ID(), oLine.getAD_Org_ID());
            rLine.setM_Movement_ID(reversal.getM_Movement_ID());
            rLine.setReversalLine_ID(oLine.getM_MovementLine_ID());
            rLine.setMovementQty(rLine.getMovementQty().negate());
            rLine.setTargetQty(Env.ZERO);
            rLine.setScrappedQty(Env.ZERO);
            rLine.setConfirmedQty(Env.ZERO);
            rLine.setProcessed(false);
            if (!rLine.save()) {
                this.m_processMsg = "Could not create Movement Reversal Line";
                return null;
            }
            if (rLine.getM_AttributeSetInstance_ID() == 0) {
                MMovementLineMA[] mas = MMovementLineMA.get(this.getCtx(), oLine.getM_MovementLine_ID(), this.get_TrxName());
                int j = 0;
                while (j < mas.length) {
                    MMovementLineMA ma = new MMovementLineMA(rLine, mas[j].getM_AttributeSetInstance_ID(), mas[j].getMovementQty().negate(), mas[j].getDateMaterialPolicy(), true);
                    ma.saveEx();
                    ++j;
                }
            }
            ++i2;
        }
        if (!reversal.processIt("CO")) {
            this.m_processMsg = "Reversal ERROR: " + reversal.getProcessMsg();
            return null;
        }
        reversal.closeIt();
        reversal.setDocStatus("RE");
        reversal.setDocAction("--");
        reversal.saveEx();
        this.addDescription("(" + reversal.getDocumentNo() + "<-)");
        this.setReversal_ID(reversal.getM_Movement_ID());
        this.setProcessed(true);
        this.setDocStatus("RE");
        this.setDocAction("--");
        return reversal;
    }

    @Override
    public boolean reverseAccrualIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        MMovement reversal = this.reverse(true);
        if (reversal == null) {
            return false;
        }
        this.m_processMsg = reversal.getDocumentNo();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "ApprovalAmt")).append("=").append(this.getApprovalAmt()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    protected void setReversal(boolean reversal) {
        this.m_reversal = reversal;
    }

    protected boolean isReversal() {
        return this.m_reversal;
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }
}

