/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MGoalRestriction;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.X_PA_MeasureCalc;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MMeasureCalc
extends X_PA_MeasureCalc {
    private static final long serialVersionUID = 4720674127987683534L;
    private static CCache<Integer, MMeasureCalc> s_cache = new CCache("PA_MeasureCalc", 10);

    public static MMeasureCalc get(Properties ctx, int PA_MeasureCalc_ID) {
        Integer key = PA_MeasureCalc_ID;
        MMeasureCalc retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MMeasureCalc(ctx, PA_MeasureCalc_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MMeasureCalc(Properties ctx, int PA_MeasureCalc_ID, String trxName) {
        super(ctx, PA_MeasureCalc_ID, trxName);
    }

    public MMeasureCalc(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getSqlPI(MGoalRestriction[] restrictions, String MeasureScope, String MeasureDataType, Timestamp reportDate, MRole role) {
        StringBuilder sb = new StringBuilder(this.getSelectClause()).append(" ").append(this.getWhereClause());
        if (this.getDateColumn() != null && "T".equals(MeasureDataType) && !"0".equals(MeasureScope)) {
            if (reportDate == null) {
                reportDate = new Timestamp(System.currentTimeMillis());
            }
            String dateString = DB.TO_DATE(reportDate);
            String trunc = "DD";
            if ("1".equals(MeasureScope)) {
                trunc = "Y";
            } else if ("3".equals(MeasureScope)) {
                trunc = "Q";
            } else if ("5".equals(MeasureScope)) {
                trunc = "MM";
            } else if ("7".equals(MeasureScope)) {
                trunc = "D";
            }
            sb.append(" AND TRUNC(").append(this.getDateColumn()).append(",'").append(trunc).append("')=TRUNC(").append(DB.TO_DATE(reportDate)).append(",'").append(trunc).append("')");
        }
        String sql = this.addRestrictions(sb.toString(), restrictions, role);
        this.log.fine(sql);
        return sql;
    }

    public String getSqlBarChart(MGoalRestriction[] restrictions, String MeasureDisplay, Timestamp startDate, MRole role) {
        StringBuilder sb = new StringBuilder();
        String dateCol = null;
        String groupBy = null;
        if (this.getDateColumn() != null && !"0".equals(MeasureDisplay)) {
            String trunc = "D";
            if ("1".equals(MeasureDisplay)) {
                trunc = "Y";
            } else if ("3".equals(MeasureDisplay)) {
                trunc = "Q";
            } else if ("5".equals(MeasureDisplay)) {
                trunc = "MM";
            } else if ("7".equals(MeasureDisplay)) {
                trunc = "W";
            }
            groupBy = dateCol = "TRUNC(" + this.getDateColumn() + ",'" + trunc + "') ";
        } else {
            dateCol = "MAX(" + this.getDateColumn() + ") ";
        }
        String selectFrom = this.getSelectClause();
        int index = selectFrom.indexOf("FROM ");
        if (index == -1) {
            index = selectFrom.toUpperCase().indexOf("FROM ");
        }
        if (index == -1) {
            throw new IllegalArgumentException("Cannot find FROM in sql - " + selectFrom);
        }
        sb.append(selectFrom.substring(0, index)).append(",").append(dateCol).append(selectFrom.substring(index));
        sb.append(" ").append(this.getWhereClause());
        if (this.getDateColumn() != null && startDate != null && !"0".equals(MeasureDisplay)) {
            String dateString = DB.TO_DATE(startDate);
            sb.append(" AND ").append(this.getDateColumn()).append(">=").append(dateString);
        }
        String sql = this.addRestrictions(sb.toString(), restrictions, role);
        if (groupBy != null) {
            sql = String.valueOf(sql) + " GROUP BY " + groupBy + " ORDER BY " + groupBy;
        }
        this.log.fine(sql);
        return sql;
    }

    public MQuery getQuery(MGoalRestriction[] restrictions, String MeasureDisplay, Timestamp date, MRole role) {
        StringBuilder where;
        MQuery query;
        block18: {
            String finalSQL;
            query = new MQuery(this.getAD_Table_ID());
            StringBuilder sql = new StringBuilder("SELECT ").append(this.getKeyColumn()).append(" ");
            String from = this.getSelectClause();
            int index = from.indexOf("FROM ");
            if (index == -1) {
                throw new IllegalArgumentException("Cannot find FROM " + from);
            }
            sql.append(from.substring(index)).append(" ").append(this.getWhereClause());
            if (this.getDateColumn() != null && !"0".equals(MeasureDisplay)) {
                String trunc = "D";
                if ("1".equals(MeasureDisplay)) {
                    trunc = "Y";
                } else if ("3".equals(MeasureDisplay)) {
                    trunc = "Q";
                } else if ("5".equals(MeasureDisplay)) {
                    trunc = "MM";
                } else if ("7".equals(MeasureDisplay)) {
                    trunc = "W";
                }
                sql.append(" AND TRUNC(").append(this.getDateColumn()).append(",'").append(trunc).append("')=TRUNC(").append(DB.TO_DATE(date)).append(",'").append(trunc).append("')");
            }
            if ((finalSQL = this.addRestrictions(sql.toString(), restrictions, role)).indexOf("@") >= 0) {
                finalSQL = Env.parseContext(this.getCtx(), 0, finalSQL, false, false);
            }
            where = new StringBuilder();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(finalSQL, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int id = rs.getInt(1);
                        if (where.length() > 0) {
                            where.append(",");
                        }
                        where.append(id);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, finalSQL, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block18;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (where.length() == 0) {
            return MQuery.getNoRecordQuery(query.getTableName(), false);
        }
        StringBuilder whereClause = new StringBuilder(this.getKeyColumn()).append(" IN (").append((CharSequence)where).append(")");
        query.addRestriction(whereClause.toString());
        query.setRecordCount(1);
        return query;
    }

    private String addRestrictions(String sql, MGoalRestriction[] restrictions, MRole role) {
        return MMeasureCalc.addRestrictions(sql, false, restrictions, role, this.getTableName(), this.getOrgColumn(), this.getBPartnerColumn(), this.getProductColumn());
    }

    public static String addRestrictions(String sql, boolean queryOnly, MGoalRestriction[] restrictions, MRole role, String tableName, String orgColumn, String bpColumn, String pColumn) {
        int i2;
        StringBuilder sb = new StringBuilder(sql);
        if (orgColumn != null) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            int i3 = 0;
            while (i3 < restrictions.length) {
                if ("O".equals(restrictions[i3].getGoalRestrictionType())) {
                    list.add(restrictions[i3].getOrg_ID());
                }
                ++i3;
            }
            if (list.size() == 1) {
                sb.append(" AND ").append(orgColumn).append("=").append(list.get(0));
            } else if (list.size() > 1) {
                sb.append(" AND ").append(orgColumn).append(" IN (");
                i3 = 0;
                while (i3 < list.size()) {
                    if (i3 > 0) {
                        sb.append(",");
                    }
                    sb.append(list.get(i3));
                    ++i3;
                }
                sb.append(")");
            }
        }
        if (bpColumn != null) {
            ArrayList<Integer> listBP = new ArrayList<Integer>();
            ArrayList<Integer> listBPG = new ArrayList<Integer>();
            i2 = 0;
            while (i2 < restrictions.length) {
                if ("B".equals(restrictions[i2].getGoalRestrictionType())) {
                    listBP.add(restrictions[i2].getC_BPartner_ID());
                }
                if ("G".equals(restrictions[i2].getGoalRestrictionType())) {
                    listBPG.add(restrictions[i2].getC_BP_Group_ID());
                }
                ++i2;
            }
            if (listBP.size() == 1) {
                sb.append(" AND ").append(bpColumn).append("=").append(listBP.get(0));
            } else if (listBP.size() > 1) {
                sb.append(" AND ").append(bpColumn).append(" IN (");
                i2 = 0;
                while (i2 < listBP.size()) {
                    if (i2 > 0) {
                        sb.append(",");
                    }
                    sb.append(listBP.get(i2));
                    ++i2;
                }
                sb.append(")");
            }
            if (bpColumn.indexOf(46) == -1) {
                bpColumn = String.valueOf(tableName) + "." + bpColumn;
            }
            if (listBPG.size() == 1) {
                sb.append(" AND EXISTS (SELECT * FROM C_BPartner bpx WHERE ").append(bpColumn).append("=bpx.C_BPartner_ID AND bpx.C_BP_GROUP_ID=").append(listBPG.get(0)).append(")");
            } else if (listBPG.size() > 1) {
                sb.append(" AND EXISTS (SELECT * FROM C_BPartner bpx WHERE ").append(bpColumn).append("=bpx.C_BPartner_ID AND bpx.C_BP_GROUP_ID IN (");
                i2 = 0;
                while (i2 < listBPG.size()) {
                    if (i2 > 0) {
                        sb.append(",");
                    }
                    sb.append(listBPG.get(i2));
                    ++i2;
                }
                sb.append("))");
            }
        }
        if (pColumn != null) {
            ArrayList<Integer> listP = new ArrayList<Integer>();
            ArrayList<Integer> listPC = new ArrayList<Integer>();
            i2 = 0;
            while (i2 < restrictions.length) {
                if ("P".equals(restrictions[i2].getGoalRestrictionType())) {
                    listP.add(restrictions[i2].getM_Product_ID());
                }
                if ("C".equals(restrictions[i2].getGoalRestrictionType())) {
                    listPC.add(restrictions[i2].getM_Product_Category_ID());
                }
                ++i2;
            }
            if (listP.size() == 1) {
                sb.append(" AND ").append(pColumn).append("=").append(listP.get(0));
            } else if (listP.size() > 1) {
                sb.append(" AND ").append(pColumn).append(" IN (");
                i2 = 0;
                while (i2 < listP.size()) {
                    if (i2 > 0) {
                        sb.append(",");
                    }
                    sb.append(listP.get(i2));
                    ++i2;
                }
                sb.append(")");
            }
            if (pColumn.indexOf(46) == -1) {
                pColumn = String.valueOf(tableName) + "." + pColumn;
            }
            if (listPC.size() == 1) {
                sb.append(" AND EXISTS (SELECT * FROM M_Product px WHERE ").append(pColumn).append("=px.M_Product_ID AND px.M_Product_Category_ID=").append(listPC.get(0)).append(")");
            } else if (listPC.size() > 1) {
                sb.append(" AND EXISTS (SELECT * FROM M_Product px WHERE ").append(pColumn).append("=px.M_Product_ID AND px.M_Product_Category_ID IN (");
                i2 = 0;
                while (i2 < listPC.size()) {
                    if (i2 > 0) {
                        sb.append(",");
                    }
                    sb.append(listPC.get(i2));
                    ++i2;
                }
                sb.append("))");
            }
        }
        String finalSQL = sb.toString();
        if (queryOnly) {
            return finalSQL;
        }
        if (role == null) {
            role = MRole.getDefault();
        }
        String retValue = role.addAccessSQL(finalSQL, tableName, true, false);
        return retValue;
    }

    public String getTableName() {
        return MTable.getTableName(Env.getCtx(), this.getAD_Table_ID());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MMeasureCalc[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }
}

