/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Savepoint;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPGroup;
import org.compiere.model.MConversionRate;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MSysConfig;
import org.compiere.model.PO;
import org.compiere.model.X_C_InvoiceLine;
import org.compiere.model.X_M_InOutLine;
import org.compiere.model.X_M_MatchPO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.util.ValueNamePair;

public class MMatchPO
extends X_M_MatchPO {
    private static final long serialVersionUID = 487498668807522050L;
    protected MMatchInv m_matchInv;
    private static CLogger s_log = CLogger.getCLogger(MMatchPO.class);
    protected boolean m_isInvoiceLineChange = false;
    protected boolean m_isInOutLineChange = false;
    protected MOrderLine m_oLine = null;
    protected MInvoiceLine m_iLine = null;

    public static MMatchPO[] get(Properties ctx, int C_OrderLine_ID, int C_InvoiceLine_ID, String trxName) {
        ArrayList<MMatchPO> list;
        block7: {
            if (C_OrderLine_ID == 0 || C_InvoiceLine_ID == 0) {
                return new MMatchPO[0];
            }
            String sql = "SELECT * FROM M_MatchPO WHERE C_OrderLine_ID=? AND C_InvoiceLine_ID=?";
            list = new ArrayList<MMatchPO>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, C_OrderLine_ID);
                    pstmt.setInt(2, C_InvoiceLine_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MMatchPO(ctx, rs, trxName));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MMatchPO[] retValue = new MMatchPO[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MMatchPO[] get(Properties ctx, int M_InOutLine_ID, String trxName) {
        if (M_InOutLine_ID == 0) {
            return new MMatchPO[0];
        }
        String sql = "SELECT * FROM M_MatchPO WHERE M_InOutLine_ID=?";
        ArrayList<MMatchPO> list = new ArrayList<MMatchPO>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, trxName);
                pstmt.setInt(1, M_InOutLine_ID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.add(new MMatchPO(ctx, rs, trxName));
                }
            }
            catch (Exception e) {
                s_log.log(Level.SEVERE, sql, e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new IllegalStateException(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        MMatchPO[] retValue = new MMatchPO[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MMatchPO[] getInOut(Properties ctx, int M_InOut_ID, String trxName) {
        ArrayList<MMatchPO> list;
        block7: {
            if (M_InOut_ID == 0) {
                return new MMatchPO[0];
            }
            String sql = "SELECT * FROM M_MatchPO m INNER JOIN M_InOutLine l ON (m.M_InOutLine_ID=l.M_InOutLine_ID) WHERE l.M_InOut_ID=?";
            list = new ArrayList<MMatchPO>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, M_InOut_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MMatchPO(ctx, rs, trxName));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MMatchPO[] retValue = new MMatchPO[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MMatchPO[] getInvoice(Properties ctx, int C_Invoice_ID, String trxName) {
        ArrayList<MMatchPO> list;
        block7: {
            if (C_Invoice_ID == 0) {
                return new MMatchPO[0];
            }
            String sql = "SELECT * FROM M_MatchPO mi INNER JOIN C_InvoiceLine il ON (mi.C_InvoiceLine_ID=il.C_InvoiceLine_ID) WHERE il.C_Invoice_ID=?";
            list = new ArrayList<MMatchPO>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, C_Invoice_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MMatchPO(ctx, rs, trxName));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MMatchPO[] retValue = new MMatchPO[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MMatchPO[] getOrderLine(Properties ctx, int C_OrderLine_ID, String trxName) {
        ArrayList<MMatchPO> list;
        block7: {
            if (C_OrderLine_ID == 0) {
                return new MMatchPO[0];
            }
            String sql = "SELECT * FROM M_MatchPO WHERE C_OrderLine_ID=?";
            list = new ArrayList<MMatchPO>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, C_OrderLine_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MMatchPO(ctx, rs, trxName));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MMatchPO[] retValue = new MMatchPO[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MMatchPO create(MInvoiceLine iLine, MInOutLine sLine, Timestamp dateTrx, BigDecimal qty) {
        String trxName = null;
        Properties ctx = null;
        int C_OrderLine_ID = 0;
        if (iLine != null) {
            trxName = iLine.get_TrxName();
            ctx = iLine.getCtx();
            C_OrderLine_ID = iLine.getC_OrderLine_ID();
        }
        if (sLine != null) {
            trxName = sLine.get_TrxName();
            ctx = sLine.getCtx();
            C_OrderLine_ID = sLine.getC_OrderLine_ID();
        }
        if (C_OrderLine_ID > 0) {
            return MMatchPO.create(ctx, iLine, sLine, C_OrderLine_ID, dateTrx, qty, trxName);
        }
        if (sLine != null && iLine != null) {
            MMatchPO[] matchpos;
            MMatchPO[] mMatchPOArray = matchpos = MMatchPO.get(ctx, sLine.getM_InOutLine_ID(), trxName);
            int n = matchpos.length;
            int n2 = 0;
            while (n2 < n) {
                MMatchPO matchpo = mMatchPOArray[n2];
                C_OrderLine_ID = matchpo.getC_OrderLine_ID();
                MOrderLine orderLine = new MOrderLine(ctx, C_OrderLine_ID, trxName);
                BigDecimal toInvoice = orderLine.getQtyOrdered().subtract(orderLine.getQtyInvoiced());
                if (toInvoice.signum() > 0) {
                    BigDecimal matchQty = qty;
                    if (matchQty.compareTo(toInvoice) > 0) {
                        matchQty = toInvoice;
                    }
                    if (matchQty.signum() > 0) {
                        MMatchPO newMatchPO = MMatchPO.create(ctx, iLine, sLine, C_OrderLine_ID, dateTrx, matchQty, trxName);
                        if (!newMatchPO.save()) {
                            String msg = "Failed to update match po.";
                            ValueNamePair error = CLogger.retrieveError();
                            if (error != null) {
                                msg = String.valueOf(msg) + " " + error.getName();
                            }
                            throw new RuntimeException(msg);
                        }
                        if ((qty = qty.subtract(matchQty)).signum() <= 0) {
                            return newMatchPO;
                        }
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    protected static MMatchPO create(Properties ctx, MInvoiceLine iLine, MInOutLine sLine, int C_OrderLine_ID, Timestamp dateTrx, BigDecimal qty, String trxName) {
        int tmpInOutLineId;
        MMatchPO retValue = null;
        String sql = "SELECT * FROM M_MatchPO WHERE C_OrderLine_ID=? and Reversal_ID IS NULL ORDER BY M_MatchPO_ID";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, trxName);
                pstmt.setInt(1, C_OrderLine_ID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    MMatchPO mpo = new MMatchPO(ctx, rs, trxName);
                    if (qty.compareTo(mpo.getQty()) < 0) continue;
                    BigDecimal toMatch = qty;
                    BigDecimal matchQty = mpo.getQty();
                    if (toMatch.compareTo(matchQty) > 0) {
                        toMatch = matchQty;
                    }
                    if (iLine != null) {
                        if (mpo.getC_InvoiceLine_ID() != 0 && mpo.getC_InvoiceLine_ID() != iLine.getC_InvoiceLine_ID()) continue;
                        if (iLine.getM_AttributeSetInstance_ID() != 0) {
                            if (mpo.getM_AttributeSetInstance_ID() == 0) {
                                mpo.setM_AttributeSetInstance_ID(iLine.getM_AttributeSetInstance_ID());
                            } else if (mpo.getM_AttributeSetInstance_ID() != iLine.getM_AttributeSetInstance_ID()) continue;
                        }
                    }
                    if (sLine != null) {
                        if (mpo.getM_InOutLine_ID() != 0 && mpo.getM_InOutLine_ID() != sLine.getM_InOutLine_ID()) continue;
                        if (sLine.getM_AttributeSetInstance_ID() != 0) {
                            if (mpo.getM_AttributeSetInstance_ID() == 0) {
                                mpo.setM_AttributeSetInstance_ID(sLine.getM_AttributeSetInstance_ID());
                            } else if (mpo.getM_AttributeSetInstance_ID() != sLine.getM_AttributeSetInstance_ID()) continue;
                        }
                    }
                    if (!(iLine == null && mpo.getC_InvoiceLine_ID() <= 0 || sLine == null && mpo.getM_InOutLine_ID() <= 0)) {
                        int M_InOutLine_ID = sLine != null ? sLine.getM_InOutLine_ID() : mpo.getM_InOutLine_ID();
                        int C_InvoiceLine_ID = iLine != null ? iLine.getC_InvoiceLine_ID() : mpo.getC_InvoiceLine_ID();
                        tmpInOutLineId = DB.getSQLValue(mpo.get_TrxName(), "SELECT M_InOutLine_ID FROM C_InvoiceLine WHERE C_InvoiceLine_ID=" + C_InvoiceLine_ID);
                        if (tmpInOutLineId > 0 && tmpInOutLineId != M_InOutLine_ID) continue;
                        int cnt = DB.getSQLValue(mpo.get_TrxName(), "SELECT Count(*) FROM M_MatchInv WHERE M_InOutLine_ID=" + M_InOutLine_ID + " AND C_InvoiceLine_ID=" + C_InvoiceLine_ID);
                        if (cnt <= 0) {
                            Trx trx = trxName != null ? Trx.get(trxName, false) : null;
                            Savepoint savepoint = trx != null ? trx.getConnection().setSavepoint() : null;
                            MMatchInv matchInv = new MMatchInv(mpo.getCtx(), 0, mpo.get_TrxName());
                            matchInv.setC_InvoiceLine_ID(C_InvoiceLine_ID);
                            matchInv.setM_Product_ID(mpo.getM_Product_ID());
                            matchInv.setM_InOutLine_ID(M_InOutLine_ID);
                            matchInv.setAD_Client_ID(mpo.getAD_Client_ID());
                            matchInv.setAD_Org_ID(mpo.getAD_Org_ID());
                            matchInv.setM_AttributeSetInstance_ID(mpo.getM_AttributeSetInstance_ID());
                            matchInv.setQty(mpo.getQty());
                            matchInv.setDateTrx(dateTrx);
                            matchInv.setProcessed(true);
                            if (!matchInv.save()) {
                                if (savepoint != null) {
                                    trx.getConnection().rollback(savepoint);
                                    savepoint = null;
                                } else {
                                    matchInv.delete(true);
                                }
                                String msg = "Failed to auto match invoice.";
                                ValueNamePair error = CLogger.retrieveError();
                                if (error != null) {
                                    msg = String.valueOf(msg) + " " + error.getName();
                                }
                                s_log.fine(msg);
                                continue;
                            }
                            mpo.setMatchInvCreated(matchInv);
                            if (savepoint != null) {
                                try {
                                    trx.getConnection().releaseSavepoint(savepoint);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    if (iLine != null) {
                        mpo.setC_InvoiceLine_ID(iLine);
                    }
                    if (sLine != null) {
                        mpo.setM_InOutLine_ID(sLine.getM_InOutLine_ID());
                        if (!mpo.isPosted()) {
                            mpo.setDateAcct(sLine.getParent().getDateAcct());
                        }
                    }
                    if (!mpo.save()) {
                        String msg = "Failed to update match po.";
                        ValueNamePair error = CLogger.retrieveError();
                        if (error != null) {
                            msg = String.valueOf(msg) + " " + error.getName();
                        }
                        throw new RuntimeException(msg);
                    }
                    if ((qty = qty.subtract(toMatch)).signum() > 0) continue;
                    retValue = mpo;
                    break;
                }
            }
            catch (Exception e) {
                s_log.log(Level.SEVERE, sql, e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new IllegalStateException(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        if (retValue == null) {
            BigDecimal sLineMatchedQty = null;
            if (sLine != null && iLine != null) {
                sLineMatchedQty = DB.getSQLValueBD(sLine.get_TrxName(), "SELECT Sum(Qty) FROM M_MatchPO WHERE C_OrderLine_ID=" + C_OrderLine_ID + " AND M_InOutLine_ID=?", sLine.getM_InOutLine_ID());
            }
            if (!(sLine == null || sLine.getC_OrderLine_ID() != C_OrderLine_ID && iLine != null || sLineMatchedQty != null && sLineMatchedQty.signum() > 0)) {
                if (qty.signum() > 0) {
                    retValue = new MMatchPO(sLine, dateTrx, qty);
                    retValue.setC_OrderLine_ID(C_OrderLine_ID);
                    X_M_MatchPO otherMatchPO = null;
                    if (iLine == null) {
                        MMatchPO[] matchPOs;
                        MMatchPO[] cnt = matchPOs = MMatchPO.getOrderLine(retValue.getCtx(), sLine.getC_OrderLine_ID(), retValue.get_TrxName());
                        tmpInOutLineId = matchPOs.length;
                        int error = 0;
                        while (error < tmpInOutLineId) {
                            int cnt2;
                            MMatchPO matchPO = cnt[error];
                            if (matchPO.getC_InvoiceLine_ID() > 0 && matchPO.getM_InOutLine_ID() == 0 && (cnt2 = DB.getSQLValueEx(sLine.get_TrxName(), "SELECT Count(*) FROM M_MatchInv WHERE M_InOutLine_ID=" + sLine.getM_InOutLine_ID() + " AND C_InvoiceLine_ID=" + matchPO.getC_InvoiceLine_ID(), new Object[0])) <= 0 && !matchPO.isPosted() && matchPO.getQty().compareTo(retValue.getQty()) >= 0) {
                                otherMatchPO = matchPO;
                                iLine = new MInvoiceLine(retValue.getCtx(), matchPO.getC_InvoiceLine_ID(), retValue.get_TrxName());
                                matchPO.setQty(matchPO.getQty().subtract(retValue.getQty()));
                                matchPO.saveEx();
                                break;
                            }
                            ++error;
                        }
                    }
                    if (iLine != null) {
                        if (otherMatchPO == null) {
                            retValue.setC_InvoiceLine_ID(iLine);
                        }
                        if (otherMatchPO != null) {
                            block65: {
                                Savepoint savepoint = null;
                                Trx trx = null;
                                try {
                                    try {
                                        trx = trxName != null ? Trx.get(trxName, false) : null;
                                        savepoint = trx != null ? trx.getConnection().setSavepoint() : null;
                                        MMatchInv matchInv = new MMatchInv(retValue.getCtx(), 0, retValue.get_TrxName());
                                        matchInv.setC_InvoiceLine_ID(otherMatchPO.getC_InvoiceLine_ID());
                                        matchInv.setM_Product_ID(retValue.getM_Product_ID());
                                        matchInv.setM_InOutLine_ID(retValue.getM_InOutLine_ID());
                                        matchInv.setAD_Client_ID(retValue.getAD_Client_ID());
                                        matchInv.setAD_Org_ID(retValue.getAD_Org_ID());
                                        matchInv.setM_AttributeSetInstance_ID(retValue.getM_AttributeSetInstance_ID());
                                        matchInv.setQty(retValue.getQty());
                                        matchInv.setDateTrx(dateTrx);
                                        matchInv.setProcessed(true);
                                        if (!matchInv.save()) {
                                            if (savepoint != null) {
                                                trx.getConnection().rollback(savepoint);
                                                savepoint = null;
                                            } else {
                                                matchInv.delete(true);
                                            }
                                            String msg = "Failed to auto match invoice.";
                                            ValueNamePair error = CLogger.retrieveError();
                                            if (error != null) {
                                                msg = String.valueOf(msg) + " " + error.getName();
                                            }
                                            s_log.severe(msg);
                                        }
                                        retValue.setMatchInvCreated(matchInv);
                                    }
                                    catch (Exception e) {
                                        s_log.log(Level.SEVERE, "Failed to auto match Invoice.", e);
                                        if (savepoint != null) {
                                            try {
                                                trx.getConnection().releaseSavepoint(savepoint);
                                            }
                                            catch (Exception exception) {}
                                        }
                                        break block65;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (savepoint != null) {
                                        try {
                                            trx.getConnection().releaseSavepoint(savepoint);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                    throw throwable;
                                }
                                if (savepoint != null) {
                                    try {
                                        trx.getConnection().releaseSavepoint(savepoint);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (otherMatchPO.getQty().signum() == 0) {
                                otherMatchPO.deleteEx(true);
                            }
                        }
                    }
                    if (!retValue.save()) {
                        String msg = "Failed to update match po.";
                        ValueNamePair error = CLogger.retrieveError();
                        if (error != null) {
                            msg = String.valueOf(msg) + " " + error.getName();
                        }
                        throw new RuntimeException(msg);
                    }
                }
            } else if (iLine != null && qty.signum() > 0) {
                retValue = new MMatchPO(iLine, dateTrx, qty);
                retValue.setC_OrderLine_ID(C_OrderLine_ID);
                if (!retValue.save()) {
                    String msg = "Failed to update match po.";
                    ValueNamePair error = CLogger.retrieveError();
                    if (error != null) {
                        msg = String.valueOf(msg) + " " + error.getName();
                    }
                    throw new RuntimeException(msg);
                }
            }
        }
        return retValue;
    }

    protected void setMatchInvCreated(MMatchInv matchInv) {
        this.m_matchInv = matchInv;
    }

    public MMatchInv getMatchInvCreated() {
        MMatchInv tmp = this.m_matchInv;
        this.m_matchInv = null;
        return tmp;
    }

    public MMatchPO(Properties ctx, int M_MatchPO_ID, String trxName) {
        super(ctx, M_MatchPO_ID, trxName);
        if (M_MatchPO_ID == 0) {
            this.setM_AttributeSetInstance_ID(0);
            this.setPosted(false);
            this.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public MMatchPO(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MMatchPO(MInOutLine sLine, Timestamp dateTrx, BigDecimal qty) {
        this(sLine.getCtx(), 0, sLine.get_TrxName());
        this.setClientOrg(sLine);
        this.setM_InOutLine_ID(sLine.getM_InOutLine_ID());
        this.setC_OrderLine_ID(sLine.getC_OrderLine_ID());
        if (dateTrx != null) {
            this.setDateTrx(dateTrx);
        }
        this.setM_Product_ID(sLine.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(sLine.getM_AttributeSetInstance_ID());
        this.setQty(qty);
        this.setProcessed(true);
    }

    public MMatchPO(MInvoiceLine iLine, Timestamp dateTrx, BigDecimal qty) {
        this(iLine.getCtx(), 0, iLine.get_TrxName());
        this.setClientOrg(iLine);
        this.setC_InvoiceLine_ID(iLine);
        if (iLine.getC_OrderLine_ID() != 0) {
            this.setC_OrderLine_ID(iLine.getC_OrderLine_ID());
        }
        if (dateTrx != null) {
            this.setDateTrx(dateTrx);
        }
        this.setM_Product_ID(iLine.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(iLine.getM_AttributeSetInstance_ID());
        this.setQty(qty);
        this.setProcessed(true);
    }

    public void setC_InvoiceLine_ID(MInvoiceLine line) {
        this.m_iLine = line;
        if (line == null) {
            this.setC_InvoiceLine_ID(0);
        } else {
            this.setC_InvoiceLine_ID(line.getC_InvoiceLine_ID());
        }
    }

    @Override
    public void setC_InvoiceLine_ID(int C_InvoiceLine_ID) {
        int old = this.getC_InvoiceLine_ID();
        if (old != C_InvoiceLine_ID) {
            super.setC_InvoiceLine_ID(C_InvoiceLine_ID);
            this.m_isInvoiceLineChange = true;
        }
    }

    public MInvoiceLine getInvoiceLine() {
        if (this.m_iLine == null && this.getC_InvoiceLine_ID() != 0) {
            this.m_iLine = new MInvoiceLine(this.getCtx(), this.getC_InvoiceLine_ID(), this.get_TrxName());
        }
        return this.m_iLine;
    }

    @Override
    public void setM_InOutLine_ID(int M_InOutLine_ID) {
        int old = this.getM_InOutLine_ID();
        if (old != M_InOutLine_ID) {
            super.setM_InOutLine_ID(M_InOutLine_ID);
            this.m_isInOutLineChange = true;
        }
    }

    public void setC_OrderLine_ID(MOrderLine line) {
        this.m_oLine = line;
        if (line == null) {
            this.setC_OrderLine_ID(0);
        } else {
            this.setC_OrderLine_ID(line.getC_OrderLine_ID());
        }
    }

    public MOrderLine getOrderLine() {
        if (this.m_oLine == null && this.getC_OrderLine_ID() != 0 || this.getC_OrderLine_ID() != this.m_oLine.getC_OrderLine_ID()) {
            this.m_oLine = new MOrderLine(this.getCtx(), this.getC_OrderLine_ID(), this.get_TrxName());
        }
        return this.m_oLine;
    }

    public BigDecimal getInvoicePriceActual() {
        int orderCurrency_ID;
        MInvoiceLine iLine = this.getInvoiceLine();
        MInvoice invoice = iLine.getParent();
        MOrder order = this.getOrderLine().getParent();
        BigDecimal priceActual = iLine.getPriceActual();
        int invoiceCurrency_ID = invoice.getC_Currency_ID();
        if (invoiceCurrency_ID != (orderCurrency_ID = order.getC_Currency_ID())) {
            priceActual = MConversionRate.convert(this.getCtx(), priceActual, invoiceCurrency_ID, orderCurrency_ID, invoice.getDateInvoiced(), invoice.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
        }
        return priceActual;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getDateTrx() == null) {
            this.setDateTrx(new Timestamp(System.currentTimeMillis()));
        }
        if (this.getDateAcct() == null) {
            Timestamp ts = this.getNewerDateAcct();
            if (ts == null) {
                ts = this.getDateTrx();
            }
            this.setDateAcct(ts);
        }
        if (this.getM_AttributeSetInstance_ID() == 0 && this.getM_InOutLine_ID() != 0) {
            MInOutLine iol = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
            this.setM_AttributeSetInstance_ID(iol.getM_AttributeSetInstance_ID());
        }
        if (newRecord && this.getC_InvoiceLine_ID() == 0 && this.getReversal_ID() == 0) {
            MMatchInv[] mpi = MMatchInv.getInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
            int i2 = 0;
            while (i2 < mpi.length) {
                int cnt;
                if (mpi[i2].getC_InvoiceLine_ID() != 0 && mpi[i2].getM_AttributeSetInstance_ID() == this.getM_AttributeSetInstance_ID() && (cnt = DB.getSQLValue(this.get_TrxName(), "SELECT Count(*) FROM M_MatchPO WHERE M_InOutLine_ID=" + this.getM_InOutLine_ID() + " AND C_InvoiceLine_ID=" + mpi[i2].getC_InvoiceLine_ID())) <= 0) {
                    if (mpi[i2].getQty().compareTo(this.getQty()) == 0) {
                        this.setC_InvoiceLine_ID(mpi[i2].getC_InvoiceLine_ID());
                        break;
                    }
                    MInvoiceLine il = new MInvoiceLine(this.getCtx(), mpi[i2].getC_InvoiceLine_ID(), this.get_TrxName());
                    MMatchPO match = new MMatchPO(il, this.getDateTrx(), mpi[i2].getQty());
                    match.setC_OrderLine_ID(this.getC_OrderLine_ID());
                    if (!match.save()) {
                        String msg = "Failed to create match po";
                        ValueNamePair error = CLogger.retrieveError();
                        if (error != null) {
                            msg = String.valueOf(msg) + " " + error.getName();
                        }
                        throw new RuntimeException(msg);
                    }
                }
                ++i2;
            }
        }
        if (this.getC_OrderLine_ID() == 0) {
            MInOutLine iol;
            MInvoiceLine il = null;
            if (this.getC_InvoiceLine_ID() != 0 && (il = this.getInvoiceLine()).getC_OrderLine_ID() != 0) {
                this.setC_OrderLine_ID(il.getC_OrderLine_ID());
            }
            if (this.getC_OrderLine_ID() == 0 && this.getM_InOutLine_ID() != 0 && (iol = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName())).getC_OrderLine_ID() != 0) {
                this.setC_OrderLine_ID(iol.getC_OrderLine_ID());
                if (il != null) {
                    il.setC_OrderLine_ID(iol.getC_OrderLine_ID());
                    il.saveEx();
                }
            }
        }
        if (this.getC_OrderLine_ID() != 0 && this.getC_InvoiceLine_ID() != 0 && (newRecord || this.is_ValueChanged("C_OrderLine_ID") || this.is_ValueChanged("C_InvoiceLine_ID"))) {
            int cnt;
            BigDecimal invPrice;
            BigDecimal poPrice = this.getOrderLine().getPriceActual();
            BigDecimal difference = poPrice.subtract(invPrice = this.getInvoicePriceActual());
            if (difference.signum() != 0) {
                difference = difference.multiply(this.getQty());
                this.setPriceMatchDifference(difference);
                MBPGroup group = MBPGroup.getOfBPartner(this.getCtx(), this.getOrderLine().getC_BPartner_ID());
                BigDecimal mt = group.getPriceMatchTolerance();
                if (mt != null && mt.signum() != 0) {
                    boolean ok;
                    BigDecimal poAmt = poPrice.multiply(this.getQty());
                    BigDecimal maxTolerance = poAmt.multiply(mt);
                    maxTolerance = maxTolerance.abs().divide(Env.ONEHUNDRED, 2, RoundingMode.HALF_UP);
                    boolean bl = ok = (difference = difference.abs()).compareTo(maxTolerance) <= 0;
                    if (this.log.isLoggable(Level.CONFIG)) {
                        this.log.config("Difference=" + this.getPriceMatchDifference() + ", Max=" + maxTolerance + " => " + ok);
                    }
                    this.setIsApproved(ok);
                }
            } else {
                this.setPriceMatchDifference(difference);
                this.setIsApproved(true);
            }
            if (this.getM_InOutLine_ID() > 0 && this.getC_InvoiceLine_ID() > 0 && (cnt = DB.getSQLValue(this.get_TrxName(), "SELECT Count(*) FROM M_MatchInv WHERE M_InOutLine_ID=" + this.getM_InOutLine_ID() + " AND C_InvoiceLine_ID=" + this.getC_InvoiceLine_ID())) <= 0) {
                MInvoiceLine invoiceLine = new MInvoiceLine(this.getCtx(), this.getC_InvoiceLine_ID(), this.get_TrxName());
                MInOutLine inoutLine = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
                throw new IllegalStateException("[MatchPO] Missing corresponding invoice matching record for invoice line " + invoiceLine + " and receipt line " + inoutLine);
            }
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (success) {
            boolean validateOrderedQty;
            BigDecimal matchedQty;
            PO line;
            if (this.getM_InOutLine_ID() > 0) {
                line = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
                matchedQty = DB.getSQLValueBD(this.get_TrxName(), "SELECT Coalesce(SUM(Qty),0) FROM M_MatchPO WHERE M_InOutLine_ID=?", this.getM_InOutLine_ID());
                if (((X_M_InOutLine)line).getMovementQty().signum() > 0 && matchedQty != null && matchedQty.compareTo(((X_M_InOutLine)line).getMovementQty()) > 0) {
                    throw new IllegalStateException("Total matched qty > movement qty. MatchedQty=" + matchedQty + ", MovementQty=" + ((X_M_InOutLine)line).getMovementQty() + ", Line=" + line);
                }
            }
            if (this.getC_InvoiceLine_ID() > 0) {
                line = new MInvoiceLine(this.getCtx(), this.getC_InvoiceLine_ID(), this.get_TrxName());
                matchedQty = DB.getSQLValueBD(this.get_TrxName(), "SELECT Coalesce(SUM(Qty),0) FROM M_MatchPO WHERE C_InvoiceLine_ID=?  AND Reversal_ID IS NULL ", this.getC_InvoiceLine_ID());
                if (matchedQty != null && matchedQty.compareTo(((X_C_InvoiceLine)line).getQtyInvoiced()) > 0) {
                    throw new IllegalStateException("Total matched qty > invoiced qty. MatchedQty=" + matchedQty + ", InvoicedQty=" + ((X_C_InvoiceLine)line).getQtyInvoiced() + ", Line=" + line);
                }
            }
            if (this.getC_OrderLine_ID() > 0 && (validateOrderedQty = MSysConfig.getBooleanValue("VALIDATE_MATCHING_TO_ORDERED_QTY", true, Env.getAD_Client_ID(Env.getCtx())))) {
                MOrderLine line2 = new MOrderLine(this.getCtx(), this.getC_OrderLine_ID(), this.get_TrxName());
                BigDecimal invoicedQty = DB.getSQLValueBD(this.get_TrxName(), "SELECT Coalesce(SUM(Qty),0) FROM M_MatchPO WHERE C_InvoiceLine_ID > 0 and C_OrderLine_ID=? AND Reversal_ID IS NULL", this.getC_OrderLine_ID());
                if (invoicedQty != null && invoicedQty.compareTo(line2.getQtyOrdered()) > 0) {
                    throw new IllegalStateException("Total matched invoiced qty > ordered qty. MatchedInvoicedQty=" + invoicedQty + ", OrderedQty=" + line2.getQtyOrdered() + ", Line=" + line2);
                }
                BigDecimal deliveredQty = DB.getSQLValueBD(this.get_TrxName(), "SELECT Coalesce(SUM(Qty),0) FROM M_MatchPO WHERE M_InOutLine_ID > 0 and C_OrderLine_ID=? AND Reversal_ID IS NULL", this.getC_OrderLine_ID());
                if (deliveredQty != null && deliveredQty.compareTo(line2.getQtyOrdered()) > 0) {
                    throw new IllegalStateException("Total matched delivered qty > ordered qty. MatchedDeliveredQty=" + deliveredQty + ", OrderedQty=" + line2.getQtyOrdered() + ", Line=" + line2);
                }
            }
        }
        if (success && this.getC_OrderLine_ID() != 0) {
            MInOutLine iol;
            BigDecimal oldQty;
            MOrderLine orderLine = this.getOrderLine();
            if (this.m_isInOutLineChange && (newRecord || this.getM_InOutLine_ID() != this.get_ValueOldAsInt("M_InOutLine_ID"))) {
                if (this.getM_InOutLine_ID() != 0) {
                    orderLine.setQtyDelivered(orderLine.getQtyDelivered().add(this.getQty()));
                } else if (!newRecord) {
                    orderLine.setQtyDelivered(orderLine.getQtyDelivered().subtract(this.getQty()));
                }
                orderLine.setDateDelivered(this.getDateTrx());
            } else if (!newRecord && this.getM_InOutLine_ID() > 0 && this.is_ValueChanged("Qty")) {
                oldQty = (BigDecimal)this.get_ValueOld("Qty");
                orderLine.setQtyDelivered(orderLine.getQtyDelivered().subtract(oldQty.subtract(this.getQty())));
            }
            if (this.m_isInvoiceLineChange && (newRecord || this.getC_InvoiceLine_ID() != this.get_ValueOldAsInt("C_InvoiceLine_ID"))) {
                if (this.getC_InvoiceLine_ID() != 0) {
                    orderLine.setQtyInvoiced(orderLine.getQtyInvoiced().add(this.getQty()));
                } else if (!newRecord) {
                    orderLine.setQtyInvoiced(orderLine.getQtyInvoiced().subtract(this.getQty()));
                }
                orderLine.setDateInvoiced(this.getDateTrx());
            } else if (!newRecord && this.getC_InvoiceLine_ID() > 0 && this.is_ValueChanged("Qty")) {
                oldQty = (BigDecimal)this.get_ValueOld("Qty");
                orderLine.setQtyInvoiced(orderLine.getQtyInvoiced().subtract(oldQty.subtract(this.getQty())));
            }
            if (orderLine.getM_AttributeSetInstance_ID() == 0 && this.getM_InOutLine_ID() != 0 && (iol = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName())).getMovementQty().compareTo(orderLine.getQtyOrdered()) == 0) {
                orderLine.setM_AttributeSetInstance_ID(iol.getM_AttributeSetInstance_ID());
            }
            return orderLine.save();
        }
        return success;
    }

    public Timestamp getNewerDateAcct() {
        String sql;
        Timestamp invoiceDate = null;
        Timestamp shipDate = null;
        if (this.getC_InvoiceLine_ID() != 0) {
            sql = "SELECT i.DateAcct FROM C_InvoiceLine il INNER JOIN C_Invoice i ON (i.C_Invoice_ID=il.C_Invoice_ID) WHERE C_InvoiceLine_ID=?";
            invoiceDate = DB.getSQLValueTS(null, sql, this.getC_InvoiceLine_ID());
        }
        if (this.getM_InOutLine_ID() != 0) {
            sql = "SELECT io.DateAcct FROM M_InOutLine iol INNER JOIN M_InOut io ON (io.M_InOut_ID=iol.M_InOut_ID) WHERE iol.M_InOutLine_ID=?";
            shipDate = DB.getSQLValueTS(null, sql, this.getM_InOutLine_ID());
        }
        if (invoiceDate == null) {
            return shipDate;
        }
        if (shipDate == null) {
            return invoiceDate;
        }
        if (invoiceDate.after(shipDate)) {
            return invoiceDate;
        }
        return shipDate;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.isPosted()) {
            MPeriod.testPeriodOpen(this.getCtx(), this.getDateTrx(), "MXP", this.getAD_Org_ID());
            this.setPosted(false);
            MFactAcct.deleteEx(473, this.get_ID(), this.get_TrxName());
        }
        return true;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success && this.getC_OrderLine_ID() != 0) {
            MOrderLine orderLine = new MOrderLine(this.getCtx(), this.getC_OrderLine_ID(), this.get_TrxName());
            if (this.getM_InOutLine_ID() != 0) {
                orderLine.setQtyDelivered(orderLine.getQtyDelivered().subtract(this.getQty()));
            }
            if (this.getC_InvoiceLine_ID() != 0) {
                orderLine.setQtyInvoiced(orderLine.getQtyInvoiced().subtract(this.getQty()));
            }
            return orderLine.save(this.get_TrxName());
        }
        return success;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MMatchPO[");
        sb.append(this.get_ID()).append(",Qty=").append(this.getQty()).append(",C_OrderLine_ID=").append(this.getC_OrderLine_ID()).append(",M_InOutLine_ID=").append(this.getM_InOutLine_ID()).append(",C_InvoiceLine_ID=").append(this.getC_InvoiceLine_ID()).append("]");
        return sb.toString();
    }

    public static void consolidate(Properties ctx) {
        int errors;
        int success;
        block9: {
            String sql = "SELECT * FROM M_MatchPO po WHERE EXISTS (SELECT 1 FROM M_MatchPO x WHERE po.C_OrderLine_ID=x.C_OrderLine_ID AND po.Qty=x.Qty GROUP BY C_OrderLine_ID, Qty HAVING COUNT(*) = 2)  AND AD_Client_ID=?ORDER BY C_OrderLine_ID, M_InOutLine_ID";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            success = 0;
            errors = 0;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, Env.getAD_Client_ID(ctx));
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MMatchPO po1 = new MMatchPO(ctx, rs, null);
                        if (!rs.next()) continue;
                        MMatchPO po2 = new MMatchPO(ctx, rs, null);
                        if (po1.getM_InOutLine_ID() == 0 || po1.getC_InvoiceLine_ID() != 0 || po2.getM_InOutLine_ID() != 0 || po2.getC_InvoiceLine_ID() == 0) continue;
                        StringBuilder s1 = new StringBuilder("UPDATE M_MatchPO SET C_InvoiceLine_ID=").append(po2.getC_InvoiceLine_ID()).append(" WHERE M_MatchPO_ID=").append(po1.getM_MatchPO_ID());
                        int no1 = DB.executeUpdate(s1.toString(), null);
                        if (no1 != 1) {
                            ++errors;
                            s_log.warning("Not updated M_MatchPO_ID=" + po1.getM_MatchPO_ID());
                            continue;
                        }
                        String s2 = "DELETE FROM Fact_Acct WHERE AD_Table_ID=473 AND Record_ID=?";
                        int no2 = DB.executeUpdate(s2, po2.getM_MatchPO_ID(), null);
                        String s3 = "DELETE FROM M_MatchPO WHERE M_MatchPO_ID=?";
                        int no3 = DB.executeUpdate(s3, po2.getM_MatchPO_ID(), null);
                        if (no2 == 0 && no3 == 1) {
                            ++success;
                            continue;
                        }
                        s_log.warning("M_MatchPO_ID=" + po2.getM_MatchPO_ID() + " - Deleted=" + no2 + ", Acct=" + no3);
                        ++errors;
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if ((errors != 0 || success != 0) && s_log.isLoggable(Level.INFO)) {
            s_log.info("Success #" + success + " - Error #" + errors);
        }
    }

    public boolean reverse(Timestamp reversalDate) {
        if (this.isProcessed() && this.getReversal_ID() == 0) {
            MMatchPO reversal = new MMatchPO(this.getCtx(), 0, this.get_TrxName());
            reversal.setC_InvoiceLine_ID(this.getC_InvoiceLine_ID());
            reversal.setM_InOutLine_ID(this.getM_InOutLine_ID());
            if (this.getC_OrderLine_ID() != 0) {
                reversal.setC_OrderLine_ID(this.getC_OrderLine_ID());
            } else {
                reversal.setC_OrderLine_ID(this.getM_InOutLine().getC_OrderLine_ID());
            }
            reversal.setM_Product_ID(this.getM_Product_ID());
            reversal.setM_AttributeSetInstance_ID(this.getM_AttributeSetInstance_ID());
            reversal.setAD_Org_ID(this.getAD_Org_ID());
            reversal.setDescription("(->" + this.getDocumentNo() + ")");
            reversal.setQty(this.getQty().negate());
            reversal.setDateAcct(reversalDate);
            reversal.setDateTrx(reversalDate);
            reversal.set_ValueNoCheck("DocumentNo", null);
            reversal.setPosted(false);
            reversal.setProcessed(true);
            reversal.setReversal_ID(this.getM_MatchPO_ID());
            reversal.saveEx();
            this.setDescription("(" + reversal.getDocumentNo() + "<-)");
            this.setReversal_ID(reversal.getM_MatchPO_ID());
            this.saveEx();
            if (reversal.getC_InvoiceLine_ID() > 0 && reversal.getM_InOutLine_ID() > 0) {
                MMatchPO matchPO;
                MMatchPO[] matchPOs = MMatchPO.getOrderLine(reversal.getCtx(), reversal.getC_OrderLine_ID(), reversal.get_TrxName());
                BigDecimal matchQty = this.getQty();
                MMatchPO[] mMatchPOArray = matchPOs;
                int n = matchPOs.length;
                int n2 = 0;
                while (n2 < n) {
                    matchPO = mMatchPOArray[n2];
                    if (matchPO.getReversal_ID() == 0 && !matchPO.isPosted() && matchPO.getC_InvoiceLine_ID() == reversal.getC_InvoiceLine_ID() && matchPO.getM_InOutLine_ID() == 0) {
                        matchPO.setQty(matchPO.getQty().add(matchQty));
                        matchPO.saveEx();
                        matchQty = BigDecimal.ZERO;
                        break;
                    }
                    ++n2;
                }
                if (matchQty.signum() != 0) {
                    matchPO = new MMatchPO(this.getCtx(), 0, this.get_TrxName());
                    matchPO.setC_OrderLine_ID(this.getC_OrderLine_ID());
                    matchPO.setC_InvoiceLine_ID(this.getC_InvoiceLine_ID());
                    matchPO.setM_InOutLine_ID(0);
                    matchPO.setAD_Org_ID(this.getAD_Org_ID());
                    matchPO.setQty(this.getQty());
                    matchPO.setDateAcct(this.getDateAcct());
                    matchPO.setDateTrx(this.getDateTrx());
                    matchPO.setM_AttributeSetInstance_ID(this.getM_AttributeSetInstance_ID());
                    matchPO.setM_Product_ID(this.getM_Product_ID());
                    matchPO.setDescription(null);
                    matchPO.setProcessed(true);
                    matchPO.setPosted(false);
                    matchPO.saveEx();
                }
            }
            return true;
        }
        return false;
    }
}

