/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCostDetail;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPeriod;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_C_InvoiceLine;
import org.compiere.model.X_M_InOutLine;
import org.compiere.model.X_M_MatchInv;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class MMatchInv
extends X_M_MatchInv {
    private static final long serialVersionUID = -6673764788466220541L;
    private static CLogger s_log = CLogger.getCLogger(MMatchInv.class);

    public static MMatchInv[] get(Properties ctx, int M_InOutLine_ID, int C_InvoiceLine_ID, String trxName) {
        if (M_InOutLine_ID <= 0 || C_InvoiceLine_ID <= 0) {
            return new MMatchInv[0];
        }
        String whereClause = "M_InOutLine_ID=? AND C_InvoiceLine_ID=?";
        List<MMatchInv> list = new Query(ctx, "M_MatchInv", "M_InOutLine_ID=? AND C_InvoiceLine_ID=?", trxName).setParameters(M_InOutLine_ID, C_InvoiceLine_ID).list();
        return list.toArray(new MMatchInv[list.size()]);
    }

    public static MMatchInv[] getInvoiceLine(Properties ctx, int C_InvoiceLine_ID, String trxName) {
        if (C_InvoiceLine_ID <= 0) {
            return new MMatchInv[0];
        }
        String whereClause = "C_InvoiceLine_ID=?";
        List<MMatchInv> list = new Query(ctx, "M_MatchInv", whereClause, trxName).setParameters(C_InvoiceLine_ID).list();
        return list.toArray(new MMatchInv[list.size()]);
    }

    public static MMatchInv[] getInOut(Properties ctx, int M_InOut_ID, String trxName) {
        if (M_InOut_ID <= 0) {
            return new MMatchInv[0];
        }
        String whereClause = "EXISTS (SELECT 1 FROM M_InOutLine l WHERE M_MatchInv.M_InOutLine_ID=l.M_InOutLine_ID AND l.M_InOut_ID=?)";
        List<MMatchInv> list = new Query(ctx, "M_MatchInv", "EXISTS (SELECT 1 FROM M_InOutLine l WHERE M_MatchInv.M_InOutLine_ID=l.M_InOutLine_ID AND l.M_InOut_ID=?)", trxName).setParameters(M_InOut_ID).list();
        return list.toArray(new MMatchInv[list.size()]);
    }

    public static MMatchInv[] getInvoice(Properties ctx, int C_Invoice_ID, String trxName) {
        if (C_Invoice_ID == 0) {
            return new MMatchInv[0];
        }
        String whereClause = " EXISTS (SELECT 1 FROM C_InvoiceLine il WHERE M_MatchInv.C_InvoiceLine_ID=il.C_InvoiceLine_ID AND il.C_Invoice_ID=?)";
        List<MMatchInv> list = new Query(ctx, "M_MatchInv", " EXISTS (SELECT 1 FROM C_InvoiceLine il WHERE M_MatchInv.C_InvoiceLine_ID=il.C_InvoiceLine_ID AND il.C_Invoice_ID=?)", trxName).setParameters(C_Invoice_ID).list();
        return list.toArray(new MMatchInv[list.size()]);
    }

    public MMatchInv(Properties ctx, int M_MatchInv_ID, String trxName) {
        super(ctx, M_MatchInv_ID, trxName);
        if (M_MatchInv_ID == 0) {
            this.setM_AttributeSetInstance_ID(0);
            this.setPosted(false);
            this.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public MMatchInv(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MMatchInv(MInvoiceLine iLine, Timestamp dateTrx, BigDecimal qty) {
        this(iLine.getCtx(), 0, iLine.get_TrxName());
        this.setClientOrg(iLine);
        this.setC_InvoiceLine_ID(iLine.getC_InvoiceLine_ID());
        this.setM_InOutLine_ID(iLine.getM_InOutLine_ID());
        if (dateTrx != null) {
            this.setDateTrx(dateTrx);
        }
        this.setM_Product_ID(iLine.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(iLine.getM_AttributeSetInstance_ID());
        this.setQty(qty);
        this.setProcessed(true);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getDateTrx() == null) {
            this.setDateTrx(new Timestamp(System.currentTimeMillis()));
        }
        if (this.getDateAcct() == null) {
            Timestamp ts = this.getNewerDateAcct();
            if (ts == null) {
                ts = this.getDateTrx();
            }
            this.setDateAcct(ts);
        }
        if (this.getM_AttributeSetInstance_ID() == 0 && this.getM_InOutLine_ID() != 0) {
            MInOutLine iol = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
            this.setM_AttributeSetInstance_ID(iol.getM_AttributeSetInstance_ID());
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        BigDecimal matchedQty;
        PO line;
        if (!success) {
            return false;
        }
        if (this.getM_InOutLine_ID() > 0) {
            line = new MInOutLine(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName());
            matchedQty = DB.getSQLValueBD(this.get_TrxName(), "SELECT Coalesce(SUM(Qty),0) FROM M_MatchInv WHERE M_InOutLine_ID=?", this.getM_InOutLine_ID());
            if (matchedQty != null && matchedQty.compareTo(((X_M_InOutLine)line).getMovementQty()) > 0) {
                throw new IllegalStateException("Total matched qty > movement qty. MatchedQty=" + matchedQty + ", MovementQty=" + ((X_M_InOutLine)line).getMovementQty() + ", Line=" + line);
            }
        }
        if (this.getC_InvoiceLine_ID() > 0) {
            line = new MInvoiceLine(this.getCtx(), this.getC_InvoiceLine_ID(), this.get_TrxName());
            matchedQty = DB.getSQLValueBD(this.get_TrxName(), "SELECT Coalesce(SUM(Qty),0) FROM M_MatchInv WHERE C_InvoiceLine_ID=?", this.getC_InvoiceLine_ID());
            if (matchedQty != null && matchedQty.compareTo(((X_C_InvoiceLine)line).getQtyInvoiced()) > 0) {
                throw new IllegalStateException("Total matched qty > invoiced qty. MatchedQty=" + matchedQty + ", InvoicedQty=" + ((X_C_InvoiceLine)line).getQtyInvoiced() + ", Line=" + line);
            }
        }
        return true;
    }

    public Timestamp getNewerDateAcct() {
        String sql = "SELECT i.DateAcct FROM C_InvoiceLine il INNER JOIN C_Invoice i ON (i.C_Invoice_ID=il.C_Invoice_ID) WHERE C_InvoiceLine_ID=?";
        Timestamp invoiceDate = DB.getSQLValueTS(this.get_TrxName(), sql, this.getC_InvoiceLine_ID());
        sql = "SELECT io.DateAcct FROM M_InOutLine iol INNER JOIN M_InOut io ON (io.M_InOut_ID=iol.M_InOut_ID) WHERE iol.M_InOutLine_ID=?";
        Timestamp shipDate = DB.getSQLValueTS(this.get_TrxName(), sql, this.getM_InOutLine_ID());
        if (invoiceDate == null) {
            return shipDate;
        }
        if (shipDate == null) {
            return invoiceDate;
        }
        if (invoiceDate.after(shipDate)) {
            return invoiceDate;
        }
        return shipDate;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.isPosted()) {
            MPeriod.testPeriodOpen(this.getCtx(), this.getDateTrx(), "MXI", this.getAD_Org_ID());
            this.setPosted(false);
            MFactAcct.deleteEx(472, this.get_ID(), this.get_TrxName());
        }
        return true;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            this.deleteMatchInvCostDetail();
        }
        return success;
    }

    protected String deleteMatchInvCostDetail() {
        MAcctSchema[] acctschemas = MAcctSchema.getClientAcctSchema(this.getCtx(), this.getAD_Client_ID());
        int asn = 0;
        while (asn < acctschemas.length) {
            MCostDetail cd;
            MAcctSchema as = acctschemas[asn];
            if (!as.isSkipOrg(this.getAD_Org_ID()) && (cd = MCostDetail.get(this.getCtx(), "M_MatchInv_ID=?", this.getM_MatchInv_ID(), this.getM_AttributeSetInstance_ID(), as.getC_AcctSchema_ID(), this.get_TrxName())) != null) {
                cd.deleteEx(true);
            }
            ++asn;
        }
        return "";
    }

    public static MMatchInv[] getInOutLine(Properties ctx, int M_InOutLine_ID, String trxName) {
        if (M_InOutLine_ID <= 0) {
            return new MMatchInv[0];
        }
        String whereClause = "M_InOutLine_ID=?";
        List<MMatchInv> list = new Query(ctx, "M_MatchInv", "M_InOutLine_ID=?", trxName).setParameters(M_InOutLine_ID).list();
        return list.toArray(new MMatchInv[list.size()]);
    }

    public boolean reverse(Timestamp reversalDate) {
        if (this.isProcessed() && this.getReversal_ID() == 0) {
            MMatchInv reversal = new MMatchInv(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(this, reversal);
            reversal.setAD_Org_ID(this.getAD_Org_ID());
            reversal.setDescription("(->" + this.getDocumentNo() + ")");
            reversal.setQty(this.getQty().negate());
            reversal.setDateAcct(reversalDate);
            reversal.setDateTrx(reversalDate);
            reversal.set_ValueNoCheck("DocumentNo", null);
            reversal.setPosted(false);
            reversal.setReversal_ID(this.getM_MatchInv_ID());
            reversal.saveEx();
            this.setDescription("(" + reversal.getDocumentNo() + "<-)");
            this.setReversal_ID(reversal.getM_MatchInv_ID());
            this.saveEx();
            return true;
        }
        return false;
    }
}

