/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MLotCtl;
import org.compiere.model.Query;
import org.compiere.model.X_M_Lot;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;

public class MLot
extends X_M_Lot {
    private static final long serialVersionUID = -2238962371935615958L;
    private static CLogger s_log = CLogger.getCLogger(MLot.class);

    public static MLot[] getProductLots(Properties ctx, int M_Product_ID, String trxName) {
        String whereClause = "M_Product_ID=?";
        List<MLot> list = new Query(ctx, "M_Lot", "M_Product_ID=?", trxName).setParameters(M_Product_ID).list();
        MLot[] retValue = new MLot[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MLot getProductLot(Properties ctx, int M_Product_ID, String lot, String trxName) {
        String whereClause = "M_Product_ID=? AND Name=?";
        MLot retValue = (MLot)new Query(ctx, "M_Lot", "M_Product_ID=? AND Name=?", trxName).setParameters(M_Product_ID, lot).setOrderBy("M_Lot_ID DESC").first();
        return retValue;
    }

    public static KeyNamePair[] getProductLotPairs(int M_Product_ID, String trxName) {
        ArrayList<KeyNamePair> list;
        block6: {
            String sql = "SELECT M_Lot_ID, Name FROM M_Lot WHERE M_Product_ID=?";
            list = new ArrayList<KeyNamePair>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, M_Product_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                    }
                }
                catch (SQLException ex) {
                    s_log.log(Level.SEVERE, sql, ex);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        KeyNamePair[] retValue = new KeyNamePair[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MLot(Properties ctx, int M_Lot_ID, String trxName) {
        super(ctx, M_Lot_ID, trxName);
    }

    public MLot(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MLot(MLotCtl ctl, int M_Product_ID, String Name2) {
        this(ctl.getCtx(), 0, ctl.get_TrxName());
        this.setClientOrg(ctl);
        this.setM_LotCtl_ID(ctl.getM_LotCtl_ID());
        this.setM_Product_ID(M_Product_ID);
        this.setName(Name2);
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

