/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.adempiere.util.ContextRunnable;
import org.compiere.Adempiere;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLookupCache;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MQuery;
import org.compiere.model.MTable;
import org.compiere.util.CLogMgt;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.KeyNamePair;
import org.compiere.util.NamePair;
import org.compiere.util.ValueNamePair;

public final class MLookup
extends Lookup
implements Serializable {
    private static final long serialVersionUID = 2228200000988048623L;
    public static final String INACTIVE_S = "~";
    public static final String INACTIVE_E = "~";
    private static final int MAX_ROWS = 5000;
    private static Integer MINUS_ONE = -1;
    private MLookupInfo m_info = null;
    private volatile LinkedHashMap<Object, Object> m_lookup = new LinkedHashMap();
    private MLoader m_loader;
    private boolean m_allLoaded = false;
    private boolean m_hasInactive = false;
    private boolean m_refreshing = false;
    private long m_nextRead = 0L;
    public static final String SHORTLIST_S = "*";
    public static final String SHORTLIST_E = "*";
    private boolean m_hasShortListItems = false;
    private HashMap<Object, Object> m_lookupDirect = null;
    private Object m_directNullKey = null;
    private Future<?> m_loaderFuture;

    public MLookup(MLookupInfo info, int TabNo) {
        super(info.DisplayType, info.WindowNo);
        this.m_info = info;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.m_info.KeyColumn);
        }
        if (Ini.isClient() && MLookupCache.loadFromCache(this.m_info, this.m_lookup)) {
            return;
        }
        if (this.m_info.DisplayType == 30 || this.m_info.IsCreadedUpdatedBy) {
            return;
        }
        if (this.m_info.IsParent || this.m_info.IsKey) {
            this.m_hasInactive = true;
            return;
        }
    }

    @Override
    public void dispose() {
        if (this.m_info != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(this.m_info.KeyColumn) + ": dispose");
        }
        if (this.m_loaderFuture != null && !this.m_loaderFuture.isDone()) {
            this.m_loaderFuture.cancel(true);
        }
        this.m_loader = null;
        this.m_loaderFuture = null;
        if (this.m_lookup != null) {
            this.m_lookup.clear();
        }
        this.m_lookup = null;
        if (this.m_lookupDirect != null) {
            this.m_lookupDirect.clear();
        }
        this.m_lookupDirect = null;
        this.m_info = null;
        super.dispose();
    }

    @Override
    public void loadComplete() {
        if (this.m_loaderFuture != null && !this.m_loaderFuture.isDone()) {
            try {
                this.m_loaderFuture.get();
            }
            catch (Exception ie) {
                this.log.log(Level.SEVERE, String.valueOf(this.m_info.KeyColumn) + ": Interrupted", ie);
            }
            this.m_loader = null;
            this.m_loaderFuture = null;
        }
    }

    public NamePair get(Object key, boolean includeDirect) {
        NamePair retValue;
        if (key == null || MINUS_ONE.equals(key)) {
            return null;
        }
        if (this.m_info.IsParent) {
            if (this.m_nextRead > 0L && this.m_nextRead < System.currentTimeMillis()) {
                this.m_lookup.clear();
                if (this.m_lookupDirect != null) {
                    this.m_lookupDirect.clear();
                }
            }
            this.m_nextRead = System.currentTimeMillis() + 5000L;
        }
        if ((retValue = (NamePair)this.m_lookup.get(key)) != null) {
            return retValue;
        }
        if (this.m_loaderFuture != null && !this.m_loaderFuture.isDone()) {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.m_info.KeyColumn == null ? "ID=" + this.m_info.Column_ID : this.m_info.KeyColumn) + ": waiting for Loader");
            }
            this.loadComplete();
            retValue = (NamePair)this.m_lookup.get(key);
            if (retValue != null) {
                return retValue;
            }
        }
        if (includeDirect) {
            boolean cacheLocal = this.m_info.IsValidated;
            return this.getDirect(key, false, cacheLocal);
        }
        return null;
    }

    @Override
    public NamePair get(Object key) {
        return this.get(key, true);
    }

    public NamePair getNoDirect(Object key) {
        return this.get(key, false);
    }

    @Override
    public String getDisplay(Object key) {
        if (key == null) {
            return "";
        }
        NamePair display = this.get(key);
        if (display == null) {
            StringBuilder msgreturn = new StringBuilder("<").append(key.toString()).append(">");
            return msgreturn.toString();
        }
        return ((Object)display).toString();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.m_lookup.containsKey(key)) {
            return true;
        }
        if (this.m_lookup.size() > 0) {
            return false;
        }
        return this.get(key) != null;
    }

    @Override
    public boolean containsKeyNoDirect(Object key) {
        if (this.m_lookup.containsKey(key)) {
            return true;
        }
        if (this.m_lookup.size() > 0) {
            return false;
        }
        return this.getNoDirect(key) != null;
    }

    public String toString() {
        StringBuilder msgreturn = new StringBuilder("MLookup[").append(this.m_info.KeyColumn).append(",Column_ID=").append(this.m_info.Column_ID).append(",Size=").append(this.m_lookup.size()).append(",Validated=").append(this.isValidated()).append("-").append(this.getValidation()).append("]");
        return msgreturn.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MLookup) {
            MLookup ll = (MLookup)obj;
            if (ll.m_info.Column_ID == this.m_info.Column_ID) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public int size() {
        return this.m_lookup.size();
    }

    public boolean isAllLoaded() {
        return this.m_allLoaded;
    }

    @Override
    public boolean isValidated() {
        if (this.m_info == null) {
            return false;
        }
        return this.isValidated(this.m_info);
    }

    @Override
    public String getValidation() {
        return this.m_info.ValidationCode;
    }

    public int getAD_Reference_Value_ID() {
        return this.m_info.AD_Reference_Value_ID;
    }

    @Override
    public boolean hasInactive() {
        return this.m_hasInactive;
    }

    public int getAD_InfoWindow_ID() {
        return this.m_info.InfoWindowId;
    }

    private ArrayList<Object> getData(boolean onlyValidated, boolean loadParent) {
        boolean validated;
        if (this.m_loaderFuture != null && !this.m_loaderFuture.isDone()) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(this.m_info.KeyColumn == null ? "ID=" + this.m_info.Column_ID : this.m_info.KeyColumn) + ": waiting for Loader");
            }
            this.loadComplete();
        }
        if (!this.m_allLoaded || this.m_lookup.size() == 0) {
            this.loadData(loadParent);
        }
        if (validated = this.isValidated(this.m_info)) {
            return new ArrayList<Object>(this.m_lookup.values());
        }
        if (!validated && onlyValidated) {
            this.loadData(loadParent);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(String.valueOf(this.m_info.KeyColumn) + ": Validated - #" + this.m_lookup.size());
            }
        }
        return new ArrayList<Object>(this.m_lookup.values());
    }

    @Override
    public ArrayList<Object> getData(boolean mandatory, boolean onlyValidated, boolean onlyActive, boolean temporary, boolean shortlist) {
        String s;
        Object o;
        int i2;
        ArrayList<Object> list = this.getData(onlyValidated, true);
        if (onlyActive && this.m_hasInactive) {
            i2 = list.size();
            while (i2 > 0) {
                o = list.get(i2 - 1);
                if (o != null && (s = o.toString()).startsWith("~") && s.endsWith("~")) {
                    list.remove(i2 - 1);
                }
                --i2;
            }
        }
        if (shortlist && this.m_hasShortListItems) {
            i2 = list.size();
            while (i2 > 0) {
                o = list.get(i2 - 1);
                if (o != null && (s = o.toString()).startsWith("*") && s.endsWith("*")) {
                    list.remove(i2 - 1);
                }
                --i2;
            }
        }
        if (!mandatory) {
            NamePair p2 = null;
            p2 = this.m_info.KeyColumn != null && this.m_info.KeyColumn.endsWith("_ID") ? new KeyNamePair(-1, "") : new ValueNamePair("", "");
            list.add(0, p2);
        }
        return list;
    }

    @Override
    public NamePair getDirect(Object key, boolean saveInCache, boolean cacheLocal) {
        NamePair directValue;
        block25: {
            if (key == null || this.m_info.QueryDirect == null || this.m_info.QueryDirect.length() == 0) {
                return null;
            }
            if (key.equals(this.m_directNullKey)) {
                return null;
            }
            if (key.toString().trim().length() == 0) {
                return null;
            }
            directValue = null;
            if (this.m_lookupDirect != null && (directValue = (NamePair)this.m_lookupDirect.get(key)) != null) {
                return directValue;
            }
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.m_info.KeyColumn) + ": " + key + ", SaveInCache=" + saveInCache + ",Local=" + cacheLocal);
            }
            boolean isNumber = this.m_info.KeyColumn.endsWith("_ID");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(this.m_info.QueryDirect, null);
                    if (isNumber) {
                        pstmt.setInt(1, Integer.parseInt(key.toString()));
                    } else {
                        pstmt.setString(1, key.toString());
                    }
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        StringBuilder name = new StringBuilder().append(rs.getString(3));
                        boolean isActive = rs.getString(4).equals("Y");
                        if (!isActive) {
                            name.insert(0, "~").append("~");
                        }
                        if (isNumber) {
                            int keyValue = rs.getInt(1);
                            KeyNamePair p2 = new KeyNamePair(keyValue, name.toString());
                            if (saveInCache) {
                                this.m_lookup.put(keyValue, p2);
                            }
                            directValue = p2;
                        } else {
                            String value = rs.getString(2);
                            ValueNamePair p3 = new ValueNamePair(value, name.toString());
                            if (saveInCache) {
                                this.m_lookup.put(value, p3);
                            }
                            directValue = p3;
                        }
                        if (rs.next()) {
                            this.log.log(Level.SEVERE, String.valueOf(this.m_info.KeyColumn) + ": Not unique (first returned) for " + key + " SQL=" + this.m_info.QueryDirect);
                        }
                    } else {
                        this.m_directNullKey = key;
                        directValue = null;
                    }
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest(String.valueOf(this.m_info.KeyColumn) + ": " + directValue + " - " + this.m_info);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, String.valueOf(this.m_info.KeyColumn) + ": SQL=" + this.m_info.QueryDirect + "; Key=" + key, e);
                    directValue = null;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block25;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (cacheLocal && !saveInCache && directValue != null) {
            if (this.m_lookupDirect == null) {
                this.m_lookupDirect = new HashMap();
            } else if (!this.m_lookupDirect.containsKey(key)) {
                this.m_lookupDirect.clear();
                this.m_lookupDirect.put(key, directValue);
            }
        }
        this.m_hasInactive = true;
        return directValue;
    }

    @Override
    public int getZoom() {
        return this.m_info.ZoomWindow;
    }

    @Override
    public int getZoom(MQuery query) {
        if (this.m_info.ZoomWindowPO == 0 || query == null) {
            return this.m_info.ZoomWindow;
        }
        boolean isSOTrx = DB.isSOTrx(this.m_info.TableName, query.getWhereClause(false), this.m_info.WindowNo);
        return this.getZoom(isSOTrx);
    }

    @Override
    public int getZoom(boolean isSOTrx) {
        if (this.m_info.ZoomWindowPO == 0) {
            return this.m_info.ZoomWindow;
        }
        return isSOTrx ? this.m_info.ZoomWindow : this.m_info.ZoomWindowPO;
    }

    @Override
    public MQuery getZoomQuery() {
        return this.m_info.ZoomQuery;
    }

    @Override
    public String getColumnName() {
        return this.m_info.KeyColumn;
    }

    @Override
    public int refresh() {
        if (this.m_refreshing) {
            return 0;
        }
        return this.refresh(true);
    }

    public int refresh(boolean loadParent) {
        if (this.m_refreshing) {
            return 0;
        }
        if (!loadParent && this.m_info.IsParent) {
            return 0;
        }
        if (this.m_info.DisplayType == 30 || this.m_info.IsCreadedUpdatedBy) {
            this.removeAllElements();
            return 0;
        }
        this.m_refreshing = true;
        this.m_lookup.clear();
        this.fillComboBox(this.isMandatory(), true, true, false, this.isShortList());
        this.m_refreshing = false;
        return this.m_lookup.size();
    }

    private int loadData(boolean loadParent) {
        if (!loadParent && this.m_info.IsParent) {
            return 0;
        }
        if (this.m_info.DisplayType == 30 || this.m_info.IsCreadedUpdatedBy) {
            return 0;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(this.m_info.KeyColumn) + ": start");
        }
        this.m_loader = new MLoader();
        this.m_loaderFuture = Adempiere.getThreadPoolExecutor().submit(this.m_loader);
        this.loadComplete();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(this.m_info.KeyColumn) + ": #" + this.m_lookup.size());
        }
        return this.m_lookup.size();
    }

    @Override
    public void removeAllElements() {
        super.removeAllElements();
        this.m_lookup.clear();
        if (this.m_lookupDirect != null) {
            this.m_lookupDirect.clear();
        }
    }

    private boolean isValidated(MLookupInfo info) {
        if (info.IsValidated) {
            return true;
        }
        if (info.ValidationCode.length() == 0) {
            return true;
        }
        String validation = Env.parseContext(this.m_info.ctx, this.m_info.WindowNo, this.m_info.ValidationCode, false);
        return validation.equals(info.parsedValidationCode);
    }

    public MLookupInfo getLookupInfo() {
        return this.m_info;
    }

    class MLoader
    extends ContextRunnable
    implements Serializable {
        private static final long serialVersionUID = -7868426685745727939L;
        private long m_startTime = System.currentTimeMillis();

        @Override
        protected void doRun() {
            long startTime;
            block29: {
                startTime = System.currentTimeMillis();
                if (Ini.isClient()) {
                    MLookupCache.loadStart(MLookup.this.m_info);
                }
                StringBuilder sql = new StringBuilder().append(MLookup.this.m_info.Query);
                if (MLookup.this.isShortList()) {
                    int posFirstPoint = sql.indexOf(".");
                    String tableName = sql.substring(7, posFirstPoint);
                    int posFirstFrom = sql.indexOf(String.valueOf(tableName) + ".IsActive FROM " + tableName) + tableName.length() + 9;
                    String ClauseFromWhereOrder = sql.substring(posFirstFrom, sql.length());
                    sql = new StringBuilder(String.valueOf(sql.substring(0, posFirstFrom)) + ", " + tableName + ".IsShortList" + ClauseFromWhereOrder);
                }
                if (!MLookup.this.m_info.IsValidated) {
                    String validation;
                    MLookup.this.m_info.parsedValidationCode = validation = Env.parseContext(MLookup.this.m_info.ctx, MLookup.this.m_info.WindowNo, MLookup.this.m_info.tabNo, MLookup.this.m_info.ValidationCode, false);
                    if (validation.length() == 0 && MLookup.this.m_info.ValidationCode.length() > 0) {
                        boolean isReportViewer;
                        if (MLookup.this.log.isLoggable(Level.FINE)) {
                            MLookup.this.log.fine(String.valueOf(MLookup.this.m_info.KeyColumn) + ": Loader NOT Validated: " + MLookup.this.m_info.ValidationCode);
                        }
                        if (!(isReportViewer = Env.getContext(MLookup.this.m_info.ctx, MLookup.this.m_info.WindowNo, "_WinInfo_IsReportViewer").equals("Y"))) {
                            MLookup.this.m_lookup.clear();
                            return;
                        }
                    } else {
                        int posFrom;
                        if (MLookup.this.log.isLoggable(Level.FINE)) {
                            MLookup.this.log.fine(String.valueOf(MLookup.this.m_info.KeyColumn) + ": Loader Validated: " + validation);
                        }
                        boolean hasWhere = sql.indexOf(" WHERE ", posFrom = sql.lastIndexOf(" FROM ")) != -1;
                        int posOrder = sql.lastIndexOf(" ORDER BY ");
                        if (posOrder != -1) {
                            sql = new StringBuilder(sql.substring(0, posOrder)).append(hasWhere ? " AND " : " WHERE ").append(validation).append(sql.substring(posOrder));
                        } else {
                            sql.append(hasWhere ? " AND " : " WHERE ").append(validation);
                        }
                        if (CLogMgt.isLevelFinest() && MLookup.this.log.isLoggable(Level.FINE)) {
                            MLookup.this.log.fine(String.valueOf(MLookup.this.m_info.KeyColumn) + ": Validation=" + validation);
                        }
                    }
                }
                if (Thread.interrupted()) {
                    MLookup.this.log.log(Level.WARNING, String.valueOf(MLookup.this.m_info.KeyColumn) + ": Loader interrupted");
                    return;
                }
                if (MLookup.this.log.isLoggable(Level.FINER)) {
                    MLookup.this.log.finer(String.valueOf(MLookup.this.m_info.Column_ID) + ", " + MLookup.this.m_info.KeyColumn + ": " + sql.toString());
                }
                if (MLookup.this.log.isLoggable(Level.FINEST)) {
                    MLookup.this.log.finest(String.valueOf(MLookup.this.m_info.KeyColumn) + ": " + sql);
                }
                MLookup.this.m_lookup.clear();
                boolean isNumber = MLookup.this.m_info.KeyColumn.endsWith("_ID");
                MLookup.this.m_hasInactive = false;
                int rows = 0;
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql.toString(), null);
                        rs = pstmt.executeQuery();
                        MLookup.this.m_allLoaded = true;
                        while (rs.next()) {
                            if (rows++ > 5000) {
                                StringBuilder s = new StringBuilder().append(MLookup.this.m_info.KeyColumn).append(": Loader - Too many records");
                                if (MLookup.this.m_info.Column_ID > 0) {
                                    MColumn mColumn = MColumn.get(MLookup.this.m_info.ctx, MLookup.this.m_info.Column_ID);
                                    String column = mColumn.getColumnName();
                                    s.append(", Column=").append(column);
                                    String tableName = MTable.getTableName(MLookup.this.m_info.ctx, mColumn.getAD_Table_ID());
                                    s.append(", Table=").append(tableName);
                                }
                                MLookup.this.log.warning(s.toString());
                            } else if (rows % 20 != 0 || !Thread.interrupted()) {
                                NamePair p2;
                                boolean isShortListItem;
                                StringBuilder name = new StringBuilder().append(rs.getString(3));
                                boolean isActive = rs.getString(4).equals("Y");
                                if (!isActive) {
                                    name.insert(0, "~").append("~");
                                    MLookup.this.m_hasInactive = true;
                                }
                                if (MLookup.this.isShortList() && !(isShortListItem = rs.getString(5).equals("Y"))) {
                                    name = new StringBuilder("*").append((CharSequence)name).append("*");
                                    MLookup.this.m_hasShortListItems = true;
                                }
                                if (isNumber) {
                                    int key = rs.getInt(1);
                                    p2 = new KeyNamePair(key, name.toString());
                                    MLookup.this.m_lookup.put(key, p2);
                                    continue;
                                }
                                String value = rs.getString(2);
                                p2 = new ValueNamePair(value, name.toString());
                                MLookup.this.m_lookup.put(value, p2);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (SQLException e) {
                        MLookup.this.log.log(Level.SEVERE, String.valueOf(MLookup.this.m_info.KeyColumn) + ", " + MLookup.this.m_info.Column_ID + " : Loader - " + sql, e);
                        MLookup.this.m_allLoaded = false;
                        DB.close(rs, pstmt);
                        break block29;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close(rs, pstmt);
            }
            int size = MLookup.this.m_lookup.size();
            if (MLookup.this.log.isLoggable(Level.FINER)) {
                MLookup.this.log.finer(String.valueOf(MLookup.this.m_info.KeyColumn) + " (" + MLookup.this.m_info.Column_ID + "):" + " - Loader complete #" + size + " - all=" + MLookup.this.m_allLoaded + " - ms=" + String.valueOf(System.currentTimeMillis() - this.m_startTime) + " (" + String.valueOf(System.currentTimeMillis() - startTime) + ")");
            }
            if (Ini.isClient()) {
                MLookupCache.loadEnd(MLookup.this.m_info, MLookup.this.m_lookup);
            }
        }
    }
}

