/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAccount;
import org.compiere.model.MAddressTransaction;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MColumn;
import org.compiere.model.MCountry;
import org.compiere.model.MRegion;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.X_C_Location;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class MLocation
extends X_C_Location
implements Comparator<Object> {
    private static final long serialVersionUID = -4100591609253985073L;
    public static String LOCATION_MAPS_URL_PREFIX = MSysConfig.getValue("LOCATION_MAPS_URL_PREFIX");
    public static String LOCATION_MAPS_ROUTE_PREFIX = MSysConfig.getValue("LOCATION_MAPS_ROUTE_PREFIX");
    public static String LOCATION_MAPS_SOURCE_ADDRESS = MSysConfig.getValue("LOCATION_MAPS_SOURCE_ADDRESS");
    public static String LOCATION_MAPS_DESTINATION_ADDRESS = MSysConfig.getValue("LOCATION_MAPS_DESTINATION_ADDRESS");
    private static CCache<Integer, MLocation> s_cache = new CCache("C_Location", 100, 30);
    private static CLogger s_log = CLogger.getCLogger(MLocation.class);
    private MCountry m_c = null;
    private MRegion m_r = null;
    public static final String updateBPLocName = "SELECT C_BPartner_Location_ID FROM C_BPartner_Location WHERE C_Location_ID = ? AND IsPreserveCustomName = 'N'";
    private String m_errorMessage = null;

    public static MLocation get(Properties ctx, int C_Location_ID, String trxName) {
        if (C_Location_ID == 0) {
            return new MLocation(ctx, C_Location_ID, trxName);
        }
        Integer key = C_Location_ID;
        MLocation retValue = null;
        if (trxName == null) {
            retValue = s_cache.get(key);
        }
        if (retValue != null) {
            return retValue;
        }
        retValue = new MLocation(ctx, C_Location_ID, trxName);
        if (retValue.get_ID() != 0) {
            if (trxName == null) {
                s_cache.put(key, retValue);
            }
            return retValue;
        }
        return null;
    }

    public static MLocation getBPLocation(Properties ctx, int C_BPartner_Location_ID, String trxName) {
        MLocation loc;
        block7: {
            if (C_BPartner_Location_ID == 0) {
                return null;
            }
            loc = null;
            String sql = "SELECT * FROM C_Location l WHERE C_Location_ID IN (SELECT C_Location_ID FROM C_BPartner_Location WHERE C_BPartner_Location_ID=?)";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, C_BPartner_Location_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        loc = new MLocation(ctx, rs, trxName);
                    }
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, String.valueOf(sql) + " - " + C_BPartner_Location_ID, e);
                    loc = null;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return loc;
    }

    public MLocation(Properties ctx, int C_Location_ID, String trxName) {
        super(ctx, C_Location_ID, trxName);
        if (C_Location_ID == 0) {
            MCountry defaultCountry = MCountry.getDefault(this.getCtx());
            this.setCountry(defaultCountry);
            MRegion defaultRegion = MRegion.getDefault(this.getCtx());
            if (defaultRegion != null && defaultRegion.getC_Country_ID() == defaultCountry.getC_Country_ID()) {
                this.setRegion(defaultRegion);
            }
        }
    }

    public MLocation(MCountry country, MRegion region) {
        super(country.getCtx(), 0, country.get_TrxName());
        this.setCountry(country);
        this.setRegion(region);
    }

    public MLocation(Properties ctx, int C_Country_ID, int C_Region_ID, String city, String trxName) {
        super(ctx, 0, trxName);
        this.setC_Country_ID(C_Country_ID);
        this.setC_Region_ID(C_Region_ID);
        this.setCity(city);
    }

    public MLocation(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setCountry(MCountry country) {
        this.m_c = country != null ? country : MCountry.getDefault(this.getCtx());
        super.setC_Country_ID(this.m_c.getC_Country_ID());
    }

    @Override
    public void setC_Country_ID(int C_Country_ID) {
        if (this.getC_Country_ID() != C_Country_ID) {
            this.setRegion(null);
        }
        this.setCountry(MCountry.get(this.getCtx(), C_Country_ID));
    }

    public MCountry getCountry() {
        if (this.m_c != null && this.m_c.get_ID() != this.getC_Country_ID()) {
            this.m_c = null;
        }
        if (this.m_c == null) {
            this.m_c = this.getC_Country_ID() != 0 ? MCountry.get(this.getCtx(), this.getC_Country_ID()) : MCountry.getDefault(this.getCtx());
        }
        return this.m_c;
    }

    public String getCountryName() {
        return this.getCountry().getName();
    }

    public String getCountry(boolean local) {
        if (local && this.getC_Country_ID() == MCountry.getDefault(this.getCtx()).getC_Country_ID()) {
            return null;
        }
        return this.getCountryName();
    }

    public String getCountry(boolean local, String language) {
        if (local && this.getC_Country_ID() == MCountry.getDefault(this.getCtx()).getC_Country_ID()) {
            return null;
        }
        MCountry mc = this.getCountry();
        return mc.getTrlName(language);
    }

    public void setRegion(MRegion region) {
        this.m_r = region;
        if (region == null) {
            super.setC_Region_ID(0);
            this.setRegionName(null);
        } else {
            super.setC_Region_ID(this.m_r.getC_Region_ID());
            this.setRegionName(this.m_r.getName());
            if (this.m_r.getC_Country_ID() != this.getC_Country_ID()) {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Region(" + region + ") C_Country_ID=" + region.getC_Country_ID() + " - From  C_Country_ID=" + this.getC_Country_ID());
                }
                this.setC_Country_ID(region.getC_Country_ID());
            }
        }
    }

    @Override
    public void setC_Region_ID(int C_Region_ID) {
        if (C_Region_ID == 0) {
            this.setRegion(null);
        } else if (this.getC_Country_ID() != 0) {
            MCountry cc = this.getCountry();
            if (cc.isValidRegion(C_Region_ID)) {
                super.setC_Region_ID(C_Region_ID);
            } else {
                this.setRegion(null);
            }
        } else {
            this.setRegion(MRegion.get(this.getCtx(), C_Region_ID));
        }
    }

    public MRegion getRegion() {
        if (this.m_r != null && this.m_r.get_ID() != this.getC_Region_ID()) {
            this.m_r = null;
        }
        if (this.m_r == null && this.getC_Region_ID() != 0) {
            this.m_r = MRegion.get(this.getCtx(), this.getC_Region_ID());
        }
        return this.m_r;
    }

    @Override
    public String getRegionName() {
        return this.getRegionName(false);
    }

    public String getRegionName(boolean getFromRegion) {
        if (getFromRegion && this.getCountry().isHasRegion() && this.getRegion() != null) {
            super.setRegionName("");
            return this.getRegion().getName();
        }
        String regionName = super.getRegionName();
        if (regionName == null) {
            regionName = "";
        }
        return regionName;
    }

    public boolean equals(int C_Country_ID, int C_Region_ID, String Postal, String Postal_Add, String City, String Address1, String Address2) {
        if (C_Country_ID != 0 && this.getC_Country_ID() != C_Country_ID) {
            return false;
        }
        if (C_Region_ID != 0 && this.getC_Region_ID() != C_Region_ID) {
            return false;
        }
        if (!this.equalsNull(Postal, this.getPostal())) {
            return false;
        }
        if (!this.equalsNull(Postal_Add, this.getPostal_Add())) {
            return false;
        }
        if (!this.equalsNull(City, this.getCity())) {
            return false;
        }
        if (!this.equalsNull(Address1, this.getAddress1())) {
            return false;
        }
        return this.equalsNull(Address2, this.getAddress2());
    }

    private boolean equalsNull(String c1, String c2) {
        if (c1 == null) {
            c1 = "";
        }
        if (c2 == null) {
            c2 = "";
        }
        return c1.equalsIgnoreCase(c2);
    }

    @Override
    public boolean equals(Object cmp) {
        if (cmp == null) {
            return false;
        }
        if (cmp.getClass().equals(this.getClass())) {
            return ((PO)cmp).get_ID() == this.get_ID();
        }
        return this.equals(cmp);
    }

    @Override
    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public boolean isAddressLinesReverse() {
        if (MCountry.getDefault(this.getCtx()) != null && this.getC_Country_ID() == MCountry.getDefault(this.getCtx()).getC_Country_ID()) {
            return this.getCountry().isAddressLinesLocalReverse();
        }
        return this.getCountry().isAddressLinesReverse();
    }

    public String getCityRegionPostal() {
        return this.parseCRP(this.getCountry());
    }

    private String parseCRP(MCountry c) {
        if (c == null) {
            return "CountryNotFound";
        }
        boolean local = MCountry.getDefault(this.getCtx()) != null && this.getC_Country_ID() == MCountry.getDefault(this.getCtx()).getC_Country_ID();
        String inStr = local ? c.getDisplaySequenceLocal() : c.getDisplaySequence();
        StringBuilder outStr = new StringBuilder();
        int i2 = inStr.indexOf(64);
        while (i2 != -1) {
            String token;
            outStr.append(inStr.substring(0, i2));
            inStr = inStr.substring(i2 + 1, inStr.length());
            int j = inStr.indexOf(64);
            if (j < 0) {
                token = "";
                j = i2 + 1;
            } else {
                token = inStr.substring(0, j);
            }
            if (token.equals("C")) {
                if (this.getCity() != null) {
                    outStr.append(this.getCity());
                }
            } else if (token.equals("R")) {
                if (this.getRegion() != null) {
                    outStr.append(this.getRegion().getName());
                } else if (super.getRegionName() != null && super.getRegionName().length() > 0) {
                    outStr.append(super.getRegionName());
                }
            } else if (token.equals("P")) {
                if (this.getPostal() != null) {
                    outStr.append(this.getPostal());
                }
            } else if (token.equals("A")) {
                String add = this.getPostal_Add();
                if (add != null && add.length() > 0) {
                    outStr.append("-").append(add);
                }
            } else {
                outStr.append("@").append(token).append("@");
            }
            inStr = inStr.substring(j + 1, inStr.length());
            i2 = inStr.indexOf(64);
        }
        outStr.append(inStr);
        if (c.getDisplaySequence().indexOf("@R@") == -1 && super.getRegionName() != null && super.getRegionName().length() > 0) {
            outStr.append(" ").append(super.getRegionName());
        }
        String retValue = Util.replace(outStr.toString(), "\\n", "\n");
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("parseCRP - " + c.getDisplaySequence() + " -> " + retValue);
        }
        return retValue;
    }

    @Override
    public String toString() {
        StringBuilder retStr = new StringBuilder();
        if (this.isAddressLinesReverse()) {
            retStr.append(this.parseCRP(this.getCountry()));
            if (this.getAddress5() != null && this.getAddress5().length() > 0) {
                retStr.append(", ").append(this.getAddress5());
            }
            if (this.getAddress4() != null && this.getAddress4().length() > 0) {
                retStr.append(", ").append(this.getAddress4());
            }
            if (this.getAddress3() != null && this.getAddress3().length() > 0) {
                retStr.append(", ").append(this.getAddress3());
            }
            if (this.getAddress2() != null && this.getAddress2().length() > 0) {
                retStr.append(", ").append(this.getAddress2());
            }
            if (this.getAddress1() != null) {
                retStr.append(", ").append(this.getAddress1());
            }
        } else {
            if (this.getAddress1() != null) {
                retStr.append(this.getAddress1());
            }
            if (this.getAddress2() != null && this.getAddress2().length() > 0) {
                retStr.append(", ").append(this.getAddress2());
            }
            if (this.getAddress3() != null && this.getAddress3().length() > 0) {
                retStr.append(", ").append(this.getAddress3());
            }
            if (this.getAddress4() != null && this.getAddress4().length() > 0) {
                retStr.append(", ").append(this.getAddress4());
            }
            if (this.getAddress5() != null && this.getAddress5().length() > 0) {
                retStr.append(", ").append(this.getAddress5());
            }
            retStr.append(", ").append(this.parseCRP(this.getCountry()));
        }
        return retStr.toString();
    }

    public String toStringCR() {
        StringBuilder retStr = new StringBuilder();
        if (this.isAddressLinesReverse()) {
            retStr.append(this.parseCRP(this.getCountry()));
            if (this.getAddress5() != null && this.getAddress5().length() > 0) {
                retStr.append("\n").append(this.getAddress5());
            }
            if (this.getAddress4() != null && this.getAddress4().length() > 0) {
                retStr.append("\n").append(this.getAddress4());
            }
            if (this.getAddress3() != null && this.getAddress3().length() > 0) {
                retStr.append("\n").append(this.getAddress3());
            }
            if (this.getAddress2() != null && this.getAddress2().length() > 0) {
                retStr.append("\n").append(this.getAddress2());
            }
            if (this.getAddress1() != null) {
                retStr.append("\n").append(this.getAddress1());
            }
        } else {
            if (this.getAddress1() != null) {
                retStr.append(this.getAddress1());
            }
            if (this.getAddress2() != null && this.getAddress2().length() > 0) {
                retStr.append("\n").append(this.getAddress2());
            }
            if (this.getAddress3() != null && this.getAddress3().length() > 0) {
                retStr.append("\n").append(this.getAddress3());
            }
            if (this.getAddress4() != null && this.getAddress4().length() > 0) {
                retStr.append("\n").append(this.getAddress4());
            }
            if (this.getAddress5() != null && this.getAddress5().length() > 0) {
                retStr.append("\n").append(this.getAddress5());
            }
            retStr.append("\n").append(this.parseCRP(this.getCountry()));
        }
        return retStr.toString();
    }

    public String toStringX() {
        StringBuilder sb = new StringBuilder("MLocation=[");
        sb.append(this.get_ID()).append(",C_Country_ID=").append(this.getC_Country_ID()).append(",C_Region_ID=").append(this.getC_Region_ID()).append(",Postal=").append(this.getPostal()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        int city_id;
        if (this.getAD_Org_ID() != 0) {
            this.setAD_Org_ID(0);
        }
        if (this.getC_Region_ID() != 0) {
            if (this.m_c == null || this.m_c.getC_Country_ID() != this.getC_Country_ID()) {
                this.getCountry();
            }
            if (!this.m_c.isHasRegion()) {
                this.setC_Region_ID(0);
            }
        } else {
            this.setRegionName(null);
        }
        if (this.getC_City_ID() <= 0 && this.getCity() != null && this.getCity().length() > 0 && (city_id = DB.getSQLValue(this.get_TrxName(), "SELECT C_City_ID FROM C_City WHERE C_Country_ID=? AND COALESCE(C_Region_ID,0)=? AND Name=? AND AD_Client_ID IN (0,?)", this.getC_Country_ID(), this.getC_Region_ID(), this.getCity(), this.getAD_Client_ID())) > 0) {
            this.setC_City_ID(city_id);
        }
        if (this.m_c != null && !this.m_c.isAllowCitiesOutOfList() && this.getC_City_ID() <= 0) {
            this.log.saveError("CityNotFound", Msg.translate(this.getCtx(), "CityNotFound"));
            return false;
        }
        if (this.m_c != null && !this.m_c.isAllowCitiesOutOfList() && this.getC_City_ID() > 0 && (city_id = DB.getSQLValue(this.get_TrxName(), "SELECT C_City_ID   FROM C_City  WHERE C_Country_ID=?    AND COALESCE(C_Region_ID,0)=?    AND C_City_ID =?", this.getC_Country_ID(), this.getC_Region_ID(), this.getC_City_ID())) < 0) {
            this.log.saveError("CityNotFound", String.valueOf(Msg.translate(this.getCtx(), "CityNotFound")) + " C_City_ID[" + this.getC_City_ID() + "]");
            return false;
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        int bplID;
        if (!success) {
            return success;
        }
        if (!newRecord && ("Y".equals(Env.getContext(this.getCtx(), "$Element_LF")) || "Y".equals(Env.getContext(this.getCtx(), "$Element_LT"))) && (this.is_ValueChanged("Postal") || this.is_ValueChanged("City"))) {
            StringBuilder msgup = new StringBuilder("(C_LocFrom_ID=").append(this.getC_Location_ID()).append(" OR C_LocTo_ID=").append(this.getC_Location_ID()).append(")");
            MAccount.updateValueDescription(this.getCtx(), msgup.toString(), this.get_TrxName());
        }
        if (this.get_TrxName().startsWith("POSave") && (bplID = DB.getSQLValueEx(this.get_TrxName(), updateBPLocName, this.getC_Location_ID())) > 0) {
            int bplocname = MSysConfig.getIntValue("START_VALUE_BPLOCATION_NAME", 0, this.getAD_Client_ID(), this.getAD_Org_ID());
            if (bplocname < 0 || bplocname > 4) {
                bplocname = 0;
            }
            if (this.is_ValueChanged("City") || this.is_ValueChanged("C_City_ID") || bplocname >= 1 && this.is_ValueChanged("Address1") || bplocname >= 2 && this.is_ValueChanged("Address2") || bplocname >= 3 && (this.is_ValueChanged("RegionName") || this.is_ValueChanged("C_Region_ID"))) {
                MBPartnerLocation bpl = new MBPartnerLocation(this.getCtx(), bplID, this.get_TrxName());
                bpl.setName(bpl.getBPLocName(this));
                bpl.saveEx();
            }
        }
        return success;
    }

    public String getMapsLocation() {
        MRegion region = new MRegion(Env.getCtx(), this.getC_Region_ID(), this.get_TrxName());
        StringBuilder address = new StringBuilder();
        address.append(this.getAddress1() != null ? String.valueOf(this.getAddress1()) + ", " : "");
        address.append(this.getAddress2() != null ? String.valueOf(this.getAddress2()) + ", " : "");
        address.append(this.getAddress3() != null ? String.valueOf(this.getAddress3()) + ", " : "");
        address.append(this.getCity() != null ? String.valueOf(this.getCity()) + ", " : "");
        address.append(region.getName() != null ? String.valueOf(region.getName()) + ", " : "");
        address.append(this.getCountryName() != null ? this.getCountryName() : "");
        return address.toString().replace(" ", "+");
    }

    public static int getFieldLength(String columnName) {
        MTable loctable = MTable.get(Env.getCtx(), 162);
        MColumn column = loctable.getColumn(columnName);
        if (column == null) {
            return -1;
        }
        return column.getFieldLength();
    }

    public void setErrorMessage(String errorMessage) {
        this.m_errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    public boolean processOnline(int C_AddressValidation_ID) {
        this.setErrorMessage(null);
        Trx trx = Trx.get(Trx.createTrxName("avt-"), true);
        trx.setDisplayName(String.valueOf(this.getClass().getName()) + "_processOnline");
        boolean ok = false;
        try {
            try {
                MAddressTransaction at = MLocation.createAddressTransaction(this.getCtx(), this, C_AddressValidation_ID, trx.getTrxName());
                ok = at.processOnline();
                at.saveEx();
                this.setC_AddressValidation_ID(at.getC_AddressValidation_ID());
                this.setIsValid(at.isValid());
                this.setResult(at.getResult());
                if (!ok) {
                    this.setErrorMessage(at.getErrorMessage());
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "processOnline", e);
                this.setErrorMessage(String.valueOf(Msg.getMsg(Env.getCtx(), "AddressNotProcessed")) + ": " + e.getMessage());
                if (trx != null) {
                    trx.commit();
                    trx.close();
                }
            }
        }
        finally {
            if (trx != null) {
                trx.commit();
                trx.close();
            }
        }
        return ok;
    }

    private static MAddressTransaction createAddressTransaction(Properties ctx, MLocation location, int C_AddressValidation_ID, String trxName) {
        MAddressTransaction at = new MAddressTransaction(ctx, 0, trxName);
        at.setAD_Org_ID(location.getAD_Org_ID());
        at.setAddress1(location.getAddress1());
        at.setAddress2(location.getAddress2());
        at.setAddress3(location.getAddress3());
        at.setAddress4(location.getAddress4());
        at.setAddress5(location.getAddress5());
        at.setComments(location.getComments());
        at.setC_AddressValidation_ID(C_AddressValidation_ID);
        at.setC_Location_ID(location.getC_Location_ID());
        at.setCity(location.getCity());
        if (location.getCountry() != null) {
            at.setCountry(location.getCountry().getCountryCode());
        }
        at.setIsActive(location.isActive());
        at.setPostal(location.getPostal());
        if (location.getRegion() != null) {
            at.setRegion(location.getRegion().getName());
        } else {
            at.setRegion(location.getRegionName());
        }
        at.saveEx();
        return at;
    }
}

