/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.compiere.Adempiere;
import org.compiere.model.MIssueProject;
import org.compiere.model.MIssueSystem;
import org.compiere.model.MIssueUser;
import org.compiere.model.MSystem;
import org.compiere.model.X_AD_Issue;
import org.compiere.model.X_R_Request;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Secure;

public class MIssue
extends X_AD_Issue {
    private static final long serialVersionUID = -3680542992654002121L;
    private static CLogger s_log = CLogger.getCLogger(MIssue.class);
    public static String DELIMITER = "|";
    private static final int INFOLENGTH = 2000;

    public static MIssue create(LogRecord record) {
        s_log.config(record.getMessage());
        MSystem system = MSystem.get(Env.getCtx());
        if (!DB.isConnected() || system == null || !system.isAutoErrorReport()) {
            return null;
        }
        MIssue issue = new MIssue(record);
        String error = issue.report();
        issue.saveEx();
        if (error != null) {
            return null;
        }
        return issue;
    }

    public static MIssue create(Properties ctx, String hexInput) {
        HashMap hmIn = null;
        try {
            byte[] byteArray = Secure.convertHexString(hexInput);
            ByteArrayInputStream bIn = new ByteArrayInputStream(byteArray);
            ObjectInputStream oIn = new ObjectInputStream(bIn);
            hmIn = (HashMap)oIn.readObject();
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "", e);
            return null;
        }
        MIssue issue = new MIssue(ctx, hmIn);
        return issue;
    }

    public MIssue(Properties ctx, int AD_Issue_ID, String trxName) {
        super(ctx, AD_Issue_ID, trxName);
        if (AD_Issue_ID == 0) {
            this.setProcessed(false);
            this.setSystemStatus("E");
            try {
                this.init(ctx);
            }
            catch (Exception e) {
                e.getStackTrace();
            }
        }
    }

    public MIssue(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MIssue(LogRecord record) {
        this(Env.getCtx(), 0, null);
        String summary = record.getMessage();
        this.setSourceClassName(record.getSourceClassName());
        this.setSourceMethodName(record.getSourceMethodName());
        this.setLoggerName(record.getLoggerName());
        Throwable t = record.getThrown();
        if (t != null) {
            if (summary != null && summary.length() > 0) {
                summary = String.valueOf(t.toString()) + " " + summary;
            }
            if (summary == null || summary.length() == 0) {
                summary = t.toString();
            }
            StringBuilder error = new StringBuilder();
            StackTraceElement[] tes = t.getStackTrace();
            int count = 0;
            int i2 = 0;
            while (i2 < tes.length) {
                StackTraceElement element = tes[i2];
                String s = element.toString();
                if (s.indexOf("adempiere") != -1) {
                    error.append(s).append("\n");
                    if (count == 0) {
                        StringBuilder source = new StringBuilder().append(element.getClassName()).append(".").append(element.getMethodName());
                        this.setSourceClassName(source.toString());
                        this.setLineNo(element.getLineNumber());
                    }
                    ++count;
                }
                if (count > 5 || error.length() > 2000) break;
                ++i2;
            }
            this.setErrorTrace(error.toString());
            CharArrayWriter cWriter = new CharArrayWriter();
            PrintWriter pWriter = new PrintWriter(cWriter);
            t.printStackTrace(pWriter);
            this.setStackTrace(cWriter.toString());
        }
        if (summary == null || summary.length() == 0) {
            summary = "??";
        }
        this.setIssueSummary(summary.toString());
        this.setRecord_ID(1);
    }

    public MIssue(Properties ctx, HashMap<String, String> hmIn) {
        super(ctx, 0, null);
        this.load(hmIn);
        this.setRecord_ID(0);
    }

    private void init(Properties ctx) throws Exception {
        MSystem system = MSystem.get(ctx);
        this.setName(system.getName());
        this.setUserName(system.getUserName());
        this.setDBAddress(system.getDBAddress());
        this.setSystemStatus(system.getSystemStatus());
        this.setReleaseNo(system.getReleaseNo());
        this.setVersion(Adempiere.DATE_VERSION);
        this.setDatabaseInfo(DB.getDatabaseInfo());
        this.setOperatingSystemInfo(Adempiere.getOSInfo());
        this.setJavaInfo(Adempiere.getJavaInfo());
        this.setReleaseTag(Adempiere.getImplementationVersion());
        this.setLocal_Host(InetAddress.getLocalHost().toString());
        if (system.isAllowStatistics()) {
            this.setStatisticsInfo(system.getStatisticsInfo(false));
            this.setProfileInfo(system.getProfileInfo(false));
        }
    }

    @Override
    public void setIssueSummary(String IssueSummary) {
        if (IssueSummary == null) {
            return;
        }
        IssueSummary = IssueSummary.replace("java.lang.", "");
        if ((IssueSummary = IssueSummary.replace("java.sql.", "")).length() > 2000) {
            IssueSummary = IssueSummary.substring(0, 1999);
        }
        super.setIssueSummary(IssueSummary);
    }

    @Override
    public void setStackTrace(String StackTrace) {
        if (StackTrace == null) {
            return;
        }
        StackTrace = StackTrace.replace("java.lang.", "");
        if ((StackTrace = StackTrace.replace("java.sql.", "")).length() > 2000) {
            StackTrace = StackTrace.substring(0, 1999);
        }
        super.setStackTrace(StackTrace);
    }

    @Override
    public void setErrorTrace(String ErrorTrace) {
        if (ErrorTrace == null) {
            return;
        }
        ErrorTrace = ErrorTrace.replace("java.lang.", "");
        if ((ErrorTrace = ErrorTrace.replace("java.sql.", "")).length() > 2000) {
            ErrorTrace = ErrorTrace.substring(0, 1999);
        }
        super.setErrorTrace(ErrorTrace);
    }

    public void addComments(String Comments) {
        if (Comments == null || Comments.length() == 0) {
            return;
        }
        String old = this.getComments();
        if (old == null || old.length() == 0) {
            this.setComments(Comments);
        } else if (!old.equals(Comments) && old.indexOf(Comments) == -1) {
            StringBuilder msgc = new StringBuilder(Comments).append(" | ").append(old);
            this.setComments(msgc.toString());
        }
    }

    @Override
    public void setComments(String Comments) {
        if (Comments == null) {
            return;
        }
        if (Comments.length() > 2000) {
            Comments = Comments.substring(0, 1999);
        }
        super.setComments(Comments);
    }

    @Override
    public void setResponseText(String ResponseText) {
        if (ResponseText == null) {
            return;
        }
        if (ResponseText.length() > 2000) {
            ResponseText = ResponseText.substring(0, 1999);
        }
        super.setResponseText(ResponseText);
    }

    public String process() {
        MIssueProject.get(this);
        MIssueSystem.get(this);
        MIssueUser.get(this);
        return this.createAnswer();
    }

    public String createAnswer() {
        StringBuilder sb = new StringBuilder();
        if (this.getA_Asset_ID() != 0) {
            sb.append("Sign up for support at http://www.adempiere.org to receive answers.");
        } else {
            if (this.getR_IssueKnown_ID() != 0) {
                sb.append("Known Issue\n");
            }
            if (this.getR_Request_ID() != 0) {
                sb.append("Request: ").append(this.getRequest().getDocumentNo()).append("\n");
            }
        }
        return sb.toString();
    }

    public X_R_Request getRequest() {
        if (this.getR_Request_ID() == 0) {
            return null;
        }
        return new X_R_Request(this.getCtx(), this.getR_Request_ID(), null);
    }

    @Override
    public String getRequestDocumentNo() {
        if (this.getR_Request_ID() == 0) {
            return "";
        }
        X_R_Request r = this.getRequest();
        return r.getDocumentNo();
    }

    @Override
    public String getSystemStatus() {
        String s = super.getSystemStatus();
        if (s == null || s.length() == 0) {
            s = "E";
        }
        return s;
    }

    public String report() {
        return "-";
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MIssue[");
        sb.append(this.get_ID()).append("-").append(this.getIssueSummary()).append(",Record=").append(this.getRecord_ID()).append("]");
        return sb.toString();
    }
}

