/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MPaySchedule;
import org.compiere.model.X_C_InvoicePaySchedule;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class MInvoicePaySchedule
extends X_C_InvoicePaySchedule {
    private static final long serialVersionUID = 4613382619117842586L;
    private static CLogger s_log = CLogger.getCLogger(MInvoicePaySchedule.class);
    private MInvoice m_parent = null;

    public static MInvoicePaySchedule[] getInvoicePaySchedule(Properties ctx, int C_Invoice_ID, int C_InvoicePaySchedule_ID, String trxName) {
        ArrayList<MInvoicePaySchedule> list;
        block10: {
            StringBuilder sql = new StringBuilder("SELECT * FROM C_InvoicePaySchedule ips WHERE IsActive='Y' ");
            if (C_Invoice_ID != 0) {
                sql.append("AND C_Invoice_ID=? ");
            } else {
                sql.append("AND EXISTS (SELECT * FROM C_InvoicePaySchedule x").append(" WHERE x.C_InvoicePaySchedule_ID=? AND ips.C_Invoice_ID=x.C_Invoice_ID) ");
            }
            sql.append("ORDER BY DueDate");
            list = new ArrayList<MInvoicePaySchedule>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), trxName);
                    if (C_Invoice_ID != 0) {
                        pstmt.setInt(1, C_Invoice_ID);
                    } else {
                        pstmt.setInt(1, C_InvoicePaySchedule_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MInvoicePaySchedule(ctx, rs, trxName));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, "getInvoicePaySchedule", e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MInvoicePaySchedule[] retValue = new MInvoicePaySchedule[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MInvoicePaySchedule(Properties ctx, int C_InvoicePaySchedule_ID, String trxName) {
        super(ctx, C_InvoicePaySchedule_ID, trxName);
        if (C_InvoicePaySchedule_ID == 0) {
            this.setIsValid(false);
        }
    }

    public MInvoicePaySchedule(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInvoicePaySchedule(MInvoice invoice, MPaySchedule paySchedule) {
        super(invoice.getCtx(), 0, invoice.get_TrxName());
        this.m_parent = invoice;
        this.setClientOrg(invoice);
        this.setC_Invoice_ID(invoice.getC_Invoice_ID());
        this.setC_PaySchedule_ID(paySchedule.getC_PaySchedule_ID());
        int scale = MCurrency.getStdPrecision(this.getCtx(), invoice.getC_Currency_ID());
        BigDecimal due = invoice.getGrandTotal();
        if (due.compareTo(Env.ZERO) == 0) {
            this.setDueAmt(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setIsValid(false);
        } else {
            due = due.multiply(paySchedule.getPercentage()).divide(Env.ONEHUNDRED, scale, RoundingMode.HALF_UP);
            this.setDueAmt(due);
            BigDecimal discount = due.multiply(paySchedule.getDiscount()).divide(Env.ONEHUNDRED, scale, RoundingMode.HALF_UP);
            this.setDiscountAmt(discount);
            this.setIsValid(true);
        }
        Timestamp dueDate = TimeUtil.addDays(invoice.getDateInvoiced(), paySchedule.getNetDays());
        this.setDueDate(dueDate);
        Timestamp discountDate = TimeUtil.addDays(invoice.getDateInvoiced(), paySchedule.getDiscountDays());
        this.setDiscountDate(discountDate);
    }

    public MInvoice getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void setParent(MInvoice parent) {
        this.m_parent = parent;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MInvoicePaySchedule[");
        sb.append(this.get_ID()).append("-Due=").append(this.getDueDate()).append("/").append(this.getDueAmt()).append(";Discount=").append(this.getDiscountDate()).append("/").append(this.getDiscountAmt()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.is_ValueChanged("DueAmt")) {
            this.log.fine("beforeSave");
            this.setIsValid(false);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (this.is_ValueChanged("DueAmt") || this.is_ValueChanged("IsActive")) {
            this.log.fine("afterSave");
            this.getParent();
            this.m_parent.validatePaySchedule();
            this.m_parent.saveEx();
        }
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        this.log.fine("afterDelete");
        this.getParent();
        this.m_parent.validatePaySchedule();
        this.m_parent.saveEx();
        return success;
    }
}

