/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.BPartnerNoAddressException;
import org.adempiere.exceptions.DBException;
import org.adempiere.exceptions.PeriodClosedException;
import org.adempiere.model.ITaxProvider;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MBankAccount;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MConversionRateUtil;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MDocTypeCounter;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoiceBatch;
import org.compiere.model.MInvoiceBatchLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoicePaySchedule;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrg;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentProcessor;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MPaymentTransaction;
import org.compiere.model.MPeriod;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductBOM;
import org.compiere.model.MProject;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.MRefList;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTax;
import org.compiere.model.MTaxProvider;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.POResultSet;
import org.compiere.model.Query;
import org.compiere.model.X_C_Invoice;
import org.compiere.model.X_C_Order;
import org.compiere.model.X_C_OrderLine;
import org.compiere.model.X_M_InOutLine;
import org.compiere.model.X_M_RMA;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class MInvoice
extends X_C_Invoice
implements DocAction {
    private static final long serialVersionUID = -9210893813732918522L;
    private static CCache<Integer, MInvoice> s_cache = new CCache("C_Invoice", 20, 2);
    private BigDecimal m_openAmt = null;
    private MInvoiceLine[] m_lines;
    private MInvoiceTax[] m_taxes;
    private static CLogger s_log = CLogger.getCLogger(MInvoice.class);
    private boolean m_reversal = false;
    private static volatile boolean recursiveCall = false;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    ArrayList<PO> docsPostProcess = new ArrayList();

    public static MInvoice[] getOfBPartner(Properties ctx, int C_BPartner_ID, String trxName) {
        List<MInvoice> list = new Query(ctx, "C_Invoice", "C_BPartner_ID=?", trxName).setParameters(C_BPartner_ID).list();
        return list.toArray(new MInvoice[list.size()]);
    }

    public static MInvoice copyFrom(MInvoice from, Timestamp dateDoc, Timestamp dateAcct, int C_DocTypeTarget_ID, boolean isSOTrx, boolean counter, String trxName, boolean setOrder) {
        return MInvoice.copyFrom(from, dateDoc, dateAcct, C_DocTypeTarget_ID, isSOTrx, counter, trxName, setOrder, null);
    }

    public static MInvoice copyFrom(MInvoice from, Timestamp dateDoc, Timestamp dateAcct, int C_DocTypeTarget_ID, boolean isSOTrx, boolean counter, String trxName, boolean setOrder, String documentNo) {
        MInvoice to = new MInvoice(from.getCtx(), 0, trxName);
        PO.copyValues(from, to, from.getAD_Client_ID(), from.getAD_Org_ID());
        to.set_ValueNoCheck("C_Invoice_ID", I_ZERO);
        to.set_ValueNoCheck("DocumentNo", documentNo);
        to.setDocStatus("DR");
        to.setDocAction("CO");
        to.setC_DocType_ID(0);
        to.setC_DocTypeTarget_ID(C_DocTypeTarget_ID);
        to.setIsSOTrx(isSOTrx);
        to.setDateInvoiced(dateDoc);
        to.setDateAcct(dateAcct);
        to.setDatePrinted(null);
        to.setIsPrinted(false);
        to.setIsApproved(false);
        to.setC_Payment_ID(0);
        to.setC_CashLine_ID(0);
        to.setIsPaid(false);
        to.setIsInDispute(false);
        to.setGrandTotal(Env.ZERO);
        to.setTotalLines(Env.ZERO);
        to.setIsTransferred(false);
        to.setPosted(false);
        to.setProcessed(false);
        to.setProcessing(false);
        to.setIsSelfService(false);
        if (!setOrder) {
            to.setC_Order_ID(0);
        }
        if (counter) {
            PO peer;
            to.setRef_Invoice_ID(from.getC_Invoice_ID());
            MOrg org = MOrg.get(from.getCtx(), from.getAD_Org_ID());
            int counterC_BPartner_ID = org.getLinkedC_BPartner_ID(trxName);
            if (counterC_BPartner_ID == 0) {
                return null;
            }
            to.setBPartner(MBPartner.get(from.getCtx(), counterC_BPartner_ID));
            if (from.getC_Order_ID() != 0 && ((X_C_Order)(peer = new MOrder(from.getCtx(), from.getC_Order_ID(), from.get_TrxName()))).getRef_Order_ID() != 0) {
                to.setC_Order_ID(((X_C_Order)peer).getRef_Order_ID());
            }
            if (from.getM_RMA_ID() != 0 && ((X_M_RMA)(peer = new MRMA(from.getCtx(), from.getM_RMA_ID(), from.get_TrxName()))).getRef_RMA_ID() > 0) {
                to.setM_RMA_ID(((X_M_RMA)peer).getRef_RMA_ID());
            }
        } else {
            to.setRef_Invoice_ID(0);
        }
        to.saveEx(trxName);
        if (counter) {
            from.setRef_Invoice_ID(to.getC_Invoice_ID());
        }
        if (to.copyLinesFrom(from, counter, setOrder) == 0) {
            throw new IllegalStateException("Could not create Invoice Lines");
        }
        return to;
    }

    public static MInvoice copyFrom(MInvoice from, Timestamp dateDoc, int C_DocTypeTarget_ID, boolean isSOTrx, boolean counter, String trxName, boolean setOrder) {
        MInvoice to = MInvoice.copyFrom(from, dateDoc, dateDoc, C_DocTypeTarget_ID, isSOTrx, counter, trxName, setOrder);
        return to;
    }

    public static String getPDFFileName(String documentDir, int C_Invoice_ID) {
        StringBuilder sb = new StringBuilder(documentDir);
        if (sb.length() == 0) {
            sb.append(".");
        }
        if (!sb.toString().endsWith(File.separator)) {
            sb.append(File.separator);
        }
        sb.append("C_Invoice_ID_").append(C_Invoice_ID).append(".pdf");
        return sb.toString();
    }

    public static MInvoice get(Properties ctx, int C_Invoice_ID) {
        Integer key = C_Invoice_ID;
        MInvoice retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MInvoice(ctx, C_Invoice_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MInvoice(Properties ctx, int C_Invoice_ID, String trxName) {
        super(ctx, C_Invoice_ID, trxName);
        if (C_Invoice_ID == 0) {
            this.setDocStatus("DR");
            this.setDocAction("CO");
            this.setPaymentRule("P");
            this.setDateInvoiced(new Timestamp(System.currentTimeMillis()));
            this.setDateAcct(new Timestamp(System.currentTimeMillis()));
            this.setChargeAmt(Env.ZERO);
            this.setTotalLines(Env.ZERO);
            this.setGrandTotal(Env.ZERO);
            this.setIsSOTrx(true);
            this.setIsTaxIncluded(false);
            this.setIsApproved(false);
            this.setIsDiscountPrinted(false);
            this.setIsPaid(false);
            this.setSendEMail(false);
            this.setIsPrinted(false);
            this.setIsTransferred(false);
            this.setIsSelfService(false);
            this.setIsPayScheduleValid(false);
            this.setIsInDispute(false);
            this.setPosted(false);
            super.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public MInvoice(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInvoice(MOrder order, int C_DocTypeTarget_ID, Timestamp invoiceDate) {
        this(order.getCtx(), 0, order.get_TrxName());
        MDocType odt;
        this.setClientOrg(order);
        this.setOrder(order);
        if (C_DocTypeTarget_ID <= 0 && (odt = MDocType.get(order.getCtx(), order.getC_DocType_ID())) != null && (C_DocTypeTarget_ID = odt.getC_DocTypeInvoice_ID()) <= 0) {
            throw new AdempiereException("@NotFound@ @C_DocTypeInvoice_ID@ - @C_DocType_ID@:" + odt.get_Translation("Name"));
        }
        this.setC_DocTypeTarget_ID(C_DocTypeTarget_ID);
        if (invoiceDate != null) {
            this.setDateInvoiced(invoiceDate);
        }
        this.setDateAcct(this.getDateInvoiced());
        this.setSalesRep_ID(order.getSalesRep_ID());
        this.setC_BPartner_ID(order.getBill_BPartner_ID());
        this.setC_BPartner_Location_ID(order.getBill_Location_ID());
        this.setAD_User_ID(order.getBill_User_ID());
    }

    public MInvoice(MInOut ship, Timestamp invoiceDate) {
        this(ship.getCtx(), 0, ship.get_TrxName());
        this.setClientOrg(ship);
        this.setShipment(ship);
        this.setC_DocTypeTarget_ID();
        if (invoiceDate != null) {
            this.setDateInvoiced(invoiceDate);
        }
        this.setDateAcct(this.getDateInvoiced());
        this.setSalesRep_ID(ship.getSalesRep_ID());
    }

    public MInvoice(MInvoiceBatch batch, MInvoiceBatchLine line) {
        this(line.getCtx(), 0, line.get_TrxName());
        this.setClientOrg(line);
        this.setDocumentNo(line.getDocumentNo());
        this.setIsSOTrx(batch.isSOTrx());
        MBPartner bp = new MBPartner(line.getCtx(), line.getC_BPartner_ID(), line.get_TrxName());
        this.setBPartner(bp);
        this.setIsTaxIncluded(line.isTaxIncluded());
        this.setC_Currency_ID(batch.getC_Currency_ID());
        this.setC_ConversionType_ID(batch.getC_ConversionType_ID());
        this.setDescription(batch.getDescription());
        this.setAD_OrgTrx_ID(line.getAD_OrgTrx_ID());
        this.setC_Project_ID(line.getC_Project_ID());
        this.setC_Activity_ID(line.getC_Activity_ID());
        this.setUser1_ID(line.getUser1_ID());
        this.setUser2_ID(line.getUser2_ID());
        this.setC_DocTypeTarget_ID(line.getC_DocType_ID());
        this.setDateInvoiced(line.getDateInvoiced());
        this.setDateAcct(line.getDateAcct());
        this.setSalesRep_ID(batch.getSalesRep_ID());
        this.setC_BPartner_ID(line.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(line.getC_BPartner_Location_ID());
        this.setAD_User_ID(line.getAD_User_ID());
    }

    @Override
    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    public void setBPartner(MBPartner bp) {
        MUser[] contacts;
        MBPartnerLocation[] locs;
        String ss;
        if (bp == null) {
            return;
        }
        this.setC_BPartner_ID(bp.getC_BPartner_ID());
        int ii = 0;
        ii = this.isSOTrx() ? bp.getC_PaymentTerm_ID() : bp.getPO_PaymentTerm_ID();
        if (ii != 0) {
            this.setC_PaymentTerm_ID(ii);
        }
        if ((ii = this.isSOTrx() ? bp.getM_PriceList_ID() : bp.getPO_PriceList_ID()) != 0) {
            this.setM_PriceList_ID(ii);
        }
        if ((ss = bp.getPaymentRule()) != null) {
            this.setPaymentRule(ss);
        }
        if ((locs = bp.getLocations(false)) != null) {
            int i2 = 0;
            while (i2 < locs.length) {
                if (locs[i2].isBillTo() && this.isSOTrx() || locs[i2].isPayFrom() && !this.isSOTrx()) {
                    this.setC_BPartner_Location_ID(locs[i2].getC_BPartner_Location_ID());
                }
                ++i2;
            }
            if (this.getC_BPartner_Location_ID() == 0 && locs.length > 0) {
                this.setC_BPartner_Location_ID(locs[0].getC_BPartner_Location_ID());
            }
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            this.log.log(Level.SEVERE, new BPartnerNoAddressException(bp).getLocalizedMessage());
        }
        if ((contacts = bp.getContacts(false)) != null && contacts.length > 0) {
            this.setAD_User_ID(contacts[0].getAD_User_ID());
        }
    }

    public void setOrder(MOrder order) {
        if (order == null) {
            return;
        }
        this.setC_Order_ID(order.getC_Order_ID());
        this.setIsSOTrx(order.isSOTrx());
        this.setIsDiscountPrinted(order.isDiscountPrinted());
        this.setIsSelfService(order.isSelfService());
        this.setSendEMail(order.isSendEMail());
        this.setM_PriceList_ID(order.getM_PriceList_ID());
        this.setIsTaxIncluded(order.isTaxIncluded());
        this.setC_Currency_ID(order.getC_Currency_ID());
        this.setC_ConversionType_ID(order.getC_ConversionType_ID());
        this.setPaymentRule(order.getPaymentRule());
        this.setC_PaymentTerm_ID(order.getC_PaymentTerm_ID());
        this.setPOReference(order.getPOReference());
        this.setDescription(order.getDescription());
        this.setDateOrdered(order.getDateOrdered());
        this.setAD_OrgTrx_ID(order.getAD_OrgTrx_ID());
        this.setC_Project_ID(order.getC_Project_ID());
        this.setC_Campaign_ID(order.getC_Campaign_ID());
        this.setC_Activity_ID(order.getC_Activity_ID());
        this.setUser1_ID(order.getUser1_ID());
        this.setUser2_ID(order.getUser2_ID());
    }

    public void setShipment(MInOut ship) {
        MDocType dt;
        if (ship == null) {
            return;
        }
        this.setIsSOTrx(ship.isSOTrx());
        MBPartner bp = new MBPartner(this.getCtx(), ship.getC_BPartner_ID(), null);
        this.setBPartner(bp);
        this.setAD_User_ID(ship.getAD_User_ID());
        this.setSendEMail(ship.isSendEMail());
        this.setPOReference(ship.getPOReference());
        this.setDescription(ship.getDescription());
        this.setDateOrdered(ship.getDateOrdered());
        this.setAD_OrgTrx_ID(ship.getAD_OrgTrx_ID());
        this.setC_Project_ID(ship.getC_Project_ID());
        this.setC_Campaign_ID(ship.getC_Campaign_ID());
        this.setC_Activity_ID(ship.getC_Activity_ID());
        this.setUser1_ID(ship.getUser1_ID());
        this.setUser2_ID(ship.getUser2_ID());
        if (ship.getC_Order_ID() != 0) {
            this.setC_Order_ID(ship.getC_Order_ID());
            MOrder order = new MOrder(this.getCtx(), ship.getC_Order_ID(), this.get_TrxName());
            this.setIsDiscountPrinted(order.isDiscountPrinted());
            this.setM_PriceList_ID(order.getM_PriceList_ID());
            this.setIsTaxIncluded(order.isTaxIncluded());
            this.setC_Currency_ID(order.getC_Currency_ID());
            this.setC_ConversionType_ID(order.getC_ConversionType_ID());
            this.setPaymentRule(order.getPaymentRule());
            this.setC_PaymentTerm_ID(order.getC_PaymentTerm_ID());
            dt = MDocType.get(this.getCtx(), order.getC_DocType_ID());
            if (dt.getC_DocTypeInvoice_ID() != 0) {
                this.setC_DocTypeTarget_ID(dt.getC_DocTypeInvoice_ID());
            }
            this.setC_BPartner_ID(order.getBill_BPartner_ID());
            this.setC_BPartner_Location_ID(order.getBill_Location_ID());
            this.setAD_User_ID(order.getBill_User_ID());
        }
        if (ship.getM_RMA_ID() != 0) {
            this.setM_RMA_ID(ship.getM_RMA_ID());
            MRMA rma = new MRMA(this.getCtx(), ship.getM_RMA_ID(), this.get_TrxName());
            dt = MDocType.get(this.getCtx(), rma.getC_DocType_ID());
            if (dt.getC_DocTypeInvoice_ID() != 0) {
                this.setC_DocTypeTarget_ID(dt.getC_DocTypeInvoice_ID());
            }
            this.setIsSOTrx(rma.isSOTrx());
            MOrder rmaOrder = rma.getOriginalOrder();
            if (rmaOrder != null) {
                this.setM_PriceList_ID(rmaOrder.getM_PriceList_ID());
                this.setIsTaxIncluded(rmaOrder.isTaxIncluded());
                this.setC_Currency_ID(rmaOrder.getC_Currency_ID());
                this.setC_ConversionType_ID(rmaOrder.getC_ConversionType_ID());
                this.setPaymentRule(rmaOrder.getPaymentRule());
                this.setC_PaymentTerm_ID(rmaOrder.getC_PaymentTerm_ID());
                this.setC_BPartner_Location_ID(rmaOrder.getBill_Location_ID());
            }
        }
    }

    public void setC_DocTypeTarget_ID(String DocBaseType) {
        String sql = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID=? AND AD_Org_ID in (0,?) AND DocBaseType=? AND IsActive='Y' ORDER BY IsDefault DESC, AD_Org_ID DESC";
        int C_DocType_ID = DB.getSQLValueEx(null, sql, this.getAD_Client_ID(), this.getAD_Org_ID(), DocBaseType);
        if (C_DocType_ID <= 0) {
            this.log.log(Level.SEVERE, "Not found for AD_Client_ID=" + this.getAD_Client_ID() + " - " + DocBaseType);
        } else {
            this.log.fine(DocBaseType);
            this.setC_DocTypeTarget_ID(C_DocType_ID);
            boolean isSOTrx = "ARI".equals(DocBaseType) || "ARC".equals(DocBaseType);
            this.setIsSOTrx(isSOTrx);
        }
    }

    public void setC_DocTypeTarget_ID() {
        if (this.getC_DocTypeTarget_ID() > 0) {
            return;
        }
        if (this.isSOTrx()) {
            this.setC_DocTypeTarget_ID("ARI");
        } else {
            this.setC_DocTypeTarget_ID("API");
        }
    }

    public BigDecimal getGrandTotal(boolean creditMemoAdjusted) {
        if (!creditMemoAdjusted) {
            return super.getGrandTotal();
        }
        BigDecimal amt = this.getGrandTotal();
        if (this.isCreditMemo()) {
            return amt.negate();
        }
        return amt;
    }

    public BigDecimal getTotalLines(boolean creditMemoAdjusted) {
        if (!creditMemoAdjusted) {
            return super.getTotalLines();
        }
        BigDecimal amt = this.getTotalLines();
        if (this.isCreditMemo()) {
            return amt.negate();
        }
        return amt;
    }

    private MInvoiceLine[] getLines(String whereClause) {
        String whereClauseFinal = "C_Invoice_ID=? ";
        if (whereClause != null) {
            whereClauseFinal = String.valueOf(whereClauseFinal) + whereClause;
        }
        List<MInvoiceLine> list = new Query(this.getCtx(), "C_InvoiceLine", whereClauseFinal, this.get_TrxName()).setParameters(this.getC_Invoice_ID()).setOrderBy("Line, C_InvoiceLine_ID").list();
        return list.toArray(new MInvoiceLine[list.size()]);
    }

    public MInvoiceLine[] getLines(boolean requery) {
        if (this.m_lines == null || this.m_lines.length == 0 || requery) {
            this.m_lines = this.getLines(null);
        }
        MInvoice.set_TrxName(this.m_lines, this.get_TrxName());
        return this.m_lines;
    }

    public MInvoiceLine[] getLines() {
        return this.getLines(false);
    }

    public void renumberLines(int step) {
        int number = step;
        MInvoiceLine[] lines = this.getLines(false);
        int i2 = 0;
        while (i2 < lines.length) {
            MInvoiceLine line = lines[i2];
            line.setLine(number);
            line.saveEx();
            number += step;
            ++i2;
        }
        this.m_lines = null;
    }

    public int copyLinesFrom(MInvoice otherInvoice, boolean counter, boolean setOrder) {
        if (this.isProcessed() || this.isPosted() || otherInvoice == null) {
            return 0;
        }
        MInvoiceLine[] fromLines = otherInvoice.getLines(false);
        int count = 0;
        int i2 = 0;
        while (i2 < fromLines.length) {
            MInvoiceLine line = new MInvoiceLine(this.getCtx(), 0, this.get_TrxName());
            MInvoiceLine fromLine = fromLines[i2];
            if (counter) {
                PO.copyValues(fromLine, line, this.getAD_Client_ID(), this.getAD_Org_ID());
            } else {
                PO.copyValues(fromLine, line, fromLine.getAD_Client_ID(), fromLine.getAD_Org_ID());
            }
            line.setC_Invoice_ID(this.getC_Invoice_ID());
            line.setInvoice(this);
            line.set_ValueNoCheck("C_InvoiceLine_ID", I_ZERO);
            if (!setOrder) {
                line.setC_OrderLine_ID(0);
            }
            line.setRef_InvoiceLine_ID(0);
            line.setM_InOutLine_ID(0);
            line.setA_Asset_ID(0);
            line.setM_AttributeSetInstance_ID(0);
            line.setS_ResourceAssignment_ID(0);
            if (this.getC_BPartner_ID() != otherInvoice.getC_BPartner_ID()) {
                line.setTax();
            }
            if (counter) {
                PO peer;
                line.setRef_InvoiceLine_ID(fromLine.getC_InvoiceLine_ID());
                if (fromLine.getC_OrderLine_ID() != 0 && ((X_C_OrderLine)(peer = new MOrderLine(this.getCtx(), fromLine.getC_OrderLine_ID(), this.get_TrxName()))).getRef_OrderLine_ID() != 0) {
                    line.setC_OrderLine_ID(((X_C_OrderLine)peer).getRef_OrderLine_ID());
                }
                line.setM_InOutLine_ID(0);
                if (fromLine.getM_InOutLine_ID() != 0 && ((X_M_InOutLine)(peer = new MInOutLine(this.getCtx(), fromLine.getM_InOutLine_ID(), this.get_TrxName()))).getRef_InOutLine_ID() != 0) {
                    line.setM_InOutLine_ID(((X_M_InOutLine)peer).getRef_InOutLine_ID());
                }
            }
            line.setProcessed(false);
            if (line.save(this.get_TrxName())) {
                ++count;
            }
            if (counter) {
                fromLine.setRef_InvoiceLine_ID(line.getC_InvoiceLine_ID());
                fromLine.saveEx(this.get_TrxName());
            }
            line.copyLandedCostFrom(fromLine);
            line.allocateLandedCosts();
            ++i2;
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "Line difference - From=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    private void setReversal(boolean reversal) {
        this.m_reversal = reversal;
    }

    public boolean isReversal() {
        return this.m_reversal;
    }

    public MInvoiceTax[] getTaxes(boolean requery) {
        if (this.m_taxes != null && !requery) {
            return this.m_taxes;
        }
        String whereClause = "C_Invoice_ID=?";
        List<MInvoiceTax> list = new Query(this.getCtx(), "C_InvoiceTax", "C_Invoice_ID=?", this.get_TrxName()).setParameters(this.get_ID()).list();
        this.m_taxes = list.toArray(new MInvoiceTax[list.size()]);
        return this.m_taxes;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            StringBuilder msgd = new StringBuilder(desc).append(" | ").append(description);
            this.setDescription(msgd.toString());
        }
    }

    public boolean isCreditMemo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID() == 0 ? this.getC_DocTypeTarget_ID() : this.getC_DocType_ID());
        return "APC".equals(dt.getDocBaseType()) || "ARC".equals(dt.getDocBaseType());
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        StringBuilder set = new StringBuilder("SET Processed='").append(processed ? "Y" : "N").append("' WHERE C_Invoice_ID=").append(this.getC_Invoice_ID());
        StringBuilder msgdb = new StringBuilder("UPDATE C_InvoiceLine ").append((CharSequence)set);
        int noLine = DB.executeUpdate(msgdb.toString(), this.get_TrxName());
        msgdb = new StringBuilder("UPDATE C_InvoiceTax ").append((CharSequence)set);
        int noTax = DB.executeUpdate(msgdb.toString(), this.get_TrxName());
        this.m_lines = null;
        this.m_taxes = null;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(processed) + " - Lines=" + noLine + ", Tax=" + noTax);
        }
    }

    public boolean validatePaySchedule() {
        MInvoicePaySchedule[] schedule = MInvoicePaySchedule.getInvoicePaySchedule(this.getCtx(), this.getC_Invoice_ID(), 0, this.get_TrxName());
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + schedule.length);
        }
        if (schedule.length == 0) {
            this.setIsPayScheduleValid(false);
            return false;
        }
        BigDecimal total = Env.ZERO;
        int i2 = 0;
        while (i2 < schedule.length) {
            schedule[i2].setParent(this);
            BigDecimal due = schedule[i2].getDueAmt();
            if (due != null) {
                total = total.add(due);
            }
            ++i2;
        }
        boolean valid = this.getGrandTotal().compareTo(total) == 0;
        this.setIsPayScheduleValid(valid);
        int i3 = 0;
        while (i3 < schedule.length) {
            if (schedule[i3].isValid() != valid) {
                schedule[i3].setIsValid(valid);
                schedule[i3].saveEx(this.get_TrxName());
            }
            ++i3;
        }
        return valid;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        int cnt;
        MOrder order;
        int ii;
        this.log.fine("");
        if (this.getC_BPartner_ID() == 0) {
            this.setBPartner(MBPartner.getTemplate(this.getCtx(), this.getAD_Client_ID()));
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            this.setBPartner(new MBPartner(this.getCtx(), this.getC_BPartner_ID(), null));
        }
        if (this.getM_PriceList_ID() == 0) {
            String sql;
            int ii2 = Env.getContextAsInt(this.getCtx(), "#M_PriceList_ID");
            if (ii2 != 0) {
                MPriceList pl = new MPriceList(this.getCtx(), ii2, null);
                if (this.isSOTrx() == pl.isSOPriceList()) {
                    this.setM_PriceList_ID(ii2);
                }
            }
            if (this.getM_PriceList_ID() == 0 && (ii2 = DB.getSQLValue(null, sql = "SELECT M_PriceList_ID FROM M_PriceList WHERE AD_Client_ID=? AND IsSOPriceList=? AND IsActive='Y' ORDER BY IsDefault DESC", this.getAD_Client_ID(), this.isSOTrx())) != 0) {
                this.setM_PriceList_ID(ii2);
            }
        }
        if (this.getC_Currency_ID() == 0) {
            String sql = "SELECT C_Currency_ID FROM M_PriceList WHERE M_PriceList_ID=?";
            int ii3 = DB.getSQLValue(null, sql, this.getM_PriceList_ID());
            if (ii3 != 0) {
                this.setC_Currency_ID(ii3);
            } else {
                this.setC_Currency_ID(Env.getContextAsInt(this.getCtx(), "#C_Currency_ID"));
            }
        }
        if (this.getSalesRep_ID() == 0 && (ii = Env.getContextAsInt(this.getCtx(), "#SalesRep_ID")) != 0) {
            this.setSalesRep_ID(ii);
        }
        if (this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID(0);
        }
        if (this.getC_DocTypeTarget_ID() == 0) {
            this.setC_DocTypeTarget_ID(this.isSOTrx() ? "ARI" : "API");
        }
        if (this.getC_PaymentTerm_ID() == 0) {
            ii = Env.getContextAsInt(this.getCtx(), "#C_PaymentTerm_ID");
            if (ii != 0) {
                this.setC_PaymentTerm_ID(ii);
            } else {
                String sql = "SELECT C_PaymentTerm_ID FROM C_PaymentTerm WHERE AD_Client_ID=? AND IsDefault='Y' AND IsActive='Y'";
                ii = DB.getSQLValue(null, sql, this.getAD_Client_ID());
                if (ii != 0) {
                    this.setC_PaymentTerm_ID(ii);
                }
            }
        }
        if (this.getC_Order_ID() > 0 && this.getC_CashPlanLine_ID() <= 0 && (order = new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName())).getC_CashPlanLine_ID() > 0) {
            this.setC_CashPlanLine_ID(order.getC_CashPlanLine_ID());
        }
        if (!newRecord && (this.is_ValueChanged("M_PriceList_ID") || this.is_ValueChanged("DateInvoiced")) && (cnt = DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM C_InvoiceLine WHERE C_Invoice_ID=? AND M_Product_ID>0", this.getC_Invoice_ID())) > 0) {
            if (this.is_ValueChanged("M_PriceList_ID")) {
                this.log.saveError("Error", Msg.getMsg(this.getCtx(), "CannotChangePlIn"));
                return false;
            }
            if (this.is_ValueChanged("DateInvoiced")) {
                MPriceList pList = MPriceList.get(this.getCtx(), this.getM_PriceList_ID(), null);
                MPriceListVersion plOld = pList.getPriceListVersion((Timestamp)this.get_ValueOld("DateInvoiced"));
                MPriceListVersion plNew = pList.getPriceListVersion((Timestamp)this.get_Value("DateInvoiced"));
                if (plNew == null || !plNew.equals(plOld)) {
                    this.log.saveError("Error", Msg.getMsg(this.getCtx(), "CannotChangeDateInvoiced"));
                    return false;
                }
            }
        }
        if (!recursiveCall && !newRecord && this.is_ValueChanged("C_PaymentTerm_ID")) {
            recursiveCall = true;
            try {
                MPaymentTerm pt = new MPaymentTerm(this.getCtx(), this.getC_PaymentTerm_ID(), this.get_TrxName());
                boolean valid = pt.apply(this);
                this.setIsPayScheduleValid(valid);
            }
            finally {
                recursiveCall = false;
            }
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.getC_Order_ID() != 0) {
            this.getLines();
        }
        return true;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        if (this.getC_Order_ID() != 0) {
            MInvoiceLine[] lines = this.getLines(false);
            int i2 = 0;
            while (i2 < lines.length) {
                if (lines[i2].getM_InOutLine_ID() > 0) {
                    MInOutLine sLine = new MInOutLine(this.getCtx(), lines[i2].getM_InOutLine_ID(), this.get_TrxName());
                    sLine.setIsInvoiced(false);
                    sLine.saveEx();
                }
                ++i2;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MInvoice[").append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",GrandTotal=").append(this.getGrandTotal());
        if (this.m_lines != null) {
            sb.append(" (#").append(this.m_lines.length).append(")");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        StringBuilder msgreturn = new StringBuilder().append(dt.getNameTrl()).append(" ").append(this.getDocumentNo());
        return msgreturn.toString();
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success || newRecord) {
            return success;
        }
        if (this.is_ValueChanged("AD_Org_ID")) {
            StringBuilder sql = new StringBuilder("UPDATE C_InvoiceLine ol").append(" SET AD_Org_ID =").append("(SELECT AD_Org_ID").append(" FROM C_Invoice o WHERE ol.C_Invoice_ID=o.C_Invoice_ID) ").append("WHERE C_Invoice_ID=").append(this.getC_Invoice_ID());
            int no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Lines -> #" + no);
            }
        }
        return true;
    }

    @Override
    public void setM_PriceList_ID(int M_PriceList_ID) {
        MPriceList pl = MPriceList.get(this.getCtx(), M_PriceList_ID, null);
        if (pl != null) {
            this.setC_Currency_ID(pl.getC_Currency_ID());
            super.setM_PriceList_ID(M_PriceList_ID);
        }
    }

    public BigDecimal getAllocatedAmt() {
        BigDecimal retValue = null;
        String sql = "SELECT SUM(currencyConvert(al.Amount+al.DiscountAmt+al.WriteOffAmt,ah.C_Currency_ID, i.C_Currency_ID,ah.DateTrx,COALESCE(i.C_ConversionType_ID,0), al.AD_Client_ID,al.AD_Org_ID)) FROM C_AllocationLine al INNER JOIN C_AllocationHdr ah ON (al.C_AllocationHdr_ID=ah.C_AllocationHdr_ID) INNER JOIN C_Invoice i ON (al.C_Invoice_ID=i.C_Invoice_ID) WHERE al.C_Invoice_ID=? AND ah.IsActive='Y' AND al.IsActive='Y'";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, this.getC_Invoice_ID());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    retValue = rs.getBigDecimal(1);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return retValue;
    }

    public boolean testAllocation(boolean beingCompleted) {
        boolean change = false;
        if (this.isProcessed() || beingCompleted) {
            boolean test;
            BigDecimal alloc = this.getAllocatedAmt();
            if (alloc == null) {
                alloc = Env.ZERO;
            }
            BigDecimal total = this.getGrandTotal();
            if (!this.isSOTrx()) {
                total = total.negate();
            }
            if (this.isCreditMemo()) {
                total = total.negate();
            }
            if (change = (test = total.compareTo(alloc) == 0) ^ this.isPaid()) {
                this.setIsPaid(test);
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Paid=" + test + " (" + alloc + "=" + total + ")");
            }
        }
        return change;
    }

    public boolean testAllocation() {
        return this.testAllocation(false);
    }

    public static void setIsPaid(Properties ctx, int C_BPartner_ID, String trxName) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuilder whereClause = new StringBuilder("IsPaid='N' AND DocStatus IN ('CO','CL')");
        if (C_BPartner_ID > 1) {
            whereClause.append(" AND C_BPartner_ID=?");
            params.add(C_BPartner_ID);
        } else {
            whereClause.append(" AND AD_Client_ID=?");
            params.add(Env.getAD_Client_ID(ctx));
        }
        POResultSet rs = new Query(ctx, "C_Invoice", whereClause.toString(), trxName).setParameters(params).scroll();
        int counter = 0;
        try {
            while (rs.hasNext()) {
                MInvoice invoice = (MInvoice)rs.next();
                if (!invoice.testAllocation() || !invoice.save()) continue;
                ++counter;
            }
        }
        finally {
            DB.close(rs);
        }
        if (s_log.isLoggable(Level.CONFIG)) {
            s_log.config("#" + counter);
        }
    }

    public BigDecimal getOpenAmt() {
        return this.getOpenAmt(true, null);
    }

    public BigDecimal getOpenAmt(boolean creditMemoAdjusted, Timestamp paymentDate) {
        if (this.isPaid()) {
            return Env.ZERO;
        }
        if (this.m_openAmt == null) {
            this.m_openAmt = this.getGrandTotal();
            BigDecimal allocated = this.getAllocatedAmt();
            if (allocated != null) {
                allocated = allocated.abs();
                this.m_openAmt = this.m_openAmt.subtract(allocated);
            }
        }
        if (!creditMemoAdjusted) {
            return this.m_openAmt;
        }
        if (this.isCreditMemo()) {
            return this.m_openAmt.negate();
        }
        return this.m_openAmt;
    }

    public String getDocStatusName() {
        return MRefList.getListName(this.getCtx(), 131, this.getDocStatus());
    }

    @Override
    public File createPDF() {
        try {
            StringBuilder msgfile = new StringBuilder().append(this.get_TableName()).append(this.get_ID()).append("_");
            File temp = File.createTempFile(msgfile.toString(), ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        ReportEngine re = ReportEngine.get(this.getCtx(), 2, this.getC_Invoice_ID(), this.get_TrxName());
        if (re == null) {
            return null;
        }
        MPrintFormat format = re.getPrintFormat();
        if (format.getJasperProcess_ID() > 0) {
            ProcessInfo pi = new ProcessInfo("", format.getJasperProcess_ID());
            pi.setRecord_ID(this.getC_Invoice_ID());
            pi.setIsBatch(true);
            ServerProcessCtl.process(pi, null);
            return pi.getPDFReport();
        }
        return re.getPDF(file);
    }

    public String getPDFFileName(String documentDir) {
        return MInvoice.getPDFFileName(documentDir, this.getC_Invoice_ID());
    }

    public String getCurrencyISO() {
        return MCurrency.getISO_Code(this.getCtx(), this.getC_Currency_ID());
    }

    public int getPrecision() {
        return MCurrency.getStdPrecision(this.getCtx(), this.getC_Currency_ID());
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("unlockIt - " + this.toString());
        }
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("invalidateIt - " + this.toString());
        }
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        MBPartner bp;
        MDocType doc;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), this.getC_DocTypeTarget_ID(), this.getAD_Org_ID());
        MInvoiceLine[] lines = this.getLines(true);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        if (this.getC_DocType_ID() != this.getC_DocTypeTarget_ID()) {
            this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
        }
        if (this.getC_DocType_ID() == 0) {
            this.m_processMsg = "No Document Type";
            return "IN";
        }
        this.explodeBOM();
        if (!this.calculateTaxTotal()) {
            this.m_processMsg = "Error calculating Tax";
            return "IN";
        }
        if (this.getGrandTotal().signum() != 0 && ("P".equals(this.getPaymentRule()) || "D".equals(this.getPaymentRule()))) {
            if (!this.createPaySchedule()) {
                this.m_processMsg = "@ErrorPaymentSchedule@";
                return "IN";
            }
        } else if (MInvoicePaySchedule.getInvoicePaySchedule(this.getCtx(), this.getC_Invoice_ID(), 0, this.get_TrxName()).length > 0) {
            this.m_processMsg = "@ErrorPaymentSchedule@";
            return "IN";
        }
        if (this.isSOTrx() && ((doc = (MDocType)this.getC_DocTypeTarget()).getDocBaseType().equals("ARC") && this.getGrandTotal().signum() < 0 || doc.getDocBaseType().equals("ARI") && this.getGrandTotal().signum() > 0) && "S".equals((bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), null)).getSOCreditStatus())) {
            this.m_processMsg = "@BPartnerCreditStop@ - @TotalOpenBalance@=" + bp.getTotalOpenBalance() + ", @SO_CreditLimit@=" + bp.getSO_CreditLimit();
            return "IN";
        }
        if (!this.isSOTrx()) {
            int i2 = 0;
            while (i2 < lines.length) {
                MInvoiceLine line = lines[i2];
                String error = line.allocateLandedCosts();
                if (error != null && error.length() > 0) {
                    this.m_processMsg = error;
                    return "IN";
                }
                ++i2;
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    private void explodeBOM() {
        String where = "AND IsActive='Y' AND EXISTS (SELECT * FROM M_Product p WHERE C_InvoiceLine.M_Product_ID=p.M_Product_ID AND\tp.IsBOM='Y' AND p.IsVerified='Y' AND p.IsStocked='N')";
        String sql = "SELECT COUNT(*) FROM C_InvoiceLine WHERE C_Invoice_ID=? " + where;
        int count = DB.getSQLValueEx(this.get_TrxName(), sql, this.getC_Invoice_ID());
        while (count != 0) {
            this.renumberLines(100);
            MInvoiceLine[] lines = this.getLines(where);
            int i2 = 0;
            while (i2 < lines.length) {
                MInvoiceLine line = lines[i2];
                MProduct product = MProduct.get(this.getCtx(), line.getM_Product_ID());
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(product.getName());
                }
                int lineNo = line.getLine();
                MProductBOM[] mProductBOMArray = MProductBOM.getBOMLines(product);
                int n = mProductBOMArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MProductBOM bom = mProductBOMArray[n2];
                    MInvoiceLine newLine = new MInvoiceLine(this);
                    newLine.setLine(++lineNo);
                    newLine.setM_Product_ID(bom.getM_ProductBOM_ID(), true);
                    newLine.setQty(line.getQtyInvoiced().multiply(bom.getBOMQty()));
                    if (bom.getDescription() != null) {
                        newLine.setDescription(bom.getDescription());
                    }
                    newLine.setPrice();
                    newLine.saveEx(this.get_TrxName());
                    ++n2;
                }
                line.setM_Product_ID(0);
                line.setM_AttributeSetInstance_ID(0);
                line.setPriceEntered(Env.ZERO);
                line.setPriceActual(Env.ZERO);
                line.setPriceLimit(Env.ZERO);
                line.setPriceList(Env.ZERO);
                line.setLineNetAmt(Env.ZERO);
                StringBuilder description = new StringBuilder().append(product.getName());
                if (product.getDescription() != null) {
                    description.append(" ").append(product.getDescription());
                }
                if (line.getDescription() != null) {
                    description.append(" ").append(line.getDescription());
                }
                line.setDescription(description.toString());
                line.saveEx(this.get_TrxName());
                ++i2;
            }
            this.m_lines = null;
            count = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Invoice_ID());
            this.renumberLines(10);
        }
    }

    public boolean calculateTaxTotal() {
        MTaxProvider[] providers;
        this.log.fine("");
        StringBuilder msgdb = new StringBuilder("DELETE C_InvoiceTax WHERE C_Invoice_ID=").append(this.getC_Invoice_ID());
        DB.executeUpdateEx(msgdb.toString(), this.get_TrxName());
        this.m_taxes = null;
        MTaxProvider[] mTaxProviderArray = providers = this.getTaxProviders();
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            MTaxProvider provider = mTaxProviderArray[n2];
            ITaxProvider calculator = Core.getTaxProvider(provider);
            if (calculator == null) {
                throw new AdempiereException(Msg.getMsg(this.getCtx(), "TaxNoProvider"));
            }
            if (!calculator.calculateInvoiceTaxTotal(provider, this)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean createPaySchedule() {
        if (this.getC_PaymentTerm_ID() == 0) {
            return false;
        }
        MPaymentTerm pt = new MPaymentTerm(this.getCtx(), this.getC_PaymentTerm_ID(), null);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(pt.toString());
        }
        int numSchema = pt.getSchedule(false).length;
        MInvoicePaySchedule[] schedule = MInvoicePaySchedule.getInvoicePaySchedule(this.getCtx(), this.getC_Invoice_ID(), 0, this.get_TrxName());
        if (schedule.length > 0) {
            if (numSchema == 0) {
                return false;
            }
            return this.validatePaySchedule();
        }
        boolean isValid = pt.apply(this);
        if (numSchema == 0) {
            return true;
        }
        return isValid;
    }

    @Override
    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String valid;
        if (!this.m_justPrepared) {
            String status = this.prepareIt();
            this.m_justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.setDefiniteDocumentNo();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        StringBuilder info = new StringBuilder();
        boolean fromPOS = false;
        if (this.getC_Order_ID() > 0) {
            boolean bl = fromPOS = this.getC_Order().getC_POS_ID() > 0;
        }
        if ("B".equals(this.getPaymentRule()) && !fromPOS) {
            String whereClause = "AD_Org_ID=? AND C_Currency_ID=?";
            MBankAccount ba = (MBankAccount)new Query(this.getCtx(), "C_BankAccount", whereClause, this.get_TrxName()).setParameters(this.getAD_Org_ID(), this.getC_Currency_ID()).setOnlyActiveRecords(true).setOrderBy("IsDefault DESC").first();
            if (ba == null) {
                this.m_processMsg = "@NoAccountOrgCurrency@";
                return "IN";
            }
            String docBaseType = "";
            docBaseType = this.isSOTrx() ? "ARR" : "APP";
            MDocType[] doctypes = MDocType.getOfDocBaseType(this.getCtx(), docBaseType);
            if (doctypes == null || doctypes.length == 0) {
                this.m_processMsg = "No document type ";
                return "IN";
            }
            MDocType doctype = null;
            MDocType[] mDocTypeArray = doctypes;
            int n = doctypes.length;
            int n2 = 0;
            while (n2 < n) {
                MDocType doc = mDocTypeArray[n2];
                if (doc.getAD_Org_ID() == this.getAD_Org_ID()) {
                    doctype = doc;
                    break;
                }
                ++n2;
            }
            if (doctype == null) {
                doctype = doctypes[0];
            }
            MPayment payment = new MPayment(this.getCtx(), 0, this.get_TrxName());
            payment.setAD_Org_ID(this.getAD_Org_ID());
            payment.setTenderType("X");
            payment.setC_BankAccount_ID(ba.getC_BankAccount_ID());
            payment.setC_BPartner_ID(this.getC_BPartner_ID());
            payment.setC_Invoice_ID(this.getC_Invoice_ID());
            payment.setC_Currency_ID(this.getC_Currency_ID());
            payment.setC_DocType_ID(doctype.getC_DocType_ID());
            if (this.isCreditMemo()) {
                payment.setPayAmt(this.getGrandTotal().negate());
            } else {
                payment.setPayAmt(this.getGrandTotal());
            }
            payment.setIsPrepayment(false);
            payment.setDateAcct(this.getDateAcct());
            payment.setDateTrx(this.getDateInvoiced());
            payment.saveEx();
            payment.setDocAction("CO");
            if (!payment.processIt("CO")) {
                this.m_processMsg = "Cannot Complete the Payment : [" + payment.getProcessMsg() + "] " + payment;
                return "IN";
            }
            payment.saveEx();
            info.append("@C_Payment_ID@: " + payment.getDocumentInfo());
            if (payment.getJustCreatedAllocInv() != null) {
                this.addDocsPostProcess(payment.getJustCreatedAllocInv());
            }
        }
        int matchInv = 0;
        int matchPO = 0;
        MInvoiceLine[] lines = this.getLines(false);
        int i2 = 0;
        while (i2 < lines.length) {
            MInvoiceLine line = lines[i2];
            if (!this.isSOTrx() && line.getM_InOutLine_ID() != 0 && line.getM_Product_ID() != 0 && !this.isReversal()) {
                MMatchInv inv;
                MInOutLine receiptLine = new MInOutLine(this.getCtx(), line.getM_InOutLine_ID(), this.get_TrxName());
                BigDecimal matchQty = line.getQtyInvoiced();
                if (receiptLine.getMovementQty().compareTo(matchQty) < 0) {
                    matchQty = receiptLine.getMovementQty();
                }
                if (!(inv = new MMatchInv(line, this.getDateInvoiced(), matchQty)).save(this.get_TrxName())) {
                    this.m_processMsg = CLogger.retrieveErrorString("Could not create Invoice Matching");
                    return "IN";
                }
                ++matchInv;
                this.addDocsPostProcess(inv);
            }
            MOrderLine ol = null;
            if (line.getC_OrderLine_ID() != 0) {
                if (this.isSOTrx() || line.getM_Product_ID() == 0) {
                    ol = new MOrderLine(this.getCtx(), line.getC_OrderLine_ID(), this.get_TrxName());
                    if (line.getQtyInvoiced() != null) {
                        ol.setQtyInvoiced(ol.getQtyInvoiced().add(line.getQtyInvoiced()));
                    }
                    if (!ol.save(this.get_TrxName())) {
                        this.m_processMsg = "Could not update Order Line";
                        return "IN";
                    }
                } else if (!this.isSOTrx() && line.getM_Product_ID() != 0 && !this.isReversal()) {
                    BigDecimal matchQty = line.getQtyInvoiced();
                    MMatchPO po = MMatchPO.create(line, null, this.getDateInvoiced(), matchQty);
                    if (po != null) {
                        MMatchInv[] matchInvoices;
                        if (!po.save(this.get_TrxName())) {
                            this.m_processMsg = "Could not create PO Matching";
                            return "IN";
                        }
                        ++matchPO;
                        if (!po.isPosted() && po.getM_InOutLine_ID() > 0) {
                            this.addDocsPostProcess(po);
                        }
                        if ((matchInvoices = MMatchInv.getInvoiceLine(this.getCtx(), line.getC_InvoiceLine_ID(), this.get_TrxName())) != null && matchInvoices.length > 0) {
                            MMatchInv[] mMatchInvArray = matchInvoices;
                            int n = matchInvoices.length;
                            int n3 = 0;
                            while (n3 < n) {
                                MMatchInv matchInvoice = mMatchInvArray[n3];
                                if (!matchInvoice.isPosted()) {
                                    this.addDocsPostProcess(matchInvoice);
                                }
                                ++n3;
                            }
                        }
                    }
                }
            }
            if (line.getM_RMALine_ID() != 0) {
                MRMALine rmaLine = new MRMALine(this.getCtx(), line.getM_RMALine_ID(), this.get_TrxName());
                if (rmaLine.getQtyInvoiced() != null) {
                    rmaLine.setQtyInvoiced(rmaLine.getQtyInvoiced().add(line.getQtyInvoiced()));
                } else {
                    rmaLine.setQtyInvoiced(line.getQtyInvoiced());
                }
                if (!rmaLine.save(this.get_TrxName())) {
                    this.m_processMsg = "Could not update RMA Line";
                    return "IN";
                }
            }
            ++i2;
        }
        if (matchInv > 0) {
            info.append(" @M_MatchInv_ID@#").append(matchInv).append(" ");
        }
        if (matchPO > 0) {
            info.append(" @M_MatchPO_ID@#").append(matchPO).append(" ");
        }
        MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        DB.getDatabase().forUpdate(bp, 0);
        BigDecimal invAmt = MConversionRate.convertBase(this.getCtx(), this.getGrandTotal(true), this.getC_Currency_ID(), this.getDateAcct(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
        if (invAmt == null) {
            this.m_processMsg = MConversionRateUtil.getErrorMessage(this.getCtx(), "ErrorConvertingCurrencyToBaseCurrency", this.getC_Currency_ID(), MClient.get(this.getCtx()).getC_Currency_ID(), this.getC_ConversionType_ID(), this.getDateAcct(), this.get_TrxName());
            return "IN";
        }
        BigDecimal newBalance = bp.getTotalOpenBalance();
        if (newBalance == null) {
            newBalance = Env.ZERO;
        }
        if (this.isSOTrx()) {
            BigDecimal newLifeAmt;
            newBalance = newBalance.add(invAmt);
            if (bp.getFirstSale() == null) {
                bp.setFirstSale(this.getDateInvoiced());
            }
            newLifeAmt = (newLifeAmt = bp.getActualLifeTimeValue()) == null ? invAmt : newLifeAmt.add(invAmt);
            BigDecimal newCreditAmt = bp.getSO_CreditUsed();
            newCreditAmt = newCreditAmt == null ? invAmt : newCreditAmt.add(invAmt);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("GrandTotal=" + this.getGrandTotal(true) + "(" + invAmt + ") BP Life=" + bp.getActualLifeTimeValue() + "->" + newLifeAmt + ", Credit=" + bp.getSO_CreditUsed() + "->" + newCreditAmt + ", Balance=" + bp.getTotalOpenBalance() + " -> " + newBalance);
            }
            bp.setActualLifeTimeValue(newLifeAmt);
            bp.setSO_CreditUsed(newCreditAmt);
        } else {
            newBalance = newBalance.subtract(invAmt);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("GrandTotal=" + this.getGrandTotal(true) + "(" + invAmt + ") Balance=" + bp.getTotalOpenBalance() + " -> " + newBalance);
            }
        }
        bp.setTotalOpenBalance(newBalance);
        bp.setSOCreditStatus();
        if (!bp.save(this.get_TrxName())) {
            this.m_processMsg = "Could not update Business Partner";
            return "IN";
        }
        if (this.getAD_User_ID() != 0) {
            MUser user = new MUser(this.getCtx(), this.getAD_User_ID(), this.get_TrxName());
            user.setLastContact(new Timestamp(System.currentTimeMillis()));
            StringBuilder msgset = new StringBuilder().append(Msg.translate(this.getCtx(), "C_Invoice_ID")).append(": ").append(this.getDocumentNo());
            user.setLastResult(msgset.toString());
            if (!user.save(this.get_TrxName())) {
                this.m_processMsg = "Could not update Business Partner User";
                return "IN";
            }
        }
        if (this.isSOTrx() && this.getC_Project_ID() != 0) {
            MProject project = new MProject(this.getCtx(), this.getC_Project_ID(), this.get_TrxName());
            BigDecimal amt = this.getGrandTotal(true);
            int C_CurrencyTo_ID = project.getC_Currency_ID();
            if (C_CurrencyTo_ID != this.getC_Currency_ID()) {
                amt = MConversionRate.convert(this.getCtx(), amt, this.getC_Currency_ID(), C_CurrencyTo_ID, this.getDateAcct(), 0, this.getAD_Client_ID(), this.getAD_Org_ID());
            }
            if (amt == null) {
                this.m_processMsg = MConversionRateUtil.getErrorMessage(this.getCtx(), "ErrorConvertingCurrencyToProjectCurrency", this.getC_Currency_ID(), C_CurrencyTo_ID, 0, this.getDateAcct(), this.get_TrxName());
                return "IN";
            }
            BigDecimal newAmt = project.getInvoicedAmt();
            newAmt = newAmt == null ? amt : newAmt.add(amt);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("GrandTotal=" + this.getGrandTotal(true) + "(" + amt + ") Project " + project.getName() + " - Invoiced=" + project.getInvoicedAmt() + "->" + newAmt);
            }
            project.setInvoicedAmt(newAmt);
            if (!project.save(this.get_TrxName())) {
                this.m_processMsg = "Could not update Project";
                return "IN";
            }
        }
        if (this.isSOTrx() && !this.isReversal()) {
            StringBuilder whereClause = new StringBuilder();
            whereClause.append("C_Order_ID IN (");
            whereClause.append("SELECT C_Order_ID ");
            whereClause.append("FROM C_OrderLine ");
            whereClause.append("WHERE C_OrderLine_ID IN (");
            whereClause.append("SELECT C_OrderLine_ID ");
            whereClause.append("FROM C_InvoiceLine ");
            whereClause.append("WHERE C_Invoice_ID = ");
            whereClause.append(this.getC_Invoice_ID()).append("))");
            int[] orderIDList = MOrder.getAllIDs("C_Order", whereClause.toString(), this.get_TrxName());
            int[] ids = MPaymentTransaction.getAuthorizationPaymentTransactionIDs(orderIDList, this.getC_Invoice_ID(), this.get_TrxName());
            if (ids.length > 0) {
                boolean pureCIM = true;
                ArrayList<MPaymentTransaction> ptList = new ArrayList<MPaymentTransaction>();
                BigDecimal totalPayAmt = BigDecimal.ZERO;
                int[] nArray = ids;
                int n = ids.length;
                int n4 = 0;
                while (n4 < n) {
                    boolean isCIM;
                    int id = nArray[n4];
                    MPaymentTransaction pt = new MPaymentTransaction(this.getCtx(), id, this.get_TrxName());
                    if (!pt.setPaymentProcessor()) {
                        if (pt.getC_PaymentProcessor_ID() > 0) {
                            MPaymentProcessor pp = new MPaymentProcessor(this.getCtx(), pt.getC_PaymentProcessor_ID(), this.get_TrxName());
                            this.m_processMsg = String.valueOf(Msg.getMsg(this.getCtx(), "PaymentNoProcessorModel")) + ": " + pp.toString();
                        } else {
                            this.m_processMsg = Msg.getMsg(this.getCtx(), "PaymentNoProcessorModel");
                        }
                        return "IN";
                    }
                    boolean bl = isCIM = pt.getC_PaymentProcessor_ID() > 0 && pt.getCustomerPaymentProfileID() != null && pt.getCustomerPaymentProfileID().length() > 0;
                    if (pureCIM && !isCIM) {
                        pureCIM = false;
                    }
                    totalPayAmt = totalPayAmt.add(pt.getPayAmt());
                    ptList.add(pt);
                    ++n4;
                }
                if (this.getGrandTotal().compareTo(totalPayAmt) != 0 && ptList.size() > 0 && pureCIM) {
                    MPaymentTransaction newSalesPT = MPaymentTransaction.copyFrom((MPaymentTransaction)ptList.get(0), new Timestamp(System.currentTimeMillis()), "S", "", this.get_TrxName());
                    newSalesPT.setIsApproved(false);
                    newSalesPT.setIsVoided(false);
                    newSalesPT.setIsDelayedCapture(false);
                    newSalesPT.setDescription("InvoicedAmt: " + this.getGrandTotal() + " <> TotalAuthorizedAmt: " + totalPayAmt);
                    newSalesPT.setC_Invoice_ID(this.getC_Invoice_ID());
                    newSalesPT.setPayAmt(this.getGrandTotal());
                    for (MPaymentTransaction pt : ptList) {
                        pt.setDescription("InvoicedAmt: " + this.getGrandTotal() + " <> AuthorizedAmt: " + pt.getPayAmt());
                        boolean ok = pt.voidOnlineAuthorizationPaymentTransaction();
                        pt.saveEx();
                        if (ok) continue;
                        this.m_processMsg = String.valueOf(Msg.getMsg(this.getCtx(), "VoidAuthorizationPaymentFailed")) + ": " + pt.getErrorMessage();
                        return "IN";
                    }
                    boolean ok = newSalesPT.processOnline();
                    newSalesPT.saveEx();
                    if (!ok) {
                        this.m_processMsg = String.valueOf(Msg.getMsg(this.getCtx(), "CreateNewSalesPaymentFailed")) + ": " + newSalesPT.getErrorMessage();
                        return "IN";
                    }
                } else {
                    if (this.getGrandTotal().compareTo(totalPayAmt) != 0 && ptList.size() > 0) {
                        this.m_processMsg = "InvoicedAmt: " + this.getGrandTotal() + " <> AuthorizedAmt: " + totalPayAmt;
                        return "IN";
                    }
                    for (MPaymentTransaction pt : ptList) {
                        boolean ok = pt.delayCaptureOnlineAuthorizationPaymentTransaction(this.getC_Invoice_ID());
                        pt.saveEx();
                        if (ok) continue;
                        this.m_processMsg = String.valueOf(Msg.getMsg(this.getCtx(), "DelayCaptureAuthFailed")) + ": " + pt.getErrorMessage();
                        return "IN";
                    }
                }
                if (this.testAllocation(true)) {
                    this.saveEx();
                }
            }
        }
        if ("B".equals(this.getPaymentRule()) && this.testAllocation(true)) {
            this.saveEx();
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate(this, 9)) != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        MInvoice counter = this.createCounterDoc();
        if (counter != null) {
            info.append(" - @CounterDoc@: @C_Invoice_ID@=").append(counter.getDocumentNo());
        }
        this.m_processMsg = info.toString().trim();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void addDocsPostProcess(PO doc) {
        this.docsPostProcess.add(doc);
    }

    public ArrayList<PO> getDocsPostProcess() {
        return this.docsPostProcess;
    }

    private void setDefiniteDocumentNo() {
        String value;
        if (this.isReversal() && !MSysConfig.getBooleanValue("Invoice_ReverseUseNewNumber", true, this.getAD_Client_ID())) {
            return;
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateInvoiced(TimeUtil.getDay(0L));
            if (this.getDateAcct().before(this.getDateInvoiced())) {
                this.setDateAcct(this.getDateInvoiced());
                MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), this.getC_DocType_ID(), this.getAD_Org_ID());
            }
        }
        if (dt.isOverwriteSeqOnComplete() && (value = DB.getDocumentNo(this.getC_DocType_ID(), this.get_TrxName(), true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    private MInvoice createCounterDoc() {
        if (this.getRef_Invoice_ID() != 0) {
            return null;
        }
        MOrg org = MOrg.get(this.getCtx(), this.getAD_Org_ID());
        int counterC_BPartner_ID = org.getLinkedC_BPartner_ID(this.get_TrxName());
        if (counterC_BPartner_ID == 0) {
            return null;
        }
        MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), null);
        int counterAD_Org_ID = bp.getAD_OrgBP_ID_Int();
        if (counterAD_Org_ID == 0) {
            return null;
        }
        MBPartner counterBP = new MBPartner(this.getCtx(), counterC_BPartner_ID, null);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Counter BP=" + counterBP.getName());
        }
        int C_DocTypeTarget_ID = 0;
        MDocTypeCounter counterDT = MDocTypeCounter.getCounterDocType(this.getCtx(), this.getC_DocType_ID());
        if (counterDT != null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(counterDT.toString());
            }
            if (!counterDT.isCreateCounter() || !counterDT.isValid()) {
                return null;
            }
            C_DocTypeTarget_ID = counterDT.getCounter_C_DocType_ID();
        } else {
            C_DocTypeTarget_ID = MDocTypeCounter.getCounterDocType_ID(this.getCtx(), this.getC_DocType_ID());
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Indirect C_DocTypeTarget_ID=" + C_DocTypeTarget_ID);
            }
            if (C_DocTypeTarget_ID <= 0) {
                return null;
            }
        }
        MInvoice counter = MInvoice.copyFrom(this, this.getDateInvoiced(), this.getDateAcct(), C_DocTypeTarget_ID, !this.isSOTrx(), true, this.get_TrxName(), true);
        counter.setAD_Org_ID(counterAD_Org_ID);
        counter.setSalesRep_ID(this.getSalesRep_ID());
        counter.saveEx(this.get_TrxName());
        MInvoiceLine[] counterLines = counter.getLines(true);
        int i2 = 0;
        while (i2 < counterLines.length) {
            MInvoiceLine counterLine = counterLines[i2];
            counterLine.setClientOrg(counter);
            counterLine.setInvoice(counter);
            counterLine.setPrice();
            counterLine.setTax();
            counterLine.saveEx(this.get_TrxName());
            ++i2;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(counter.toString());
        }
        if (counterDT != null && counterDT.getDocAction() != null) {
            counter.setDocAction(counterDT.getDocAction());
            if (!counter.processIt(counterDT.getDocAction())) {
                throw new AdempiereException("Failed when processing document - " + counter.getProcessMsg());
            }
            counter.saveEx(this.get_TrxName());
        }
        return counter;
    }

    @Override
    public boolean voidIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
            if (this.m_processMsg != null) {
                return false;
            }
            MInvoiceLine[] lines = this.getLines(false);
            int i2 = 0;
            while (i2 < lines.length) {
                MInvoiceLine line = lines[i2];
                BigDecimal old = line.getQtyInvoiced();
                if (old.compareTo(Env.ZERO) != 0) {
                    line.setQty(Env.ZERO);
                    line.setTaxAmt(Env.ZERO);
                    line.setLineNetAmt(Env.ZERO);
                    line.setLineTotalAmt(Env.ZERO);
                    StringBuilder msgadd = new StringBuilder(Msg.getMsg(this.getCtx(), "Voided")).append(" (").append(old).append(")");
                    line.addDescription(msgadd.toString());
                    if (line.getM_InOutLine_ID() != 0) {
                        MInOutLine ioLine = new MInOutLine(this.getCtx(), line.getM_InOutLine_ID(), this.get_TrxName());
                        ioLine.setIsInvoiced(false);
                        ioLine.saveEx(this.get_TrxName());
                        line.setM_InOutLine_ID(0);
                    }
                    line.saveEx(this.get_TrxName());
                }
                ++i2;
            }
        } else {
            boolean accrual = false;
            try {
                MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), this.getC_DocType_ID(), this.getAD_Org_ID());
            }
            catch (PeriodClosedException e) {
                accrual = true;
            }
            if (accrual) {
                return this.reverseAccrualIt();
            }
            return this.reverseCorrectIt();
        }
        this.addDescription(Msg.getMsg(this.getCtx(), "Voided"));
        this.setIsPaid(true);
        this.setC_Payment_ID(0);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        MInvoice reversal = this.reverse(false);
        if (reversal == null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = reversal.getDocumentNo();
        return true;
    }

    private MInvoice reverse(boolean accrual) {
        Timestamp reversalDate;
        Timestamp timestamp = reversalDate = accrual ? Env.getContextAsDate(this.getCtx(), "#Date") : this.getDateAcct();
        if (reversalDate == null) {
            reversalDate = new Timestamp(System.currentTimeMillis());
        }
        Timestamp reversalDateInvoiced = accrual ? reversalDate : this.getDateInvoiced();
        MPeriod.testPeriodOpen(this.getCtx(), reversalDate, this.getC_DocType_ID(), this.getAD_Org_ID());
        this.reverseAllocations(accrual, this.getC_Invoice_ID());
        if (!this.isSOTrx()) {
            MMatchInv[] mInv = MMatchInv.getInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
            int i2 = 0;
            while (i2 < mInv.length) {
                if (mInv[i2].getReversal_ID() <= 0) {
                    if (!mInv[i2].reverse(reversalDate)) {
                        this.m_processMsg = "Could not Reverse MatchInv";
                        return null;
                    }
                    this.addDocsPostProcess(new MMatchInv(Env.getCtx(), mInv[i2].getReversal_ID(), this.get_TrxName()));
                }
                ++i2;
            }
            MMatchPO[] mPO = MMatchPO.getInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
            int i3 = 0;
            while (i3 < mPO.length) {
                if (mPO[i3].getReversal_ID() <= 0) {
                    if (mPO[i3].getM_InOutLine_ID() == 0) {
                        if (mPO[i3].isPosted()) {
                            if (!mPO[i3].reverse(reversalDate)) {
                                this.m_processMsg = "Could not Reverse MatchPO";
                                return null;
                            }
                            this.addDocsPostProcess(new MMatchPO(Env.getCtx(), mPO[i3].getReversal_ID(), this.get_TrxName()));
                        } else {
                            mPO[i3].deleteEx(true);
                        }
                    } else {
                        mPO[i3].setC_InvoiceLine_ID(null);
                        mPO[i3].saveEx(this.get_TrxName());
                    }
                }
                ++i3;
            }
        }
        this.load(this.get_TrxName());
        MInvoice reversal = null;
        reversal = MSysConfig.getBooleanValue("Invoice_ReverseUseNewNumber", true, this.getAD_Client_ID()) ? MInvoice.copyFrom(this, reversalDateInvoiced, reversalDate, this.getC_DocType_ID(), this.isSOTrx(), false, this.get_TrxName(), true) : MInvoice.copyFrom(this, reversalDateInvoiced, reversalDate, this.getC_DocType_ID(), this.isSOTrx(), false, this.get_TrxName(), true, String.valueOf(this.getDocumentNo()) + "^");
        if (reversal == null) {
            this.m_processMsg = "Could not create Invoice Reversal";
            return null;
        }
        reversal.setReversal(true);
        MInvoiceLine[] oLines = this.getLines(false);
        MInvoiceLine[] rLines = reversal.getLines(true);
        int i4 = 0;
        while (i4 < rLines.length) {
            MInvoiceLine rLine = rLines[i4];
            rLine.getParent().setReversal(true);
            MInvoiceLine oLine = oLines[i4];
            rLine.setQtyEntered(oLine.getQtyEntered().negate());
            rLine.setQtyInvoiced(oLine.getQtyInvoiced().negate());
            rLine.setLineNetAmt(oLine.getLineNetAmt().negate());
            rLine.setTaxAmt(oLine.getTaxAmt().negate());
            rLine.setLineTotalAmt(oLine.getLineTotalAmt().negate());
            rLine.setPriceActual(oLine.getPriceActual());
            rLine.setPriceList(oLine.getPriceList());
            rLine.setPriceLimit(oLine.getPriceLimit());
            rLine.setPriceEntered(oLine.getPriceEntered());
            rLine.setC_UOM_ID(oLine.getC_UOM_ID());
            if (!rLine.save(this.get_TrxName())) {
                this.m_processMsg = "Could not correct Invoice Reversal Line";
                return null;
            }
            ++i4;
        }
        reversal.setC_Order_ID(this.getC_Order_ID());
        StringBuilder msgadd = new StringBuilder("{->").append(this.getDocumentNo()).append(")");
        reversal.addDescription(msgadd.toString());
        reversal.setReversal_ID(this.getC_Invoice_ID());
        reversal.saveEx(this.get_TrxName());
        reversal.docsPostProcess = this.docsPostProcess;
        this.docsPostProcess = new ArrayList();
        if (!reversal.processIt("CO")) {
            this.m_processMsg = "Reversal ERROR: " + reversal.getProcessMsg();
            return null;
        }
        this.reverseAllocations(accrual, reversal.getC_Invoice_ID());
        reversal.setC_Payment_ID(0);
        reversal.setIsPaid(true);
        reversal.closeIt();
        reversal.setProcessing(false);
        reversal.setDocStatus("RE");
        reversal.setDocAction("--");
        reversal.saveEx(this.get_TrxName());
        msgadd = new StringBuilder("(").append(reversal.getDocumentNo()).append("<-)");
        this.addDescription(msgadd.toString());
        MInvoiceLine[] iLines = this.getLines(false);
        int i5 = 0;
        while (i5 < iLines.length) {
            MInvoiceLine iLine = iLines[i5];
            if (iLine.getM_InOutLine_ID() != 0) {
                MInOutLine ioLine = new MInOutLine(this.getCtx(), iLine.getM_InOutLine_ID(), this.get_TrxName());
                ioLine.setIsInvoiced(false);
                ioLine.saveEx(this.get_TrxName());
                iLine.setM_InOutLine_ID(0);
                iLine.saveEx(this.get_TrxName());
            }
            ++i5;
        }
        this.setProcessed(true);
        this.setReversal_ID(reversal.getC_Invoice_ID());
        this.setDocStatus("RE");
        this.setDocAction("--");
        this.setC_Payment_ID(0);
        this.setIsPaid(true);
        StringBuilder msgall = new StringBuilder().append(Msg.translate(this.getCtx(), "C_Invoice_ID")).append(": ").append(this.getDocumentNo()).append("/").append(reversal.getDocumentNo());
        MAllocationHdr alloc = new MAllocationHdr(this.getCtx(), false, reversalDate, this.getC_Currency_ID(), msgall.toString(), this.get_TrxName());
        alloc.setAD_Org_ID(this.getAD_Org_ID());
        alloc.saveEx();
        BigDecimal gt = this.getGrandTotal(true);
        if (!this.isSOTrx()) {
            gt = gt.negate();
        }
        MAllocationLine aLine = new MAllocationLine(alloc, gt, Env.ZERO, Env.ZERO, Env.ZERO);
        aLine.setC_Invoice_ID(this.getC_Invoice_ID());
        aLine.saveEx();
        MAllocationLine rLine = new MAllocationLine(alloc, gt.negate(), Env.ZERO, Env.ZERO, Env.ZERO);
        rLine.setC_Invoice_ID(reversal.getC_Invoice_ID());
        rLine.saveEx();
        if (!alloc.processIt("CO")) {
            throw new AdempiereException("Failed when processing document - " + alloc.getProcessMsg());
        }
        alloc.saveEx();
        return reversal;
    }

    private void reverseAllocations(boolean accrual, int invoiceID) {
        MAllocationHdr[] mAllocationHdrArray = MAllocationHdr.getOfInvoice(this.getCtx(), invoiceID, this.get_TrxName());
        int n = mAllocationHdrArray.length;
        int n2 = 0;
        while (n2 < n) {
            MAllocationHdr allocation = mAllocationHdrArray[n2];
            if (accrual) {
                allocation.setDocAction("RA");
                allocation.reverseAccrualIt();
            } else {
                allocation.setDocAction("RC");
                allocation.reverseCorrectIt();
            }
            allocation.saveEx(this.get_TrxName());
            ++n2;
        }
    }

    @Override
    public boolean reverseAccrualIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        MInvoice reversal = this.reverse(true);
        if (reversal == null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = reversal.getDocumentNo();
        return true;
    }

    @Override
    public boolean reActivateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public String getSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "GrandTotal")).append("=").append(this.getGrandTotal()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return this.getGrandTotal();
    }

    public void setRMA(MRMA rma) {
        this.setM_RMA_ID(rma.getM_RMA_ID());
        this.setAD_Org_ID(rma.getAD_Org_ID());
        this.setDescription(rma.getDescription());
        this.setC_BPartner_ID(rma.getC_BPartner_ID());
        this.setSalesRep_ID(rma.getSalesRep_ID());
        this.setGrandTotal(rma.getAmt());
        this.setIsSOTrx(rma.isSOTrx());
        this.setTotalLines(rma.getAmt());
        MInvoice originalInvoice = rma.getOriginalInvoice();
        if (originalInvoice == null) {
            throw new IllegalStateException("Not invoiced - RMA: " + rma.getDocumentNo());
        }
        this.setC_BPartner_Location_ID(originalInvoice.getC_BPartner_Location_ID());
        this.setAD_User_ID(originalInvoice.getAD_User_ID());
        this.setC_Currency_ID(originalInvoice.getC_Currency_ID());
        this.setIsTaxIncluded(originalInvoice.isTaxIncluded());
        this.setM_PriceList_ID(originalInvoice.getM_PriceList_ID());
        this.setC_Project_ID(originalInvoice.getC_Project_ID());
        this.setC_Activity_ID(originalInvoice.getC_Activity_ID());
        this.setC_Campaign_ID(originalInvoice.getC_Campaign_ID());
        this.setUser1_ID(originalInvoice.getUser1_ID());
        this.setUser2_ID(originalInvoice.getUser2_ID());
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }

    public MOrder getOriginalOrder() {
        if (this.getM_RMA_ID() > 0) {
            MRMA rma = new MRMA(this.getCtx(), this.getM_RMA_ID(), this.get_TrxName());
            MOrder originalOrder = rma.getOriginalOrder();
            if (originalOrder != null) {
                return originalOrder;
            }
            MInvoice originalInvoice = rma.getOriginalInvoice();
            if (originalInvoice.getC_Order_ID() > 0 && (originalOrder = new MOrder(this.getCtx(), originalInvoice.getC_Order_ID(), this.get_TrxName())) != null) {
                return originalOrder;
            }
        } else if (this.getC_Order_ID() > 0) {
            return new MOrder(this.getCtx(), this.getC_Order_ID(), this.get_TrxName());
        }
        return null;
    }

    public void setProcessMessage(String processMsg) {
        this.m_processMsg = processMsg;
    }

    public MTaxProvider[] getTaxProviders() {
        MInvoiceLine[] lines;
        Hashtable<Integer, MTaxProvider> providers = new Hashtable<Integer, MTaxProvider>();
        MInvoiceLine[] mInvoiceLineArray = lines = this.getLines();
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MInvoiceLine line = mInvoiceLineArray[n2];
            MTax tax = new MTax(line.getCtx(), line.getC_Tax_ID(), line.get_TrxName());
            MTaxProvider provider = (MTaxProvider)providers.get(tax.getC_TaxProvider_ID());
            if (provider == null) {
                providers.put(tax.getC_TaxProvider_ID(), new MTaxProvider(tax.getCtx(), tax.getC_TaxProvider_ID(), tax.get_TrxName()));
            }
            ++n2;
        }
        MTaxProvider[] retValue = new MTaxProvider[providers.size()];
        providers.values().toArray(retValue);
        return retValue;
    }

    public int getDocTypeID() {
        return this.getC_DocType_ID() > 0 ? this.getC_DocType_ID() : this.getC_DocTypeTarget_ID();
    }
}

