/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.I_M_Inventory;
import org.compiere.model.I_M_InventoryLine;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.Query;
import org.compiere.model.X_M_InventoryLineMA;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MInventoryLineMA
extends X_M_InventoryLineMA {
    private static final long serialVersionUID = -5654504108476140057L;
    private static CLogger s_log = CLogger.getCLogger(MInventoryLineMA.class);

    public static MInventoryLineMA[] get(Properties ctx, int M_InventoryLine_ID, String trxName) {
        ArrayList<MInventoryLineMA> list;
        block6: {
            list = new ArrayList<MInventoryLineMA>();
            String sql = "SELECT * FROM M_InventoryLineMA WHERE M_InventoryLine_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, M_InventoryLine_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MInventoryLineMA(ctx, rs, trxName));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MInventoryLineMA[] retValue = new MInventoryLineMA[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static int deleteInventoryMA(int M_Inventory_ID, String trxName) {
        StringBuilder sql = new StringBuilder("DELETE FROM M_InventoryLineMA ma WHERE EXISTS ").append("(SELECT * FROM M_InventoryLine l WHERE l.M_InventoryLine_ID=ma.M_InventoryLine_ID").append(" AND M_Inventory_ID=").append(M_Inventory_ID).append(")");
        return DB.executeUpdate(sql.toString(), trxName);
    }

    public static int deleteInventoryLineMA(int M_InventoryLine_ID, String trxName) {
        StringBuilder sql = new StringBuilder("DELETE FROM M_InventoryLineMA ma WHERE EXISTS ").append("(SELECT * FROM M_InventoryLine l WHERE l.M_InventoryLine_ID=ma.M_InventoryLine_ID").append(" AND M_InventoryLine_ID=").append(M_InventoryLine_ID).append(") AND ma.IsAutoGenerated='Y'");
        return DB.executeUpdate(sql.toString(), trxName);
    }

    public MInventoryLineMA(Properties ctx, int M_InventoryLineMA_ID, String trxName) {
        super(ctx, M_InventoryLineMA_ID, trxName);
        if (M_InventoryLineMA_ID != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
    }

    public MInventoryLineMA(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInventoryLineMA(MInventoryLine parent, int M_AttributeSetInstance_ID, BigDecimal MovementQty, Timestamp DateMaterialPolicy) {
        this(parent, M_AttributeSetInstance_ID, MovementQty, DateMaterialPolicy, true);
    }

    public MInventoryLineMA(MInventoryLine parent, int M_AttributeSetInstance_ID, BigDecimal MovementQty, Timestamp DateMaterialPolicy, boolean isAutoGenerated) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setM_InventoryLine_ID(parent.getM_InventoryLine_ID());
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        this.setMovementQty(MovementQty);
        if (DateMaterialPolicy == null) {
            if (M_AttributeSetInstance_ID > 0) {
                DateMaterialPolicy = MStorageOnHand.getDateMaterialPolicy(parent.getM_Product_ID(), M_AttributeSetInstance_ID, parent.get_TrxName());
            }
            if (DateMaterialPolicy == null) {
                DateMaterialPolicy = parent.getParent().getMovementDate();
            }
        }
        this.setDateMaterialPolicy(DateMaterialPolicy);
        this.setIsAutoGenerated(isAutoGenerated);
    }

    @Override
    public void setDateMaterialPolicy(Timestamp DateMaterialPolicy) {
        if (DateMaterialPolicy != null) {
            DateMaterialPolicy = Util.removeTime(DateMaterialPolicy);
        }
        super.setDateMaterialPolicy(DateMaterialPolicy);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MInventoryLineMA[");
        sb.append("M_InventoryLine_ID=").append(this.getM_InventoryLine_ID()).append(",M_AttributeSetInstance_ID=").append(this.getM_AttributeSetInstance_ID()).append(", Qty=").append(this.getMovementQty()).append("]");
        return sb.toString();
    }

    public static MInventoryLineMA addOrCreate(MInventoryLine line, int M_AttributeSetInstance_ID, BigDecimal MovementQty, Timestamp DateMaterialPolicy) {
        return MInventoryLineMA.addOrCreate(line, M_AttributeSetInstance_ID, MovementQty, DateMaterialPolicy, true);
    }

    public static MInventoryLineMA addOrCreate(MInventoryLine line, int M_AttributeSetInstance_ID, BigDecimal MovementQty, Timestamp DateMaterialPolicy, boolean isAutoGenerated) {
        Query query = new Query(Env.getCtx(), "M_InventoryLineMA", "M_InventoryLine_ID=? AND M_AttributeSetInstance_ID=? AND DateMaterialPolicy=trunc(cast(? as date))", line.get_TrxName());
        MInventoryLineMA po = (MInventoryLineMA)query.setParameters(line.getM_InventoryLine_ID(), M_AttributeSetInstance_ID, DateMaterialPolicy).first();
        if (po == null) {
            po = new MInventoryLineMA(line, M_AttributeSetInstance_ID, MovementQty, DateMaterialPolicy, isAutoGenerated);
        } else {
            po.setMovementQty(po.getMovementQty().add(MovementQty));
        }
        return po;
    }

    public static BigDecimal getManualQty(int M_MovementLine_ID, String trxName) {
        String sql = "SELECT SUM(movementqty) FROM M_InventoryLineMA ma WHERE ma.M_InventoryLine_ID=? AND IsAutoGenerated='N'";
        BigDecimal totalQty = DB.getSQLValueBD(trxName, sql, M_MovementLine_ID);
        return totalQty == null ? Env.ZERO : totalQty.negate();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (!newRecord && this.is_ValueChanged("M_AttributeSetInstance_ID")) {
            I_M_InventoryLine line = this.getM_InventoryLine();
            Timestamp dateMPolicy = null;
            if (this.getM_AttributeSetInstance_ID() > 0) {
                dateMPolicy = MStorageOnHand.getDateMaterialPolicy(line.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.get_TrxName());
            }
            if (dateMPolicy == null) {
                I_M_Inventory inventory = line.getM_Inventory();
                dateMPolicy = inventory.getMovementDate();
            }
            this.setDateMaterialPolicy(dateMPolicy);
        }
        return true;
    }
}

