/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.model.IInfoColumn;
import org.compiere.model.AccessSqlParser;
import org.compiere.model.MColumn;
import org.compiere.model.MInfoWindow;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.M_Element;
import org.compiere.model.X_AD_InfoColumn;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Evaluator;

public class MInfoColumn
extends X_AD_InfoColumn
implements IInfoColumn {
    private static final long serialVersionUID = 9198213211937136870L;
    private MInfoWindow m_parent = null;

    public MInfoColumn(Properties ctx, int AD_InfoColumn_ID, String trxName) {
        super(ctx, AD_InfoColumn_ID, trxName);
    }

    public MInfoColumn(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInfoWindow getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MInfoWindow(this.getCtx(), this.getAD_InfoWindow_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public boolean isColumnAccess(AccessSqlParser.TableInfo[] tableInfos) {
        int index = this.getSelectClause().indexOf(".");
        if (index == this.getSelectClause().lastIndexOf(".") && index >= 0) {
            String synonym = this.getSelectClause().substring(0, index);
            String column = this.getSelectClause().substring(index + 1);
            AccessSqlParser.TableInfo[] tableInfoArray = tableInfos;
            int n = tableInfos.length;
            int n2 = 0;
            while (n2 < n) {
                AccessSqlParser.TableInfo tableInfo = tableInfoArray[n2];
                if (tableInfo.getSynonym() != null && tableInfo.getSynonym().equals(synonym)) {
                    MColumn mColumn;
                    String tableName = tableInfo.getTableName();
                    MTable mTable = MTable.get(Env.getCtx(), tableName);
                    if (mTable != null && (mColumn = mTable.getColumn(column)) != null && !MRole.getDefault().isColumnAccess(mTable.getAD_Table_ID(), mColumn.getAD_Column_ID(), true)) {
                        return false;
                    }
                }
                ++n2;
            }
        }
        return true;
    }

    public boolean isDisplayed(final Properties ctx, final int windowNo) {
        if (!this.isDisplayed()) {
            return false;
        }
        if (this.getDisplayLogic() == null || this.getDisplayLogic().trim().length() == 0) {
            return true;
        }
        Evaluatee evaluatee = new Evaluatee(){

            @Override
            public String get_ValueAsString(String variableName) {
                return Env.getContext(ctx, windowNo, variableName, true);
            }
        };
        boolean retValue = Evaluator.evaluateLogic(evaluatee, this.getDisplayLogic());
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest(String.valueOf(this.getName()) + " (" + this.getDisplayLogic() + ") => " + retValue);
        }
        return retValue;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if ((newRecord || this.is_ValueChanged("AD_Element_ID")) && this.getAD_Element_ID() != 0 && this.isCentrallyMaintained()) {
            M_Element element = new M_Element(this.getCtx(), this.getAD_Element_ID(), this.get_TrxName());
            this.setName(element.getName());
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        boolean isNeedValid;
        if (!success) {
            return success;
        }
        boolean bl = isNeedValid = newRecord || this.is_ValueChanged("SelectClause");
        if (isNeedValid) {
            this.getParent().validate();
            this.getParent().saveEx(this.get_TrxName());
        }
        return super.afterSave(newRecord, success);
    }

    @Override
    protected boolean afterDelete(boolean success) {
        this.getParent().validate();
        this.getParent().saveEx(this.get_TrxName());
        return super.afterDelete(success);
    }

    @Override
    public int getInfoColumnID() {
        return this.get_ID();
    }

    @Override
    public MInfoColumn getAD_InfoColumn() {
        return this;
    }
}

