/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.compiere.model.X_K_Index;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MIndex
extends X_K_Index {
    private static final long serialVersionUID = 7835438766016462027L;
    private static final char[] s_char = new char[]{'\u00c4', '\u00d6', '\u00dc', '\u00df'};
    private static final String[] s_string = new String[]{"AE", "OE", "UE", "SS"};

    public MIndex(Properties ctx, int K_Index_ID, String trxName) {
        super(ctx, K_Index_ID, trxName);
    }

    public MIndex(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static int cleanUp(String trxName, int AD_Client_ID, int AD_Table_ID, int Record_ID) {
        StringBuilder sb = new StringBuilder("DELETE FROM K_Index ").append("WHERE AD_Client_ID=").append(AD_Client_ID).append(" AND ").append("AD_Table_ID=").append(AD_Table_ID).append(" AND ").append("Record_ID=").append(Record_ID);
        int no = DB.executeUpdate(sb.toString(), trxName);
        return no;
    }

    @Override
    public void setKeyword(String Keyword) {
        String kw = MIndex.standardizeKeyword(Keyword);
        if (kw == null) {
            kw = "?";
        }
        super.setKeyword(kw);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord || this.is_ValueChanged("Keyword")) {
            this.setKeyword(this.getKeyword());
        }
        if (this.getKeyword().equals("?")) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "Keyword"));
            return false;
        }
        return true;
    }

    public static Hashtable<String, String> indexStringBuffer(StringBuffer thisText) {
        return MIndex.indexString(thisText.toString());
    }

    public static Hashtable<String, String> indexString(String thisText) {
        if ((thisText = MIndex.removeHTML(thisText)) != null) {
            String[] keywords = thisText.toUpperCase().split("\\t|\\p{Punct}|\\p{Space}");
            Hashtable<String, String> keyhash = new Hashtable<String, String>(keywords.length);
            int currentPos = 0;
            int i2 = 0;
            while (i2 < keywords.length) {
                String thisExcerpt = "";
                if (keywords[i2].length() >= 2 && !keyhash.contains(keywords[i2])) {
                    int endExcerpt;
                    int startExcerpt = thisText.toUpperCase().indexOf(keywords[i2], currentPos);
                    if (startExcerpt > 50) {
                        startExcerpt -= 50;
                    }
                    if (startExcerpt > thisText.length() && startExcerpt > 50 && thisText.length() > 50) {
                        startExcerpt = thisText.length() - 50;
                    }
                    if ((endExcerpt = thisText.toUpperCase().indexOf(keywords[i2], currentPos) + keywords[i2].length()) > currentPos) {
                        currentPos = endExcerpt;
                    }
                    if (endExcerpt < thisText.length() - 50) {
                        endExcerpt += 50;
                    }
                    if (endExcerpt > thisText.length()) {
                        endExcerpt = thisText.length();
                    }
                    thisExcerpt = thisText.substring(startExcerpt, endExcerpt);
                    keyhash.put(keywords[i2], thisExcerpt);
                }
                ++i2;
            }
            return keyhash;
        }
        return null;
    }

    public static boolean runIndex(String thisText, Properties ctx, String trxName, int tableID, int recordID, int CMWebProjectID, Timestamp sourceUpdated) {
        if (thisText != null) {
            Hashtable<String, String> keyHash = MIndex.indexString(thisText);
            Enumeration<String> e = keyHash.keys();
            while (e.hasMoreElements()) {
                String name = e.nextElement();
                String value = keyHash.get(name);
                MIndex thisIndex = new MIndex(ctx, 0, trxName);
                thisIndex.setAD_Table_ID(tableID);
                if (CMWebProjectID > 0) {
                    thisIndex.setCM_WebProject_ID(CMWebProjectID);
                }
                thisIndex.setExcerpt(value);
                thisIndex.setKeyword(name);
                thisIndex.setRecord_ID(recordID);
                thisIndex.setSourceUpdated(sourceUpdated);
                thisIndex.saveEx();
            }
            return true;
        }
        return false;
    }

    public static void reIndex(boolean runCleanUp, String[] toBeIndexed, Properties ctx, int AD_Client_ID, int AD_Table_ID, int Record_ID, int CM_WebProject_ID, Timestamp lastUpdated) {
        StringBuilder trxName = new StringBuilder("ReIndex_").append(AD_Table_ID).append("_").append(Record_ID);
        try {
            if (!runCleanUp) {
                MIndex.cleanUp(trxName.toString(), AD_Client_ID, AD_Table_ID, Record_ID);
            }
            int i2 = 0;
            while (i2 < toBeIndexed.length) {
                MIndex.runIndex(toBeIndexed[i2], ctx, trxName.toString(), AD_Table_ID, Record_ID, CM_WebProject_ID, lastUpdated);
                ++i2;
            }
            DB.commit(true, trxName.toString());
        }
        catch (SQLException sqlE) {
            try {
                DB.rollback(true, trxName.toString());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected static String removeHTML(String textElement) {
        String retValue = textElement.replaceAll("<?\\w+((\\s+\\w+(\\s*=\\s*(?:\"b(.|\\n)*?\"|'(.|\\n)*?'|[^'\">\\s]+))?)+\\s*|\\s*)/?>", " ");
        retValue = retValue.replaceAll("</", " ");
        retValue = retValue.replaceAll("\\\\n", " ");
        return retValue.toString();
    }

    protected static String standardizeKeyword(String keyword) {
        if (keyword == null) {
            return null;
        }
        if ((keyword = keyword.trim()).length() == 0) {
            return null;
        }
        keyword = keyword.toUpperCase();
        StringBuilder sb = new StringBuilder();
        char[] chars = keyword.toCharArray();
        int i2 = 0;
        while (i2 < chars.length) {
            char c = chars[i2];
            sb.append(MIndex.standardizeCharacter(c));
            ++i2;
        }
        return sb.toString();
    }

    private static String standardizeCharacter(char c) {
        if (c >= '!' && c <= 'Z') {
            return String.valueOf(c);
        }
        int index = Arrays.binarySearch(s_char, c);
        if (index < 0) {
            return String.valueOf(c);
        }
        return s_string[index];
    }
}

