/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_M_InOut;
import org.compiere.model.I_M_InOutLine;
import org.compiere.model.MInOutLine;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_M_InOutLineMA;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MInOutLineMA
extends X_M_InOutLineMA {
    private static final long serialVersionUID = -2610075295914545809L;
    private static CLogger s_log = CLogger.getCLogger(MInOutLineMA.class);

    public static MInOutLineMA[] get(Properties ctx, int M_InOutLine_ID, String trxName) {
        Query query = MTable.get(ctx, "M_InOutLineMA").createQuery("M_InOutLine_ID=?", trxName);
        query.setParameters(M_InOutLine_ID);
        List<MInOutLineMA> list = query.list();
        MInOutLineMA[] retValue = new MInOutLineMA[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static int deleteInOutMA(int M_InOut_ID, String trxName) {
        StringBuilder sql = new StringBuilder("DELETE FROM M_InOutLineMA ma WHERE EXISTS ").append("(SELECT * FROM M_InOutLine l WHERE l.M_InOutLine_ID=ma.M_InOutLine_ID").append(" AND M_InOut_ID=").append(M_InOut_ID).append(")");
        return DB.executeUpdate(sql.toString(), trxName);
    }

    public static int deleteInOutLineMA(int M_InOutLine_ID, String trxName) {
        String sql = "DELETE FROM M_InOutLineMA ma WHERE ma.M_InOutLine_ID=? AND ma.IsAutoGenerated='Y'";
        return DB.executeUpdate(sql, M_InOutLine_ID, trxName);
    }

    public MInOutLineMA(Properties ctx, int M_InOutLineMA_ID, String trxName) {
        super(ctx, M_InOutLineMA_ID, trxName);
        if (M_InOutLineMA_ID != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
    }

    public MInOutLineMA(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInOutLineMA(MInOutLine parent, int M_AttributeSetInstance_ID, BigDecimal MovementQty, Timestamp DateMaterialPolicy) {
        this(parent, M_AttributeSetInstance_ID, MovementQty, DateMaterialPolicy, true);
    }

    public MInOutLineMA(MInOutLine parent, int M_AttributeSetInstance_ID, BigDecimal MovementQty, Timestamp DateMaterialPolicy, boolean isAutoGenerated) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setM_InOutLine_ID(parent.getM_InOutLine_ID());
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        this.setMovementQty(MovementQty);
        if (DateMaterialPolicy == null) {
            if (M_AttributeSetInstance_ID > 0) {
                DateMaterialPolicy = MStorageOnHand.getDateMaterialPolicy(parent.getM_Product_ID(), M_AttributeSetInstance_ID, parent.get_TrxName());
            }
            if (DateMaterialPolicy == null) {
                DateMaterialPolicy = parent.getParent().getMovementDate();
            }
        }
        this.setDateMaterialPolicy(DateMaterialPolicy);
        this.setIsAutoGenerated(isAutoGenerated);
    }

    @Override
    public void setDateMaterialPolicy(Timestamp DateMaterialPolicy) {
        if (DateMaterialPolicy != null) {
            DateMaterialPolicy = Util.removeTime(DateMaterialPolicy);
        }
        super.setDateMaterialPolicy(DateMaterialPolicy);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MInOutLineMA[");
        sb.append("M_InOutLine_ID=").append(this.getM_InOutLine_ID()).append(",M_AttributeSetInstance_ID=").append(this.getM_AttributeSetInstance_ID()).append(", Qty=").append(this.getMovementQty()).append("]");
        return sb.toString();
    }

    public static MInOutLineMA addOrCreate(MInOutLine line, int M_AttributeSetInstance_ID, BigDecimal MovementQty, Timestamp DateMaterialPolicy) {
        return MInOutLineMA.addOrCreate(line, M_AttributeSetInstance_ID, MovementQty, DateMaterialPolicy, true);
    }

    public static MInOutLineMA addOrCreate(MInOutLine line, int M_AttributeSetInstance_ID, BigDecimal MovementQty, Timestamp DateMaterialPolicy, boolean isAutoGenerated) {
        Query query = new Query(Env.getCtx(), "M_InOutLineMA", "M_InOutLine_ID=? AND M_AttributeSetInstance_ID=? AND DateMaterialPolicy=trunc(cast(? as date))", line.get_TrxName());
        MInOutLineMA po = (MInOutLineMA)query.setParameters(line.getM_InOutLine_ID(), M_AttributeSetInstance_ID, DateMaterialPolicy).first();
        if (po == null) {
            po = new MInOutLineMA(line, M_AttributeSetInstance_ID, MovementQty, DateMaterialPolicy, isAutoGenerated);
        } else {
            po.setMovementQty(po.getMovementQty().add(MovementQty));
        }
        return po;
    }

    public static BigDecimal getManualQty(int M_InOutLine_ID, String trxName) {
        String sql = "SELECT SUM(movementqty) FROM M_InOutLineMA ma WHERE ma.M_InOutLine_ID=? AND ma.IsAutoGenerated='N'";
        BigDecimal totalQty = DB.getSQLValueBD(trxName, sql, M_InOutLine_ID);
        return totalQty == null ? Env.ZERO : totalQty;
    }

    public static MInOutLineMA[] getNonReturned(Properties ctx, int M_InOutLine_ID, String trxName) {
        String sql = "SELECT * FROM M_InoutLineMA_Returned WHERE (returnedQty<>movementQty or returnedQty is null) and m_inoutline_id=? ";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<MInOutLineMA> list = new ArrayList<MInOutLineMA>();
        try {
            try {
                pstmt = DB.prepareStatement(sql, trxName);
                pstmt.setInt(1, M_InOutLine_ID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    MInOutLineMA lineMA = new MInOutLineMA(ctx, rs, trxName);
                    list.add(lineMA);
                }
            }
            catch (SQLException ex) {
                s_log.log(Level.SEVERE, sql, ex);
                throw new AdempiereException(ex.getLocalizedMessage(), ex);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        MInOutLineMA[] retValue = new MInOutLineMA[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (!newRecord && this.is_ValueChanged("M_AttributeSetInstance_ID")) {
            I_M_InOutLine line = this.getM_InOutLine();
            Timestamp dateMPolicy = null;
            if (this.getM_AttributeSetInstance_ID() > 0) {
                dateMPolicy = MStorageOnHand.getDateMaterialPolicy(line.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.get_TrxName());
            }
            if (dateMPolicy == null) {
                I_M_InOut inout = line.getM_InOut();
                dateMPolicy = inout.getMovementDate();
            }
            this.setDateMaterialPolicy(dateMPolicy);
        }
        return true;
    }
}

