/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.AdempiereProcessorLog;
import org.compiere.model.MIMPProcessorLog;
import org.compiere.model.X_IMP_Processor;
import org.compiere.model.X_IMP_ProcessorParameter;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MIMPProcessor
extends X_IMP_Processor
implements AdempiereProcessor {
    private static final long serialVersionUID = 4477942100661801354L;
    private static CLogger s_log = CLogger.getCLogger(MIMPProcessor.class);

    public MIMPProcessor(Properties ctx, int EXP_ReplicationProcessor_ID, String trxName) {
        super(ctx, EXP_ReplicationProcessor_ID, trxName);
        if (EXP_ReplicationProcessor_ID == 0) {
            this.setName("Default Import Processor");
            this.setFrequencyType("H");
            this.setFrequency(1);
            this.setKeepLogDays(7);
        }
    }

    public MIMPProcessor(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public Timestamp getDateNextRun(boolean requery) {
        if (requery) {
            this.load(this.get_TrxName());
        }
        return this.getDateNextRun();
    }

    @Override
    public AdempiereProcessorLog[] getLogs() {
        ArrayList<MIMPProcessorLog> list;
        block6: {
            list = new ArrayList<MIMPProcessorLog>();
            String sql = "SELECT * FROM IMP_ProcessorLog WHERE IMP_Processor_ID=? ORDER BY Created DESC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getIMP_Processor_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MIMPProcessorLog(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        AdempiereProcessorLog[] retValue = new MIMPProcessorLog[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int deleteLog() {
        if (this.getKeepLogDays() < 1) {
            return 0;
        }
        StringBuilder sql = new StringBuilder("DELETE ").append("IMP_ProcessorLog").append(" ").append("WHERE ").append("IMP_Processor_ID").append("=").append(this.getIMP_Processor_ID()).append(" AND (Created+").append(this.getKeepLogDays()).append(") < SysDate");
        int no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        return no;
    }

    @Override
    public String getServerID() {
        StringBuilder msgreturn = new StringBuilder("ReplicationProcessor").append(this.get_ID());
        return msgreturn.toString();
    }

    public X_IMP_ProcessorParameter[] getIMP_ProcessorParameters(String trxName) {
        ArrayList<X_IMP_ProcessorParameter> resultList;
        block6: {
            resultList = new ArrayList<X_IMP_ProcessorParameter>();
            StringBuilder sql = new StringBuilder("SELECT * ").append(" FROM ").append("IMP_ProcessorParameter").append(" WHERE ").append("IMP_Processor_ID").append("=?").append(" AND IsActive = ?");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            X_IMP_ProcessorParameter processorParameter = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), trxName);
                    pstmt.setInt(1, this.getIMP_Processor_ID());
                    pstmt.setString(2, "Y");
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        processorParameter = new X_IMP_ProcessorParameter(this.getCtx(), rs, trxName);
                        resultList.add(processorParameter);
                    }
                }
                catch (SQLException e) {
                    s_log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        X_IMP_ProcessorParameter[] result = resultList.toArray(new X_IMP_ProcessorParameter[0]);
        return result;
    }

    public static MIMPProcessor[] getActive(Properties ctx) {
        ArrayList<MIMPProcessor> list;
        block6: {
            list = new ArrayList<MIMPProcessor>();
            String sql = "SELECT * FROM IMP_Processor WHERE IsActive='Y'";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MIMPProcessor(ctx, rs, null));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MIMPProcessor[] retValue = new MIMPProcessor[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    @Override
    public String getScheduleType() {
        return "F";
    }

    @Override
    public String getCronPattern() {
        return null;
    }
}

