/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.X_GL_Category;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MGLCategory
extends X_GL_Category {
    private static final long serialVersionUID = -272365151811522531L;
    private static CLogger s_log = CLogger.getCLogger(MGLCategory.class);
    private static CCache<Integer, MGLCategory> s_cache = new CCache("GL_Category", 5);

    public static MGLCategory get(Properties ctx, int GL_Category_ID) {
        Integer key = GL_Category_ID;
        MGLCategory retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MGLCategory(ctx, GL_Category_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static MGLCategory getDefault(Properties ctx, String CategoryType) {
        MGLCategory retValue;
        block7: {
            retValue = null;
            String sql = "SELECT * FROM GL_Category WHERE AD_Client_ID=? AND IsDefault='Y'";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, Env.getAD_Client_ID(ctx));
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MGLCategory temp = new MGLCategory(ctx, rs, null);
                        if (CategoryType != null && CategoryType.equals(temp.getCategoryType())) {
                            retValue = temp;
                            break;
                        }
                        if (retValue != null) continue;
                        retValue = temp;
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }

    public static MGLCategory getDefaultSystem(Properties ctx) {
        MGLCategory retValue = MGLCategory.getDefault(ctx, "S");
        if (retValue == null || !retValue.getCategoryType().equals("S")) {
            retValue = new MGLCategory(ctx, 0, null);
            retValue.setName("Default System");
            retValue.setCategoryType("S");
            retValue.setIsDefault(true);
            if (!retValue.save()) {
                throw new IllegalStateException("Could not save default system GL Category");
            }
        }
        return retValue;
    }

    public MGLCategory(Properties ctx, int GL_Category_ID, String trxName) {
        super(ctx, GL_Category_ID, trxName);
        if (GL_Category_ID == 0) {
            this.setCategoryType("M");
            this.setIsDefault(false);
        }
    }

    public MGLCategory(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String toString() {
        StringBuilder msgreturn = new StringBuilder().append(this.getClass().getSimpleName()).append("[").append(this.get_ID()).append(", Name=").append(this.getName()).append(", IsDefault=").append(this.isDefault()).append(", IsActive=").append(this.isActive()).append(", CategoryType=").append(this.getCategoryType()).append("]");
        return msgreturn.toString();
    }
}

