/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.Query;
import org.compiere.model.X_AD_EntityType;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;

public class MEntityType
extends X_AD_EntityType {
    private static final long serialVersionUID = -8449015496292546851L;
    private static CCache<String, MEntityType> s_cache = new CCache("AD_EntityType", 20);
    private static CLogger s_log = CLogger.getCLogger(MEntityType.class);
    private static final int s_maxAD_EntityType_ID = 1000000;

    public static MEntityType get(Properties ctx, String entityType) {
        MEntityType retValue = s_cache.get(entityType);
        if (retValue != null) {
            return retValue;
        }
        retValue = (MEntityType)new Query(ctx, "AD_EntityType", "EntityType=?", null).setParameters(entityType).firstOnly();
        if (retValue != null) {
            s_cache.put(entityType, retValue);
        }
        return retValue;
    }

    public MEntityType(Properties ctx, int AD_EntityType_ID, String trxName) {
        super(ctx, AD_EntityType_ID, trxName);
    }

    public MEntityType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public boolean isSystemMaintained() {
        int id = this.getAD_EntityType_ID();
        return id < 1000000;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (!newRecord) {
            boolean systemMaintained;
            int id = this.getAD_EntityType_ID();
            boolean bl = systemMaintained = id == 10 || id == 20;
            if (systemMaintained) {
                this.log.saveError("Error", "You cannot modify a System maintained entity");
                return false;
            }
            systemMaintained = this.is_ValueChanged("EntityType");
            if (systemMaintained) {
                this.log.saveError("Error", "You cannot modify EntityType");
                return false;
            }
            boolean bl2 = systemMaintained = this.isSystemMaintained() && (this.is_ValueChanged("Name") || this.is_ValueChanged("Description") || this.is_ValueChanged("Help") || this.is_ValueChanged("IsActive"));
            if (systemMaintained) {
                this.log.saveError("Error", "You cannot modify Name,Description,Help");
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.isSystemMaintained()) {
            this.log.saveError("Error", "You cannot delete a System maintained entity");
            return false;
        }
        return true;
    }
}

