/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MEXPFormatLine;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_EXP_Format;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;

public class MEXPFormat
extends X_EXP_Format {
    private static final long serialVersionUID = -5011042965945626099L;
    private static CLogger s_log = CLogger.getCLogger(MEXPFormat.class);
    private static CCache<String, MEXPFormat> s_cache = new CCache("EXP_Format", 50);
    private static CCache<Integer, MEXPFormat> exp_format_by_id_cache = new CCache("EXP_Format", 50);
    private List<MEXPFormatLine> m_lines = null;
    private List<MEXPFormatLine> m_lines_unique = null;

    public MEXPFormat(Properties ctx, int EXP_Format_ID, String trxName) {
        super(ctx, EXP_Format_ID, trxName);
    }

    public MEXPFormat(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public List<MEXPFormatLine> getFormatLines() {
        return this.getFormatLinesOrderedBy("Position");
    }

    public List<MEXPFormatLine> getFormatLinesOrderedBy(String orderBy) {
        if (this.m_lines != null) {
            return this.m_lines;
        }
        String clauseWhere = "EXP_Format_ID=?";
        this.m_lines = new Query(this.getCtx(), "EXP_FormatLine", "EXP_Format_ID=?", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.getEXP_Format_ID()).setOrderBy(orderBy).list();
        return this.m_lines;
    }

    public Collection<MEXPFormatLine> getUniqueColumns() throws SQLException {
        if (this.m_lines_unique != null) {
            return this.m_lines_unique;
        }
        String clauseWhere = "EXP_Format_ID= ? AND IsPartUniqueIndex= ?";
        this.m_lines_unique = new Query(this.getCtx(), "EXP_FormatLine", "EXP_Format_ID= ? AND IsPartUniqueIndex= ?", this.get_TrxName()).setOnlyActiveRecords(true).setParameters(this.getEXP_Format_ID(), "Y").setOrderBy("Position").list();
        return this.m_lines_unique;
    }

    public static MEXPFormat get(Properties ctx, int EXP_Format_ID, String trxName) {
        MEXPFormat exp_format = exp_format_by_id_cache.get(EXP_Format_ID);
        if (exp_format != null) {
            return exp_format;
        }
        exp_format = new MEXPFormat(ctx, EXP_Format_ID, trxName);
        if (exp_format != null) {
            exp_format.getFormatLines();
            exp_format_by_id_cache.put(EXP_Format_ID, exp_format);
        }
        return exp_format;
    }

    public static MEXPFormat getFormatByValueAD_Client_IDAndVersion(Properties ctx, String value, int AD_Client_ID, String version, String trxName) throws SQLException {
        String key = new String(String.valueOf(value) + version);
        MEXPFormat retValue = null;
        StringBuilder whereClause = new StringBuilder("Value").append("=?").append(" AND AD_Client_ID = ?").append(" AND ").append("Version").append(" = ?");
        retValue = (MEXPFormat)new Query(ctx, "EXP_Format", whereClause.toString(), trxName).setParameters(value, AD_Client_ID, version).first();
        if (retValue != null) {
            retValue.getFormatLines();
            s_cache.put(key, retValue);
            exp_format_by_id_cache.put(retValue.getEXP_Format_ID(), retValue);
        }
        return retValue;
    }

    public static MEXPFormat getFormatByAD_Client_IDAD_Table_IDAndVersion(Properties ctx, int AD_Client_ID, int AD_Table_ID, String version, String trxName) throws SQLException {
        String key = new String(String.valueOf(MTable.getTableName(ctx, AD_Table_ID)) + version);
        MEXPFormat retValue = null;
        retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        StringBuilder whereClause = new StringBuilder(" AD_Client_ID = ? ").append("  AND ").append("AD_Table_ID").append(" = ? ").append("  AND ").append("Version").append(" = ?");
        retValue = (MEXPFormat)new Query(ctx, "EXP_Format", whereClause.toString(), trxName).setParameters(AD_Client_ID, AD_Table_ID, version).first();
        if (retValue != null) {
            retValue.getFormatLines();
            s_cache.put(key, retValue);
            exp_format_by_id_cache.put(retValue.getEXP_Format_ID(), retValue);
        }
        return retValue;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("X_EXP_Format[ID=").append(this.get_ID()).append("; Value = ").append(this.getValue()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeDelete() {
        int[] ids;
        int[] nArray = ids = MEXPFormatLine.getAllIDs("EXP_FormatLine", "EXP_Format_ID=" + this.getEXP_Format_ID(), this.get_TrxName());
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            MEXPFormatLine line = new MEXPFormatLine(this.getCtx(), id, this.get_TrxName());
            line.delete(true);
            ++n2;
        }
        return true;
    }
}

