/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_PA_DocumentStatus;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MDocumentStatus
extends X_PA_DocumentStatus {
    private static final long serialVersionUID = 5908220133480463782L;

    public MDocumentStatus(Properties ctx, int PA_DocumentStatus_ID, String trxName) {
        super(ctx, PA_DocumentStatus_ID, trxName);
    }

    public MDocumentStatus(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MDocumentStatus[] getDocumentStatusIndicators(Properties ctx, int AD_User_ID, int AD_Role_ID) {
        if (AD_User_ID < 0) {
            return new MDocumentStatus[0];
        }
        String whereClause = "AD_Client_ID IN (0,?) AND ((AD_User_ID IS NULL OR AD_User_ID=?) AND ( AD_Role_ID IS NULL OR AD_Role_ID=?))";
        List list = new Query(ctx, "PA_DocumentStatus", whereClause, null).setOnlyActiveRecords(true).setOrderBy("SeqNo").setParameters(Env.getAD_Client_ID(ctx), AD_User_ID, AD_Role_ID).list();
        ArrayList<MDocumentStatus> listWithAccess = new ArrayList<MDocumentStatus>();
        for (MDocumentStatus ds : list) {
            Boolean access;
            if (ds.getAD_Window_ID() > 0) {
                access = MRole.getDefault().getWindowAccess(ds.getAD_Window_ID());
                if (access == null) continue;
                listWithAccess.add(ds);
                continue;
            }
            if (ds.getAD_Form_ID() <= 0 || (access = MRole.getDefault().getFormAccess(ds.getAD_Form_ID())) == null) continue;
            listWithAccess.add(ds);
        }
        MDocumentStatus[] retValue = new MDocumentStatus[listWithAccess.size()];
        listWithAccess.toArray(retValue);
        return retValue;
    }

    public static int evaluate(MDocumentStatus documentStatus) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(*) FROM ");
        String tableName = MTable.getTableName(Env.getCtx(), documentStatus.getAD_Table_ID());
        sql.append(tableName);
        String where = MDocumentStatus.getWhereClause(documentStatus);
        if (where != null && where.trim().length() > 0) {
            sql.append(" WHERE ").append(where);
        }
        String sqlS = MRole.getDefault().addAccessSQL(sql.toString(), tableName, false, true);
        return DB.getSQLValue(null, sqlS);
    }

    public static String getWhereClause(MDocumentStatus documentStatus) {
        String extra;
        StringBuffer where = new StringBuffer(" AD_Client_ID=" + Env.getAD_Client_ID(Env.getCtx()));
        if (documentStatus.getC_Project_ID() > 0) {
            where.append(" AND C_Project_ID=").append(documentStatus.getC_Project_ID());
        }
        if (documentStatus.getAD_Org_ID() > 0) {
            where.append(" AND AD_Org_ID=").append(documentStatus.getAD_Org_ID());
        }
        if ((extra = documentStatus.getWhereClause()) != null && extra.trim().length() > 0) {
            where.append(" AND ( ").append(extra).append(" ) ");
        }
        return Env.parseContext(Env.getCtx(), 0, where.toString(), false);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MDocumentStatus[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }
}

