/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MDiscountSchemaBreak;
import org.compiere.model.MDiscountSchemaLine;
import org.compiere.model.X_M_DiscountSchema;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class MDiscountSchema
extends X_M_DiscountSchema {
    private static final long serialVersionUID = -3314884382853756019L;
    private static CCache<Integer, MDiscountSchema> s_cache = new CCache("M_DiscountSchema", 20);
    private MDiscountSchemaBreak[] m_breaks = null;
    private MDiscountSchemaLine[] m_lines = null;

    public static MDiscountSchema get(Properties ctx, int M_DiscountSchema_ID) {
        Integer key = M_DiscountSchema_ID;
        MDiscountSchema retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MDiscountSchema(ctx, M_DiscountSchema_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MDiscountSchema(Properties ctx, int M_DiscountSchema_ID, String trxName) {
        super(ctx, M_DiscountSchema_ID, trxName);
        if (M_DiscountSchema_ID == 0) {
            this.setDiscountType("F");
            this.setFlatDiscount(Env.ZERO);
            this.setIsBPartnerFlatDiscount(false);
            this.setIsQuantityBased(true);
            this.setCumulativeLevel("L");
        }
    }

    public MDiscountSchema(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MDiscountSchemaBreak[] getBreaks(boolean reload) {
        ArrayList<MDiscountSchemaBreak> list;
        block7: {
            if (this.m_breaks != null && !reload) {
                return this.m_breaks;
            }
            String sql = "SELECT * FROM M_DiscountSchemaBreak WHERE M_DiscountSchema_ID=? ORDER BY SeqNo";
            list = new ArrayList<MDiscountSchemaBreak>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getM_DiscountSchema_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MDiscountSchemaBreak(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_breaks = new MDiscountSchemaBreak[list.size()];
        list.toArray(this.m_breaks);
        return this.m_breaks;
    }

    public MDiscountSchemaLine[] getLines(boolean reload) {
        ArrayList<MDiscountSchemaLine> list;
        block7: {
            if (this.m_lines != null && !reload) {
                MDiscountSchema.set_TrxName(this.m_lines, this.get_TrxName());
                return this.m_lines;
            }
            String sql = "SELECT * FROM M_DiscountSchemaLine WHERE M_DiscountSchema_ID=? ORDER BY SeqNo";
            list = new ArrayList<MDiscountSchemaLine>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getM_DiscountSchema_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MDiscountSchemaLine(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_lines = new MDiscountSchemaLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public BigDecimal calculatePrice(BigDecimal Qty, BigDecimal Price, int M_Product_ID, int M_Product_Category_ID, BigDecimal BPartnerFlatDiscount) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Price=" + Price + ",Qty=" + Qty);
        }
        if (Price == null || Env.ZERO.compareTo(Price) == 0) {
            return Price;
        }
        BigDecimal discount = this.calculateDiscount(Qty, Price, M_Product_ID, M_Product_Category_ID, BPartnerFlatDiscount);
        if (discount == null || discount.signum() == 0) {
            return Price;
        }
        BigDecimal onehundred = Env.ONEHUNDRED;
        BigDecimal multiplier = onehundred.subtract(discount);
        multiplier = multiplier.divide(onehundred, 6, RoundingMode.HALF_UP);
        BigDecimal newPrice = Price.multiply(multiplier);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("=>" + newPrice);
        }
        return newPrice;
    }

    /*
     * Unable to fully structure code
     */
    public BigDecimal calculateDiscount(BigDecimal Qty, BigDecimal Price, int M_Product_ID, int M_Product_Category_ID, BigDecimal BPartnerFlatDiscount) {
        if (BPartnerFlatDiscount == null) {
            BPartnerFlatDiscount = Env.ZERO;
        }
        if ("F".equals(this.getDiscountType())) {
            if (this.isBPartnerFlatDiscount()) {
                return BPartnerFlatDiscount;
            }
            return this.getFlatDiscount();
        }
        if ("S".equals(this.getDiscountType()) || "P".equals(this.getDiscountType())) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Not supported (yet) DiscountType=" + this.getDiscountType());
            }
            return Env.ZERO;
        }
        this.getBreaks(false);
        Amt = Price.multiply(Qty);
        if (this.isQuantityBased()) {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Qty=" + Qty + ",M_Product_ID=" + M_Product_ID + ",M_Product_Category_ID=" + M_Product_Category_ID);
            }
        } else if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("Amt=" + Amt + ",M_Product_ID=" + M_Product_ID + ",M_Product_Category_ID=" + M_Product_Category_ID);
        }
        i = 0;
        while (i < this.m_breaks.length) {
            block17: {
                block18: {
                    block19: {
                        br = this.m_breaks[i];
                        if (!br.isActive()) break block17;
                        if (!this.isQuantityBased()) break block18;
                        if (br.applies(Qty, M_Product_ID, M_Product_Category_ID)) break block19;
                        if (this.log.isLoggable(Level.FINER)) {
                            this.log.finer("No: " + br);
                        }
                        break block17;
                    }
                    if (this.log.isLoggable(Level.FINER)) {
                        this.log.finer("Yes: " + br);
                    }
                    ** GOTO lbl40
                }
                if (!br.applies(Amt, M_Product_ID, M_Product_Category_ID)) {
                    if (this.log.isLoggable(Level.FINER)) {
                        this.log.finer("No: " + br);
                    }
                } else {
                    if (this.log.isLoggable(Level.FINER)) {
                        this.log.finer("Yes: " + br);
                    }
lbl40:
                    // 4 sources

                    discount = null;
                    discount = br.isBPartnerFlatDiscount() != false ? BPartnerFlatDiscount : br.getBreakDiscount();
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Discount=>" + discount);
                    }
                    return discount;
                }
            }
            ++i;
        }
        return Env.ZERO;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getValidFrom() == null) {
            this.setValidFrom(TimeUtil.getDay(null));
        }
        return true;
    }

    public int reSeq() {
        int count = 0;
        MDiscountSchemaLine[] lines = this.getLines(true);
        int i2 = 0;
        while (i2 < lines.length) {
            int line = (i2 + 1) * 10;
            if (line != lines[i2].getSeqNo()) {
                lines[i2].setSeqNo(line);
                if (lines[i2].save()) {
                    ++count;
                }
            }
            ++i2;
        }
        this.m_lines = null;
        MDiscountSchemaBreak[] breaks = this.getBreaks(true);
        int i3 = 0;
        while (i3 < breaks.length) {
            int line = (i3 + 1) * 10;
            if (line != breaks[i3].getSeqNo()) {
                breaks[i3].setSeqNo(line);
                if (breaks[i3].save()) {
                    ++count;
                }
            }
            ++i3;
        }
        this.m_breaks = null;
        return count;
    }
}

