/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MDesktop {
    private Properties m_ctx;
    private ArrayList<Integer> m_workbenches = new ArrayList();
    private int AD_Desktop_ID;
    private String Name;
    private String Description;
    private String Help;
    private int AD_Column_ID;
    private int AD_Image_ID;
    private int AD_Color_ID;
    private int PA_Goal_ID;
    private CLogger log = CLogger.getCLogger(this.getClass());

    public MDesktop(Properties ctx) {
        this.m_ctx = ctx;
    }

    public boolean initDesktop(int ad_Desktop_ID) {
        block10: {
            this.AD_Desktop_ID = ad_Desktop_ID;
            StringBuilder sql = null;
            sql = Env.isBaseLanguage(this.m_ctx, "AD_Desktop") ? new StringBuilder("SELECT Name,Description,Help,").append(" AD_Column_ID,AD_Image_ID,AD_Color_ID,PA_Goal_ID ").append("FROM AD_Desktop ").append("WHERE AD_Desktop_ID=? AND IsActive='Y'") : new StringBuilder("SELECT t.Name,t.Description,t.Help,").append(" w.AD_Column_ID,w.AD_Image_ID,w.AD_Color_ID,w.PA_Goal_ID ").append("FROM AD_Desktop w, AD_Desktop_Trl t ").append("WHERE w.AD_Desktop_ID=? AND w.IsActive='Y'").append(" AND w.AD_Desktop_ID=t.AD_Desktop_ID").append(" AND t.AD_Language='").append(Env.getAD_Language(this.m_ctx)).append("'");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    pstmt.setInt(1, this.AD_Desktop_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.Name = rs.getString(1);
                        this.Description = rs.getString(2);
                        if (this.Description == null) {
                            this.Description = "";
                        }
                        this.Help = rs.getString(3);
                        if (this.Help == null) {
                            this.Help = "";
                        }
                        this.AD_Column_ID = rs.getInt(4);
                        this.AD_Image_ID = rs.getInt(5);
                        this.AD_Color_ID = rs.getInt(6);
                        this.PA_Goal_ID = rs.getInt(7);
                    } else {
                        this.AD_Desktop_ID = 0;
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (this.AD_Desktop_ID == 0) {
            return false;
        }
        return this.initDesktopWorkbenches();
    }

    public String toString() {
        StringBuilder msgreturn = new StringBuilder("MDesktop ID=").append(this.AD_Desktop_ID).append(" ").append(this.Name);
        return msgreturn.toString();
    }

    public int getAD_Desktop_ID() {
        return this.AD_Desktop_ID;
    }

    public String getName() {
        return this.Name;
    }

    public String getDescription() {
        return this.Description;
    }

    public String getHelp() {
        return this.Help;
    }

    public int getAD_Column_ID() {
        return this.AD_Column_ID;
    }

    public int getAD_Image_ID() {
        return this.AD_Image_ID;
    }

    public int getAD_Color_ID() {
        return this.AD_Color_ID;
    }

    public int getPA_Goal_ID() {
        return this.PA_Goal_ID;
    }

    private boolean initDesktopWorkbenches() {
        String sql = "SELECT AD_Workbench_ID FROM AD_DesktopWorkbench WHERE AD_Desktop_ID=? AND IsActive='Y' ORDER BY SeqNo";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, this.AD_Desktop_ID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int AD_Workbench_ID = rs.getInt(1);
                    this.m_workbenches.add(AD_Workbench_ID);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, "MWorkbench.initDesktopWorkbenches", e);
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return false;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return true;
    }

    public int getWindowCount() {
        return this.m_workbenches.size();
    }

    public int getAD_Workbench_ID(int index) {
        if (index < 0 || index > this.m_workbenches.size()) {
            return -1;
        }
        Integer id = this.m_workbenches.get(index);
        return id;
    }
}

