/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MAssetGroupAcct;
import org.compiere.model.MDepreciation;
import org.compiere.model.MDepreciationExp;
import org.compiere.model.Query;
import org.compiere.model.SetGetModel;
import org.compiere.model.SetGetUtil;
import org.compiere.model.X_A_Depreciation_Workfile;
import org.compiere.util.CCache;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.idempiere.fa.feature.UseLife;
import org.idempiere.fa.feature.UseLifeImpl;

public class MDepreciationWorkfile
extends X_A_Depreciation_Workfile
implements UseLife {
    private static final long serialVersionUID = -3814417671427820714L;
    private MAsset m_asset = null;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private static CCache<MultiKey, MDepreciationWorkfile> s_cacheAsset = new CCache("A_Depreciation_Workfile", "A_Depreciation_Workfile_Asset", 10);
    private boolean m_isFiscal = false;
    private boolean m_buildDepreciation = false;

    public MDepreciationWorkfile(Properties ctx, int A_Depreciation_Workfile_ID, String trxName) {
        super(ctx, A_Depreciation_Workfile_ID, trxName);
        if (A_Depreciation_Workfile_ID == 0) {
            this.setPostingType("A");
            this.setA_QTY_Current(Env.ZERO);
            this.setA_Asset_Cost(Env.ZERO);
            this.setA_Accumulated_Depr(Env.ZERO);
            this.setA_Period_Posted(0);
            this.setA_Current_Period(0);
        }
    }

    public MDepreciationWorkfile(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAsset getAsset() {
        return this.getAsset(false);
    }

    public MAsset getAsset(boolean requery) {
        if (this.m_asset == null || requery) {
            this.m_asset = MAsset.get(this.getCtx(), this.getA_Asset_ID(), this.get_TrxName());
        }
        if (this.m_asset.get_ID() <= 0) {
            this.m_asset = null;
        }
        return this.m_asset;
    }

    public void setAsset(MAsset asset) {
        this.setA_Asset_ID(asset.get_ID());
        this.m_asset = asset;
    }

    @Override
    public Timestamp getAssetServiceDate() {
        MAsset asset = this.getAsset();
        if (asset == null) {
            return null;
        }
        return asset.getAssetServiceDate();
    }

    protected boolean afterSave(boolean newRecord) {
        if (this.m_buildDepreciation) {
            this.buildDepreciation();
        }
        return true;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MAsset asset;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Entering: trxName=" + this.get_TrxName());
        }
        if (newRecord) {
            this.setA_Life_Period(this.getUseLifeMonths());
            this.setA_Asset_Life_Years(this.getUseLifeYears());
            this.setA_Life_Period_F(this.getUseLifeMonths_F());
            this.setA_Asset_Life_Years_F(this.getUseLifeYears_F());
        }
        if ("AC".equals((asset = this.getAsset(true)).getA_Asset_Status()) && this.isFullyDepreciated()) {
            asset.changeStatus("DP", null);
            asset.saveEx();
        }
        if (this.is_ValueChanged("DateAcct")) {
            this.setDateAcct(TimeUtil.getMonthLastDay(this.getDateAcct()));
        }
        BigDecimal cost = this.getA_Asset_Cost();
        BigDecimal accumDep_C = this.getA_Accumulated_Depr();
        this.setA_Asset_Remaining(cost.subtract(accumDep_C));
        BigDecimal accumDep_F = this.getA_Accumulated_Depr_F();
        this.setA_Asset_Remaining_F(cost.subtract(accumDep_F));
        String mainColumnName = null;
        if (newRecord || this.is_ValueChanged("A_Asset_Cost")) {
            mainColumnName = "A_Asset_Cost";
        } else if (this.is_ValueChanged("A_Valoare_Cofinantare")) {
            mainColumnName = "A_Valoare_Cofinantare";
        } else if (this.is_ValueChanged("A_Valoare_Tert")) {
            mainColumnName = "A_Valoare_Tert";
        }
        MDepreciationWorkfile.updateFinantare(this, mainColumnName);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Leaving: trxName=" + this.get_TrxName() + " [RETURN TRUE]");
        }
        return true;
    }

    public boolean isFullyDepreciated() {
        if (!this.getPostingType().equals("A")) {
            return false;
        }
        BigDecimal remainingAmt_C = this.getRemainingCost(null, false);
        BigDecimal remainingAmt_F = this.getRemainingCost(null, true);
        if (remainingAmt_C.signum() == 0 && remainingAmt_F.signum() == 0) {
            return this.getA_Asset_Cost().signum() != 0;
        }
        return false;
    }

    public MDepreciationWorkfile(MAsset asset, String postingType, MAssetGroupAcct assetgrpacct) {
        this(asset.getCtx(), 0, asset.get_TrxName());
        this.setA_Asset_ID(asset.getA_Asset_ID());
        this.setAD_Org_ID(asset.getAD_Org_ID());
        this.setA_Asset_Cost(asset.getA_Asset_Cost());
        this.setA_Accumulated_Depr(asset.getA_Accumulated_Depr());
        this.setA_Accumulated_Depr_F(asset.getA_Accumulated_Depr_F());
        this.setA_Current_Period(asset.getA_Current_Period());
        this.setIsDepreciated(asset.isDepreciated());
        this.setPostingType(postingType);
        if (assetgrpacct == null) {
            assetgrpacct = MAssetGroupAcct.forA_Asset_Group_ID(asset.getCtx(), asset.getA_Asset_Group_ID(), postingType);
        }
        UseLifeImpl.copyValues(this, assetgrpacct);
        Timestamp dateAcct = asset.getDateAcct();
        if (dateAcct != null) {
            dateAcct = TimeUtil.addMonths(dateAcct, 1);
            this.setDateAcct(dateAcct);
        }
        if (asset.getUseLifeMonths() > 0) {
            UseLifeImpl.get(this, false).setUseLifeMonths(asset.getUseLifeMonths());
        }
        if (asset.getUseLifeMonths_F() > 0) {
            UseLifeImpl.get(this, true).setUseLifeMonths(asset.getUseLifeMonths_F());
        }
        this.dump();
    }

    public static Collection<MDepreciationWorkfile> forA_Asset_ID(Properties ctx, int asset_id, String trxName) {
        return new Query(ctx, "A_Depreciation_Workfile", "A_Asset_ID=?", trxName).setParameters(asset_id).list();
    }

    public static MDepreciationWorkfile get(Properties ctx, int A_Asset_ID, String postingType) {
        return MDepreciationWorkfile.get(ctx, A_Asset_ID, postingType, null);
    }

    public static MDepreciationWorkfile get(Properties ctx, int A_Asset_ID, String postingType, String trxName) {
        MDepreciationWorkfile wk;
        if (A_Asset_ID <= 0 || postingType == null) {
            return null;
        }
        MultiKey key = new MultiKey((Object)A_Asset_ID, (Object)postingType);
        if (trxName == null && (wk = s_cacheAsset.get(key)) != null) {
            return wk;
        }
        String whereClause = "A_Asset_ID=? AND PostingType=? ";
        MDepreciationWorkfile wk2 = (MDepreciationWorkfile)new Query(ctx, "A_Depreciation_Workfile", "A_Asset_ID=? AND PostingType=? ", trxName).setParameters(A_Asset_ID, postingType).firstOnly();
        if (trxName == null && wk2 != null) {
            s_cacheAsset.put(key, wk2);
        }
        return wk2;
    }

    public Timestamp getLastActionDate() {
        return TimeUtil.getMonthLastDay(TimeUtil.addMonths(this.getDateAcct(), -1));
    }

    public boolean isDepreciated(Timestamp date) {
        boolean isDepr;
        Timestamp lastActionDate = this.getLastActionDate();
        boolean bl = isDepr = !date.after(lastActionDate);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("LastActionDate=" + lastActionDate + ", GivenDate=" + date + " => isDepreciated=" + isDepr);
        }
        return isDepr;
    }

    public MAssetAcct getA_AssetAcct(Timestamp dateAcct, String trxName) {
        return MAssetAcct.forA_Asset_ID(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), dateAcct, trxName);
    }

    public BigDecimal getActualCost() {
        return this.getActualCost(this.getA_Asset_Cost());
    }

    public BigDecimal getActualCost(BigDecimal assetCost) {
        return assetCost.subtract(this.getA_Salvage_Value());
    }

    public void adjustCost(BigDecimal deltaAmt, BigDecimal deltaQty, boolean reset) {
        BigDecimal newCost = Env.ZERO;
        BigDecimal newQty = Env.ZERO;
        if (!reset) {
            newCost = this.getA_Asset_Cost();
            newQty = this.getA_QTY_Current();
        }
        newCost = newCost.add(deltaAmt);
        newQty = newQty.add(deltaQty);
        this.setA_Asset_Cost(newCost);
        this.setA_QTY_Current(newQty);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("adjustCost(" + deltaAmt + ", " + deltaQty + ", reset=" + reset + ") => amt=" + this.getA_Asset_Cost() + ", qty=" + this.getA_QTY_Current());
        }
    }

    public boolean adjustAccumulatedDepr(BigDecimal amt, BigDecimal amt_F, boolean reset) {
        if (amt == null) {
            amt = Env.ZERO;
        }
        if (amt_F == null) {
            amt_F = Env.ZERO;
        }
        this.setA_Accumulated_Depr(amt.add(reset ? Env.ZERO : this.getA_Accumulated_Depr()));
        this.setA_Accumulated_Depr_F(amt_F.add(reset ? Env.ZERO : this.getA_Accumulated_Depr_F()));
        return true;
    }

    public void adjustUseLife(int deltaUseLifeYears, int deltaUseLifeYears_F, boolean reset) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Entering: deltaUseLifeYears=" + deltaUseLifeYears + ", deltaUseLifeYears_F=" + deltaUseLifeYears_F);
        }
        UseLifeImpl.get(this, false).adjustUseLifeYears(deltaUseLifeYears, reset);
        UseLifeImpl.get(this, true).adjustUseLifeYears(deltaUseLifeYears_F, reset);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Leaving");
        }
    }

    public int getUseLifeMonths(boolean fiscal) {
        return fiscal ? this.getUseLifeMonths_F() : this.getUseLifeMonths();
    }

    public BigDecimal getA_Accumulated_Depr(boolean fiscal) {
        return fiscal ? this.getA_Accumulated_Depr_F() : this.getA_Accumulated_Depr();
    }

    public BigDecimal getAccumulatedCost() {
        return this.getA_Accumulated_Depr(this.isFiscal());
    }

    public BigDecimal getReevaluationCost() {
        return Env.ZERO;
    }

    public BigDecimal getRemainingCost(BigDecimal accumAmt, boolean fiscal) {
        BigDecimal cost = this.getActualCost();
        if (accumAmt == null) {
            accumAmt = this.getA_Accumulated_Depr(fiscal);
        }
        return cost.subtract(accumAmt);
    }

    public BigDecimal getRemainingCost(BigDecimal accumAmt) {
        return this.getRemainingCost(accumAmt, this.isFiscal());
    }

    public int getRemainingPeriods(int A_Current_Period, MDepreciation method) {
        int useLifePeriods = this.getUseLifeMonths(this.isFiscal());
        if (method != null) {
            useLifePeriods += method.getFixMonthOffset();
        }
        int currentPeriod = A_Current_Period >= 0 ? A_Current_Period : this.getA_Current_Period();
        return useLifePeriods - currentPeriod;
    }

    public int getRemainingPeriods(int A_Current_Period) {
        return this.getRemainingPeriods(A_Current_Period, null);
    }

    public boolean isFiscal() {
        return this.m_isFiscal;
    }

    public void setFiscal(boolean fiscal) {
        this.m_isFiscal = fiscal;
    }

    public void incA_Current_Period() {
        int old_period = this.getA_Current_Period();
        Timestamp old_date = this.getDateAcct();
        int new_period = old_period + 1;
        Timestamp new_date = TimeUtil.addMonths(this.getDateAcct(), 1);
        this.setA_Current_Period(new_period);
        this.setDateAcct(new_date);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("(A_Current_Period, DateAcct)=(" + old_period + ", " + old_date + ")->(" + new_period + ", " + new_date + ")");
        }
    }

    public void setA_Current_Period() {
        String whereClause = "A_Asset_ID=? AND PostingType=? AND Processed=? AND IsActive=?";
        MDepreciationExp depexp = (MDepreciationExp)new Query(this.getCtx(), "A_Depreciation_Exp", whereClause, this.get_TrxName()).setParameters(this.getA_Asset_ID(), this.getPostingType(), true, true).setOrderBy("A_Period DESC,DateAcct DESC").first();
        if (depexp != null) {
            this.setA_Current_Period(depexp.getA_Period());
            this.setDateAcct(depexp.getDateAcct());
            this.incA_Current_Period();
        } else {
            this.log.info("There are no records from which to infer its");
        }
    }

    public void buildDepreciation() {
        int A_Current_Period;
        if (!this.isDepreciated()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        this.load(this.get_TrxName());
        MAssetAcct assetacct = this.getA_AssetAcct(null, this.get_TrxName());
        MDepreciation depreciation_C = MDepreciation.get(this.getCtx(), assetacct.getA_Depreciation_ID());
        MDepreciation depreciation_F = MDepreciation.get(this.getCtx(), assetacct.getA_Depreciation_F_ID());
        int offset_C = 0;
        int offset_F = 0;
        BigDecimal assetCost = this.getActualCost();
        BigDecimal accumDep_C = this.getA_Accumulated_Depr(false);
        BigDecimal accumDep_F = this.getA_Accumulated_Depr(true);
        int lifePeriods_C = this.getUseLifeMonths(false) + offset_C;
        int lifePeriods_F = this.getUseLifeMonths(true) + offset_F;
        int lifePeriods = lifePeriods_C > lifePeriods_F ? lifePeriods_C : lifePeriods_F;
        BigDecimal exp_C = Env.ZERO;
        BigDecimal exp_F = Env.ZERO;
        if (CLogMgt.isLevelFine()) {
            sb.append("currentPeriod=" + this.getA_Current_Period() + ", AssetServiceDate=" + this.getAssetDepreciationDate() + "\n");
            sb.append("offset: C|F=" + offset_C + "|" + offset_F + "\n");
            sb.append("life: C|F=" + lifePeriods_C + "|" + lifePeriods_F + " + offset =" + lifePeriods + "\n");
        }
        this.truncDepreciation();
        int currentPeriod = A_Current_Period = this.getA_Current_Period();
        int cnt = 1;
        while (currentPeriod <= lifePeriods) {
            exp_C = Env.ZERO;
            exp_F = Env.ZERO;
            String help = accumDep_C + "|" + accumDep_F + " + ";
            if (lifePeriods_C > currentPeriod || !depreciation_C.requireLastPeriodAdjustment()) {
                this.setFiscal(false);
                exp_C = depreciation_C.invoke(this, assetacct, currentPeriod, accumDep_C);
                accumDep_C = accumDep_C.add(exp_C);
            } else if (lifePeriods_C == currentPeriod) {
                exp_C = assetCost.subtract(accumDep_C);
                accumDep_C = assetCost;
            }
            if (lifePeriods_F > currentPeriod || !depreciation_F.requireLastPeriodAdjustment()) {
                this.setFiscal(true);
                exp_F = depreciation_F.invoke(this, assetacct, currentPeriod, accumDep_F);
                accumDep_F = accumDep_F.add(exp_F);
            } else if (lifePeriods_F == currentPeriod) {
                exp_F = assetCost.subtract(accumDep_F);
                accumDep_F = assetCost;
            }
            help = String.valueOf(help) + exp_C + "|" + exp_F + " = " + accumDep_C + "|" + accumDep_F;
            int months = 0;
            Timestamp dateAcct = TimeUtil.getMonthLastDay(TimeUtil.addMonths(this.getDateAcct(), months += currentPeriod - A_Current_Period));
            MDepreciationExp.createDepreciation(this, currentPeriod, dateAcct, exp_C, exp_F, accumDep_C, accumDep_F, help, this.get_TrxName());
            if (this.log.isLoggable(Level.FINE)) {
                String info = cnt + ": period=" + currentPeriod + "/" + lifePeriods_C + "|" + lifePeriods_F + ", exp=" + exp_C + "|" + exp_F + ", accumDep=" + accumDep_C + "|" + accumDep_F + ", DateAcct=" + dateAcct;
                this.log.fine("=> " + info + Env.NL + Env.NL);
                sb.append(String.valueOf(info) + Env.NL);
            }
            ++currentPeriod;
            ++cnt;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(sb.toString());
        }
        this.m_buildDepreciation = false;
    }

    public void truncDepreciation() {
        String trxName = this.get_TrxName();
        int A_Current_Period = this.getA_Current_Period();
        String sql = "DELETE FROM A_Depreciation_Exp WHERE Processed=? AND A_Period>=? AND A_Asset_ID=? AND PostingType=?";
        Object[] params = new Object[]{false, A_Current_Period, this.getA_Asset_ID(), this.getPostingType()};
        int no = DB.executeUpdateEx("DELETE FROM A_Depreciation_Exp WHERE Processed=? AND A_Period>=? AND A_Asset_ID=? AND PostingType=?", params, trxName);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("sql=DELETE FROM A_Depreciation_Exp WHERE Processed=? AND A_Period>=? AND A_Asset_ID=? AND PostingType=?\nDeleted #" + no);
        }
    }

    public static void updateFinantare(SetGetModel m, String changedColumnName) {
        BigDecimal valCofinantare = SetGetUtil.get_AttrValueAsBigDecimal(m, "A_Valoare_Cofinantare");
        BigDecimal assetCost = SetGetUtil.get_AttrValueAsBigDecimal(m, "A_Asset_Cost");
        BigDecimal valTert = SetGetUtil.get_AttrValueAsBigDecimal(m, "A_Valoare_Tert");
        if (valCofinantare.signum() == 0 && valTert.signum() == 0) {
            valCofinantare = assetCost;
            valTert = Env.ZERO;
        } else if ("A_Asset_Cost".equals(changedColumnName)) {
            valCofinantare = assetCost.subtract(valTert);
        } else if ("A_Valoare_Cofinantare".equals(changedColumnName)) {
            valTert = assetCost.subtract(valCofinantare);
        } else if ("A_Valoare_Tert".equals(changedColumnName)) {
            valCofinantare = assetCost.subtract(valTert);
        } else {
            valTert = assetCost.subtract(valCofinantare);
        }
        String tipFinantare = "C";
        if (valTert.signum() == 0) {
            tipFinantare = "P";
        } else if (valCofinantare.signum() == 0) {
            tipFinantare = "T";
        }
        m.set_AttrValue("A_Tip_Finantare", tipFinantare);
        m.set_AttrValue("A_Valoare_Cofinantare", valCofinantare);
        m.set_AttrValue("A_Valoare_Tert", valTert);
        if ("P".equals(tipFinantare) && SetGetUtil.isPersistent(m)) {
            m.set_AttrValue("A_FundingMode_ID", null);
        }
    }

    @Override
    public boolean set_AttrValue(String ColumnName, Object value) {
        int index = this.get_ColumnIndex(ColumnName);
        if (index < 0) {
            return false;
        }
        return this.set_ValueNoCheck(ColumnName, value);
    }

    @Override
    public Object get_AttrValue(String ColumnName) {
        int index = this.get_ColumnIndex(ColumnName);
        if (index < 0) {
            return null;
        }
        return this.get_Value(index);
    }

    @Override
    public boolean is_AttrValueChanged(String ColumnName) {
        int index = this.get_ColumnIndex(ColumnName);
        if (index < 0) {
            return false;
        }
        return this.is_ValueChanged(index);
    }
}

